package com.digiwin.athena.dtdapp.config;

import lombok.Getter;
import lombok.Setter;
import org.neo4j.driver.v1.AuthTokens;
import org.neo4j.driver.v1.Config;
import org.neo4j.driver.v1.GraphDatabase;
import org.neo4j.ogm.driver.Driver;
import org.neo4j.ogm.drivers.bolt.driver.BoltDriver;
import org.neo4j.ogm.session.SessionFactory;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.domain.EntityScanPackages;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.neo4j.repository.config.EnableNeo4jRepositories;

import java.util.List;
import java.util.concurrent.TimeUnit;


//@Configuration
//@ConditionalOnProperty(value = "spring.data.neo4j.domain1.enable",havingValue = "true")
//@EnableNeo4jRepositories(
//        sessionFactoryRef = DtdappNeo4j1Config.SESSION_FACTORY,
//        transactionManagerRef = DtdappNeo4j1Config.TRANSACTION_MANAGER
//)
//@ConfigurationProperties(prefix = "spring.data.neo4j.domain1")
//@Setter
//@Getter
public class DtdappNeo4j1Config {

    {
        System.out.println("Neo4j1Config........");
    }

    public static final String SESSION_FACTORY = "dtdappSessionFactoryForDomain1";
    public static final String TRANSACTION_MANAGER = "dtdappTransactionManagerForDomain1";


    private String uri;

    private String username;

    private String password;

    private Boolean enable;



    @Bean("dtdappNeo4jDriverDomain1")
    public org.neo4j.driver.v1.Driver dtdappNeo4jDriverDomain1() {
        System.out.println("neo4jDriverDomain1... url="+this.uri+",username="+this.username+",password="+this.password);

        Config config = Config.build()
                .withConnectionTimeout(10, TimeUnit.SECONDS)
                .withConnectionLivenessCheckTimeout(2, TimeUnit.MINUTES)
                .withMaxConnectionLifetime( 4, TimeUnit.MINUTES )
                .withMaxConnectionPoolSize( 20 )
                .withConnectionAcquisitionTimeout( 1, TimeUnit.MINUTES )
                .toConfig();
        return GraphDatabase.driver(this.uri, AuthTokens.basic( this.username, this.password ), config );
    }


    @Bean("dtdAppOgmDriverDomain1")
    public Driver dtdappOgmDriverDomain1() {
        Driver ogmDriver = new BoltDriver(dtdappNeo4jDriverDomain1());
        return ogmDriver;
    }


    @Bean(name = SESSION_FACTORY)
    public SessionFactory dtdAppSessionFactory(ApplicationContext applicationContext) {
        String[] packages = getPackagesToScan(applicationContext);
        return new SessionFactory(dtdappOgmDriverDomain1(),packages);
    }

//    @Bean(name = TRANSACTION_MANAGER) // <3>
//    public Neo4jTransactionManager neo4jTransactionManager(ApplicationContext applicationContext) {
//        System.out.println("==========neo4jTransactionManager1==========");
//        return new Neo4jTransactionManager(sessionFactory(applicationContext));
//    }

    private String[] getPackagesToScan(ApplicationContext applicationContext) {
//        List<String> packages = EntityScanPackages.get(applicationContext)
//                .getPackageNames();
//        if (packages.isEmpty() && AutoConfigurationPackages.has(applicationContext)) {
//            packages = AutoConfigurationPackages.get(applicationContext);
//        }
//        return org.springframework.util.StringUtils.toStringArray(packages);
        return new String[]{ "com.digiwin.athena.dtdapp.pojo.neo4j"};
    }
}
