package com.digiwin.athena.dtdapp.dao;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.dao.DWDao;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.athena.dtdapp.mapper.EmployeeEntryInfoMapper;
import com.digiwin.athena.dtdapp.mapper.FileInfoMapper;
import com.digiwin.athena.dtdapp.pojo.entity.EmployeeEntryInfo;
import com.digiwin.athena.dtdapp.pojo.entity.FileInfo;
import com.digiwin.athena.dtdapp.pojo.vo.EmployeeEntryInfoVO;
import com.digiwin.athena.dtdapp.pojo.vo.FileInfoData;
import com.digiwin.athena.dtdapp.util.DateUtils;
import com.digiwin.utils.DWTenantUtils;
import jodd.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.*;
import java.util.stream.Collectors;

@Service
public class EmployeeEntryInfoDAO2 {

    private static final Logger LOGGER = LoggerFactory.getLogger(EmployeeEntryInfoDAO2.class);

    public static final String TABLE_NAME = "employee_entry_info";


//    @Autowired
//    @Qualifier("dw-dao")
//    private DWDao dao;

    @Autowired
    private EmployeeEntryInfoMapper employeeEntryInfoMapper;

    @Autowired
    private FileInfoDAO fileInfoDAO;

//    private DWDataSetOperationOption getOption() {
//        DWDataSetOperationOption option = new DWDataSetOperationOption();
//        option.setTenantEnabled(false);
//        return option;
//    }

    private boolean checkAllEmpNoIsNotNull(JSONArray jsonArray){
        for(int i=0; i<jsonArray.size(); i++){
            JSONObject jsonObjParam = jsonArray.getJSONObject(i);
            String empNo = jsonObjParam.getString("emp_no");
            if(StringUtils.isEmpty(empNo)){
                return false;
            }
        }
        return true;
    }

    public List<Map<String, Object>>  updateEmployeeEntryInfo(Map<String, String> parameter) throws Exception{
        LOGGER.info("updateEmployeeEntryInfo:{}", parameter);
        JSONObject obj = JSON.parseObject(JSON.toJSONString(parameter));
        JSONArray jsonArray = obj.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("emp_entry_info");

        if(ObjectUtils.isEmpty(jsonArray)){
            throw new DWException("update emp_entry_info is empty");
        }

        if(!this.checkAllEmpNoIsNotNull(jsonArray)){
            throw new DWException("update emp_entry_info has object emp_no is null");
        }

        for(int i=0; i<jsonArray.size(); i++){
            JSONObject jsonObjParam = jsonArray.getJSONObject(i);
            String empNo = jsonObjParam.getString("emp_no");
            if(StringUtils.isEmpty(empNo)){
                throw new DWException("empNo is empty");
            }
            String empName = jsonObjParam.getString("emp_name");
            String loginName = jsonObjParam.getString("login_name");
            String entryDateString = jsonObjParam.getString("entry_date");

            String managerName = jsonObjParam.getString("manager_name");
            String reportSubmitDateString = jsonObjParam.getString("report_submit_date");

            String workReportApprovalDateString = jsonObjParam.getString("work_report_approval_date");

            String probationDateString = jsonObjParam.getString("probation_date");
            String task_status = jsonObjParam.getString("task_status");


            JSONObject report_attachment = jsonObjParam.getJSONObject("report_attachment");
            List<String> rAttachmentIds = null;
            if(!ObjectUtils.isEmpty(report_attachment)){
                FileInfoData fileInfoData = JSON.parseObject(report_attachment.toJSONString(), FileInfoData.class);
                List<FileInfo> data = fileInfoData.getData();
                if(!CollectionUtils.isEmpty(data)){
                    fileInfoDAO.saveOrUpdateBatch(data);
                    rAttachmentIds = data.stream().map(FileInfo::getId).collect(Collectors.toList());
                }
            }

            JSONObject work_report_attachment = jsonObjParam.getJSONObject("work_report_attachment");
            List<String> wrAttachmentIds = null;
            if(!ObjectUtils.isEmpty(work_report_attachment)){
                FileInfoData fileInfoData = JSON.parseObject(work_report_attachment.toJSONString(), FileInfoData.class);
                List<FileInfo> data = fileInfoData.getData();
                if(!CollectionUtils.isEmpty(data)){
                    fileInfoDAO.saveOrUpdateBatch(data);
                    wrAttachmentIds = data.stream().map(FileInfo::getId).collect(Collectors.toList());
                }
            }

            EmployeeEntryInfo employeeEntryInfo = new EmployeeEntryInfo();
            employeeEntryInfo.setUpdate_date(DateUtils.getDateTimeNow());

            if (StringUtil.isNotBlank(entryDateString)) {
                Date entryDate = DateUtils.parseStringToDate(entryDateString, "yyyy-MM-dd");
                employeeEntryInfo.setEntry_date(entryDate);
            }
            if (StringUtil.isNotBlank(reportSubmitDateString)) {
                Date reportSubmitDate = DateUtils.parseStringToDate(reportSubmitDateString, "yyyy-MM-dd");
                employeeEntryInfo.setReport_submit_date(reportSubmitDate);
            }
            if (StringUtil.isNotBlank(workReportApprovalDateString)) {
                Date workReportApprovalDate = DateUtils.parseStringToDate(workReportApprovalDateString, "yyyy-MM-dd");
                employeeEntryInfo.setWork_report_approval_date(workReportApprovalDate);
            }
            if (StringUtil.isNotBlank(probationDateString)) {
                Date probationDate = DateUtils.parseStringToDate(probationDateString, "yyyy-MM-dd");
                employeeEntryInfo.setProbation_date(probationDate);
            }
            if (StringUtil.isNotBlank(task_status)) {
                employeeEntryInfo.setTask_status(task_status);
            }

            if(!CollectionUtils.isEmpty(rAttachmentIds)){
                employeeEntryInfo.setReport_attachment_id(StringUtils.join(rAttachmentIds, ","));
            }

            if(!CollectionUtils.isEmpty(wrAttachmentIds)){
                employeeEntryInfo.setWork_report_attachment_id(StringUtils.join(wrAttachmentIds, ","));
            }

            this.employeeEntryInfoMapper.update(employeeEntryInfo, new UpdateWrapper<EmployeeEntryInfo>().lambda().eq(EmployeeEntryInfo::getEmp_no, empNo));
        }

        return this.getEmployeeEntryInfo(parameter);

    }

    public List<Map<String, Object>>  insertEmployeeEntryInfo(Map<String, String> parameter) throws Exception{
        LOGGER.info("insertEmployeeEntryInfo:{}", parameter);
        JSONObject obj = JSON.parseObject(JSON.toJSONString(parameter));
        JSONArray jsonArray = obj.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("emp_entry_info");

        if(ObjectUtils.isEmpty(jsonArray)){
            throw new DWException("update emp_entry_info is empty");
        }

        if(!this.checkAllEmpNoIsNotNull(jsonArray)){
            throw new DWException("update emp_entry_info has object emp_no is null");
        }

        for(int i=0; i<jsonArray.size(); i++){
            JSONObject jsonObjParam = jsonArray.getJSONObject(i);
            String empNo = jsonObjParam.getString("emp_no");
            if(StringUtils.isEmpty(empNo)){
                throw new DWException("empNo is empty");
            }
            String empName = jsonObjParam.getString("emp_name");
            String loginName = jsonObjParam.getString("login_name");
            String entryDateString = jsonObjParam.getString("entry_date");
            Date entryDate = null;
            if(StringUtils.isNotEmpty(entryDateString)){
                entryDate = DateUtils.parseStringToDate(entryDateString, "yyyy-MM-dd");
            }
            String managerName = jsonObjParam.getString("manager_name");
            String managerNo = jsonObjParam.getString("manager_no");
            String emp_email = jsonObjParam.getString("emp_email");
            String manager_email = jsonObjParam.getString("manager_email");
            String task_status = jsonObjParam.getString("task_status");

//            String sql = "insert into employee_entry_info(emp_no, emp_name, login_name, entry_date, manager_no, manager_name,create_date,emp_email,manager_email,task_status) values(?,?,?,?,?,?,?,?,?,?)";
//            this.dao.update(getOption(), sql, empNo, empName, loginName, entryDate, managerNo, managerName, DateUtils.getDateTimeNow(),emp_email,manager_email,task_status);

            EmployeeEntryInfo employeeEntryInfo = new EmployeeEntryInfo();
            employeeEntryInfo.setEmp_no(empNo);
            employeeEntryInfo.setEmp_name(empName);
            employeeEntryInfo.setLogin_name(loginName);
            employeeEntryInfo.setEntry_date(entryDate);
            employeeEntryInfo.setManager_name(managerName);
            employeeEntryInfo.setManager_no(managerNo);
            employeeEntryInfo.setManager_email(manager_email);
            employeeEntryInfo.setEmp_email(emp_email);
            employeeEntryInfo.setTask_status(task_status);
            employeeEntryInfo.setCreate_date(DateUtils.getDateTimeNow());

            this.employeeEntryInfoMapper.insert(employeeEntryInfo);
        }

        return this.getEmployeeEntryInfo(parameter);

    }


    public List getEmployeeEntryInfo(Map<String, String> parameter)  throws DWException {
        LOGGER.info("getEmployeeEntryInfo:{}", parameter);
        JSONObject obj = JSON.parseObject(JSON.toJSONString(parameter));
        JSONArray jsonArray = obj.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("emp_entry_info");

        if(ObjectUtils.isEmpty(jsonArray)){
            throw new DWException("empNo is empty");
        }

        List empNoList = new ArrayList();
        for(int i = 0; i< jsonArray.size(); i++) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            String emp_no = jsonObject.getString("emp_no");
            empNoList.add(emp_no);
        }

        String task_status = jsonArray.getJSONObject(0).getString("task_status");


        QueryWrapper<EmployeeEntryInfo> queryWrapper = new QueryWrapper<>();
        LambdaQueryWrapper<EmployeeEntryInfo> in = queryWrapper.lambda().in(EmployeeEntryInfo::getEmp_no, empNoList);
        if(StringUtils.isNotEmpty(task_status)){
            in.eq(EmployeeEntryInfo::getTask_status, task_status);
        }

        final List<EmployeeEntryInfo> employeeEntryInfos = this.employeeEntryInfoMapper.selectList(queryWrapper);

        List<EmployeeEntryInfoVO> result = new ArrayList<>();
        if(!CollectionUtils.isEmpty(employeeEntryInfos)){
            for(EmployeeEntryInfo employeeEntryInfo : employeeEntryInfos){
                EmployeeEntryInfoVO employeeEntryInfoVO = new EmployeeEntryInfoVO();
                BeanUtils.copyProperties(employeeEntryInfo, employeeEntryInfoVO);
                String report_attachment = employeeEntryInfo.getReport_attachment_id();
                //处理附件信息
                if(StringUtils.isNotEmpty(report_attachment)){
                    List<FileInfo> fileDataList = this.fileInfoDAO.getBaseMapper().selectList(new QueryWrapper<FileInfo>()
                            .in("id", Arrays.asList(report_attachment.split(","))));
                    if(!CollectionUtils.isEmpty(fileDataList)){
                        FileInfoData fileInfoData = new FileInfoData();
                        fileInfoData.setData(fileDataList);
                        employeeEntryInfoVO.setReport_attachment(fileInfoData);
                    }

                }

                String work_report_attachment = employeeEntryInfo.getWork_report_attachment_id();
                if(StringUtils.isNotEmpty(work_report_attachment)){
                    List<FileInfo> fileDataList = this.fileInfoDAO.getBaseMapper().selectList(new QueryWrapper<FileInfo>()
                            .in("id", Arrays.asList(work_report_attachment.split(","))));
                    if(!CollectionUtils.isEmpty(fileDataList)){
                        FileInfoData fileInfoData = new FileInfoData();
                        fileInfoData.setData(fileDataList);
                        employeeEntryInfoVO.setWork_report_attachment(fileInfoData);
                    }
                }

                result.add(employeeEntryInfoVO);
            }
        }

        return result;

    }
}
