package com.digiwin.athena.dtdapp.dao;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.dtdapp.mapper.CommodityAttachmentMapper;
import com.digiwin.athena.dtdapp.mapper.CommodityInfoMapper;
import com.digiwin.athena.dtdapp.mapper.PurchaseInfoMapper;
import com.digiwin.athena.dtdapp.pojo.entity.CommodityAttachment;
import com.digiwin.athena.dtdapp.pojo.entity.CommodityInfo;
import com.digiwin.athena.dtdapp.pojo.entity.DorDodCheckResult;
import com.digiwin.athena.dtdapp.pojo.entity.PurchaseInfo;
import com.digiwin.athena.dtdapp.pojo.vo.CommodityInfoVO;
import com.digiwin.athena.dtdapp.pojo.vo.PurchaseInfoVO;
import com.digiwin.http.client.utils.DWRequestHeaderUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.stereotype.Service;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

import java.util.*;
import java.util.stream.Collectors;

@Service
@Slf4j
public class ProcureDAO {
    @Autowired
    private PurchaseInfoMapper purchaseInfoMapper;
    @Autowired
    private CommodityInfoMapper commodityInfoMapper;
    @Autowired
    private CommodityAttachmentMapper commodityAttachmentMapper;


    public List createPurchaseInfo(List<PurchaseInfoVO> purchaseInfoVOS) {
        log.info("采购信息:{}", purchaseInfoVOS);
        List purchase_temp = new ArrayList<>();
        for (PurchaseInfoVO purchaseInfoVO : purchaseInfoVOS) {
            PurchaseInfo purchaseInfo = new PurchaseInfo();
            BeanUtils.copyProperties(purchaseInfoVO, purchaseInfo);

            String uuid = UUID.randomUUID().toString();//采购单号
            purchaseInfo.setPurchase_no(uuid);
            purchaseInfoMapper.insert(purchaseInfo);

            result(purchase_temp, purchaseInfo);//操作返回信息

            List<CommodityInfoVO> commodityInfos = purchaseInfoVO.getCommodity_info();

            for (CommodityInfoVO commodityInfoVO : commodityInfos) {
                CommodityInfo commodityInfo = new CommodityInfo();
                BeanUtils.copyProperties(commodityInfoVO, commodityInfo);

                commodityInfo.setCommodity_cod(commodityInfoVO.getCommodity_cod())
                        .setPurchase_no(uuid);
                commodityInfoMapper.insert(commodityInfo);

                JSONObject attachments = commodityInfoVO.getAttachment();
                JSONArray data = attachments.getJSONArray("data");
                List<CommodityAttachment> commodityAttachments = JSON.parseArray(JSON.toJSONString(data), CommodityAttachment.class);
                for (CommodityAttachment commodityAttachment : commodityAttachments) {
                    commodityAttachment.setPurchase_no(uuid)
                            .setCommodity_cod(commodityInfoVO.getCommodity_cod());
                    commodityAttachmentMapper.insert(commodityAttachment);
                }
            }
        }
        return purchase_temp;
    }

    public List updatePurchaseInfo(List<PurchaseInfoVO> purchaseInfoVOS) {
        log.info("选择供应商更新采购信息:{}", purchaseInfoVOS);
        List purchase_temp = new ArrayList<>();//返回
        //采购单层
        for (PurchaseInfoVO purchaseInfoVO : purchaseInfoVOS) {

            PurchaseInfo purchaseInfo = new PurchaseInfo();//更新对象
            BeanUtils.copyProperties(purchaseInfoVO, purchaseInfo);

            QueryWrapper<PurchaseInfo> purchaseInfoQueryWrapper = new QueryWrapper<>();
            purchaseInfoQueryWrapper.eq("purchase_no", purchaseInfoVO.getPurchase_no());
            PurchaseInfo purchaseIf = purchaseInfoMapper.selectOne(purchaseInfoQueryWrapper);

            purchaseInfo.setId(purchaseIf.getId());
            purchaseInfoMapper.updateById(purchaseInfo);

            result(purchase_temp, purchaseInfo);//操作返回信息
            //商品层

            List<CommodityInfoVO> commodityInfoVOS = purchaseInfoVO.getCommodity_info();

            for (CommodityInfoVO commodityInfoVO : commodityInfoVOS) {

                commodityInfoVO.setPurchase_no(purchaseInfoVO.getPurchase_no());
                CommodityInfo commodityInfo = new CommodityInfo();
                BeanUtils.copyProperties(commodityInfoVO, commodityInfo);

                QueryWrapper<CommodityInfo> commodityInfoQueryWrapper = new QueryWrapper<>();
                commodityInfoQueryWrapper.eq("purchase_no", commodityInfoVO.getPurchase_no())
                        .eq("commodity_cod", commodityInfoVO.getCommodity_cod());
                CommodityInfo commodityIf = commodityInfoMapper.selectOne(commodityInfoQueryWrapper);

                commodityInfo.setId(commodityIf.getId());
                commodityInfoMapper.updateById(commodityInfo);

                JSONArray data = commodityInfoVO.getAttachment().getJSONArray("data");
                List<CommodityAttachment> commodityAttachments = JSON.parseArray(JSON.toJSONString(data), CommodityAttachment.class);

                //发送邮件
                //sendEmail(commodityInfoVO);

                //附件层,先删再增
                QueryWrapper<CommodityAttachment> commodityAttachmentQueryWrapper = new QueryWrapper<>();
                commodityAttachmentQueryWrapper.eq("purchase_no", commodityInfoVO.getPurchase_no())
                        .eq("commodity_cod", commodityInfoVO.getCommodity_cod());
                commodityAttachmentMapper.delete(commodityAttachmentQueryWrapper);
                for (CommodityAttachment commodityAttachment : commodityAttachments) {

                    commodityAttachment.setPurchase_no(purchaseInfoVO.getPurchase_no())
                            .setCommodity_cod(commodityInfoVO.getCommodity_cod());

                    commodityAttachmentMapper.insert(commodityAttachment);

                }
            }
        }
        return purchase_temp;
    }

    public List getPurchaseInfo(String purchaserCode) {
        log.info("采购人:{}", purchaserCode);
        ArrayList<PurchaseInfoVO> purchaseInfoVOS = new ArrayList<>();

        QueryWrapper<PurchaseInfo> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("purchaser_code", purchaserCode);
        List<PurchaseInfo> purchaseInfos = purchaseInfoMapper.selectList(queryWrapper);
        //采购单层
        for (PurchaseInfo purchaseInfo : purchaseInfos) {

            PurchaseInfoVO purchaseInfoVO = new PurchaseInfoVO();
            BeanUtils.copyProperties(purchaseInfo, purchaseInfoVO);

            QueryWrapper<CommodityInfo> commodityInfoQueryWrapper = new QueryWrapper<>();
            commodityInfoQueryWrapper.eq("purchase_no", purchaseInfo.getPurchase_no());
            List<CommodityInfo> commodityInfos = commodityInfoMapper.selectList(commodityInfoQueryWrapper);

            ArrayList<CommodityInfoVO> commodityInfoVOS = new ArrayList<>();
            //商品层
            for (CommodityInfo commodityInfo : commodityInfos) {

                CommodityInfoVO commodityInfoVO = new CommodityInfoVO();

                QueryWrapper<CommodityAttachment> commodityAttachmentQueryWrapper = new QueryWrapper<>();
                commodityAttachmentQueryWrapper.eq("purchase_no", commodityInfo.getPurchase_no())
                        .eq("commodity_cod", commodityInfo.getCommodity_cod());
                List<CommodityAttachment> commodityAttachments = commodityAttachmentMapper.selectList(commodityAttachmentQueryWrapper);

                //转变附件回传格式
                JSONArray jsonArray = getJsonArray(commodityAttachments);

                Map<String, Object> map = new HashMap<>();
                map.put("data", jsonArray);

                BeanUtils.copyProperties(commodityInfo, commodityInfoVO);

                commodityInfoVO.setAttachment(new JSONObject(map));

                commodityInfoVOS.add(commodityInfoVO);
            }
            purchaseInfoVO.setCommodity_info(commodityInfoVOS);

            purchaseInfoVOS.add(purchaseInfoVO);
        }
        return purchaseInfoVOS;
    }

    public List getCommodityInfo(JSONArray jsonArray) {
        log.info("供应商回复获取任务卡:{}", jsonArray);
        ArrayList<PurchaseInfoVO> purchaseInfoVOS = new ArrayList<>();

           if (jsonArray == null || jsonArray.size() == 0) {
               List<PurchaseInfo> purchaseInfos = purchaseInfoMapper.selectList(new QueryWrapper<>());
               for (PurchaseInfo purchaseInfo : purchaseInfos) {
                   String purchase_no = purchaseInfo.getPurchase_no();//采购单
                   this.processPurchaseInfo(purchaseInfo,purchaseInfoVOS,purchase_no,null);
               }
           }else {
               for (Object o : jsonArray) {

                   JSONObject jsonObject = (JSONObject) o;
                   String purchase_no = jsonObject.getString("purchase_no");//采购单
                   String supplier_no = jsonObject.getString("supplier_no");//供应商编号

                   QueryWrapper<PurchaseInfo> queryWrapper = new QueryWrapper<>();
                   queryWrapper.eq(purchase_no != null, "purchase_no", purchase_no);
                   PurchaseInfo purchaseInfo = purchaseInfoMapper.selectOne(queryWrapper);

                   this.processPurchaseInfo(purchaseInfo,purchaseInfoVOS,purchase_no,supplier_no);

//                   //采购单层
//
//                   PurchaseInfoVO purchaseInfoVO = new PurchaseInfoVO();
//                   BeanUtils.copyProperties(purchaseInfo, purchaseInfoVO);
//
//                   QueryWrapper<CommodityInfo> commodityInfoQueryWrapper = new QueryWrapper<>();
//                   commodityInfoQueryWrapper.eq(supplier_no != null, "supplier_no", supplier_no)
//                           .eq(purchase_no != null, "purchase_no", purchase_no);
//                   List<CommodityInfo> commodityInfos = commodityInfoMapper.selectList(commodityInfoQueryWrapper);
//
//
//                   ArrayList<CommodityInfoVO> commodityInfoVOS = new ArrayList<>();//商品信息
//                   //商品层
//
//                   for (CommodityInfo commodityInfo : commodityInfos) {
//
//                       CommodityInfoVO commodityInfoVO = new CommodityInfoVO();
//
//                       QueryWrapper<CommodityAttachment> commodityAttachmentQueryWrapper = new QueryWrapper<>();
//                       commodityAttachmentQueryWrapper.eq(purchase_no != null, "purchase_no", purchase_no)
//                               .eq(commodityInfo.getCommodity_cod() != null, "commodity_cod", commodityInfo.getCommodity_cod());
//                       List<CommodityAttachment> commodityAttachments = commodityAttachmentMapper.selectList(commodityAttachmentQueryWrapper);
//                       //转变附件回传格式
//                       JSONArray jsonArr = getJsonArray(commodityAttachments);
//                       Map<String, Object> map = new HashMap<>();
//                       map.put("data", jsonArr);
//
//                       BeanUtils.copyProperties(commodityInfo, commodityInfoVO);
//
//                       commodityInfoVO.setAttachment(new JSONObject(map));//附件信息
//
//                       commodityInfoVOS.add(commodityInfoVO);
//
//                   }
//                   purchaseInfoVO.setCommodity_info(commodityInfoVOS);
//
//                   purchaseInfoVOS.add(purchaseInfoVO);
//
               }
           }
        return purchaseInfoVOS;
    }

    private void processPurchaseInfo(PurchaseInfo purchaseInfo, ArrayList<PurchaseInfoVO> purchaseInfoVOS,  String purchase_no,String supplier_no ) {
        PurchaseInfoVO purchaseInfoVO = new PurchaseInfoVO();
        BeanUtils.copyProperties(purchaseInfo, purchaseInfoVO);

        QueryWrapper<CommodityInfo> commodityInfoQueryWrapper = new QueryWrapper<>();
        commodityInfoQueryWrapper.eq(supplier_no!= null,"supplier_no", supplier_no)
                .eq(purchase_no!= null,"purchase_no", purchase_no);
        List<CommodityInfo> commodityInfos = commodityInfoMapper.selectList(commodityInfoQueryWrapper);

        ArrayList<CommodityInfoVO> commodityInfoVOS = new ArrayList<>();
        for (CommodityInfo commodityInfo : commodityInfos) {
            CommodityInfoVO commodityInfoVO = new CommodityInfoVO();
            BeanUtils.copyProperties(commodityInfo, commodityInfoVO);

            QueryWrapper<CommodityAttachment> commodityAttachmentQueryWrapper = new QueryWrapper<>();
            commodityAttachmentQueryWrapper.eq("purchase_no", purchaseInfo.getPurchase_no())
                    .eq("commodity_cod", commodityInfo.getCommodity_cod());
            List<CommodityAttachment> commodityAttachments = commodityAttachmentMapper.selectList(commodityAttachmentQueryWrapper);

            //转变附件回传格式
            JSONArray jsonArr = getJsonArray(commodityAttachments);
            Map<String, Object> map = new HashMap<>();
            map.put("data", jsonArr);
            commodityInfoVO.setAttachment(new JSONObject(map));

            commodityInfoVOS.add(commodityInfoVO);
        }
        purchaseInfoVO.setCommodity_info(commodityInfoVOS);
        purchaseInfoVOS.add(purchaseInfoVO);
    }

    public List updateCommodityInfo(List<PurchaseInfoVO> purchaseInfoVOS) {
        log.info("供应商回复:{}", purchaseInfoVOS);
        List purchase_temp = new ArrayList<>();//返回
        //采购单层
        for (PurchaseInfoVO purchaseInfoVO : purchaseInfoVOS) {

            PurchaseInfo purchaseInfo = new PurchaseInfo();//更新对象
            BeanUtils.copyProperties(purchaseInfoVO, purchaseInfo);

            QueryWrapper<PurchaseInfo> purchaseInfoQueryWrapper = new QueryWrapper<>();
            purchaseInfoQueryWrapper.eq("purchase_no", purchaseInfoVO.getPurchase_no());
            PurchaseInfo purchaseIf = purchaseInfoMapper.selectOne(purchaseInfoQueryWrapper);

            purchaseInfo.setId(purchaseIf.getId());
            purchaseInfoMapper.updateById(purchaseInfo);

            result(purchase_temp, purchaseInfo);//操作返回信息
            //商品层

            List<CommodityInfoVO> commodityInfoVOS = purchaseInfoVO.getCommodity_info();

            for (CommodityInfoVO commodityInfoVO : commodityInfoVOS) {

                commodityInfoVO.setPurchase_no(purchaseInfoVO.getPurchase_no());
                CommodityInfo commodityInfo = new CommodityInfo();
                BeanUtils.copyProperties(commodityInfoVO, commodityInfo);

                QueryWrapper<CommodityInfo> commodityInfoQueryWrapper = new QueryWrapper<>();
                commodityInfoQueryWrapper.eq("purchase_no", commodityInfoVO.getPurchase_no())
                        .eq("commodity_cod", commodityInfoVO.getCommodity_cod());
                CommodityInfo commodityIf = commodityInfoMapper.selectOne(commodityInfoQueryWrapper);

                commodityInfo.setId(commodityIf.getId());
                commodityInfoMapper.updateById(commodityInfo);

                JSONArray data = commodityInfoVO.getAttachment().getJSONArray("data");
                List<CommodityAttachment> commodityAttachments = JSON.parseArray(JSON.toJSONString(data), CommodityAttachment.class);

                //附件层,先删再增
                QueryWrapper<CommodityAttachment> commodityAttachmentQueryWrapper = new QueryWrapper<>();
                commodityAttachmentQueryWrapper.eq("purchase_no", commodityInfoVO.getPurchase_no())
                        .eq("commodity_cod", commodityInfoVO.getCommodity_cod());
                commodityAttachmentMapper.delete(commodityAttachmentQueryWrapper);
                for (CommodityAttachment commodityAttachment : commodityAttachments) {

                    commodityAttachment.setPurchase_no(purchaseInfoVO.getPurchase_no())
                            .setCommodity_cod(commodityInfoVO.getCommodity_cod());

                    commodityAttachmentMapper.insert(commodityAttachment);

                }
            }
        }
        return purchase_temp;
    }


    private static JSONArray getJsonArray(List<CommodityAttachment> commodityAttachments) {
        JSONArray jsonArr = new JSONArray(commodityAttachments.stream()
                .map(commodityAttachment -> {
                    Map<String, Object> map1 = new HashMap<>();
                    map1.put("id", commodityAttachment.getId());
                    map1.put("name", commodityAttachment.getName());
                    map1.put("category", commodityAttachment.getCategory());
                    map1.put("category_id", commodityAttachment.getCategory_id());
                    map1.put("size", commodityAttachment.getSize());
                    map1.put("upload_user_id", commodityAttachment.getUpload_user_id());
                    map1.put("upload_user_name", commodityAttachment.getUpload_user_name());
                    map1.put("create_date", commodityAttachment.getCreate_date());
                    map1.put("row_data", commodityAttachment.getRow_data());
                    return new JSONObject(map1);
                })
                .collect(Collectors.toList()));
        return jsonArr;
    }

    private static void result(List purchase_temp, PurchaseInfo purchaseInfo) {
        Map map = new HashMap<>();
        map.put("purchase_no", purchaseInfo.getPurchase_no());
        map.put("eoc_company_id", purchaseInfo.getEoc_company_id());
        map.put("eoc_site_id", purchaseInfo.getEoc_site_id());
        map.put("eoc_region_id", purchaseInfo.getEoc_region_id());
        map.put("om_company_id", purchaseInfo.getOm_company_id());
        map.put("om_site_id", purchaseInfo.getOm_site_id());
        map.put("om_region_id", purchaseInfo.getOm_region_id());
        map.put("operation_results", purchaseInfo.toString());
        purchase_temp.add(map);
    }

    private static void sendEmail(CommodityInfoVO commodityInfoVO) {
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.set(DWRequestHeaderUtils.HEADER_IAM_API_APP_TOKEN,
                DWApplicationConfigUtils.getProperty("iamApToken"));
        headers.set("Content-Type", "application/json");
        String tApi = "/api/emc/v1/message/sendEmail";
        Map<String, Object> tRequest = new HashMap<>();
        ArrayList<String> list = new ArrayList<>();
        list.add(commodityInfoVO.getSupplier_email());
        tRequest.put("userIds", list);
        tRequest.put("msgType", "text");
        tRequest.put("title", "您有一份新的反馈信息");
        //获取请求域名
        String athenaTestUrl = DWApplicationConfigUtils.getProperty("athenaTestUrl");
        log.info("域名:{}", athenaTestUrl);
        tRequest.put("content", "您有新的采购订单信息，请至：<a href=\"" + athenaTestUrl + "\">雅典娜运行平台</a>查看！");
        HttpEntity<?> httpEntity = new HttpEntity<>(tRequest, headers);

        String tFinalUrl = DWApplicationConfigUtils.getProperty("emcUrl") + tApi;
        log.info("sendEmailUrl:" + tFinalUrl);
        // 拦截错误
        restTemplate.setErrorHandler(new ResponseErrorHandler() {
            @Override
            public boolean hasError(ClientHttpResponse clientHttpResponse) {
                return false;
            }

            @Override
            public void handleError(ClientHttpResponse clientHttpResponse) {
            }
        });
        ResponseEntity<String> responseEntity = null;
        try {
            responseEntity = restTemplate.exchange(tFinalUrl, HttpMethod.POST, httpEntity, String.class);
        } catch (RestClientException e) {
            e.printStackTrace();
        }
        int statusCodeValue = responseEntity.getStatusCodeValue();
        if (statusCodeValue != 200) {
            String body = responseEntity.getBody();
            log.error("send mail error:{}-{}", statusCodeValue, body);

        }
    }
}
