package com.digiwin.athena.dtdapp.dao.zentao;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.digiwin.athena.dtdapp.mapperzentao.ZtProductMapper;
import com.digiwin.athena.dtdapp.mapperzentao.ZtProjectMapper;
import com.digiwin.athena.dtdapp.pojo.entity.zentao.ZtProduct;
import com.digiwin.athena.dtdapp.pojo.entity.zentao.ZtProject;
import com.digiwin.athena.dtdapp.pojo.vo.ztkanban.ZtProjectVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author
 * @version 1.0
 */
@Service
@Slf4j
public class ZtProjectDAO extends ServiceImpl<ZtProjectMapper, ZtProject> {

    @Autowired
    private ZtProjectMapper ztProjectMapper;

    public List<ZtProject> getProgram(){
        //目前只考虑数智方案研发中心项目
        return ztProjectMapper.getProgram();
    }

    public List<ZtProject> getProjectByProgramAndType(String parentId, String type) {
        return ztProjectMapper.getProjectByProgramAndType(parentId,type);
    }

    public int getProjectCountByProjectId(String projectId) {
        return ztProjectMapper.getProjectCountByProjectId(projectId);
    }

    public List<ZtProjectVO> getProjectByProgramAndProject(List<Integer> parentIds, Integer page, Integer size) {
        return ztProjectMapper.getProjectByProgramAndProject(parentIds,page,size);
    }

    /**
     * 根据项目集id查询当前项目集及子项目集列表
     *
     * @param programId 项目集id
     * @return 返回
     */
    public List<ZtProject> queryProgramList(Integer programId){
        return ztProjectMapper.queryProgramList(programId);
    }

    /**
     * 根据项目集id查询当前项目集下的项目列表
     *
     * @param programId 项目集id
     * @return 返回
     */
    public List<ZtProject> queryProjectList(Integer programId){
        return ztProjectMapper.queryProjectList(programId);
    }

    /**
     * 根据项目集id或项目id查询当前所有冲刺
     *
     * @param id 项目集id或项目id
     * @return 返回
     */
    public List<ZtProject> querySprintList(Integer id){
        return ztProjectMapper.querySprintList(id);
    }
}
