package com.digiwin.athena.dtdapp.mapperzentao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.dtdapp.pojo.dto.zentaoplus.*;
import com.digiwin.athena.dtdapp.pojo.dto.zt.ZtProjectDTO;
import com.digiwin.athena.dtdapp.pojo.dto.ztkanban.queryTaskReq;
import com.digiwin.athena.dtdapp.pojo.entity.zentao.ZtEffort;
import com.digiwin.athena.dtdapp.pojo.entity.zentao.ZtTask;
import com.digiwin.athena.dtdapp.pojo.entity.zentao.ZtUser;
import com.digiwin.athena.dtdapp.pojo.vo.ztkanban.ZtTaskProjectVO;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.Collection;
import java.util.List;
import java.util.Set;

public interface ZtPlusProjectMapper extends BaseMapper<ZtEffort> {

    List<ProjectWithTeamInfoDto> getProjectWithTeamInfoList(@Param("parentProjectName") String parentProjectName,
                                                            @Param("projectName") String projectName,
                                                            @Param("status") String status);

    List<ProjectTeamDetailDto> getProjectTeamDetailList(int projectId, String userName, String beginDate, String endDate);

    List<UserEffortDto> getProjectUserEffort(int projectId, String userName, String beginDate, String endDate);

    List<UserTaskEstimatedAndConsumedDto> getUserTask(Collection<Integer> deptIds, String userName, String beginDate, String endDate);

    List<UserProjectConsumedDetailDto> getUserProjectConsumedList(int userId, String beginDate, String endDate);

    List<ProjectEstimateDto> getProjectTaskConsumed(String parentProjectName, String beginDate, String endDate);

    List<UserEffortDto> getUserEffortDetail(Collection<Integer> deptIds, String userName, String beginDate, String endDate);

    List<UserEffortDto> getUserProjectEffort(int userId, String beginDate, String endDate);

    List<ZtProjectDTO> getProjectByName(String projectName, Integer programId);

    List<ZtProjectDTO> getProjectChildrenByParent(List<Integer> parentIds, String type);

    List<ZtUser> getUserByDeptList(List<Integer> deptIdList, String name);

    List<ZtTask> getTaskByUser(String userAccount, String date);

    List<ZtTask> getTaskByFinishUser(List<String> userAccountList, String date);

    List<ZtUser> getUserByAccount(List<String> userAccountList);

    @Select("select id as all_sub_ids\n" +
            "from (select *\n" +
            "      from (select id, parent\n" +
            "            from zt_dept\n" +
            "            order by parent, id) org_query,\n" +
            "           (select @id := #{deptId}) initialisation\n" +
            "      where find_in_set(parent, @id) > 0\n" +
            "                AND @id := concat(@id, ',', id)) subquery;")
    List<Integer> getSubDeptIds(Integer deptId);

    /**
     * 查询用户任务列表
     *
     * @param queryTaskReq 请求对象
     * @param accountList 用户列表
     * @return 返回
     */
    List<ZtTaskProjectVO> queryTaskListByCondition(@Param("queryTaskReq") queryTaskReq queryTaskReq, @Param("accountList") Set<String> accountList);

    /**
     * 查询任务的消耗工时
     *
     * @param taskIdList 任务id列表
     * @return 返回
     */
    List<ZtEffort> queryTaskConsumed(List<Integer> taskIdList, String startTime, String endTime);

    /**
     * 查询用户bug列表
     *
     * @param queryTaskReq 请求对象
     * @return 返回
     */
    List<ZtTaskProjectVO> queryBugListByCondition(@Param("queryTaskReq") queryTaskReq queryTaskReq);
}
