package com.digiwin.athena.dtdapp.pojo.vo.st;

import com.digiwin.athena.dtdapp.pojo.dto.st.ProjectEmployeeRelationDTO;
import com.digiwin.athena.dtdapp.pojo.entity.st.Employee;
import com.digiwin.athena.dtdapp.pojo.entity.st.Project;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;
import java.util.List;

@Data
@Accessors(chain = true)
public class ProjectVO {
    private Long id;
    /**
     * 项目编号
     */
    private String project_code;
    /**
     * 项目名称
     */
    private String project_name;
    /**
     * 项目类型(1:产品型项目; 2:专案型项目)
     */
    private String project_type;
    /**
     * 状态(Y:生效; N:未生效)
     */
    private String manage_status;
    /**
     * 创建人
     */
    private String  create_by;
    /**
     * 创建时间
     */
    private Date create_time;
    /**
     * 更新人
     */
    private String update_by;
    /**
     * 更新时间
     */
    private Date update_time;
    /**
     * 租户
     */
    private Long tenantsid;
    /**
     * 包含产品
     */
    private List<ProductVO> product;
    /**
     * 项目参与人
     */
    private List<ProjectEmployeeRelationDTO> project_participants;
    /**
     * 项目负责人
     */
    private String project_leader;
    /**
     * 项目负责人
     */
    private String project_leader_id;
}
