package com.digiwin.athena.dtdapp.pojo.vo.st;

import com.digiwin.athena.dtdapp.pojo.entity.st.WorkReportDetail;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
public class WorkReportDetailVO{
    private Long id;

    private String employee_name;
    /**
     * 报工人员
     */
    private String employee_no;
    /**
     * 报工日期
     */
    @JsonFormat(pattern="yyyy-MM-dd")
    private Date report_date;
    /**
     * 序号
     */
    private Integer seq;
    /**
     * 实际工时
     */
    private BigDecimal actual_hour;
    /**
     *  剩余工时
     */
    private BigDecimal unfinished_hour;
    /**
     * 计划工时
     */
    private BigDecimal plan_hour;
    /**
     * 工作内容
     */
    private String work_content;
    /**
     * 报工类型(1.开发,2.测试,3.需求, 4.设计,5.服务（内部同人）, 6.服务（外部同人）,7.BUG处理,8.培训（讲师）
     * 9.培训与学习（学员）, 10.会议, 11.版本发布, 12.请假, 13.其他,14.讨论,15.界面,16.事务, 17.运维
     * 18.技术支持,19.软件工程,20.DAP专用请假,21.规格澄清,22.内部问题处理,23.外部问题处理 ,24.研究,25.学习)
     */
    private String report_type;
    /**
     * 报工来源(PROJECT:项目; OTHER:其他)
     */
    private String report_source;
    /**
     * 所属项目名字
     */
    private String belong_project_name;
    /**
     * 所属项目(项目id)
     */
    private String belong_project;
    /**
     * 所属产品名字
     */
    private String belong_product_name;
    /**
     * 所属产品(产品id)
     */
    private String belong_product;
    /**
     * 备注
     */
    private String remark;
    /**
     * 审核意见
     */
    private String audit_opinion;
    /**
     * 状态(0:待审核; 1:审核通过; 2:审核拒绝)
     */
    private String status;
    private String report_frequency;
    private String email;
    private Boolean from_zentao;
    private Float consumed;
    private String  task_id;
    private String org_name;
    private String org_no;
    private String title;
    private String approval_no;
    private String approval_name;
    private String zentao_effort_id;
    private Boolean from_supplement;
}
