package com.digiwin.athena.dtdapp.pojo.vo.zentaoplus;

import lombok.Getter;
import lombok.RequiredArgsConstructor;
import lombok.Setter;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;

@RequiredArgsConstructor
@Getter
@Setter
public class ProjectWithTeamInfoVo {

    /**
     * 项目 ID
     */
    private final int id;

    /**
     * 项目名称
     */
    private final String name;

    /**
     * 项目状态 closed, doing, wait, suspended, 分别对应 已关闭、进行中、等待中、已暂停
     */
    private final String status;

    /**
     * 项目预估工时
     */
    private final double estimate;

    /**
     * 项目消耗工时
     */
    private final double consumed;

    /**
     * 项目开始时间
     */
    private final String begin;

    /**
     * 项目结束时间
     */
    private final String end;

    /**
     * 项目成员明细信息
     */
    private final List<ProjectTeamConsumedInfoVo> consumedInfoVos = new LinkedList<>();
}
