package com.digiwin.athena.dtdapp.pojo.vo.zentaoplus;

import lombok.Getter;
import lombok.RequiredArgsConstructor;
import lombok.Setter;

import java.util.LinkedHashMap;
import java.util.Map;

@RequiredArgsConstructor
@Setter
@Getter
public class UserProjectConsumedVo {

    /**
     * 项目名称
     */
    private final String projectName;

    /**
     * 项目 ID
     */
    private final int projectId;

    /**
     * 项目开始时间
     */
    private final String started;

    /**
     * 项目结束时间
     */
    private final String ended;

    /**
     * 项目预估工时
     */
    private double estimate;

    /**
     * 项目消耗工时
     */
    private double consumed;

    /**
     * 日期对应的预估工时，会返回所有日期，如果没有工时则为 0，例如 2024-07-11: 0
     */
    private final Map<String, Double> dateEstimate = new LinkedHashMap<>();

    /**
     * 日期对应的消耗工时，会返回所有日期，如果没有工时则为 0，例如 2024-07-11: 0
     */
    private final Map<String, Double> dateConsumed = new LinkedHashMap<>();
}
