package com.digiwin.athena.dtdapp.pojo.vo.ztkanban;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ContentRowHeight;
import com.alibaba.excel.annotation.write.style.HeadRowHeight;
import com.digiwin.athena.dtdapp.pojo.entity.zentao.ZtProject;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@NoArgsConstructor
@AllArgsConstructor
@ContentRowHeight(15)
@HeadRowHeight(20)
public class ZtProjectExcelVO {
    @ExcelIgnore
    private String id;

    @ExcelProperty(value = {"项目名称"}, index = 0)
    private String name;

    @ExcelProperty(value = {"项目状态"}, index = 1)
    private String status;

    @ExcelProperty(value = {"计划开始"}, index = 2)
    private String begin;

    @ExcelProperty(value = {"计划完成"}, index = 3)
    private String end;

    @ExcelProperty(value = {"当前冲刺"}, index = 4)
    private String sprint_name;

    @ExcelProperty(value = {"冲刺计划开始"}, index = 5)
    private String sprint_begin;

    @ExcelProperty(value = {"冲刺计划完成"}, index = 6)
    private String sprint_end;

    @ExcelProperty(value = {"总需求数"}, index = 7)
    private Integer total_demand;

    @ExcelProperty(value = {"已完成需求数"}, index = 8)
    private Integer completed_demand;

    @ExcelProperty(value = {"剩余需求数"}, index = 9)
    private Integer residue;
}
