package com.digiwin.athena.dtdapp.provider;

import com.digiwin.app.service.DWEAIResult;
import com.digiwin.app.service.DWService;
import com.digiwin.app.service.eai.EAIService;

import java.util.Map;

public interface IDorDodProvider extends DWService {

    @EAIService(id = "dor.dod.check.item.get")
    DWEAIResult getDorDodCheckItems(Map<String, String> headers, String messageBody) throws Exception;

    @EAIService(id = "dor.dod.check.item.save")
    DWEAIResult saveDorDodCheckItems(Map<String, String> headers, String messageBody) throws Exception;


    @EAIService(id = "dor.dod.info.create")
    DWEAIResult createDorDodInfo(Map<String, String> headers, String messageBody) throws Exception;

    @EAIService(id = "dor.dod.check.result.get")
    DWEAIResult getDorDodCheckResult(Map<String, String> headers, String messageBody) throws Exception;

    @EAIService(id = "dor.dod.check.result.update")
    DWEAIResult updateDorDodCheckResult(Map<String, String> headers, String messageBody) throws Exception;

    /**
     * audit 和 update 接口分开，因为合并单元格的形式好像小ai不支持直接设置状态值
     */
    @EAIService(id = "dor.dod.check.result.audit")
    DWEAIResult auditDorDodCheckResult(Map<String, String> headers, String messageBody) throws Exception;


    /**
     *项目卡展示用，没有D数组
     */
    @EAIService(id = "dor.dod.check.result.detail.get")
    DWEAIResult getDorDodCheckResultDetail(Map<String, String> headers, String messageBody) throws Exception;


    @EAIService(id = "dor.dod.check.result.callback")
    DWEAIResult callbackDorDodCheckResult(Map<String, String> headers, String messageBody) throws Exception;

}
