package com.digiwin.athena.dtdapp.provider;

import com.digiwin.app.service.AllowAnonymous;
import com.digiwin.app.service.DWService;
import com.digiwin.app.service.restful.DWRequestMapping;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.app.service.restful.DWRestfulService;
import com.digiwin.athena.dtdapp.pojo.dto.ztkanban.queryTaskReq;
import com.digiwin.athena.dtdapp.pojo.entity.zentao.*;
import com.digiwin.athena.dtdapp.pojo.vo.ztkanban.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;


@DWRestfulService
public interface IZtKanBanService extends DWService {

    /**
     * 获取项目集
     * @return
     */
    @DWRequestMapping(path = "board/project/getProgram", method = {DWRequestMethod.GET})
    @AllowAnonymous
    List<ZtProjectLevelVO> getProgram();

    /**
     * 根据项目集id获取项目集所包含的项目
     * @param
     * @return
     */
    @DWRequestMapping(path = "board/project/getProjectByProgram", method = {DWRequestMethod.POST})
    @AllowAnonymous
    List<ZtProject> getProjectByProgram(@RequestParam(required = false)  String requestMap);

    /**
     * 获取项目下的具体项目
     * @param requestMap
     * @return
     */
    @DWRequestMapping(path = "board/project/getProjectByProgramAndProject", method = {DWRequestMethod.POST})
    @AllowAnonymous
    PageVO<ZtProjectVO> getProjectByProgramAndProject(@RequestParam(required = false) String requestMap);

    /**
     * 获取所属冲刺
     * @param request
     * @return
     */
    @DWRequestMapping(path = "board/story/getSprintByProject", method = {DWRequestMethod.POST})
    @AllowAnonymous
    List<ZtProject> getSprintByProject(@RequestParam(required = false)  String request);

    /**
     * 获取需求看板项目维度需求
     * @param requestMap
     * @return
     */
    @DWRequestMapping(path = "board/story/getStoryByProject", method = {DWRequestMethod.POST})
    @AllowAnonymous
    PageVO<ZtStoryVO> getStoryByProjectOrSprint(@RequestParam(required = false)  String requestMap);




    /**
     * 获取所属产品
     * @param requestMap
     * @return
     */
    @DWRequestMapping(path = "board/product/getProductByProgram", method = {DWRequestMethod.POST})
    @AllowAnonymous
    List<ZtProduct> getProductByProgram(@RequestParam(required = false)  String requestMap);

    /**
     * 获取需求看板所属模块
     * @param requestMap
     * @return
     */
    @DWRequestMapping(path = "board/product/getModuleByProduct", method = {DWRequestMethod.POST})
    @AllowAnonymous
    List<ZtModuleLevelVO> getModuleByProduct(@RequestParam(required = false)  String requestMap);
    /**
     * 获取需求看板产品维度需求
     * @param requestMap
     * @return
     */
    @DWRequestMapping(path = "board/story/getStoryByProduct", method = {DWRequestMethod.POST})
    @AllowAnonymous
    PageVO<ZtStoryVO> getStoryByProduct(@RequestParam(required = false) String requestMap);

//    /**
//     * 获取需求看板需求达成情况
//     * @param requestMap
//     * @return
//     */
//    @DWRequestMapping(path = "board/story/getDemandCompleteStatus", method = {DWRequestMethod.POST})
//    @AllowAnonymous
//    DemandVO getDemandCompleteStatus(@RequestParam(required = false)  String requestMap);

    /**
     * 项目看板内容导出
     * @param requestMap
     * @return
     */
    @DWRequestMapping(path = "board/project/getProjectToExcel", method = {DWRequestMethod.POST})
    @AllowAnonymous
    void getProjectToExcel(@RequestParam(required = false)  Map<String, String> requestMap);

    /**
     * 需求看板项目维度需求导出
     * @param requestMap
     * @return
     */
    @DWRequestMapping(path = "board/story/getStoryByProjectToExcel", method = {DWRequestMethod.POST})
    @AllowAnonymous
    void getStoryByProjectToExcel(@RequestParam(required = false)  String requestMap);

    /**
     * 需求看板产品维度需求导出
     * @param requestMap
     * @return
     */
    @DWRequestMapping(path = "board/story/getStoryByProductToExcel", method = {DWRequestMethod.POST})
    @AllowAnonymous
    void getStoryByProductToExcel(@RequestParam(required = false)  String requestMap);


    /**
     * 获取需求看板项目维度需求达成情况
     * @param requestMap
     * @return
     */
    @DWRequestMapping(path = "board/story/getProjectDemandCompleteStatus", method = {DWRequestMethod.POST})
    @AllowAnonymous
    DemandVO getProjectDemandCompleteStatus(@RequestParam(required = false)  String requestMap);


    /**
     * 获取需求看板产品维度需求达成情况
     * @param requestMap
     * @return
     */
    @DWRequestMapping(path = "board/story/getProductDemandCompleteStatus", method = {DWRequestMethod.POST})
    @AllowAnonymous
    DemandVO getProductDemandCompleteStatus(@RequestParam(required = false)  String requestMap);

    /**
     * 查询部门列表
     * 不传deptId默认查询"數據自決研發中心"部门
     *
     * @param deptId 部门id
     * @return 返回
     */
    @DWRequestMapping(path = "board/dept/queryDeptList", method = {DWRequestMethod.POST})
    @AllowAnonymous
    List<ZtDeptVO> queryDeptList(@RequestParam(required = false) Integer deptId);

    /**
     * 查询用户(角色为研发和测试)列表
     * 不传deptId默认查询"數據自決研發中心"部门
     *
     * @param deptId 部门id
     * @return 返回
     */
    @DWRequestMapping(path = "board/user/queryUserList", method = {DWRequestMethod.POST})
    @AllowAnonymous
    List<ZtUser> queryUserList(@RequestParam(required = false) Integer deptId);

    /**
     * 查询项目集列表
     * 不传programId默认查询"数据自决研发中心"项目集
     *
     * @param programId 项目集id
     * @return 返回
     */
    @DWRequestMapping(path = "board/program/queryProgramList", method = {DWRequestMethod.POST})
    @AllowAnonymous
    List<ZtProjectLevelVO> queryProgramList(@RequestParam(required = false) Integer programId);

    /**
     * 查询项目列表
     * 不传programId默认查询"数据自决研发中心"项目集
     *
     * @param programId 项目集id
     * @return 返回
     */
    @DWRequestMapping(path = "board/project/queryProjectList", method = {DWRequestMethod.POST})
    @AllowAnonymous
    List<ZtProjectLevelVO> queryProjectList(@RequestParam(required = false) Integer programId);

    /**
     * 查询冲刺列表
     * 不传id默认查询"数据自决研发中心"项目集
     *
     * @param id 项目集id或项目id
     * @return 返回
     */
    @DWRequestMapping(path = "board/sprint/querySprintList", method = {DWRequestMethod.POST})
    @AllowAnonymous
    List<ZtProjectLevelVO> querySprintList(@RequestParam(required = false) Integer id);

    /**
     * 查询部门tab用户任务列表
     *
     * @param queryTaskReq 请求对象
     * @return 返回
     */
    @DWRequestMapping(path = "board/task/queryTaskListByDept", method = {DWRequestMethod.POST})
    @AllowAnonymous
    ZtTaskRespVO queryTaskListByDept(@RequestBody queryTaskReq queryTaskReq);

    /**
     * 查询项目tab用户任务列表
     *
     * @param queryTaskReq 请求对象
     * @return 返回
     */
    @DWRequestMapping(path = "board/task/queryTaskListByProject", method = {DWRequestMethod.POST})
    @AllowAnonymous
    ZtTaskRespVO queryTaskListByProject(@RequestBody queryTaskReq queryTaskReq);
}
