package com.digiwin.athena.dtdapp.provider;

import com.digiwin.app.service.AllowAnonymous;
import com.digiwin.app.service.DWService;
import com.digiwin.app.service.restful.DWRequestMapping;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.app.service.restful.DWRestfulService;
import com.digiwin.athena.dtdapp.dao.zentao.ZtProjectDAO;
import com.digiwin.athena.dtdapp.pojo.dto.zt.ZtProjectDTO;
import com.digiwin.athena.dtdapp.pojo.dto.zt.ZtUserScoreDTO;
import com.digiwin.athena.dtdapp.pojo.entity.zentao.ZtProject;
import com.digiwin.athena.dtdapp.pojo.entity.zentao.ZtTask;
import com.digiwin.athena.dtdapp.pojo.entity.zentao.ZtUser;
import com.digiwin.athena.dtdapp.pojo.vo.zentaoplus.*;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Collection;
import java.util.List;

@DWRestfulService
public interface IZtPlusProjectService extends DWService {

    /**
     * 项目维度查询页面
     * @param parentProjectName 项目名称
     * @param status 项目状态
     */
    @DWRequestMapping(path = "project/projectWithTeamInfo", method = {DWRequestMethod.GET})
    @AllowAnonymous
    Collection<ProjectWithTeamInfoVo> getProjectWithTeamInfoList(@RequestParam String parentProjectName,
                                                                        @RequestParam(required = false) String projectName,
                                                                        @RequestParam(required = false) String status);

    /**
     * 每个项目工时明细
     * @param projectId 上个接口返回的 id
     * @param userName 人员名称
     * @param beginDate 开始时间 2024-05-06
     * @param endDate 结束时间 2024-07-31
     */
    @DWRequestMapping(path = "project/projectTeamDetail", method = {DWRequestMethod.GET})
    @AllowAnonymous
    Collection<ProjectTeamDetailVo> getProjectTeamDetailList(@RequestParam int projectId,
                                                                    @RequestParam(required = false) String userName,
                                                                    @RequestParam String beginDate,
                                                                    @RequestParam String endDate);

    /**
     * 人员预估和消耗工时
     * @param deptId 部门Id
     * @param userName 人员名称
     * @param beginDate 开始时间 2024-05-06
     * @param endDate 结束时间 2024-07-31
     */
    @DWRequestMapping(path = "project/userEstimateAndConsumed", method = {DWRequestMethod.GET})
    @AllowAnonymous
    Collection<UserEstimateAndConsumedVo> getUserEstimateAndConsumedList(@RequestParam int deptId,
                                                                                @RequestParam(required = false) String userName,
                                                                                @RequestParam String beginDate,
                                                                                @RequestParam String endDate);

    /**
     * 人员项目消耗工时
     * @param userId 人员 ID
     * @param beginDate 开始时间 2024-05-06
     * @param endDate 结束时间 2024-07-31
     */
    @DWRequestMapping(path = "project/userProjectConsumed", method = {DWRequestMethod.GET})
    @AllowAnonymous
    Collection<UserProjectConsumedVo> getUserProjectConsumedList(@RequestParam int userId,
                                                                        @RequestParam String beginDate,
                                                                        @RequestParam String endDate);

    @DWRequestMapping(path = "project/getDateToProjectConsumed", method = {DWRequestMethod.GET})
    @AllowAnonymous
    List<DateToProjectConsumedVo> getDateToProjectConsumedVoList(@RequestParam String parentProjectName,
                                                                        @RequestParam String beginDate,
                                                                        @RequestParam String endDate);

    /**
     * 根据项目名称和部门获取项目里程碑
     * @param projectName 项目名称
     * @param programId 项目集id
     * @return 返回项目里程碑
     */
    @DWRequestMapping(path = "project/getMilestone", method = {DWRequestMethod.GET})
    @AllowAnonymous
    List<ZtProjectDTO> getMilestoneByName(@RequestParam String projectName,
                                          @RequestParam Integer programId);

    /**
     * 根据父级id获取项目集
     *
     * @param id 父级id
     * @return 返回项目里程碑
     */
    @DWRequestMapping(path = "project/getProgramByParentId", method = {DWRequestMethod.GET})
    @AllowAnonymous
    List<ZtProjectDTO> getProgramByParentId(@RequestParam Integer id);


    /**
     * 根据部门id获取用户
     *
     * @param deptId 部门id
     * @return 返回用户信息
     */
    @DWRequestMapping(path = "project/getUserByDept", method = {DWRequestMethod.GET})
    @AllowAnonymous
    List<ZtUser> getUserByDept(@RequestParam Integer deptId, @RequestParam String name);

    /**
     * 获取用户得分
     *
     * @param userId 用户id
     * @param deptId 部门
     * @param date 时间
     * @return 返回用户信息
     */
    @DWRequestMapping(path = "project/getUserScore", method = {DWRequestMethod.GET})
    @AllowAnonymous
    List<ZtUserScoreVO> getUserScore(@RequestParam Integer userId,
                                     @RequestParam Integer deptId,
                                     @RequestParam String date);

    /**
     * 获取用户得分任务
     *
     * @param account 用户id
     * @param date 时间
     * @return 返回用户信息
     */
    @DWRequestMapping(path = "project/getUserScoreTask", method = {DWRequestMethod.GET})
    @AllowAnonymous
    List<ZtTask> getUserScoreTask(@RequestParam String account,
                                  @RequestParam String date);
}
