package com.digiwin.athena.dtdapp.provider.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.app.service.DWEAIResult;
import com.digiwin.app.sql.transaction.seata.DWSeataUtils;
import com.digiwin.athena.dtdapp.dao.DorDoDCheckItemDAO;
import com.digiwin.athena.dtdapp.pojo.entity.DorDodCheckItem;
import com.digiwin.athena.dtdapp.pojo.entity.DorDodCheckResult;
import com.digiwin.athena.dtdapp.pojo.entity.DorDodInfo;
import com.digiwin.athena.dtdapp.pojo.vo.DorDodCallBackVO;
import com.digiwin.athena.dtdapp.pojo.vo.DorDodCheckResultVO;
import com.digiwin.athena.dtdapp.pojo.vo.DorDodInfoVO;
import com.digiwin.athena.dtdapp.provider.IDorDodProvider;
import com.digiwin.athena.dtdapp.service.DorDodService;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Slf4j
public class DorDodProviderImpl implements IDorDodProvider {

    @Autowired
    private DorDoDCheckItemDAO dorDoDCheckItemDAO;

    @Autowired
    private DorDodService dorDodService;


    @Override
    public DWEAIResult getDorDodCheckItems(Map<String, String> headers, String messageBody) throws Exception {
        Map map = JSONObject.parseObject(messageBody, Map.class);
        List list = dorDoDCheckItemDAO.getDorDodCheckItems(map);
        Map<String, Object> info = new HashMap<>();
        info.put("check_item_info", list);
        return new DWEAIResult("0", "0", "OK", info);
    }

    @Override
    public DWEAIResult saveDorDodCheckItems(Map<String, String> headers, String messageBody) throws Exception {
        Map map = JSONObject.parseObject(messageBody, Map.class);
        List list = dorDoDCheckItemDAO.saveDorDodCheckItems(map);
        Map<String, Object> info = new HashMap<>();
        info.put("check_item_info", list);
        return new DWEAIResult("0", "0", "OK", info);
    }


    @Override
    public DWEAIResult createDorDodInfo(Map<String, String> headers, String messageBody) throws Exception {
        Map map = JSONObject.parseObject(messageBody, Map.class);
        JSONObject obj = JSON.parseObject(JSON.toJSONString(map));
        JSONArray jsonArray = obj.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("dor_dod_info");
        if (jsonArray == null || jsonArray.size() == 0) {
            throw new DWRuntimeException("has no data to save");
        }

        List<DorDodInfoVO> dorDodCheckItems = JSON.parseArray(JSON.toJSONString(jsonArray), DorDodInfoVO.class);

        this.dorDodService.initDorDodInfo(dorDodCheckItems);

        Map<String, Object> info = new HashMap<>();
        info.put("dor_dod_info", dorDodCheckItems);
        return new DWEAIResult("0", "0", "OK", info);
    }

    @Override
    public DWEAIResult getDorDodCheckResult(Map<String, String> headers, String messageBody) throws Exception {
        Map map = JSONObject.parseObject(messageBody, Map.class);
        JSONObject obj = JSON.parseObject(JSON.toJSONString(map));
        JSONArray jsonArray = obj.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("dor_dod_info");

        List<DorDodCheckResult> dorDodCheckResults = JSON.parseArray(JSON.toJSONString(jsonArray), DorDodCheckResult.class);

        List<DorDodCheckResultVO> result = null;
        if (CollectionUtils.isEmpty(dorDodCheckResults)) {
            result = new ArrayList<>();
        } else {
            result = this.dorDodService.getDorDodCheckResult(dorDodCheckResults);
        }


        Map<String, Object> info = new HashMap<>();
        info.put("dor_dod_info", result);
        return new DWEAIResult("0", "0", "OK", info);
    }

    @Override
    public DWEAIResult updateDorDodCheckResult(Map<String, String> headers, String messageBody) throws Exception {
        Map map = JSONObject.parseObject(messageBody, Map.class);
        JSONObject obj = JSON.parseObject(JSON.toJSONString(map));
        JSONArray jsonArray = obj.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("dor_dod_info");

        List<DorDodCheckResultVO> dorDodCheckResults = JSON.parseArray(JSON.toJSONString(jsonArray), DorDodCheckResultVO.class);

        this.dorDodService.updateDorDodCheckResult(dorDodCheckResults);

        Map<String, Object> info = new HashMap<>();
        info.put("dor_dod_info", jsonArray);
        return new DWEAIResult("0", "0", "OK", info);

    }

    @Override
    public DWEAIResult auditDorDodCheckResult(Map<String, String> headers, String messageBody) throws Exception {
        Map map = JSONObject.parseObject(messageBody, Map.class);
        JSONObject obj = JSON.parseObject(JSON.toJSONString(map));
        JSONArray jsonArray = obj.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("dor_dod_info");

        List<DorDodCheckResultVO> dorDodCheckResults = JSON.parseArray(JSON.toJSONString(jsonArray), DorDodCheckResultVO.class);

        this.dorDodService.auditDorDodCheckResult(dorDodCheckResults);

        Map<String, Object> info = new HashMap<>();
        info.put("dor_dod_info", jsonArray);
        return new DWEAIResult("0", "0", "OK", info);

    }

    @Override
    public DWEAIResult getDorDodCheckResultDetail(Map<String, String> headers, String messageBody) throws Exception {
        Map map = JSONObject.parseObject(messageBody, Map.class);
        JSONObject obj = JSON.parseObject(JSON.toJSONString(map));
        JSONArray jsonArray = obj.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("dor_dod_info");

        List<DorDodCheckResult> dorDodCheckResults = JSON.parseArray(JSON.toJSONString(jsonArray), DorDodCheckResult.class);

        List<DorDodCheckResult> result = this.dorDodService.getDorDodCheckResultDetail(jsonArray.getJSONObject(0));

        Map<String, Object> info = new HashMap<>();
        info.put("dor_dod_info", result);
        return new DWEAIResult("0", "0", "OK", info);
    }

    @Override
    public DWEAIResult callbackDorDodCheckResult(Map<String, String> headers, String messageBody) throws Exception {
        Map map = JSONObject.parseObject(messageBody, Map.class);
        JSONObject obj = JSON.parseObject(JSON.toJSONString(map));
        JSONArray jsonArray = obj.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("dor_dod_info");
        List<DorDodCallBackVO> dorDodCallBackVOS = JSON.parseArray(JSON.toJSONString(jsonArray), DorDodCallBackVO.class);
        this.dorDodService.callbackDorDodCheckResult(dorDodCallBackVOS);
        Map<String, Object> info = new HashMap<>();
        return new DWEAIResult("0", "0", "OK", info);
    }
}
