package com.digiwin.athena.dtdapp.provider.impl;

import com.digiwin.app.service.DWFile;
//import com.digiwin.athena.dtdapp.mappermdc.ProductMapper;
import com.digiwin.athena.dtdapp.pojo.vo.publish.CompareEnv;
import com.digiwin.athena.dtdapp.pojo.vo.publish.PublishRequest;
import com.digiwin.athena.dtdapp.pojo.vo.publish.PublishResult;
import com.digiwin.athena.dtdapp.provider.IPublishService;
import com.digiwin.athena.dtdapp.service.DtdappPublishService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.*;

@Slf4j
public class DtdappPublishServiceImpl implements IPublishService {

    @Autowired
    DtdappPublishService publishService;

    @Override
    public Object publishEspActionByProduct(PublishRequest publishRequest) {

        List<String> productList = publishRequest.getProductList();
        if(CollectionUtils.isEmpty(productList)){
            return "productList is null";
        }


        Object result = publishService.publishEspActionByProduct(publishRequest);

        return null;
    }

    @Override
    public Object publishEspActionByService(PublishRequest publishRequest) {
        if(CollectionUtils.isEmpty(publishRequest.getServiceNameList())){
            return "serviceNameList is null";
        }
        Object result = publishService.publishEspActionByServiceNameList(publishRequest.getServiceNameList());
        return null;
    }

    @Override
    public Object generateActionScriptByProduct(PublishRequest publishRequest) {
        List<String> productList = publishRequest.getProductList();
        if(CollectionUtils.isEmpty(productList)){
            return "productList is null";
        }


        Object result = publishService.generateActionScriptByProduct(publishRequest);

        return null;
    }

    @Override
    public Object generateActionScriptByService(PublishRequest publishRequest) {
        if(CollectionUtils.isEmpty(publishRequest.getServiceNameList())){
            return "serviceNameList is null";
        }
        Object result = publishService.generateActionScriptByServiceNameList(publishRequest.getServiceNameList(), publishRequest.getCreateFrom(),publishRequest.getVersion());

        return null;
    }

    @Override
    public Object executeNeo4jScript(DWFile dwFile) {
        PublishResult publishResult = publishService.executeScript(dwFile);

        return publishResult;
    }


    @Override
    public Object compareEnv(CompareEnv compareEnv) {
        Map<String, Object> oldEnv = compareEnv.getOldEnv();

        Map<String, Object> newEnv = compareEnv.getNewEnv();

        Map<String, Object> result = new HashMap<>();
        Map<String, Object> atOld = new TreeMap<>() ;
        Map<String, Object> atNew = new TreeMap<>();

        for(Map.Entry<String, Object> entry : newEnv.entrySet()){
           if(!oldEnv.containsKey(entry.getKey())) {
               atNew.put(entry.getKey(), entry.getValue());
           }
        }

        for(Map.Entry<String, Object> entry : oldEnv.entrySet()){
            if(!newEnv.containsKey(entry.getKey())) {
                atOld.put(entry.getKey(), entry.getValue());
            }
        }

        result.put("atNew", atNew);
        result.put("atOld", atOld);

        return result;
    }


}
