package com.digiwin.athena.dtdapp.provider.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.service.DWEAIResult;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.dtdapp.dao.EmployeeEntryInfoDAO;
import com.digiwin.athena.dtdapp.dao.EmployeeEntryInfoDAO2;
import com.digiwin.athena.dtdapp.provider.IEmployeeEntryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EmployeeEntryServiceImpl implements IEmployeeEntryService {

    private static final Logger LOGGER = LoggerFactory.getLogger(EmployeeEntryServiceImpl.class);


    @Autowired
    private EmployeeEntryInfoDAO2 employeeEntryInfoDAO;


    @Override
    public DWEAIResult postCreateEmployeeEntryInfo(Map<String, String> headers, String messageBody) throws Exception {
        Map map = JSONObject.parseObject(messageBody, Map.class);
        List list = employeeEntryInfoDAO.insertEmployeeEntryInfo(map);
        Map<String, Object> info = new HashMap<>();
        info.put("emp_entry_info", list);
        return new DWEAIResult("0", "0", "OK", info);
    }

    @Override
    public DWEAIResult postUpdateEmployeeEntryInfo(Map<String, String> headers, String messageBody) throws Exception {
        Map map = JSONObject.parseObject(messageBody, Map.class);
        List list = employeeEntryInfoDAO.updateEmployeeEntryInfo(map);
        Map<String, Object> info = new HashMap<>();
        info.put("emp_entry_info", list);
        return new DWEAIResult("0", "0", "OK", info);
    }

    @Override
    public DWEAIResult getEmployeeEntryInfo(Map<String, String> headers, String messageBody) throws DWException {
        Map<String, Object> profile = DWServiceContext.getContext().getProfile();
        Map map = JSONObject.parseObject(messageBody, Map.class);
        Map<String, Object> info = new HashMap<>();
        List employeeEntryInfo = employeeEntryInfoDAO.getEmployeeEntryInfo(map);
        info.put("emp_entry_info", employeeEntryInfo);
        return new DWEAIResult("0", "0", "OK", info);
    }
}
