package com.digiwin.athena.dtdapp.provider.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.DWEAIResult;
import com.digiwin.athena.dtdapp.pojo.entity.newemployeereview.NewEmployeeReviewProportion;
import com.digiwin.athena.dtdapp.pojo.entity.newemployeereview.NewEmployeesReviewDetail;
import com.digiwin.athena.dtdapp.pojo.vo.newemployeereview.NewEmployeeReviewInfoVO;
import com.digiwin.athena.dtdapp.pojo.vo.newemployeereview.NewEmployeeReviewInfoVO2;
import com.digiwin.athena.dtdapp.pojo.vo.newemployeereview.NewEmployeeReviewProportionVO;
import com.digiwin.athena.dtdapp.pojo.vo.newemployeereview.ReviewProportionVO;
import com.digiwin.athena.dtdapp.provider.INewEmployeeReview;
import com.digiwin.athena.dtdapp.service.NewEmployeeReviewService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Slf4j
public class NewEmployeeReviewImpl implements INewEmployeeReview {

    @Autowired
    private NewEmployeeReviewService newEmployeeReviewService;

    @Override
    public DWEAIResult getNewEmployeeReviewDetail(Map<String, String> headers, String messageBody) throws Exception {
        Map map = JSONObject.parseObject(messageBody, Map.class);

        List<NewEmployeeReviewInfoVO> list = newEmployeeReviewService.getNewEmployeeReviewInfo(map);
        Map<String, Object> info = new HashMap<>();
        info.put("new_employees_review_info", list);
        return new DWEAIResult("0", "0", "OK", info);
    }

    @Override
    public DWEAIResult getNewEmployeeReviewDetailOne(Map<String, String> headers, String messageBody) throws Exception {
        Map map = JSONObject.parseObject(messageBody, Map.class);
        NewEmployeeReviewInfoVO newEmployeeReviewInfoVO = newEmployeeReviewService.getNewEmployeeReviewInfoOne(map);
        Map<String, Object> info = new HashMap<>();
        info.put("new_employees_review_info", newEmployeeReviewInfoVO);
        return new DWEAIResult("0", "0", "OK", info);
    }

    @Override
    public DWEAIResult getNewEmployeeReviewMonthlyReportDate(Map<String, String> headers, String messageBody) throws Exception {
        Map map = JSONObject.parseObject(messageBody, Map.class);
        List<NewEmployeeReviewInfoVO> list = newEmployeeReviewService.getNewEmployeeReviewMonthlyReportDate(map);
        Map<String, Object> info = new HashMap<>();
        info.put("new_employees_review_info", list);
        return new DWEAIResult("0", "0", "OK", info);
    }

    @Override
    public DWEAIResult getNewEmployeeReviewMonthlyReportTaskCardCompletionStatus(Map<String, String> headers, String messageBody) throws Exception {
        Map map = JSONObject.parseObject(messageBody, Map.class);
        List<NewEmployeeReviewInfoVO> list = newEmployeeReviewService.getNewEmployeeReviewMonthlyReportTaskCardCompletionStatus(map);
        Map<String, Object> info = new HashMap<>();
        info.put("new_employees_review_info", list);
        return new DWEAIResult("0", "0", "OK", info);
    }

    @Override
    public DWEAIResult getNewEmployeeReviewMonthlyReportOnDutySituation(Map<String, String> headers, String messageBody) throws Exception {
        Map map = JSONObject.parseObject(messageBody, Map.class);
        List<NewEmployeeReviewInfoVO> list = newEmployeeReviewService.getNewEmployeeReviewMonthlyReportOnDutySituation(map);
        Map<String, Object> info = new HashMap<>();
        info.put("new_employees_review_info", list);
        return new DWEAIResult("0", "0", "OK", info);
    }
    @Override
    public DWEAIResult getNewEmployeeReviewMonthlyReportRetentionSituation(Map<String, String> headers, String messageBody) throws Exception {
        Map map = JSONObject.parseObject(messageBody, Map.class);
        List<NewEmployeeReviewInfoVO> list = newEmployeeReviewService.getNewEmployeeReviewMonthlyReportRetentionSituation(map);
        Map<String, Object> info = new HashMap<>();
        info.put("new_employees_review_info", list);
        return new DWEAIResult("0", "0", "OK", info);
    }
    @Override
    public DWEAIResult getNewEmployeeReviewMonthlyReportScore(Map<String, String> headers, String messageBody) throws Exception {
        Map map = JSONObject.parseObject(messageBody, Map.class);
        List<NewEmployeeReviewInfoVO> list = newEmployeeReviewService.getNewEmployeeReviewMonthlyReportScore(map);
        Map<String, Object> info = new HashMap<>();
        info.put("new_employees_review_info", list);
        return new DWEAIResult("0", "0", "OK", info);
    }

    @Override
    public DWEAIResult getNewEmployeeReviewMonthlyReportCheckAndAccept(Map<String, String> headers, String messageBody) throws Exception {
        Map map = JSONObject.parseObject(messageBody, Map.class);
        List<NewEmployeeReviewInfoVO> list = newEmployeeReviewService.getNewEmployeeReviewMonthlyReportCheckAndAccept(map);
        Map<String, Object> info = new HashMap<>();
        info.put("new_employees_review_info", list);
        return new DWEAIResult("0", "0", "OK", info);
    }

    @Override
    public DWEAIResult getNewEmployeeReviewMonthlyReportAcceptanceRating(Map<String, String> headers, String messageBody) throws Exception {
        Map map = JSONObject.parseObject(messageBody, Map.class);
        List<NewEmployeeReviewInfoVO> list = newEmployeeReviewService.getNewEmployeeReviewMonthlyReportAcceptanceRating(map);
        Map<String, Object> info = new HashMap<>();
        info.put("new_employees_review_info", list);
        return new DWEAIResult("0", "0", "OK", info);
    }
//   // @Override
//    public DWEAIResult getNewEmployeeReviewMonthlyReport(Map<String, String> headers, String messageBody) throws Exception {
//        Map map = JSONObject.parseObject(messageBody, Map.class);
//        List<NewEmployeeReviewProportionMapper> list = newEmployeeReviewService.getNewEmployeeReviewMonthlyReport(map);
//        Map<String, Object> info = new HashMap<>();
//        info.put("new_employees_review_info", list);
//        return new DWEAIResult("0", "0", "OK", info);
//    }

    @Override
    public DWEAIResult getNewEmployeeReviewMonthlyReportDetail(Map<String, String> headers, String messageBody) throws Exception {
        Map map = JSONObject.parseObject(messageBody, Map.class);
        List<NewEmployeeReviewInfoVO2> list = newEmployeeReviewService.getNewEmployeeReviewMonthlyReportDetail(map);
        Map<String, Object> info = new HashMap<>();
        info.put("new_employees_review_info", list);
        return new DWEAIResult("0", "0", "OK", info);
    }


    @Override
    public DWEAIResult getNewEmployeeReviewStatusUpdate(Map<String, String> headers, String messageBody) throws Exception {
        Map map = JSONObject.parseObject(messageBody, Map.class);
        List<NewEmployeesReviewDetail> list = newEmployeeReviewService.getNewEmployeeReviewStatusUpdate(map);
        Map<String, Object> info = new HashMap<>();
        info.put("new_employees_review_info", list);
        return new DWEAIResult("0", "0", "OK", info);
    }

    @Override
    public DWEAIResult updateNewcomerStatistics(Map<String, String> headers, String messageBody) throws Exception {
        Map map = JSONObject.parseObject(messageBody, Map.class);
        List<NewEmployeeReviewProportion> list = newEmployeeReviewService.updateNewcomerStatistics();
        Map<String, Object> info = new HashMap<>();
        info.put("new_employees_review_info", list);
        return new DWEAIResult("0", "0", "OK", info);
    }
}
