package com.digiwin.athena.dtdapp.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.dtdapp.dao.DorDoDCheckItemDAO;
import com.digiwin.athena.dtdapp.dao.DorDoDCheckResultDAO;
import com.digiwin.athena.dtdapp.dao.DorDodCheckInfoDAO;
import com.digiwin.athena.dtdapp.pojo.entity.DorDodCheckItem;
import com.digiwin.athena.dtdapp.pojo.entity.DorDodCheckResult;
import com.digiwin.athena.dtdapp.pojo.entity.DorDodInfo;
import com.digiwin.athena.dtdapp.pojo.vo.DorDodCallBackVO;
import com.digiwin.athena.dtdapp.pojo.vo.DorDodCheckItemVO;
import com.digiwin.athena.dtdapp.pojo.vo.DorDodCheckResultVO;
import com.digiwin.athena.dtdapp.pojo.vo.DorDodInfoVO;
import com.digiwin.athena.dtdapp.util.DateUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.convert.QueryMapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.lang.reflect.InvocationTargetException;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Service
public class DorDodService {

    @Autowired
    private DorDodCheckInfoDAO dorDodCheckInfoDAO;

    @Autowired
    private DorDoDCheckResultDAO dorDodCheckResultDAO;

    @Autowired
    private DorDoDCheckItemDAO dorDoDCheckItemDAO;


    @Transactional
    public void initDorDodInfo(List<DorDodInfoVO> dorDodInfoList)  throws Exception{
        Map<String, Object> profile = DWServiceContext.getContext().getProfile();
        String userId = String.valueOf(profile.get("userId"));

        List<DorDodInfo> list = new ArrayList<>();
        for(DorDodInfoVO dorDodInfoVO : dorDodInfoList){
            DorDodInfo dorDodInfo = new DorDodInfo();
            BeanUtils.copyProperties(dorDodInfoVO, dorDodInfo);

            List<DorDodCheckItem> develop_dor_info = dorDodInfoVO.getDevelop_dor_info();
            List<Long> devDorIds = develop_dor_info.stream().map(DorDodCheckItem::getId).collect(Collectors.toList());
            List<DorDodCheckItem> qc_dor_info = dorDodInfoVO.getQc_dor_info();
            List<Long> qcDorIds = qc_dor_info.stream().map(DorDodCheckItem::getId).collect(Collectors.toList());
            List<DorDodCheckItem> develop_dod_info = dorDodInfoVO.getDevelop_dod_info();
            List<Long> devDoDIds = develop_dod_info.stream().map(DorDodCheckItem::getId).collect(Collectors.toList());
            List<DorDodCheckItem> qc_dod_info = dorDodInfoVO.getQc_dod_info();
            List<Long> qcDodIds = qc_dod_info.stream().map(DorDodCheckItem::getId).collect(Collectors.toList());

            dorDodInfo.setDevelop_dor(StringUtils.join(devDorIds, ","));
            dorDodInfo.setDevelop_dod(StringUtils.join(devDoDIds, ","));
            dorDodInfo.setQc_dor(StringUtils.join(qcDorIds, ","));
            dorDodInfo.setQc_dod(StringUtils.join(qcDodIds, ","));


            dorDodInfo.setCreate_by(userId);
            dorDodInfo.setCreate_time(DateUtils.getDateTimeNow());
            //便于查找对应数据
            String uuid = UUID.randomUUID().toString();
            dorDodInfo.setTrace_id(uuid);
            dorDodInfoVO.setTrace_id(uuid);

            list.add(dorDodInfo);
        }
        this.dorDodCheckInfoDAO.saveBatch(list);

       this.initDorDodCheckResult(dorDodInfoList);


    }

    private void initDorDodCheckResult(List<DorDodInfoVO> dorDodInfoList) throws Exception{
        List<DorDodCheckResult> dorDodCheckResults = new ArrayList<>();

        List<DorDodCheckItem> dorDodCheckItems = this.dorDoDCheckItemDAO.getBaseMapper().selectList(new QueryWrapper<>());
        Map<Long, DorDodCheckItem> collect = dorDodCheckItems.stream().collect(Collectors.toMap(DorDodCheckItem::getId, Function.identity(), (a, b) -> b));


        for(DorDodInfoVO dorDodInfo : dorDodInfoList){
            // 对每个需求 开发dor/dod 测试dor/dod 生成一条DorDodCheckResult初始对象
            List<DorDodCheckItem> develop_dor_info = dorDodInfo.getDevelop_dor_info();
            List<DorDodCheckItem> qc_dor_info = dorDodInfo.getQc_dor_info();
            List<DorDodCheckItem> develop_dod_info = dorDodInfo.getDevelop_dod_info();
            List<DorDodCheckItem> qc_dod_info = dorDodInfo.getQc_dod_info();

            for (DorDodCheckItem s : develop_dor_info) {
                DorDodCheckResult dorDodCheckResult = new DorDodCheckResult();
                BeanUtils.copyProperties(dorDodInfo, dorDodCheckResult);

                DorDodCheckItem dorDodCheckItem = collect.get(s.getId());

                dorDodCheckResult.setCheck_id(s.getId());
                dorDodCheckResult.setCheck_type(dorDodCheckItem.getCheck_type());
                dorDodCheckResult.setCheck_item(s.getCheck_item());
                dorDodCheckResult.setCheck_result_type(dorDodCheckItem.getCheck_result_type());
                dorDodCheckResult.setChecker_id(dorDodInfo.getDeveloper_id());
                dorDodCheckResult.setChecker_name(dorDodInfo.getDeveloper_name());
                dorDodCheckResult.setCreate_time(DateUtils.getDateTimeNow());
                dorDodCheckResult.setStatus("0");
                dorDodCheckResults.add(dorDodCheckResult);
            }

            for (DorDodCheckItem s : qc_dor_info) {
                DorDodCheckResult dorDodCheckResult = new DorDodCheckResult();
                BeanUtils.copyProperties(dorDodInfo, dorDodCheckResult);
                DorDodCheckItem dorDodCheckItem = collect.get(s.getId());

                dorDodCheckResult.setCheck_id(s.getId());
                dorDodCheckResult.setCheck_type(dorDodCheckItem.getCheck_type());
                dorDodCheckResult.setCheck_item(s.getCheck_item());
                dorDodCheckResult.setCheck_result_type(dorDodCheckItem.getCheck_result_type());
                dorDodCheckResult.setChecker_id(dorDodInfo.getQc_id());
                dorDodCheckResult.setChecker_name(dorDodInfo.getQc_name());
                dorDodCheckResult.setCreate_time(DateUtils.getDateTimeNow());
                dorDodCheckResult.setStatus("0");
                dorDodCheckResults.add(dorDodCheckResult);
            }

            for (DorDodCheckItem s : develop_dod_info) {
                DorDodCheckResult dorDodCheckResult = new DorDodCheckResult();
                BeanUtils.copyProperties(dorDodInfo, dorDodCheckResult);
                DorDodCheckItem dorDodCheckItem = collect.get(s.getId());

                dorDodCheckResult.setCheck_id(s.getId());
                dorDodCheckResult.setCheck_type(dorDodCheckItem.getCheck_type());
                dorDodCheckResult.setCheck_item(s.getCheck_item());
                dorDodCheckResult.setCheck_result_type(dorDodCheckItem.getCheck_result_type());
                dorDodCheckResult.setChecker_id(dorDodInfo.getDeveloper_id());
                dorDodCheckResult.setChecker_name(dorDodInfo.getDeveloper_name());
                dorDodCheckResult.setCreate_time(DateUtils.getDateTimeNow());
                dorDodCheckResult.setStatus("0");
                dorDodCheckResults.add(dorDodCheckResult);
            }

            for (DorDodCheckItem s : qc_dod_info) {
                DorDodCheckResult dorDodCheckResult = new DorDodCheckResult();
                BeanUtils.copyProperties(dorDodInfo, dorDodCheckResult);
                DorDodCheckItem dorDodCheckItem = collect.get(s.getId());

                dorDodCheckResult.setCheck_id(s.getId());
                dorDodCheckResult.setCheck_type(dorDodCheckItem.getCheck_type());
                dorDodCheckResult.setCheck_item(s.getCheck_item());
                dorDodCheckResult.setCheck_result_type(dorDodCheckItem.getCheck_result_type());

                dorDodCheckResult.setChecker_id(dorDodInfo.getQc_id());
                dorDodCheckResult.setChecker_name(dorDodInfo.getQc_name());
                dorDodCheckResult.setCreate_time(DateUtils.getDateTimeNow());
                dorDodCheckResult.setStatus("0");
                dorDodCheckResults.add(dorDodCheckResult);
            }

        }

        this.dorDodCheckResultDAO.saveBatch(dorDodCheckResults);

    }

    public List<DorDodCheckResultVO> getDorDodCheckResult(List<DorDodCheckResult> queryList) throws Exception {
        List<DorDodCheckResultVO> result = new ArrayList<>();

        DorDodCheckResult dorDodCheckResult = queryList.get(0);
        List<String> queryTraceIds = queryList.stream().map(DorDodCheckResult::getTrace_id).collect(Collectors.toList());

        String batch_no = dorDodCheckResult.getBatch_no(); // queryParam.getString("batch_no");
        String checker_id = dorDodCheckResult.getChecker_id(); // queryParam.getString("checker_id");
        String status = dorDodCheckResult.getStatus(); // queryParam.getString("status");
        String audit_status = dorDodCheckResult.getAudit_status(); // queryParam.getString("audit_status");
        String check_type = dorDodCheckResult.getCheck_type(); // queryParam.getString("check_type");

        QueryWrapper<DorDodCheckResult> queryWrapper = new QueryWrapper<>();
        LambdaQueryWrapper<DorDodCheckResult> queryWrapperLambada = queryWrapper.lambda().eq(DorDodCheckResult::getBatch_no, batch_no);

        if(StringUtils.isNotEmpty(checker_id)){
            queryWrapperLambada.eq(DorDodCheckResult::getChecker_id, checker_id);
        }
        if(StringUtils.isNotEmpty(status)){
            queryWrapperLambada.eq(DorDodCheckResult::getStatus, status);
        }
        if(StringUtils.isNotEmpty(audit_status)){
            queryWrapperLambada.eq(DorDodCheckResult::getAudit_status, audit_status);
        }
        if(StringUtils.isNotEmpty(check_type)){
            switch (check_type){
                case "dor":
                    queryWrapperLambada.in(DorDodCheckResult::getCheck_type, Arrays.asList("dev_dor", "qc_dor"));
                    break;
                case "dod":
                    queryWrapperLambada.in(DorDodCheckResult::getCheck_type, Arrays.asList("dev_dod", "qc_dod"));
                    break;
                default:
                    queryWrapperLambada.eq(DorDodCheckResult::getCheck_type, check_type);
                    break;
            }

        }

        if(CollectionUtils.isNotEmpty(queryTraceIds)){
            queryWrapperLambada.in(DorDodCheckResult::getTrace_id, queryTraceIds);
        }

        List<DorDodCheckResult> dorDodCheckResults = this.dorDodCheckResultDAO.getBaseMapper().selectList(queryWrapper);

        if(CollectionUtils.isEmpty(dorDodCheckResults)){
            return result;
        }

        List<String> collect = dorDodCheckResults.stream().map(DorDodCheckResult::getTrace_id).collect(Collectors.toList());

        List<DorDodInfo> dorDodInfos = this.dorDodCheckInfoDAO.getBaseMapper().selectList(new QueryWrapper<DorDodInfo>().lambda().in(DorDodInfo::getTrace_id, collect));



        for(DorDodInfo dorDodInfo : dorDodInfos){
            DorDodCheckResultVO dorDodCheckResultVO = new DorDodCheckResultVO();
            BeanUtils.copyProperties(dorDodInfo, dorDodCheckResultVO);

            List<DorDodCheckResult> collect2 = dorDodCheckResults.stream().filter(e -> StringUtils.equals(dorDodInfo.getTrace_id(), e.getTrace_id())).collect(Collectors.toList());

            List<DorDodCheckItemVO> dorDodCheckItemVOS = JSONArray.parseArray(JSON.toJSONString(collect2), DorDodCheckItemVO.class);

            dorDodCheckResultVO.setCheck_item_info(dorDodCheckItemVOS);

            dorDodCheckResultVO.setChecker_id(collect2.get(0).getChecker_id());

            dorDodCheckResultVO.setChecker_name(collect2.get(0).getChecker_name());



            result.add(dorDodCheckResultVO);
        }



        return result;
    }

    @Transactional
    public void updateDorDodCheckResult(List<DorDodCheckResultVO> dorDodCheckResults) throws Exception {

        for(DorDodCheckResultVO dorDodCheckResultVO : dorDodCheckResults){

            List<DorDodCheckItemVO> check_item_info = dorDodCheckResultVO.getCheck_item_info();
            for(DorDodCheckItemVO dorDodCheckItemVO : check_item_info){
                DorDodCheckResult dorDodCheckResult = new DorDodCheckResult();
                dorDodCheckResult.setStatus("1");  //固定为1， 审核的调用另一个接口
                dorDodCheckResult.setAudit_status("0");
                dorDodCheckResult.setNeed_check(dorDodCheckItemVO.getNeed_check());
                dorDodCheckResult.setCheck_result(dorDodCheckItemVO.getCheck_result());
                dorDodCheckResult.setUpdate_time(DateUtils.getDateTimeNow());

                this.dorDodCheckResultDAO.update(dorDodCheckResult,
                        new UpdateWrapper<DorDodCheckResult>().lambda().eq(DorDodCheckResult::getTrace_id, dorDodCheckResultVO.getTrace_id())
                                .eq(DorDodCheckResult::getCheck_id, dorDodCheckItemVO.getCheck_id())
                                .eq(DorDodCheckResult::getChecker_id, dorDodCheckResultVO.getChecker_id())
                );

            }


        }

    }

    @Transactional
    public void auditDorDodCheckResult(List<DorDodCheckResultVO> dorDodCheckResults) throws Exception {

        for(DorDodCheckResultVO dorDodCheckResultVO : dorDodCheckResults){

            List<DorDodCheckItemVO> check_item_info = dorDodCheckResultVO.getCheck_item_info();
            for(DorDodCheckItemVO dorDodCheckItemVO : check_item_info){
                DorDodCheckResult dorDodCheckResult = new DorDodCheckResult();
                dorDodCheckResult.setAudit_status("1");  //固定为1

                dorDodCheckResult.setNeed_check(dorDodCheckItemVO.getNeed_check());
                dorDodCheckResult.setCheck_result(dorDodCheckItemVO.getCheck_result());
                dorDodCheckResult.setAudit_time(DateUtils.getDateTimeNow());

                this.dorDodCheckResultDAO.update(dorDodCheckResult,
                        new UpdateWrapper<DorDodCheckResult>().lambda().eq(DorDodCheckResult::getTrace_id, dorDodCheckResultVO.getTrace_id())
                                .eq(DorDodCheckResult::getCheck_id, dorDodCheckItemVO.getCheck_id())
                                .eq(DorDodCheckResult::getChecker_id, dorDodCheckResultVO.getChecker_id())
                );

            }

            //兼容撤回操作，把对应的dod的状态更新为0; 撤回操作的时候会更新为-1，撤回如果不更新为-1，会导致从dor撤回时，dod的任务卡关闭不了
            //dod的审核不用此操作
            List<String> checkTypeList = check_item_info.stream().map(DorDodCheckItemVO::getCheck_type).filter(e->e.contains("dor")).distinct().collect(Collectors.toList());

            if(CollectionUtils.isNotEmpty(checkTypeList)){
                List<String> dodCheckTypeList = new ArrayList<>();
                if(checkTypeList.contains("dev_dor")){
                    dodCheckTypeList.add("dev_dod");
                }

                if(checkTypeList.contains("qc_dor")){
                    dodCheckTypeList.add("qc_dod");
                }

                LambdaUpdateWrapper<DorDodCheckResult> lambdaUpdateWrapper2 = new UpdateWrapper<DorDodCheckResult>().lambda().eq(DorDodCheckResult::getTrace_id, dorDodCheckResultVO.getTrace_id())
                        .eq(DorDodCheckResult::getChecker_id, dorDodCheckResultVO.getChecker_id()).in(DorDodCheckResult::getCheck_type, dodCheckTypeList);

                DorDodCheckResult dorDodCheckResult2 = new DorDodCheckResult();
                dorDodCheckResult2.setStatus("0");
                dorDodCheckResult2.setUpdate_time(DateUtils.getDateTimeNow());
                this.dorDodCheckResultDAO.update(dorDodCheckResult2, lambdaUpdateWrapper2);
            }




        }

    }

    @Transactional
    public void callbackDorDodCheckResult(List<DorDodCallBackVO> dorDodCallBackVOLists) throws Exception {

        for(DorDodCallBackVO dodCallBackVO : dorDodCallBackVOLists){
            String flag = dodCallBackVO.getFlag();
            List<DorDodCheckItemVO> check_item_info = dodCallBackVO.getCheck_item_info();
            List<Long> checkIdList = new ArrayList<>();
            List<String> checkTypeList = new ArrayList<>();
            if(CollectionUtils.isNotEmpty(check_item_info)){
                checkIdList = check_item_info.stream().map(DorDodCheckItemVO::getCheck_id).distinct().collect(Collectors.toList());
                checkTypeList = check_item_info.stream().map(DorDodCheckItemVO::getCheck_type).distinct().collect(Collectors.toList());
            }

            DorDodCheckResult dorDodCheckResult = new DorDodCheckResult();
            dorDodCheckResult.setStatus("0");
            dorDodCheckResult.setAudit_status("-1");//为了方便直接更新为-1，
            dorDodCheckResult.setUpdate_time(DateUtils.getDateTimeNow());

            LambdaUpdateWrapper<DorDodCheckResult> lambdaUpdateWrapper = new UpdateWrapper<DorDodCheckResult>().lambda().eq(DorDodCheckResult::getTrace_id, dodCallBackVO.getTrace_id())
                    .eq(DorDodCheckResult::getChecker_id, dodCallBackVO.getChecker_id());
            if(CollectionUtils.isNotEmpty(checkIdList)){
                lambdaUpdateWrapper.in(DorDodCheckResult::getCheck_id, checkIdList);
            }

            this.dorDodCheckResultDAO.update(dorDodCheckResult, lambdaUpdateWrapper);

            if(StringUtils.equalsIgnoreCase(flag, "1")){   //从dor检查撤回
                //把已经走到dod的流程状态也撤回
                List<String> dodCheckTypeList = new ArrayList<>();
                if(checkTypeList.contains("dev_dor")){
                    dodCheckTypeList.add("dev_dod");
                }

                if(checkTypeList.contains("qc_dor")){
                    dodCheckTypeList.add("qc_dod");
                }

                LambdaUpdateWrapper<DorDodCheckResult> lambdaUpdateWrapper2 = new UpdateWrapper<DorDodCheckResult>().lambda().eq(DorDodCheckResult::getTrace_id, dodCallBackVO.getTrace_id())
                        .eq(DorDodCheckResult::getChecker_id, dodCallBackVO.getChecker_id()).in(DorDodCheckResult::getCheck_type, dodCheckTypeList);

                DorDodCheckResult dorDodCheckResult2 = new DorDodCheckResult();
                dorDodCheckResult2.setStatus("-1");
                dorDodCheckResult2.setAudit_status("-1");//为了方便直接更新为-1，
                dorDodCheckResult2.setUpdate_time(DateUtils.getDateTimeNow());
                this.dorDodCheckResultDAO.update(dorDodCheckResult2, lambdaUpdateWrapper2);


            }

        }

    }

    public List<DorDodCheckResult> getDorDodCheckResultDetail(JSONObject queryParam) throws Exception {
        List<DorDodCheckResult> result = new ArrayList<>();


        String batch_no = queryParam.getString("batch_no");
        String checker_id = queryParam.getString("checker_id");
        String status = queryParam.getString("status");
        String audit_status = queryParam.getString("audit_status");
        String check_type = queryParam.getString("check_type");

        QueryWrapper<DorDodCheckResult> queryWrapper = new QueryWrapper<>();
        LambdaQueryWrapper<DorDodCheckResult> queryWrapperLambada = queryWrapper.lambda().eq(DorDodCheckResult::getBatch_no, batch_no);
        if(StringUtils.isNotEmpty(checker_id)){
            queryWrapperLambada.eq(DorDodCheckResult::getChecker_id, checker_id);
        }
        if(StringUtils.isNotEmpty(status)){
            queryWrapperLambada.eq(DorDodCheckResult::getStatus, status);
        }
        if(StringUtils.isNotEmpty(audit_status)){
            queryWrapperLambada.eq(DorDodCheckResult::getAudit_status, audit_status);
        }
        if(StringUtils.isNotEmpty(check_type)){
            switch (check_type){
                case "dor":
                    queryWrapperLambada.in(DorDodCheckResult::getCheck_type, Arrays.asList("dev_dor", "qc_dor"));
                    break;
                case "dod":
                    queryWrapperLambada.in(DorDodCheckResult::getCheck_type, Arrays.asList("dev_dod", "qc_dod"));
                    break;
                default:
                    queryWrapperLambada.eq(DorDodCheckResult::getCheck_type, check_type);
                    break;
            }

        }
        List<DorDodCheckResult> dorDodCheckResults = this.dorDodCheckResultDAO.getBaseMapper().selectList(queryWrapper);

        if(CollectionUtils.isEmpty(dorDodCheckResults)){
            return result;
        }

        return dorDodCheckResults;
    }
}
