package com.digiwin.athena.dtdapp.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.dtdapp.dao.newemployeereview.*;
import com.digiwin.athena.dtdapp.dao.st.EmployeeDAO;
import com.digiwin.athena.dtdapp.pojo.entity.newemployeereview.*;
import com.digiwin.athena.dtdapp.pojo.entity.st.Employee;
import com.digiwin.athena.dtdapp.pojo.enums.Status;
import com.digiwin.athena.dtdapp.pojo.vo.newemployeereview.*;
import com.digiwin.athena.dtdapp.util.AttachmentUtils;
import com.digiwin.athena.dtdapp.util.LoginUserUtils;

import com.digiwin.athena.dtdapp.util.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;

import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.time.*;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Service
@Slf4j
public class NewEmployeeReviewService {

    @Autowired
    private EmployeeDAO employeeDAO;
    @Autowired
    private NewEmployeesReviewDetailDAO newEmployeesReviewDetailDAO;
    @Autowired
    private ProbationaryPeriodGoalsDAO probationaryPeriodGoalsDAO;
    @Autowired
    private SummaryOneWeekDAO summaryOneWeekDAO;
    @Autowired
    private ProbationaryPeriodPlansDAO probationaryPeriodPlansDAO;
    @Autowired
    private SummaryTwoWeekDetailsDAO summaryTwoWeekDetailsDAO;
    @Autowired
    private SummaryOneMonthDetailsDAO summaryOneMonthDetailsDAO;
    @Autowired
    private SummaryTwoMonthDetailsDAO summaryTwoMonthDetailsDAO;
    @Autowired
    private SummaryThreeMonthDetailsDAO summaryThreeMonthDetailsDAO;
    @Autowired
    private NewEmployeesReviewMentorDAO newEmployeesReviewMentorDAO;
    @Autowired
    private NewEmployeeReviewProportionDAO newEmployeeReviewProportionDAO;


    public List<NewEmployeeReviewInfoVO> getNewEmployeeReviewInfo(Map map) throws DWException {
        log.info("queryEmployeeInfo:{}", map);
        JSONObject obj = JSON.parseObject(JSON.toJSONString(map));
        //String email = obj.getJSONObject("std_data").getJSONObject("parameter").getObject("email", String.class);
        String email = LoginUserUtils.getLoginUserId();
        if (email == null) {
            throw new DWException("no date");
        }
        int loop = -1; // 1-本人，2-代教，3-pm，4-vp、pmo
        List<NewEmployeeReviewInfoVO> newEmployeeReviewInfoVOS = new ArrayList<>();
        List<NewEmployeesReviewDetail> tutorDetails = new ArrayList<>();
        List<NewEmployeesReviewDetail> PMDetails = new ArrayList<>();
        NewEmployeesReviewDetail ownerDetail = null;
        List<NewEmployeesReviewDetail> PMODetails = null;
        Map<String, NewEmployeesReviewDetail> newEmployeesReviewDetailMap = new HashMap<>();
        ownerDetail = newEmployeesReviewDetailDAO.getBaseMapper().selectOne(
                new LambdaQueryWrapper<NewEmployeesReviewDetail>()
                        .eq(NewEmployeesReviewDetail::getTenantsid, LoginUserUtils.getTenantSid())
                        .eq(NewEmployeesReviewDetail::getOwner_emp_email, email)
        );

        if (ownerDetail != null) {
            loop = 1;
            newEmployeesReviewDetailMap.put(ownerDetail.getOwner_emp_email(), ownerDetail);
        }
        tutorDetails = newEmployeesReviewDetailDAO.getBaseMapper().selectList(
                new LambdaQueryWrapper<NewEmployeesReviewDetail>()
                        .eq(NewEmployeesReviewDetail::getTenantsid, LoginUserUtils.getTenantSid())
                        .eq(NewEmployeesReviewDetail::getTutor_email, email)
        );
        if (CollectionUtils.isNotEmpty(tutorDetails)) {
            loop = 2;
            for (NewEmployeesReviewDetail tutorDetail : tutorDetails) {
                if (!newEmployeesReviewDetailMap.containsKey(tutorDetail.getOwner_emp_email())) {
                    newEmployeesReviewDetailMap.put(tutorDetail.getOwner_emp_email(), tutorDetail);
                }
            }
        }
        PMDetails = newEmployeesReviewDetailDAO.getBaseMapper().selectList(
                new LambdaQueryWrapper<NewEmployeesReviewDetail>()
                        .eq(NewEmployeesReviewDetail::getTenantsid, LoginUserUtils.getTenantSid())
                        .eq(NewEmployeesReviewDetail::getManager_email, email)
        );
        if (CollectionUtils.isNotEmpty(PMDetails)) {
            loop = 3;
            for (NewEmployeesReviewDetail PMDetail : PMDetails) {
                if (!newEmployeesReviewDetailMap.containsKey(PMDetail.getOwner_emp_email())) {
                    newEmployeesReviewDetailMap.put(PMDetail.getOwner_emp_email(), PMDetail);
                }
            }
        }
        Employee getEmployee = employeeDAO.getBaseMapper().selectOne(
                new LambdaQueryWrapper<Employee>().eq(Employee::getEmail, email)
                        .eq(Employee::getTenantsid, LoginUserUtils.getTenantSid()));
        if (getEmployee != null) {
            if ("VP".equals(getEmployee.getJob_position()) || "PMO".equals(getEmployee.getJob_position())) {
                loop = 4;
                PMODetails = newEmployeesReviewDetailDAO.getBaseMapper().selectList(new LambdaQueryWrapper<NewEmployeesReviewDetail>()
                        .eq(NewEmployeesReviewDetail::getTenantsid, LoginUserUtils.getTenantSid()));
                for (NewEmployeesReviewDetail PMODetail : PMODetails) {
                    if (!newEmployeesReviewDetailMap.containsKey(PMODetail.getOwner_emp_email())) {
                        newEmployeesReviewDetailMap.put(PMODetail.getOwner_emp_email(), PMODetail);
                    }
                }
            }
        }


        if (loop == 1) {
            ArrayList<NewEmployeesReviewDetail> arrayList = new ArrayList<>();
            arrayList.add(ownerDetail);
            newEmployeeReviewInfoVOS = getInfo(arrayList, loop, true, false);
        } else if (loop == 2) {
            newEmployeeReviewInfoVOS = getInfo(tutorDetails, loop, true, false);
        } else if (loop == 3) {
            newEmployeeReviewInfoVOS = getInfo(PMDetails, loop, true, false);
        } else if (loop == 4) {
            newEmployeeReviewInfoVOS = getInfo(PMODetails, loop, true, false);
        }

        if (loop == -1) {
            return new ArrayList<NewEmployeeReviewInfoVO>();
        }
        return newEmployeeReviewInfoVOS;
    }

    private List<NewEmployeeReviewInfoVO> getInfo(List<NewEmployeesReviewDetail> newEmployeesReviewDetails, int loop, Boolean isNeedArray, Boolean isNeedDesc) {
        ArrayList<NewEmployeeReviewInfoVO> newEmployeeReviewInfoVOS = new ArrayList<>();
        for (NewEmployeesReviewDetail newEmployeesReviewDetail : newEmployeesReviewDetails) {
            NewEmployeeReviewInfoVO newEmployeeReviewInfoVO = new NewEmployeeReviewInfoVO();
            BeanUtils.copyProperties(newEmployeesReviewDetail, newEmployeeReviewInfoVO);
            if (isNeedDesc) {
                newEmployeeReviewInfoVO.setJob_title(Status.fromValue(newEmployeesReviewDetail.getJob_title()));
                newEmployeeReviewInfoVO.setJob_level(Status.fromValue(newEmployeesReviewDetail.getJob_level()));
                if ("3".equals(newEmployeeReviewInfoVO.getProbationary_period_term())) {
                    newEmployeeReviewInfoVO.setProbationary_period_term("三个月");
                } else if ("6".equals(newEmployeeReviewInfoVO.getProbationary_period_term())) {
                    newEmployeeReviewInfoVO.setProbationary_period_term("六个月");
                }

                newEmployeeReviewInfoVO.setEmployee_attribute(Status.fromValue(newEmployeesReviewDetail.getEmployee_attribute()));
                newEmployeeReviewInfoVO.setEmployee_status(Status.fromValue(newEmployeesReviewDetail.getEmployee_status()));
            }

            if (isNeedArray) {
                List<ProbationaryPeriodGoals> probationaryPeriodGoals = probationaryPeriodGoalsDAO.getBaseMapper().selectList(new LambdaQueryWrapper<ProbationaryPeriodGoals>()
                        .eq(ProbationaryPeriodGoals::getNew_employees_review_detail_id, newEmployeesReviewDetail.getNew_employees_review_detail_id())
                        .eq(ProbationaryPeriodGoals::getTenantsid, LoginUserUtils.getTenantSid()));
                List<ProbationaryPeriodGoalsVO> probationaryPeriodGoalsVOS = new ArrayList<>();
                if (CollectionUtils.isNotEmpty(probationaryPeriodGoals)) {
                    for (ProbationaryPeriodGoals probationaryPeriodGoal : probationaryPeriodGoals) {
                        ProbationaryPeriodGoalsVO probationaryPeriodGoalsVO = new ProbationaryPeriodGoalsVO();
                        probationaryPeriodGoalsVO.setGoal_id(probationaryPeriodGoal.getGoal_id());
                        probationaryPeriodGoalsVO.setGoal_category(probationaryPeriodGoal.getGoal_category());
                        probationaryPeriodGoalsVO.setGoal_project_no(probationaryPeriodGoal.getProject_no());
                        probationaryPeriodGoalsVO.setGoal_project_name(probationaryPeriodGoal.getProject_name());
                        probationaryPeriodGoalsVO.setGoal_weight(probationaryPeriodGoal.getWeight());
                        probationaryPeriodGoalsVO.setGoal_achieved_details(probationaryPeriodGoal.getAchieved_details());
                        probationaryPeriodGoalsVO.setGoal_measurement_standard(probationaryPeriodGoal.getMeasurement_standard());
                        probationaryPeriodGoalsVO.setOwner_emp_email(probationaryPeriodGoal.getOwner_emp_email());
                        probationaryPeriodGoalsVOS.add(probationaryPeriodGoalsVO);
                    }
                }
                newEmployeeReviewInfoVO.setProbationary_period_goals(probationaryPeriodGoalsVOS);
            }
            SummaryOneWeekDetails summaryOneWeekDetails = summaryOneWeekDAO.getBaseMapper().selectOne(new LambdaQueryWrapper<SummaryOneWeekDetails>()
                    .eq(SummaryOneWeekDetails::getNew_employees_review_detail_id, newEmployeesReviewDetail.getNew_employees_review_detail_id())
                    .eq(SummaryOneWeekDetails::getTenantsid, LoginUserUtils.getTenantSid()));
            if (summaryOneWeekDetails != null) {
                newEmployeeReviewInfoVO.setOne_week_new_employees_review_detail_id(summaryOneWeekDetails.getNew_employees_review_detail_id());
                newEmployeeReviewInfoVO.setOne_week_trial_period_goal(summaryOneWeekDetails.getTrial_period_goal());
                newEmployeeReviewInfoVO.setOne_week_monthly_summary_plan(summaryOneWeekDetails.getMonthly_summary_plan());
                newEmployeeReviewInfoVO.setOne_week_deviation_current_cycle(summaryOneWeekDetails.getDeviation_current_cycle());
                newEmployeeReviewInfoVO.setOne_week_deviation_reason_current_cycle(summaryOneWeekDetails.getDeviation_reason_current_cycle());
                newEmployeeReviewInfoVO.setOne_week_deviation_next_cycle(summaryOneWeekDetails.getDeviation_next_cycle());
                newEmployeeReviewInfoVO.setOne_week_deviation_reason_next_cycle(summaryOneWeekDetails.getDeviation_reason_next_cycle());
                newEmployeeReviewInfoVO.setOne_week_help_needed(summaryOneWeekDetails.getHelp_needed());
                newEmployeeReviewInfoVO.setOne_week_is_familiar_with_process(summaryOneWeekDetails.getIs_familiar_with_process());
                newEmployeeReviewInfoVO.setOne_week_is_weekly_report_completed(summaryOneWeekDetails.getIs_weekly_report_completed());
                newEmployeeReviewInfoVO.setOne_week_is_communicated_with_academy(summaryOneWeekDetails.getIs_communicated_with_academy());
                newEmployeeReviewInfoVO.setOne_week_is_daily_progress_synced(summaryOneWeekDetails.getIs_daily_progress_synced());
            }
            ArrayList<ProbationaryPeriodPlanVO> probationaryPeriodPlanVOS = new ArrayList<>();
            if (isNeedArray) {
                if (summaryOneWeekDetails != null) {
                    List<ProbationaryPeriodPlans> probationaryPeriodPlans = probationaryPeriodPlansDAO.getBaseMapper().selectList(new LambdaQueryWrapper<ProbationaryPeriodPlans>()
                            .eq(ProbationaryPeriodPlans::getSummary_one_week_details_id, summaryOneWeekDetails.getSummary_one_week_details_id())
                            .eq(ProbationaryPeriodPlans::getTenantsid, LoginUserUtils.getTenantSid()));
                    if (CollectionUtils.isNotEmpty(probationaryPeriodPlans)) {
                        for (ProbationaryPeriodPlans probationaryPeriodPlan : probationaryPeriodPlans) {
                            ProbationaryPeriodPlanVO probationaryPeriodPlanVO = new ProbationaryPeriodPlanVO();
                            probationaryPeriodPlanVO.setPlan_category(probationaryPeriodPlan.getPlan_category());
                            probationaryPeriodPlanVO.setPlan_project_name(probationaryPeriodPlan.getProject_name());
                            probationaryPeriodPlanVO.setPlan_project_no(probationaryPeriodPlan.getProject_no());
                            probationaryPeriodPlanVO.setPlan_achieved_plan_details(probationaryPeriodPlan.getAchieved_plan_details());
                            probationaryPeriodPlanVO.setPlan_measurement_standard(probationaryPeriodPlan.getMeasurement_standard());
                            probationaryPeriodPlanVO.setPlan_weight(probationaryPeriodPlan.getWeight());
                            probationaryPeriodPlanVO.setOwner_emp_email(probationaryPeriodPlan.getOwner_emp_email());
                            probationaryPeriodPlanVOS.add(probationaryPeriodPlanVO);
                        }
                    }
                }
                newEmployeeReviewInfoVO.setProbationary_period_plan(probationaryPeriodPlanVOS);
            }
            SummaryTwoWeekDetails summaryTwoWeekDetails = summaryTwoWeekDetailsDAO.getBaseMapper().selectOne(new LambdaQueryWrapper<SummaryTwoWeekDetails>()
                    .eq(SummaryTwoWeekDetails::getNew_employees_review_detail_id, newEmployeesReviewDetail.getNew_employees_review_detail_id())
                    .eq(SummaryTwoWeekDetails::getTenantsid, LoginUserUtils.getTenantSid()));
            if (summaryTwoWeekDetails != null) {
                newEmployeeReviewInfoVO.setTwo_week_new_employees_review_detail_id(summaryTwoWeekDetails.getNew_employees_review_detail_id());
                newEmployeeReviewInfoVO.setTwo_week_trial_period_goal(summaryTwoWeekDetails.getTrial_period_goal());
                newEmployeeReviewInfoVO.setTwo_week_monthly_summary_plan(summaryTwoWeekDetails.getMonthly_summary_plan());
                newEmployeeReviewInfoVO.setTwo_week_deviation_current_cycle(summaryTwoWeekDetails.getDeviation_current_cycle());
                newEmployeeReviewInfoVO.setTwo_week_deviation_reason_current_cycle(summaryTwoWeekDetails.getDeviation_reason_current_cycle());
                newEmployeeReviewInfoVO.setTwo_week_deviation_next_cycle(summaryTwoWeekDetails.getDeviation_next_cycle());
                newEmployeeReviewInfoVO.setTwo_week_deviation_reason_next_cycle(summaryTwoWeekDetails.getDeviation_reason_next_cycle());
                newEmployeeReviewInfoVO.setTwo_week_help_needed(summaryTwoWeekDetails.getHelp_needed());
            }

            SummaryOneMonthDetails summaryOneMonthDetails = summaryOneMonthDetailsDAO.getBaseMapper().selectOne(new LambdaQueryWrapper<SummaryOneMonthDetails>()
                    .eq(SummaryOneMonthDetails::getNew_employees_review_detail_id, newEmployeesReviewDetail.getNew_employees_review_detail_id())
                    .eq(SummaryOneMonthDetails::getTenantsid, LoginUserUtils.getTenantSid()));
            if (summaryOneMonthDetails != null) {
                newEmployeeReviewInfoVO.setOne_month_new_employees_review_detail_id(summaryOneMonthDetails.getNew_employees_review_detail_id());
                newEmployeeReviewInfoVO.setOne_month_trial_period_goal(summaryOneMonthDetails.getTrial_period_goal());
                newEmployeeReviewInfoVO.setOne_month_monthly_summary_plan(summaryOneMonthDetails.getMonthly_summary_plan());
                newEmployeeReviewInfoVO.setOne_month_deviation_current_cycle(summaryOneMonthDetails.getDeviation_current_cycle());
                newEmployeeReviewInfoVO.setOne_month_deviation_reason_current_cycle(summaryOneMonthDetails.getDeviation_reason_current_cycle());
                newEmployeeReviewInfoVO.setOne_month_deviation_next_cycle(summaryOneMonthDetails.getDeviation_next_cycle());
                newEmployeeReviewInfoVO.setOne_month_deviation_reason_next_cycle(summaryOneMonthDetails.getDeviation_reason_next_cycle());
                newEmployeeReviewInfoVO.setOne_month_help_needed(summaryOneMonthDetails.getHelp_needed());
            }
            SummaryTwoMonthDetails summaryTwoMonthDetails = summaryTwoMonthDetailsDAO.getBaseMapper().selectOne(new LambdaQueryWrapper<SummaryTwoMonthDetails>()
                    .eq(SummaryTwoMonthDetails::getNew_employees_review_detail_id, newEmployeesReviewDetail.getNew_employees_review_detail_id())
                    .eq(SummaryTwoMonthDetails::getTenantsid, LoginUserUtils.getTenantSid()));
            if (summaryTwoMonthDetails != null) {
                newEmployeeReviewInfoVO.setTwo_month_new_employees_review_detail_id(summaryTwoMonthDetails.getNew_employees_review_detail_id());
                newEmployeeReviewInfoVO.setTwo_month_trial_period_goal(summaryTwoMonthDetails.getTrial_period_goal());
                newEmployeeReviewInfoVO.setTwo_month_monthly_summary_plan(summaryTwoMonthDetails.getMonthly_summary_plan());
                newEmployeeReviewInfoVO.setTwo_month_deviation_current_cycle(summaryTwoMonthDetails.getDeviation_current_cycle());
                newEmployeeReviewInfoVO.setTwo_month_deviation_reason_current_cycle(summaryTwoMonthDetails.getDeviation_reason_current_cycle());
                newEmployeeReviewInfoVO.setTwo_month_deviation_next_cycle(summaryTwoMonthDetails.getDeviation_next_cycle());
                newEmployeeReviewInfoVO.setTwo_month_deviation_reason_next_cycle(summaryTwoMonthDetails.getDeviation_reason_next_cycle());
                newEmployeeReviewInfoVO.setTwo_month_help_needed(summaryTwoMonthDetails.getHelp_needed());
            }
            SummaryThreeMonthDetails summaryThreeMonthDetails = summaryThreeMonthDetailsDAO.getBaseMapper().selectOne(new LambdaQueryWrapper<SummaryThreeMonthDetails>()
                    .eq(SummaryThreeMonthDetails::getNew_employees_review_detail_id, newEmployeesReviewDetail.getNew_employees_review_detail_id())
                    .eq(SummaryThreeMonthDetails::getTenantsid, LoginUserUtils.getTenantSid()));
            if (summaryThreeMonthDetails != null) {
                newEmployeeReviewInfoVO.setThree_month_new_employees_review_detail_id(summaryThreeMonthDetails.getNew_employees_review_detail_id());
                newEmployeeReviewInfoVO.setThree_month_trial_period_goal(summaryThreeMonthDetails.getTrial_period_goal());
                newEmployeeReviewInfoVO.setThree_month_monthly_summary_plan(summaryThreeMonthDetails.getMonthly_summary_plan());
                newEmployeeReviewInfoVO.setThree_month_deviation_current_cycle(summaryThreeMonthDetails.getDeviation_current_cycle());
                newEmployeeReviewInfoVO.setThree_month_deviation_reason_current_cycle(summaryThreeMonthDetails.getDeviation_reason_current_cycle());
                newEmployeeReviewInfoVO.setThree_month_deviation_next_cycle(summaryThreeMonthDetails.getDeviation_next_cycle());
                newEmployeeReviewInfoVO.setThree_month_deviation_reason_next_cycle(summaryThreeMonthDetails.getDeviation_reason_next_cycle());
                newEmployeeReviewInfoVO.setThree_month_help_needed(summaryThreeMonthDetails.getHelp_needed());
            }
            if (loop > 1) {
                NewEmployeesReviewMentor newEmployeesReviewMentor = newEmployeesReviewMentorDAO.getBaseMapper().selectOne(new LambdaQueryWrapper<NewEmployeesReviewMentor>()
                        .eq(NewEmployeesReviewMentor::getNew_employees_review_detail_id, newEmployeesReviewDetail.getNew_employees_review_detail_id())
                        .eq(NewEmployeesReviewMentor::getTenantsid, LoginUserUtils.getTenantSid()));
                newEmployeeReviewInfoVO.setIs_edit(true);

                if (newEmployeesReviewMentor != null) {
                    BeanUtils.copyProperties(newEmployeesReviewMentor, newEmployeeReviewInfoVO);

                    newEmployeeReviewInfoVO.setIs_retainable(Status.fromValue(newEmployeesReviewMentor.getIs_retainable()));
                    newEmployeeReviewInfoVO.setAttachment_one_week(null);
                    newEmployeeReviewInfoVO.setAttachment_two_week(null);
                    newEmployeeReviewInfoVO.setAttachment_one_month(null);
                    newEmployeeReviewInfoVO.setAttachment_two_month(null);
                    newEmployeeReviewInfoVO.setAttachment_three_month(null);

                    String attachment = newEmployeesReviewMentor.getAttachment();
                    newEmployeeReviewInfoVO.setAttachment(AttachmentUtils.getAttachment(attachment));
                }
            }

            newEmployeeReviewInfoVOS.add(newEmployeeReviewInfoVO);
        }

        return newEmployeeReviewInfoVOS;
    }


    public NewEmployeeReviewInfoVO getNewEmployeeReviewInfoOne(Map map) throws DWException {
        log.info("queryEmployeeInfo:{}", map);
        JSONObject obj = JSON.parseObject(JSON.toJSONString(map));
        //String email = obj.getJSONObject("std_data").getJSONObject("parameter").getObject("email", String.class);
        String email = LoginUserUtils.getLoginUserId();
        JSONArray jsonArray = obj.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("new_employees_review_info");

        if (jsonArray == null || jsonArray.size() == 0) {
            throw new DWException("no date");
        }
        List<NewEmployeeReviewInfoVO> newEmployeeReviewInfoVOS = new ArrayList<>();
        Long tutorDetails = 0L;
        Long PMDetails = 0L;
        List<NewEmployeesReviewDetail> employees = JSON.parseArray(JSON.toJSONString(jsonArray), NewEmployeesReviewDetail.class);
        for (NewEmployeesReviewDetail employee : employees) {

            int loop = -1; // 1-本人，2-代教，3-pm，4-vp、pmo

            NewEmployeesReviewDetail ownerDetail = null;
            ownerDetail = newEmployeesReviewDetailDAO.getBaseMapper().selectOne(
                    new LambdaQueryWrapper<NewEmployeesReviewDetail>()
                            .eq(NewEmployeesReviewDetail::getTenantsid, LoginUserUtils.getTenantSid())
                            .eq(NewEmployeesReviewDetail::getOwner_emp_email, employee.getOwner_emp_email())
            );

            if (email != null && email.equals(employee.getOwner_emp_email())) {
                loop = 1;
            } else {
                tutorDetails = newEmployeesReviewDetailDAO.getBaseMapper().selectCount(
                        new LambdaQueryWrapper<NewEmployeesReviewDetail>()
                                .eq(NewEmployeesReviewDetail::getTenantsid, LoginUserUtils.getTenantSid())
                                .eq(NewEmployeesReviewDetail::getTutor_email, email)
                                .eq(NewEmployeesReviewDetail::getOwner_emp_email, employee.getOwner_emp_email())
                );
                if (tutorDetails != 0L) {
                    loop = 2;
                } else {
                    PMDetails = newEmployeesReviewDetailDAO.getBaseMapper().selectCount(
                            new LambdaQueryWrapper<NewEmployeesReviewDetail>()
                                    .eq(NewEmployeesReviewDetail::getTenantsid, LoginUserUtils.getTenantSid())
                                    .eq(NewEmployeesReviewDetail::getManager_email, email)
                                    .eq(NewEmployeesReviewDetail::getOwner_emp_email, employee.getOwner_emp_email())
                    );
                    if (PMDetails != 0L) {
                        loop = 3;
                    }
                }
            }
            if (loop == -1) {
                Employee getEmployee = employeeDAO.getBaseMapper().selectOne(
                        new LambdaQueryWrapper<Employee>().eq(Employee::getEmail, email)
                                .eq(Employee::getTenantsid, LoginUserUtils.getTenantSid()));
                if (getEmployee != null) {
                    if ("VP".equals(getEmployee.getJob_position()) || "PMO".equals(getEmployee.getJob_position())) {
                        loop = 4;
                    }
                }
            }

            ArrayList<NewEmployeesReviewDetail> arrayList = new ArrayList<>();
            if (loop != -1) {
                arrayList.add(ownerDetail);
            }

            newEmployeeReviewInfoVOS = getInfo(arrayList, loop, true, false);


        }
        if (CollectionUtils.isEmpty(newEmployeeReviewInfoVOS)) {
            NewEmployeeReviewInfoVO newEmployeeReviewInfoVO = new NewEmployeeReviewInfoVO();
            newEmployeeReviewInfoVO.setIs_edit(null);
            return newEmployeeReviewInfoVO;
        }
        NewEmployeeReviewInfoVO newEmployeeReviewInfoVO = newEmployeeReviewInfoVOS.get(0);

        return newEmployeeReviewInfoVO;
    }


    public List<NewEmployeeReviewInfoVO2> getNewEmployeeReviewMonthlyReportDetail(Map map) throws DWException {
        log.info("queryEmployeeInfo:{}", map);
        JSONObject obj = JSON.parseObject(JSON.toJSONString(map));
        //String email = obj.getJSONObject("std_data").getJSONObject("parameter").getObject("email", String.class);
        String email = LoginUserUtils.getLoginUserId();

        if (!"integration".equals(email)) {
            return new ArrayList<>();
        }
        Employee employee = employeeDAO.getBaseMapper().selectOne(new LambdaQueryWrapper<Employee>()
                .eq(Employee::getEmail, email)
                .eq(Employee::getTenantsid, LoginUserUtils.getTenantSid()));
        if(employee!=null) {
            if (!"PMO".equals(employee.getJob_position()) || !"VP".equals(employee.getJob_position())) {
                return new ArrayList<>();
            }
        }
        List<NewEmployeeReviewInfoVO> newEmployeeReviewInfoVOS = new ArrayList<>();


        List<NewEmployeesReviewDetail> allDetail = new ArrayList<>();
        allDetail = newEmployeesReviewDetailDAO.getBaseMapper().selectList(
                new LambdaQueryWrapper<NewEmployeesReviewDetail>()
                        .eq(NewEmployeesReviewDetail::getTenantsid, LoginUserUtils.getTenantSid())
        );
        newEmployeeReviewInfoVOS = getInfo(allDetail, 4, false, true);
        for (NewEmployeeReviewInfoVO newEmployeeReviewInfoVO : newEmployeeReviewInfoVOS) {
            newEmployeeReviewInfoVO.setAttachment(null);
        }

        List<NewEmployeeReviewInfoVO2> newEmployeeReviewInfoVO2s = new ArrayList<>();
        for (NewEmployeeReviewInfoVO newEmployeeReviewInfoVO : newEmployeeReviewInfoVOS) {
            NewEmployeeReviewInfoVO2 newEmployeeReviewInfoVO2 = new NewEmployeeReviewInfoVO2();
            BeanUtils.copyProperties(newEmployeeReviewInfoVO,newEmployeeReviewInfoVO2);
            StringUtils.copyObjectIsBoolean(newEmployeeReviewInfoVO,newEmployeeReviewInfoVO2);
            newEmployeeReviewInfoVO2s.add(newEmployeeReviewInfoVO2);
        }

        return newEmployeeReviewInfoVO2s;


    }

    public List<NewEmployeeReviewInfoVO> getNewEmployeeReviewMonthlyReportDate(Map map) {
        LocalDate month = LocalDate.now().minusMonths(1);
        LocalDate firstDay = month.withDayOfMonth(1);
        LocalDate localDate = month.withDayOfMonth(month.lengthOfMonth());
        //获取试用期，当月离职的新人
        LambdaQueryWrapper<NewEmployeesReviewDetail> qw = new LambdaQueryWrapper<>();
        qw.and(i -> i.eq(NewEmployeesReviewDetail::getEmployee_status, "probation")
                        .or(a -> a.eq(NewEmployeesReviewDetail::getEmployee_status, "quit")
                                .ge(NewEmployeesReviewDetail::getConfirmation_date, firstDay)
                                .le(NewEmployeesReviewDetail::getConfirmation_date, localDate)))
                .eq(NewEmployeesReviewDetail::getTenantsid, LoginUserUtils.getTenantSid());

        List<NewEmployeesReviewDetail> newEmployeesReviewDetails = newEmployeesReviewDetailDAO.getBaseMapper().selectList(qw);
        if (CollectionUtils.isEmpty(newEmployeesReviewDetails)) {
            NewEmployeeReviewInfoVO newEmployeeReviewInfoVO = new NewEmployeeReviewInfoVO();
            StringUtils.noNullFieldAttr(newEmployeeReviewInfoVO);
            ArrayList<NewEmployeeReviewInfoVO> newEmployeeReviewInfoVOS = new ArrayList<>();
            newEmployeeReviewInfoVOS.add(newEmployeeReviewInfoVO);
            return newEmployeeReviewInfoVOS;
        }
        List<NewEmployeeReviewInfoVO> info = getInfo(newEmployeesReviewDetails, 4, false, true);
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate now = LocalDate.now().minusMonths(1);
        for (NewEmployeeReviewInfoVO newEmployeeReviewInfoVO : info) {
            LocalDate parse = LocalDate.parse(newEmployeeReviewInfoVO.getEmployment_date(), dateTimeFormatter);
            LocalDate one_week = parse.plusWeeks(1);
            LocalDate two_week = parse.plusWeeks(2);
            LocalDate one_month = parse.plusMonths(1);
            LocalDate oneToTwo_month = parse.plusMonths(2);

            if (Status.PROBATION.getDesc().equals(newEmployeeReviewInfoVO.getEmployee_status())
                    || Status.DEPART.getDesc().equals(newEmployeeReviewInfoVO.getEmployee_status())) {
                if (now.isBefore(one_week)) {
                    newEmployeeReviewInfoVO.setNew_employee_status("1周内试用期员工（0-7）");
                } else if (now.isBefore(two_week)) {
                    newEmployeeReviewInfoVO.setNew_employee_status("1-2周试用期新员工（8-14天）");
                } else if (now.isBefore(one_month)) {
                    newEmployeeReviewInfoVO.setNew_employee_status("1个月试用期新员工（15-1个月）");
                } else if (now.isBefore(oneToTwo_month)) {
                    newEmployeeReviewInfoVO.setNew_employee_status("2个月试用期员工（1个月-2个月）");
                }
            }
            long until = parse.until(now, ChronoUnit.DAYS);
            if (Status.PROBATION.getDesc().equals(newEmployeeReviewInfoVO.getEmployee_status()) && until >= 60) {
                newEmployeeReviewInfoVO.setNew_employee_status("即将转正试用期员工（2个月以上）");
            }

        }

        return info;
    }

    private List<NewEmployeesReviewDetail> getNewEmployeesReviewDetails() {
        LocalDate month = LocalDate.now().minusMonths(1);
        LocalDate firstDay = month.withDayOfMonth(1);
        LocalDate localDate = month.withDayOfMonth(month.lengthOfMonth());
        //获取所有新人
        LambdaQueryWrapper<NewEmployeesReviewDetail> qw = new LambdaQueryWrapper<>();
        qw.eq(NewEmployeesReviewDetail::getTenantsid, LoginUserUtils.getTenantSid());
        qw.and(i -> i.eq(NewEmployeesReviewDetail::getEmployee_status, "probation")
                .or(a -> a.eq(NewEmployeesReviewDetail::getEmployee_status, "quit")
                        .ge(NewEmployeesReviewDetail::getConfirmation_date, firstDay)
                        .le(NewEmployeesReviewDetail::getConfirmation_date, localDate))
                .or(b -> b.eq(NewEmployeesReviewDetail::getEmployee_status, "beformal")
                        .ge(NewEmployeesReviewDetail::getConfirmation_date, firstDay)
                        .le(NewEmployeesReviewDetail::getConfirmation_date, localDate))
                .or(c -> c.eq(NewEmployeesReviewDetail::getEmployee_status, "return")
                        .ge(NewEmployeesReviewDetail::getConfirmation_date, firstDay)
                        .le(NewEmployeesReviewDetail::getConfirmation_date, localDate)));

        return newEmployeesReviewDetailDAO.getBaseMapper().selectList(qw);
    }

    public List<NewEmployeeReviewInfoVO> getNewEmployeeReviewMonthlyReportTaskCardCompletionStatus(Map map) throws URISyntaxException, IOException {
        List<NewEmployeesReviewDetail> newEmployeesReviewDetails1 = getNewEmployeesReviewDetails();
        if (CollectionUtils.isEmpty(newEmployeesReviewDetails1)) {
            NewEmployeeReviewInfoVO newEmployeeReviewInfoVO = new NewEmployeeReviewInfoVO();
            StringUtils.noNullFieldAttr(newEmployeeReviewInfoVO);
            ArrayList<NewEmployeeReviewInfoVO> newEmployeeReviewInfoVOS = new ArrayList<>();
            newEmployeeReviewInfoVOS.add(newEmployeeReviewInfoVO);
            return newEmployeeReviewInfoVOS;
        }

        List<NewEmployeeReviewInfoVO> info = getInfo(newEmployeesReviewDetails1, 4, false, true);
        Map<String, NewEmployeeReviewInfoVO> collect = info.stream().collect(Collectors.toMap(s -> s.getOwner_emp_email(), s -> {
            NewEmployeeReviewInfoVO vo = s;
            vo.setNew_employee_status("按时完成任务卡员工");
            return vo;
        }));
        LocalDate month = LocalDate.now().minusMonths(1);
        LocalDate firstDay = month.withDayOfMonth(1);
        LocalDate localDate = month.withDayOfMonth(month.lengthOfMonth());

        NewEmployeeReviewProportion newEmployeeReviewProportion = newEmployeeReviewProportionDAO.getBaseMapper().selectOne(new LambdaQueryWrapper<NewEmployeeReviewProportion>()
                .ge(NewEmployeeReviewProportion::getDate, firstDay)
                .le(NewEmployeeReviewProportion::getDate, localDate)
                .eq(NewEmployeeReviewProportion::getTenantsid, LoginUserUtils.getTenantSid()));
        List<String> list = Arrays.asList(newEmployeeReviewProportion.getOverdue_employees().split(","));

        for (String s : list) {
            if (collect.containsKey(s)) {
                collect.get(s).setNew_employee_status("超期未完成任务卡员工");
            }
        }
        List<NewEmployeeReviewInfoVO> collect1 = collect.values().stream().collect(Collectors.toList());

        return collect1;

    }


    public List<NewEmployeeReviewInfoVO> getNewEmployeeReviewMonthlyReportOnDutySituation(Map map) {
        List<NewEmployeesReviewDetail> newEmployeesReviewDetails = getNewEmployeesReviewDetails();
        if (CollectionUtils.isEmpty(newEmployeesReviewDetails)) {
            NewEmployeeReviewInfoVO newEmployeeReviewInfoVO = new NewEmployeeReviewInfoVO();
            StringUtils.noNullFieldAttr(newEmployeeReviewInfoVO);
            ArrayList<NewEmployeeReviewInfoVO> newEmployeeReviewInfoVOS = new ArrayList<>();
            newEmployeeReviewInfoVOS.add(newEmployeeReviewInfoVO);
            return newEmployeeReviewInfoVOS;
        }
        List<NewEmployeeReviewInfoVO> info = getInfo(newEmployeesReviewDetails, 4, false, true);


        for (NewEmployeeReviewInfoVO newEmployeeReviewInfoVO : info) {
            if (Status.PROBATION.getDesc().equals(newEmployeeReviewInfoVO.getEmployee_status())
                    || Status.BEFORMAL.getDesc().equals(newEmployeeReviewInfoVO.getEmployee_status())
                    || Status.NOUSED.getDesc().equals(newEmployeeReviewInfoVO.getEmployee_status())) {
                newEmployeeReviewInfoVO.setNew_employee_status("在职新员工");
            }

            //离职
            if (Status.DEPART.getDesc().equals(newEmployeeReviewInfoVO.getEmployee_status())) {
                newEmployeeReviewInfoVO.setNew_employee_status("离职新员工");
            }
        }

        return info;
    }

    public List<NewEmployeeReviewInfoVO> getNewEmployeeReviewMonthlyReportRetentionSituation(Map map) {
        List<NewEmployeesReviewDetail> newEmployeesReviewDetails = getNewEmployeesReviewDetails();
        if (CollectionUtils.isEmpty(newEmployeesReviewDetails)) {
            NewEmployeeReviewInfoVO newEmployeeReviewInfoVO = new NewEmployeeReviewInfoVO();
            StringUtils.noNullFieldAttr(newEmployeeReviewInfoVO);
            ArrayList<NewEmployeeReviewInfoVO> newEmployeeReviewInfoVOS = new ArrayList<>();
            newEmployeeReviewInfoVOS.add(newEmployeeReviewInfoVO);
            return newEmployeeReviewInfoVOS;
        }
        List<NewEmployeesReviewDetail> details = new ArrayList<>();
        for (NewEmployeesReviewDetail newEmployeesReviewDetail : newEmployeesReviewDetails) {
            NewEmployeesReviewMentor newEmployeesReviewMentor = newEmployeesReviewMentorDAO.getBaseMapper().selectOne(new LambdaQueryWrapper<NewEmployeesReviewMentor>()
                    .eq(NewEmployeesReviewMentor::getTenantsid, LoginUserUtils.getTenantSid())
                    .eq(NewEmployeesReviewMentor::getOwner_emp_email, newEmployeesReviewDetail.getOwner_emp_email()));

            if (newEmployeesReviewMentor != null) {
                if (newEmployeesReviewMentor != null && (newEmployeesReviewMentor.getAcceptance_score() != null && newEmployeesReviewMentor.getAcceptance_score() != 0)) {
                    details.add(newEmployeesReviewDetail);
                }
            }
        }
        List<NewEmployeeReviewInfoVO> info = getInfo(details, 4, false, true);
        for (NewEmployeeReviewInfoVO newEmployeeReviewInfoVO : info) {
            //转正人数
            if (Status.BEFORMAL.getDesc().equals(newEmployeeReviewInfoVO.getEmployee_status())) {
                newEmployeeReviewInfoVO.setNew_employee_status("转正员工");
            }
            //不可留用
            if (Status.NOUSED.getDesc().equals(newEmployeeReviewInfoVO.getEmployee_status())) {
                newEmployeeReviewInfoVO.setNew_employee_status("不予留用员工");
            }
        }
        if (CollectionUtils.isEmpty(info)) {
            NewEmployeeReviewInfoVO newEmployeeReviewInfoVO = new NewEmployeeReviewInfoVO();
            StringUtils.noNullFieldAttr(newEmployeeReviewInfoVO);
            ArrayList<NewEmployeeReviewInfoVO> newEmployeeReviewInfoVOS = new ArrayList<>();
            newEmployeeReviewInfoVOS.add(newEmployeeReviewInfoVO);
            return newEmployeeReviewInfoVOS;
        }

        return info;
    }


    public List<NewEmployeeReviewInfoVO> getNewEmployeeReviewMonthlyReportScore(Map map) {
        LocalDate month = LocalDate.now().minusMonths(1);
        LocalDate firstDay = month.withDayOfMonth(1);
        LocalDate localDate = month.withDayOfMonth(month.lengthOfMonth());

        NewEmployeeReviewProportion newEmployeeReviewProportion = newEmployeeReviewProportionDAO.getBaseMapper().selectOne(new LambdaQueryWrapper<NewEmployeeReviewProportion>()
                .ge(NewEmployeeReviewProportion::getDate, firstDay)
                .le(NewEmployeeReviewProportion::getDate, localDate)
                .eq(NewEmployeeReviewProportion::getTenantsid, LoginUserUtils.getTenantSid()));
        List<String> teachingRating6Employees = Arrays.asList(newEmployeeReviewProportion.getTeaching_rating_6_employees().split(","));
        List<String> teachingRating78Employees = Arrays.asList(newEmployeeReviewProportion.getTeaching_rating_7_8_employees().split(","));
        List<String> teachingRating910Employees = Arrays.asList(newEmployeeReviewProportion.getTeaching_rating_9_10_employees().split(","));
        List<String> teachingMoreThan10Employees = Arrays.asList(newEmployeeReviewProportion.getTeaching_more_than_10_employees().split(","));

        List<String> allEmail = new ArrayList<>();
        allEmail.addAll(teachingRating6Employees);
        allEmail.addAll(teachingRating78Employees);
        allEmail.addAll(teachingRating910Employees);
        allEmail.addAll(teachingMoreThan10Employees);

        List<NewEmployeesReviewDetail> allNewEmployeesReviewDetails = newEmployeesReviewDetailDAO.getBaseMapper().selectList(new LambdaQueryWrapper<NewEmployeesReviewDetail>()
                .in(NewEmployeesReviewDetail::getOwner_emp_email, allEmail)
                .eq(NewEmployeesReviewDetail::getTenantsid, LoginUserUtils.getTenantSid()));
        if(CollectionUtils.isEmpty(allNewEmployeesReviewDetails)){
            NewEmployeeReviewInfoVO newEmployeeReviewInfoVO = new NewEmployeeReviewInfoVO();
            StringUtils.noNullFieldAttr(newEmployeeReviewInfoVO);
            ArrayList<NewEmployeeReviewInfoVO> newEmployeeReviewInfoVOS = new ArrayList<>();
            newEmployeeReviewInfoVOS.add(newEmployeeReviewInfoVO);
            return newEmployeeReviewInfoVOS;
        }

        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        List<NewEmployeeReviewInfoVO> info = getInfo(allNewEmployeesReviewDetails, 4, false, true);
        for (NewEmployeeReviewInfoVO newEmployeeReviewInfoVO : info) {

            LocalDate date = LocalDate.parse(newEmployeeReviewInfoVO.getEmployment_date(),dateTimeFormatter);
            long until = date.until(localDate, ChronoUnit.DAYS);
            if (until >= 7 && until < 14) {
                newEmployeeReviewInfoVO.setCurrent_score_status("入职一周");
                if (newEmployeeReviewInfoVO.getRating_one_week_all() <= 6) {
                    newEmployeeReviewInfoVO.setNew_employee_status("代教评分6分以下");
                } else if (newEmployeeReviewInfoVO.getRating_one_week_all() >= 7 && newEmployeeReviewInfoVO.getRating_one_week_all() <= 8) {
                    newEmployeeReviewInfoVO.setNew_employee_status("代教评分7-8分");
                } else if (newEmployeeReviewInfoVO.getRating_one_week_all() >= 9 && newEmployeeReviewInfoVO.getRating_one_week_all() <= 10) {
                    newEmployeeReviewInfoVO.setNew_employee_status("代教评分9-10分");
                } else if (newEmployeeReviewInfoVO.getRating_one_week_all() > 10) {
                    newEmployeeReviewInfoVO.setNew_employee_status("代教评分10分以上");
                }
            } else if (until >= 14 && until < 30) {
                newEmployeeReviewInfoVO.setCurrent_score_status("入职二周");
                if (newEmployeeReviewInfoVO.getRating_two_week_all() <= 6) {
                    newEmployeeReviewInfoVO.setNew_employee_status("代教评分6分以下");
                } else if (newEmployeeReviewInfoVO.getRating_two_week_all() >= 7 && newEmployeeReviewInfoVO.getRating_two_week_all() <= 8) {
                    newEmployeeReviewInfoVO.setNew_employee_status("代教评分7-8分");
                } else if (newEmployeeReviewInfoVO.getRating_two_week_all() >= 9 && newEmployeeReviewInfoVO.getRating_two_week_all() <= 10) {
                    newEmployeeReviewInfoVO.setNew_employee_status("代教评分9-10分");
                } else if (newEmployeeReviewInfoVO.getRating_two_week_all() > 10) {
                    newEmployeeReviewInfoVO.setNew_employee_status("代教评分10分以上");
                }
            } else if (until >= 30 && until < 60) {
                newEmployeeReviewInfoVO.setCurrent_score_status("入职一个月");
                if (newEmployeeReviewInfoVO.getRating_one_month_all() <= 6) {
                    newEmployeeReviewInfoVO.setNew_employee_status("代教评分6分以下");
                } else if (newEmployeeReviewInfoVO.getRating_one_month_all() >= 7 && newEmployeeReviewInfoVO.getRating_one_month_all() <= 8) {
                    newEmployeeReviewInfoVO.setNew_employee_status("代教评分7-8分");
                } else if (newEmployeeReviewInfoVO.getRating_one_month_all() >= 9 && newEmployeeReviewInfoVO.getRating_one_month_all() <= 10) {
                    newEmployeeReviewInfoVO.setNew_employee_status("代教评分9-10分");
                } else if (newEmployeeReviewInfoVO.getRating_one_month_all() > 10) {
                    newEmployeeReviewInfoVO.setNew_employee_status("代教评分10分以上");
                }
            } else if (until >= 60 && until < 90) {
                newEmployeeReviewInfoVO.setCurrent_score_status("入职俩个月");
                if (newEmployeeReviewInfoVO.getRating_two_month_all() <= 6) {
                    newEmployeeReviewInfoVO.setNew_employee_status("代教评分6分以下");
                } else if (newEmployeeReviewInfoVO.getRating_two_month_all() >= 7 && newEmployeeReviewInfoVO.getRating_two_month_all() <= 8) {
                    newEmployeeReviewInfoVO.setNew_employee_status("代教评分7-8分");
                } else if (newEmployeeReviewInfoVO.getRating_two_month_all() >= 9 && newEmployeeReviewInfoVO.getRating_two_month_all() <= 10) {
                    newEmployeeReviewInfoVO.setNew_employee_status("代教评分9-10分");
                } else if (newEmployeeReviewInfoVO.getRating_two_month_all() > 10) {
                    newEmployeeReviewInfoVO.setNew_employee_status("代教评分10分以上");
                }
            } else if (until >= 90) {
                newEmployeeReviewInfoVO.setCurrent_score_status("即将转正");
                if (newEmployeeReviewInfoVO.getRating_three_month_all() <= 6) {
                    newEmployeeReviewInfoVO.setNew_employee_status("代教评分6分以下");
                } else if (newEmployeeReviewInfoVO.getRating_three_month_all() >= 7 && newEmployeeReviewInfoVO.getRating_three_month_all() <= 8) {
                    newEmployeeReviewInfoVO.setNew_employee_status("代教评分7-8分");
                } else if (newEmployeeReviewInfoVO.getRating_three_month_all() >= 9 && newEmployeeReviewInfoVO.getRating_three_month_all() <= 10) {
                    newEmployeeReviewInfoVO.setNew_employee_status("代教评分9-10分");
                } else if (newEmployeeReviewInfoVO.getRating_three_month_all() > 10) {
                    newEmployeeReviewInfoVO.setNew_employee_status("代教评分10分以上");
                }
            }
            newEmployeeReviewInfoVO.setAttachment(null);
        }
        if(CollectionUtils.isEmpty(info)){
            NewEmployeeReviewInfoVO newEmployeeReviewInfoVO = new NewEmployeeReviewInfoVO();
            StringUtils.noNullFieldAttr(newEmployeeReviewInfoVO);
            ArrayList<NewEmployeeReviewInfoVO> newEmployeeReviewInfoVOS = new ArrayList<>();
            newEmployeeReviewInfoVOS.add(newEmployeeReviewInfoVO);
            return newEmployeeReviewInfoVOS;
        }
        return info;

    }

    public List<NewEmployeeReviewInfoVO> getNewEmployeeReviewMonthlyReportCheckAndAccept(Map map) {
        List<NewEmployeesReviewDetail> newEmployeesReviewDetails = getNewEmployeesReviewDetails();
        if (CollectionUtils.isEmpty(newEmployeesReviewDetails)) {
            NewEmployeeReviewInfoVO newEmployeeReviewInfoVO = new NewEmployeeReviewInfoVO();
            StringUtils.noNullFieldAttr(newEmployeeReviewInfoVO);
            ArrayList<NewEmployeeReviewInfoVO> newEmployeeReviewInfoVOS = new ArrayList<>();
            newEmployeeReviewInfoVOS.add(newEmployeeReviewInfoVO);
            return newEmployeeReviewInfoVOS;
        }
        List<NewEmployeeReviewInfoVO> info = getInfo(newEmployeesReviewDetails, 4, false, true);


        for (NewEmployeeReviewInfoVO newEmployeeReviewInfoVO : info) {

            NewEmployeesReviewMentor newEmployeesReviewMentor = newEmployeesReviewMentorDAO.getBaseMapper().selectOne(new LambdaQueryWrapper<NewEmployeesReviewMentor>()
                    .eq(NewEmployeesReviewMentor::getTenantsid, LoginUserUtils.getTenantSid())
                    .eq(NewEmployeesReviewMentor::getOwner_emp_email, newEmployeeReviewInfoVO.getOwner_emp_email()));

            if (newEmployeesReviewMentor != null) {
                if (newEmployeesReviewMentor != null && (newEmployeesReviewMentor.getAcceptance_score() != null && newEmployeesReviewMentor.getAcceptance_score() != 0)) {
                    newEmployeeReviewInfoVO.setNew_employee_status("验收人数");
                } else {
                    newEmployeeReviewInfoVO.setNew_employee_status("未验收人数");
                }
            }

        }

        return info;
    }

    public List<NewEmployeeReviewInfoVO> getNewEmployeeReviewMonthlyReportAcceptanceRating(Map map) {
        List<NewEmployeesReviewDetail> newEmployeesReviewDetails = getNewEmployeesReviewDetails();
        if (CollectionUtils.isEmpty(newEmployeesReviewDetails)) {
            NewEmployeeReviewInfoVO newEmployeeReviewInfoVO = new NewEmployeeReviewInfoVO();
            StringUtils.noNullFieldAttr(newEmployeeReviewInfoVO);
            ArrayList<NewEmployeeReviewInfoVO> newEmployeeReviewInfoVOS = new ArrayList<>();
            newEmployeeReviewInfoVOS.add(newEmployeeReviewInfoVO);
            return newEmployeeReviewInfoVOS;
        }
        List<NewEmployeeReviewInfoVO> info = getInfo(newEmployeesReviewDetails, 4, false, true);

        ArrayList<NewEmployeeReviewInfoVO> newEmployeeReviewInfoVOS = new ArrayList<>();


        for (NewEmployeeReviewInfoVO newEmployeeReviewInfoVO : info) {
            NewEmployeesReviewMentor newEmployeesReviewMentor = newEmployeesReviewMentorDAO.getBaseMapper().selectOne(new LambdaQueryWrapper<NewEmployeesReviewMentor>()
                    .eq(NewEmployeesReviewMentor::getTenantsid, LoginUserUtils.getTenantSid())
                    .eq(NewEmployeesReviewMentor::getOwner_emp_email, newEmployeeReviewInfoVO.getOwner_emp_email()));


            if (newEmployeesReviewMentor != null) {
                if (newEmployeesReviewMentor != null && (newEmployeesReviewMentor.getAcceptance_score() != null && newEmployeesReviewMentor.getAcceptance_score() != 0)) {
                    newEmployeeReviewInfoVOS.add(newEmployeeReviewInfoVO);
                }
            }
        }
        for (NewEmployeeReviewInfoVO employeeReviewInfoVO : newEmployeeReviewInfoVOS) {
            if (employeeReviewInfoVO.getAcceptance_score() < 7) {
                employeeReviewInfoVO.setNew_employee_status("新人总验收评分5分以下");
            }
            if (employeeReviewInfoVO.getAcceptance_score() >= 7 && employeeReviewInfoVO.getAcceptance_score() <= 8) {
                employeeReviewInfoVO.setNew_employee_status("新人总验收评分7-8分");
            }
            if (employeeReviewInfoVO.getAcceptance_score() >= 9 && employeeReviewInfoVO.getAcceptance_score() <= 10) {
                employeeReviewInfoVO.setNew_employee_status("新人总验收评分9-10分");
            }
        }
        if(CollectionUtils.isEmpty(newEmployeeReviewInfoVOS)){
            NewEmployeeReviewInfoVO newEmployeeReviewInfoVO = new NewEmployeeReviewInfoVO();
            StringUtils.noNullFieldAttr(newEmployeeReviewInfoVO);
            newEmployeeReviewInfoVOS = new ArrayList<>();
            newEmployeeReviewInfoVOS.add(newEmployeeReviewInfoVO);
            return newEmployeeReviewInfoVOS;
        }
        return newEmployeeReviewInfoVOS;
    }


    @Transactional
    public List<NewEmployeesReviewDetail> getNewEmployeeReviewStatusUpdate(Map map) throws DWException {
        if (!(isPMOVP(LoginUserUtils.getLoginUserId()) || isPM(LoginUserUtils.getLoginUserId()))) {
            throw new DWException("您没有权限修改");
        }
        log.info("queryEmployeeInfo:{}", map);
        JSONObject obj = JSON.parseObject(JSON.toJSONString(map));
        JSONArray jsonArray = obj.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("new_employees_review_info");

        if (jsonArray == null || jsonArray.size() == 0) {
            throw new DWException("no date");
        }
        List<String> strings = new ArrayList<>();
        List<NewEmployeesReviewDetail> employees = JSON.parseArray(JSON.toJSONString(jsonArray), NewEmployeesReviewDetail.class);
        for (NewEmployeesReviewDetail employee : employees) {
            NewEmployeesReviewDetail newEmployeesReviewDetail = new NewEmployeesReviewDetail();
            newEmployeesReviewDetail.setOwner_emp_email(employee.getOwner_emp_email());
            newEmployeesReviewDetail.setEmployee_status(employee.getEmployee_status());

            LambdaQueryWrapper<NewEmployeesReviewDetail> w = new LambdaQueryWrapper<>();
            w.eq(NewEmployeesReviewDetail::getOwner_emp_email, employee.getOwner_emp_email())
                    .eq(NewEmployeesReviewDetail::getTenantsid, LoginUserUtils.getTenantSid());
            newEmployeesReviewDetailDAO.getBaseMapper().update(newEmployeesReviewDetail, w);
            Employee updateEmp = new Employee();
            if ("quit".equals(employee.getEmployee_status())) {
                updateEmp.setStatus("N");
            }
            employeeDAO.getBaseMapper().update(updateEmp, new LambdaQueryWrapper<Employee>()
                    .eq(Employee::getEmail, employee.getOwner_emp_email())
                    .eq(Employee::getTenantsid, LoginUserUtils.getTenantSid()));

            strings.add(employee.getOwner_emp_email());
        }
        List<NewEmployeesReviewDetail> newEmployeesReviewDetails = newEmployeesReviewDetailDAO.getBaseMapper().selectList(new LambdaQueryWrapper<NewEmployeesReviewDetail>()
                .in(NewEmployeesReviewDetail::getOwner_emp_email, strings)
                .eq(NewEmployeesReviewDetail::getTenantsid, LoginUserUtils.getTenantSid()));
        return newEmployeesReviewDetails;
    }


    @Scheduled(cron = "00 00 23 * * ?")
    public List<NewEmployeeReviewProportion> updateNewcomerStatistics() throws URISyntaxException, IOException {
        List<NewEmployeeReviewProportion> newEmployeeReviewProportions = newEmployeeReviewProportionDAO.getBaseMapper().selectList(new LambdaQueryWrapper<NewEmployeeReviewProportion>()
                .eq(NewEmployeeReviewProportion::getTenantsid, LoginUserUtils.getTenantSid())
                .orderByAsc(NewEmployeeReviewProportion::getDate));
        LocalDate now = LocalDate.now();
        int currentMonth = now.getMonth().getValue();
        int currentYear = now.getYear();

        Map<Date, NewEmployeeReviewProportion> newEmployeeReviewProportionMap = newEmployeeReviewProportions.stream().collect(Collectors.toMap(s -> s.getDate(), s -> s));
        List<NewEmployeeReviewProportion> closestData = newEmployeeReviewProportions.stream()
                .filter(proportion -> new java.util.Date(proportion.getDate().getTime()).getYear() + 1900 == currentYear)
                .filter(proportion -> new java.util.Date(proportion.getDate().getTime()).getMonth() + 1 == currentMonth)
                .collect(Collectors.toList());
        NewEmployeeReviewProportion currentMonthNewEmployeeReviewProportion = null;
        if (CollectionUtils.isEmpty(closestData)) {
            currentMonthNewEmployeeReviewProportion = getCurrentMonthNewEmployeeReviewProportion(null);

        } else {
            currentMonthNewEmployeeReviewProportion = getCurrentMonthNewEmployeeReviewProportion(closestData.get(0));
            currentMonthNewEmployeeReviewProportion.setId(closestData.get(0).getId());
        }
        currentMonthNewEmployeeReviewProportion.setTenantsid(LoginUserUtils.getTenantSid());
        newEmployeeReviewProportionDAO.saveOrUpdate(currentMonthNewEmployeeReviewProportion);
        if (CollectionUtils.isNotEmpty(closestData)) {
            newEmployeeReviewProportionMap.remove(closestData.get(0).getDate());
        }

        List<Map.Entry<Date, NewEmployeeReviewProportion>> list = new ArrayList(newEmployeeReviewProportionMap.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<Date, NewEmployeeReviewProportion>>() {
            @Override
            public int compare(Map.Entry<Date, NewEmployeeReviewProportion> o1, Map.Entry<Date, NewEmployeeReviewProportion> o2) {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                LocalDate date1 = LocalDate.parse(o1.getKey().toString(), formatter);
                LocalDate date2 = LocalDate.parse(o2.getKey().toString(), formatter);
                if (date1.isBefore(date2)) {
                    return -1;
                } else if (date1.isEqual(date2)) {
                    return 0;
                } else {
                    return 1;
                }
            }


        });
        List<NewEmployeeReviewProportion> collect = list.stream().map(a -> a.getValue()).collect(Collectors.toList());

        return collect;
    }

    private NewEmployeeReviewProportion getCurrentMonthNewEmployeeReviewProportion(NewEmployeeReviewProportion closestData) throws URISyntaxException, IOException {
        LocalDate month = LocalDate.now();
        LocalDate firstDay = month.withDayOfMonth(1);
        LocalDate localDate = month.withDayOfMonth(month.lengthOfMonth());
        //获取所有新人
        LambdaQueryWrapper<NewEmployeesReviewDetail> qw = new LambdaQueryWrapper<>();
        qw.and(i -> i.eq(NewEmployeesReviewDetail::getEmployee_status, "probation")
                        .or(a -> a.eq(NewEmployeesReviewDetail::getEmployee_status, "quit")
                                .ge(NewEmployeesReviewDetail::getConfirmation_date, firstDay)
                                .le(NewEmployeesReviewDetail::getConfirmation_date, localDate))
                        .or(b -> b.eq(NewEmployeesReviewDetail::getEmployee_status, "beformal")
                                .ge(NewEmployeesReviewDetail::getConfirmation_date, firstDay)
                                .le(NewEmployeesReviewDetail::getConfirmation_date, localDate))
                        .or(c -> c.eq(NewEmployeesReviewDetail::getEmployee_status, "return")
                                .ge(NewEmployeesReviewDetail::getConfirmation_date, firstDay)
                                .le(NewEmployeesReviewDetail::getConfirmation_date, localDate)))
                .eq(NewEmployeesReviewDetail::getTenantsid, LoginUserUtils.getTenantSid());

        List<NewEmployeesReviewDetail> newEmployeesReviewDetails = newEmployeesReviewDetailDAO.getBaseMapper().selectList(qw);

        LambdaQueryWrapper<NewEmployeesReviewMentor> wrapper = new LambdaQueryWrapper<>();
        wrapper.isNull(NewEmployeesReviewMentor::getAcceptance_score)
                .eq(NewEmployeesReviewMentor::getTenantsid, LoginUserUtils.getTenantSid());
//                .and(w -> w.isNotNull(NewEmployeesReviewMentor::getRating_one_week)
//                        .or().isNotNull(NewEmployeesReviewMentor::getRating_two_week)
//                        .or().isNotNull(NewEmployeesReviewMentor::getRating_one_month)
//                        .or().isNotNull(NewEmployeesReviewMentor::getRating_two_month)
//                        .or().isNotNull(NewEmployeesReviewMentor::getRating_three_month)
//                );

        List<NewEmployeesReviewMentor> newEmployeesReviewMentors = newEmployeesReviewMentorDAO.getBaseMapper().selectList(wrapper);
        List<String> emails = newEmployeesReviewMentors.stream().map(i -> i.getOwner_emp_email()).collect(Collectors.toList());
        List<NewEmployeesReviewDetail> score_employees = new ArrayList<>();
        Map<String, NewEmployeesReviewDetail> score_employeesMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(emails)) {
            LambdaQueryWrapper<NewEmployeesReviewDetail> wrapper1 = new LambdaQueryWrapper<>();
            wrapper1.and(i -> i.eq(NewEmployeesReviewDetail::getEmployee_status, "probation"))
                    .in(NewEmployeesReviewDetail::getOwner_emp_email, emails)
                    .eq(NewEmployeesReviewDetail::getTenantsid, LoginUserUtils.getTenantSid());

            score_employees = newEmployeesReviewDetailDAO.getBaseMapper().selectList(wrapper1);
            score_employeesMap = score_employees.stream().collect(Collectors.toMap(NewEmployeesReviewDetail::getOwner_emp_no, score_employee -> score_employee));
        }

        //总人数
        int total = newEmployeesReviewDetails.size();
        // 试用期人数
        int probation_new_employee_sum = 0;
        String probation_new_employeeS = "";

        //一周内试用期员工数量
        int one_week_sum = 0;
        String one_week_employeeS = "";
        //一周到二周试用期员工数量
        int two_week_sum = 0;
        String two_week_employeeS = "";
        //14天到一个月试用期员工数量
        int two_week_to_one_month_sum = 0;
        String two_week_to_one_month_employeeS = "";
        //一个月到俩个月试用期员工数量
        int one_to_two_month_sum = 0;
        String one_to_two_month_employeeS = "";
        //即将转正的员工数量
        int will_entry_sum = 0;
        String will_entry_employeeS = "";
        //离职员工数量
        int depart_sum = 0;
        String depart_employeeS = "";
        //验收人数
        int acceptance_sum = 0;
        String acceptance_employeeS = "";
        //转正员工数量
        int formal_sum = 0;
        String formal_employeeS = "";
        //不予留用员工数量
        int no_number_of_permanent_employees_sum = 0;
        String no_number_of_permanent_employeeS = "";
        //总验收评分6分以下
        int total_score_6 = 0;
        String total_score_6_employeeS = "";
        //总验收评分7到8分
        int total_score_7_8 = 0;
        String total_score_7_8_employeeS = "";
        //总验收评分9到10分
        int total_score_9_10 = 0;
        String total_score_9_10_employeeS = "";
        //当月评分6分以下
        int current_score_6 = 0;
        String current_score_6_employeeS = "";
        //当月评分7-8分
        int current_score_7_8 = 0;
        String current_score_7_8_employeeS = "";
        //当月评分9-10分
        int current_score_9_10 = 0;
        String current_score_9_10_employeeS = "";
        //当月评分10分以上
        int current_score_10 = 0;
        String current_score_10_employeeS = "";
        //任务卡逾期
        int overdue_sum = 0;
        String overdue_task_employeeS = "";
        //应评分人数
        int score_employeesSum = 0;
        String score_employees_employeeS= "";

        NewEmployeeReviewProportion newEmployeeReviewProportion = new NewEmployeeReviewProportion();

        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate now = LocalDate.now();
        for (NewEmployeesReviewDetail newEmployeesReviewDetail : newEmployeesReviewDetails) {
            LocalDate parse = LocalDate.parse(newEmployeesReviewDetail.getEmployment_date(), dateTimeFormatter);
            LocalDate one_week = parse.plusWeeks(1);
            LocalDate two_week = parse.plusWeeks(2);
            LocalDate one_month = parse.plusMonths(1);
            LocalDate oneToTwo_month = parse.plusMonths(2);

            if ("probation".equals(newEmployeesReviewDetail.getEmployee_status())) {
                probation_new_employee_sum++;
                probation_new_employeeS = StringUtils.splice(probation_new_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                if (now.isBefore(one_week)) {
                    one_week_sum++;
                    one_week_employeeS = StringUtils.splice(one_week_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                } else if (now.isBefore(two_week)) {
                    two_week_sum++;
                    two_week_employeeS = StringUtils.splice(two_week_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                } else if (now.isBefore(one_month)) {
                    two_week_to_one_month_sum++;
                    two_week_to_one_month_employeeS = StringUtils.splice(two_week_to_one_month_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                } else if (now.isBefore(oneToTwo_month)) {
                    one_to_two_month_sum++;
                    one_to_two_month_employeeS = StringUtils.splice(one_to_two_month_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                }
            }
            NewEmployeesReviewMentor newEmployeesReviewMentor = newEmployeesReviewMentorDAO.getBaseMapper().selectOne(new LambdaQueryWrapper<NewEmployeesReviewMentor>()
                    .eq(NewEmployeesReviewMentor::getTenantsid, LoginUserUtils.getTenantSid())
                    .in(NewEmployeesReviewMentor::getOwner_emp_email, newEmployeesReviewDetail.getOwner_emp_email()));
            //获取离职/即将转正人数
            long until = parse.until(now, ChronoUnit.DAYS);
            if ("probation".equals(newEmployeesReviewDetail.getEmployee_status()) && until >= 60) {
                will_entry_sum++;
                will_entry_employeeS = StringUtils.splice(will_entry_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
            }
            // 获取当前月不同分数段的人
            if (newEmployeesReviewMentor!=null
                    && !score_employeesMap.isEmpty()
                    && score_employeesMap.containsKey(newEmployeesReviewDetail.getOwner_emp_no())) {
                String employmentDateString = score_employeesMap.get(newEmployeesReviewDetail.getOwner_emp_no()).getEmployment_date();
                LocalDate employmentDate = LocalDate.parse(employmentDateString, dateTimeFormatter).plusDays(7);
                LocalDate finalScoringTime = LocalDate.parse(employmentDateString, dateTimeFormatter).plusDays(90);
                    if (until >= 7 && until < 14) {
                        score_employeesSum++;
                        score_employees_employeeS = StringUtils.splice(score_employees_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                        if (newEmployeesReviewMentor.getRating_one_week_all() != null) {
                            if (newEmployeesReviewMentor.getRating_one_week_all() <= 6) {
                                current_score_6++;
                                current_score_6_employeeS = StringUtils.splice(current_score_6_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                            } else if (newEmployeesReviewMentor.getRating_one_week_all() >= 7 && newEmployeesReviewMentor.getRating_one_week_all() <= 8) {
                                current_score_7_8++;
                                current_score_7_8_employeeS = StringUtils.splice(current_score_7_8_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                            } else if (newEmployeesReviewMentor.getRating_one_week_all() >= 9 && newEmployeesReviewMentor.getRating_one_week_all() <= 10) {
                                current_score_9_10++;
                                current_score_9_10_employeeS = StringUtils.splice(current_score_9_10_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                            } else if (newEmployeesReviewMentor.getRating_one_week_all() > 10) {
                                current_score_10++;
                                current_score_10_employeeS = StringUtils.splice(current_score_10_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                            }
                        }
                    } else if (until >= 14 && until < 30) {
                        score_employeesSum++;
                        score_employees_employeeS = StringUtils.splice(score_employees_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                        if (newEmployeesReviewMentor.getRating_two_week_all() != null) {
                            if (newEmployeesReviewMentor.getRating_two_week_all() <= 6) {
                                current_score_6++;
                                current_score_6_employeeS = StringUtils.splice(current_score_6_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                            } else if (newEmployeesReviewMentor.getRating_two_week_all() >= 7 && newEmployeesReviewMentor.getRating_two_week_all() <= 8) {
                                current_score_7_8++;
                                current_score_7_8_employeeS = StringUtils.splice(current_score_7_8_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                            } else if (newEmployeesReviewMentor.getRating_two_week_all() >= 9 && newEmployeesReviewMentor.getRating_two_week_all() <= 10) {
                                current_score_9_10++;
                                current_score_9_10_employeeS = StringUtils.splice(current_score_9_10_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                            } else if (newEmployeesReviewMentor.getRating_two_week_all() > 10) {
                                current_score_10++;
                                current_score_10_employeeS = StringUtils.splice(current_score_10_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                            }
                        }
                    } else if (until >= 30 && until < 60) {
                        score_employeesSum++;
                        score_employees_employeeS = StringUtils.splice(score_employees_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                        if (newEmployeesReviewMentor.getRating_one_month_all() != null) {
                            if (newEmployeesReviewMentor.getRating_one_month_all() <= 6) {
                                current_score_6++;
                                current_score_6_employeeS = StringUtils.splice(current_score_6_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                            } else if (newEmployeesReviewMentor.getRating_one_month_all() >= 7 && newEmployeesReviewMentor.getRating_one_month_all() <= 8) {
                                current_score_7_8++;
                                current_score_7_8_employeeS = StringUtils.splice(current_score_7_8_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                            } else if (newEmployeesReviewMentor.getRating_one_month_all() >= 9 && newEmployeesReviewMentor.getRating_one_month_all() <= 10) {
                                current_score_9_10++;
                                current_score_9_10_employeeS = StringUtils.splice(current_score_9_10_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                            } else if (newEmployeesReviewMentor.getRating_one_month_all() > 10) {
                                current_score_10++;
                                current_score_10_employeeS = StringUtils.splice(current_score_10_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                            }
                        }
                    } else if (until >= 60 && until < 90) {
                        score_employeesSum++;
                        score_employees_employeeS = StringUtils.splice(score_employees_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                        if (newEmployeesReviewMentor.getRating_two_month_all() != null) {
                            if (newEmployeesReviewMentor.getRating_two_month_all() <= 6) {
                                current_score_6++;
                                current_score_6_employeeS = StringUtils.splice(current_score_6_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                            } else if (newEmployeesReviewMentor.getRating_two_month_all() >= 7 && newEmployeesReviewMentor.getRating_two_month_all() <= 8) {
                                current_score_7_8++;
                                current_score_7_8_employeeS = StringUtils.splice(current_score_7_8_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                            } else if (newEmployeesReviewMentor.getRating_two_month_all() >= 9 && newEmployeesReviewMentor.getRating_two_month_all() <= 10) {
                                current_score_9_10++;
                                current_score_9_10_employeeS = StringUtils.splice(current_score_9_10_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                            } else if (newEmployeesReviewMentor.getRating_two_month_all() > 10) {
                                current_score_10++;
                                current_score_10_employeeS = StringUtils.splice(current_score_10_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                            }
                        }
                    } else if (until >= 90 &&  finalScoringTime.getYear()== now.getYear() &&finalScoringTime.getMonth().equals(now.getMonth()))  {
                        score_employeesSum++;
                        score_employees_employeeS = StringUtils.splice(score_employees_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                        if (newEmployeesReviewMentor.getRating_three_month_all() != null) {
                            if (newEmployeesReviewMentor.getRating_three_month_all() <= 6) {
                                current_score_6++;
                                current_score_6_employeeS = StringUtils.splice(current_score_6_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                            } else if (newEmployeesReviewMentor.getRating_three_month_all() >= 7 && newEmployeesReviewMentor.getRating_three_month_all() <= 8) {
                                current_score_7_8++;
                                current_score_7_8_employeeS = StringUtils.splice(current_score_7_8_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                            } else if (newEmployeesReviewMentor.getRating_three_month_all() >= 9 && newEmployeesReviewMentor.getRating_three_month_all() <= 10) {
                                current_score_9_10++;
                                current_score_9_10_employeeS = StringUtils.splice(current_score_9_10_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                            } else if (newEmployeesReviewMentor.getRating_three_month_all() > 10) {
                                current_score_10++;
                                current_score_10_employeeS = StringUtils.splice(current_score_10_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                            }
                        }
                    }
            }


            //转正人数
            if ("beformal".equals(newEmployeesReviewDetail.getEmployee_status())) {
                formal_sum++;
                formal_employeeS = StringUtils.splice(formal_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
            }
            //离职
            if ("quit".equals(newEmployeesReviewDetail.getEmployee_status())) {
                depart_sum++;
                depart_employeeS = StringUtils.splice(depart_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
            }
            //不可留用
            if ("return".equals(newEmployeesReviewDetail.getEmployee_status())) {
                no_number_of_permanent_employees_sum++;
                no_number_of_permanent_employeeS = StringUtils.splice(no_number_of_permanent_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
            }
            if (newEmployeesReviewMentor != null) {
                if (newEmployeesReviewMentor.getAcceptance_score() != null && (newEmployeesReviewMentor.getAcceptance_score() != null && newEmployeesReviewMentor.getAcceptance_score() != 0)) {
                    acceptance_sum++;
                    acceptance_employeeS = StringUtils.splice(acceptance_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                    if (newEmployeesReviewMentor.getAcceptance_score() < 7) {
                        total_score_6++;
                        total_score_6_employeeS = StringUtils.splice(total_score_6_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                    }
                    if (newEmployeesReviewMentor.getAcceptance_score() == 7 || newEmployeesReviewMentor.getAcceptance_score() == 8) {
                        total_score_7_8++;
                        total_score_7_8_employeeS = StringUtils.splice(total_score_7_8_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                    }
                    if (newEmployeesReviewMentor.getAcceptance_score() == 9 || newEmployeesReviewMentor.getAcceptance_score() == 10) {
                        total_score_9_10++;
                        total_score_9_10_employeeS = StringUtils.splice(total_score_9_10_employeeS, newEmployeesReviewDetail.getOwner_emp_email());
                    }
                }
            }


        }
        List<String> overdueTask = new ArrayList<>();
        if (closestData == null) {
            overdueTask = getOverdueTask("");
        } else {
            overdueTask = getOverdueTask(closestData.getOverdue_employees());
        }
        overdue_sum = overdueTask.size();
        String a = "";
        for (String s : overdueTask) {
            a = StringUtils.splice(a, s);
        }
        overdue_task_employeeS = a;


        newEmployeeReviewProportion.setYear(month.getYear());
        newEmployeeReviewProportion.setDate(java.sql.Date.valueOf(LocalDate.now()));
        newEmployeeReviewProportion.setTotal(total);
        newEmployeeReviewProportion.setProbation_new_employee_sum(probation_new_employee_sum);
        newEmployeeReviewProportion.setOne_week_sum(one_week_sum);
        newEmployeeReviewProportion.setOne_week_proportion((probation_new_employee_sum == 0) ? new BigDecimal(0) : new BigDecimal((one_week_sum / (probation_new_employee_sum * 1.0))).setScale(2, RoundingMode.HALF_UP));
        newEmployeeReviewProportion.setTwo_week_sum(two_week_sum);
        newEmployeeReviewProportion.setTwo_week_proportion((probation_new_employee_sum == 0) ? new BigDecimal(0) : new BigDecimal((two_week_sum / (probation_new_employee_sum * 1.0))).setScale(2, RoundingMode.HALF_UP));
        newEmployeeReviewProportion.setTwo_week_to_one_month(two_week_to_one_month_sum);
        newEmployeeReviewProportion.setTwo_week_to_one_month_proportion((probation_new_employee_sum == 0) ? new BigDecimal(0) : new BigDecimal((two_week_to_one_month_sum / (probation_new_employee_sum * 1.0))).setScale(2, RoundingMode.HALF_UP));
        newEmployeeReviewProportion.setOne_month_sum(one_to_two_month_sum);
        newEmployeeReviewProportion.setOne_month_proportion((probation_new_employee_sum == 0) ? new BigDecimal(0) : new BigDecimal((one_to_two_month_sum / (probation_new_employee_sum * 1.0))).setScale(2, RoundingMode.HALF_UP));
        newEmployeeReviewProportion.setWill_entry_sum(will_entry_sum);
        newEmployeeReviewProportion.setWill_entry_proportion((probation_new_employee_sum == 0) ? new BigDecimal(0) : new BigDecimal((will_entry_sum / (probation_new_employee_sum * 1.0))).setScale(2, RoundingMode.HALF_UP));

        newEmployeeReviewProportion.setDepart(depart_sum);
        newEmployeeReviewProportion.setDepart_proportion((total == 0) ? new BigDecimal(0) : new BigDecimal((depart_sum / (total * 1.0))).setScale(2, RoundingMode.HALF_UP));
        newEmployeeReviewProportion.setFormal_employees(formal_sum);
        newEmployeeReviewProportion.setFormal_employees_proportion((acceptance_sum == 0) ? new BigDecimal(0) : new BigDecimal((formal_sum / (acceptance_sum * 1.0))).setScale(2, RoundingMode.HALF_UP));

        newEmployeeReviewProportion.setTeaching_rating_6(current_score_6);
        newEmployeeReviewProportion.setTeaching_rating_6_proportion((score_employees.size() == 0) ? new BigDecimal(0) : new BigDecimal((current_score_6 / (score_employeesSum * 1.0))).setScale(2, RoundingMode.HALF_UP));
        newEmployeeReviewProportion.setTeaching_rating_7_8(current_score_7_8);
        newEmployeeReviewProportion.setTeaching_rating_7_8_proportion((score_employees.size() == 0) ? new BigDecimal(0) : new BigDecimal((current_score_7_8 / (score_employeesSum * 1.0))).setScale(2, RoundingMode.HALF_UP));
        newEmployeeReviewProportion.setTeaching_ration_9_10(current_score_9_10);
        newEmployeeReviewProportion.setTeaching_ration_9_10_proportion((score_employees.size() == 0) ? new BigDecimal(0) : new BigDecimal((current_score_9_10 / (score_employeesSum * 1.0))).setScale(2, RoundingMode.HALF_UP));
        newEmployeeReviewProportion.setTeaching_more_than_10(current_score_10);
        newEmployeeReviewProportion.setTeaching_more_than_10_proportion((score_employees.size() == 0) ? new BigDecimal(0) : new BigDecimal((current_score_10 / (score_employeesSum * 1.0))).setScale(2, RoundingMode.HALF_UP));

        newEmployeeReviewProportion.setAcceptance_report(acceptance_sum);
        newEmployeeReviewProportion.setAcceptance_report_proportion((total == 0) ? new BigDecimal(0) : new BigDecimal((acceptance_sum / (total * 1.0))).setScale(2, RoundingMode.HALF_UP));
        newEmployeeReviewProportion.setNo_number_of_permanent_employees(no_number_of_permanent_employees_sum);
        newEmployeeReviewProportion.setNo_number_of_permanent_employees_proportion((acceptance_sum == 0) ? new BigDecimal(0) : new BigDecimal((no_number_of_permanent_employees_sum / (acceptance_sum * 1.0))).setScale(2, RoundingMode.HALF_UP));

        newEmployeeReviewProportion.setTotal_teaching_rating_6(total_score_6);
        newEmployeeReviewProportion.setTotal_teaching_rating_7_8(total_score_7_8);
        newEmployeeReviewProportion.setTotal_teaching_rating_9_10(total_score_9_10);
        newEmployeeReviewProportion.setTotal_teaching_rating_6_proportion((acceptance_sum == 0) ? new BigDecimal(0) : new BigDecimal((total_score_6 / (acceptance_sum * 1.0))).setScale(2, RoundingMode.HALF_UP));
        newEmployeeReviewProportion.setTotal_teaching_rating_7_8_proportion((acceptance_sum == 0) ? new BigDecimal(0) : new BigDecimal((total_score_7_8 / (acceptance_sum * 1.0))).setScale(2, RoundingMode.HALF_UP));
        newEmployeeReviewProportion.setTotal_teaching_rating_9_10_proportion((acceptance_sum == 0) ? new BigDecimal(0) : new BigDecimal((total_score_9_10 / (acceptance_sum * 1.0))).setScale(2, RoundingMode.HALF_UP));

        newEmployeeReviewProportion.setOverdue_task(overdue_sum);
        newEmployeeReviewProportion.setOverdue_proportion((total == 0) ? new BigDecimal(0) : new BigDecimal((overdue_sum / (total * 1.0))).setScale(2, RoundingMode.HALF_UP));
        newEmployeeReviewProportion.setOverdue_employees(overdue_task_employeeS);

        newEmployeeReviewProportion.setProbation_new_employees(probation_new_employeeS);
        newEmployeeReviewProportion.setOne_week_employees(one_week_employeeS);
        newEmployeeReviewProportion.setTwo_week_employees(two_week_employeeS);
        newEmployeeReviewProportion.setTwo_week_to_one_month_employees(two_week_to_one_month_employeeS);
        newEmployeeReviewProportion.setOne_month_employees(one_to_two_month_employeeS);
        newEmployeeReviewProportion.setWill_entry_employees(will_entry_employeeS);
        newEmployeeReviewProportion.setOverdue_employees(overdue_task_employeeS);
        newEmployeeReviewProportion.setDepart_employees(depart_employeeS);
        newEmployeeReviewProportion.setTeaching_rating_6_employees(current_score_6_employeeS);
        newEmployeeReviewProportion.setTeaching_rating_7_8_employees(current_score_7_8_employeeS);
        newEmployeeReviewProportion.setTeaching_rating_9_10_employees(current_score_9_10_employeeS);
        newEmployeeReviewProportion.setTeaching_more_than_10_employees(current_score_10_employeeS);
        newEmployeeReviewProportion.setAcceptance_report_employees(acceptance_employeeS);
        newEmployeeReviewProportion.setFormal_employees_employees(formal_employeeS);
        newEmployeeReviewProportion.setNo_number_of_permanent_employees_employees(no_number_of_permanent_employeeS);
        newEmployeeReviewProportion.setTotal_teaching_rating_6_employees(total_score_6_employeeS);
        newEmployeeReviewProportion.setTotal_teaching_rating_7_8_employees(total_score_7_8_employeeS);
        newEmployeeReviewProportion.setTotal_teaching_rating_9_10_employees(total_score_9_10_employeeS);


        return newEmployeeReviewProportion;
    }

    private Boolean isPMOVP(String email) {
        List<NewEmployeesReviewDetail> PMODetails = new ArrayList<>();

        Employee getEmployee = employeeDAO.getBaseMapper().selectOne(
                new LambdaQueryWrapper<Employee>().eq(Employee::getEmail, email)
                        .eq(Employee::getTenantsid, LoginUserUtils.getTenantSid()));
        if (getEmployee != null) {
            if ("VP".equals(getEmployee.getJob_position()) || "PMO".equals(getEmployee.getJob_position())) {
                return true;
            }

        }
        return false;
    }

    private Boolean isPM(String email) {
        Long PMDetails = newEmployeesReviewDetailDAO.getBaseMapper().selectCount(
                new LambdaQueryWrapper<NewEmployeesReviewDetail>()
                        .eq(NewEmployeesReviewDetail::getTenantsid, LoginUserUtils.getTenantSid())
                        .eq(NewEmployeesReviewDetail::getManager_email, email));
        if (PMDetails != 0) {
            return true;
        }
        return false;
    }

    //获取超时未完成任务卡的员工
    private List<String> getOverdueTask(String existEmail) {
        List<String> list = Arrays.asList(existEmail.split(","));
        LocalDate month = LocalDate.now();
        LocalDate firstDay = month.withDayOfMonth(1);
        LocalDate localDate = month.withDayOfMonth(month.lengthOfMonth());
        //获取所有新人
        LambdaQueryWrapper<NewEmployeesReviewDetail> qw = new LambdaQueryWrapper<>();
        qw.eq(NewEmployeesReviewDetail::getTenantsid, LoginUserUtils.getTenantSid());
        qw.and(i -> i.eq(NewEmployeesReviewDetail::getEmployee_status, "probation")
                .or(a -> a.eq(NewEmployeesReviewDetail::getEmployee_status, "quit")
                        .ge(NewEmployeesReviewDetail::getConfirmation_date, firstDay)
                        .le(NewEmployeesReviewDetail::getConfirmation_date, localDate))
                .or(b -> b.eq(NewEmployeesReviewDetail::getEmployee_status, "beformal")
                        .ge(NewEmployeesReviewDetail::getConfirmation_date, firstDay)
                        .le(NewEmployeesReviewDetail::getConfirmation_date, localDate))
                .or(c -> c.eq(NewEmployeesReviewDetail::getEmployee_status, "return")
                        .ge(NewEmployeesReviewDetail::getConfirmation_date, firstDay)
                        .le(NewEmployeesReviewDetail::getConfirmation_date, localDate)));
        List<NewEmployeesReviewDetail> newEmployeesReviewDetails = newEmployeesReviewDetailDAO.getBaseMapper().selectList(qw);
        List<String> overTaskEmail = new ArrayList<>();
        for (NewEmployeesReviewDetail newEmployeesReviewDetail : newEmployeesReviewDetails) {
            String employmentDate = newEmployeesReviewDetail.getEmployment_date();
            LocalDate date = LocalDate.parse(employmentDate, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            long until = date.until(month, ChronoUnit.DAYS);
            Long aLong = -1L;//0逾期，1未逾期
            String goal = null;
            if (!newEmployeesReviewDetail.getEmployee_status().equals("quit")) {
                if (until > 1 && until < 7) {
                    aLong = probationaryPeriodGoalsDAO.getBaseMapper().selectCount(new LambdaQueryWrapper<ProbationaryPeriodGoals>()
                            .eq(ProbationaryPeriodGoals::getOwner_emp_email, newEmployeesReviewDetail.getOwner_emp_email())
                            .eq(ProbationaryPeriodGoals::getTenantsid, LoginUserUtils.getTenantSid()));

                } else if (until >= 10 && until < 14) {
                     goal = summaryOneWeekDAO.getBaseMapper().selectOne(new LambdaQueryWrapper<SummaryOneWeekDetails>()
                            .select(SummaryOneWeekDetails::getTrial_period_goal)
                            .eq(SummaryOneWeekDetails::getNew_employees_review_detail_id, newEmployeesReviewDetail.getNew_employees_review_detail_id())
                            .eq(SummaryOneWeekDetails::getTenantsid, LoginUserUtils.getTenantSid())).getTrial_period_goal();

                } else if (until > 17 && until < 30) {
                     goal = summaryTwoWeekDetailsDAO.getBaseMapper().selectOne(new LambdaQueryWrapper<SummaryTwoWeekDetails>()
                             .select(SummaryTwoWeekDetails::getTrial_period_goal)
                            .eq(SummaryTwoWeekDetails::getNew_employees_review_detail_id, newEmployeesReviewDetail.getNew_employees_review_detail_id())
                            .eq(SummaryTwoWeekDetails::getTenantsid, LoginUserUtils.getTenantSid())).getTrial_period_goal();

                } else if (until > 33 && until < 60) {
                    goal = summaryOneMonthDetailsDAO.getBaseMapper().selectOne(new LambdaQueryWrapper<SummaryOneMonthDetails>()
                            .select(SummaryOneMonthDetails::getTrial_period_goal)
                            .eq(SummaryOneMonthDetails::getNew_employees_review_detail_id, newEmployeesReviewDetail.getNew_employees_review_detail_id())
                            .eq(SummaryOneMonthDetails::getTenantsid, LoginUserUtils.getTenantSid())).getTrial_period_goal();
                } else if (until > 63 && until < 90) {
                    goal = summaryTwoMonthDetailsDAO.getBaseMapper().selectOne(new LambdaQueryWrapper<SummaryTwoMonthDetails>()
                            .select(SummaryTwoMonthDetails::getTrial_period_goal)
                            .eq(SummaryTwoMonthDetails::getNew_employees_review_detail_id, newEmployeesReviewDetail.getNew_employees_review_detail_id())
                            .eq(SummaryTwoMonthDetails::getTenantsid, LoginUserUtils.getTenantSid())).getTrial_period_goal();
                } else if (until >= 93 && until < 97) {
                    goal = summaryThreeMonthDetailsDAO.getBaseMapper().selectOne(new LambdaQueryWrapper<SummaryThreeMonthDetails>()
                            .select(SummaryThreeMonthDetails::getTrial_period_goal)
                            .eq(SummaryThreeMonthDetails::getNew_employees_review_detail_id, newEmployeesReviewDetail.getNew_employees_review_detail_id())
                            .eq(SummaryThreeMonthDetails::getTenantsid, LoginUserUtils.getTenantSid())).getTrial_period_goal();
                }
                if (("3").equals(newEmployeesReviewDetail.getProbationary_period_term() + "") && until >= 97) {
                    aLong = newEmployeesReviewMentorDAO.getBaseMapper().selectCount(new LambdaQueryWrapper<NewEmployeesReviewMentor>()
                            .eq(NewEmployeesReviewMentor::getNew_employees_review_detail_id, newEmployeesReviewDetail.getNew_employees_review_detail_id())
                            .isNotNull(NewEmployeesReviewMentor::getAcceptance_score)
                            .eq(NewEmployeesReviewMentor::getTenantsid, LoginUserUtils.getTenantSid()));
                }
                if (("6").equals(newEmployeesReviewDetail.getProbationary_period_term()) && until >= 187) {
                    aLong = newEmployeesReviewMentorDAO.getBaseMapper().selectCount(new LambdaQueryWrapper<NewEmployeesReviewMentor>()
                            .eq(NewEmployeesReviewMentor::getNew_employees_review_detail_id, newEmployeesReviewDetail.getNew_employees_review_detail_id())
                            .isNotNull(NewEmployeesReviewMentor::getAcceptance_score)
                            .eq(NewEmployeesReviewMentor::getTenantsid, LoginUserUtils.getTenantSid()));
                }
                if(!com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(goal)){
                    aLong = 1L;
                }
                if (aLong == 0) {
                    overTaskEmail.add(newEmployeesReviewDetail.getOwner_emp_email());
                }
            }

        }

        List<String> collect = Stream.of(list, overTaskEmail)
                .flatMap(Collection::stream)
                .filter(s ->!s.isEmpty())
                .distinct()
                .collect(Collectors.toList());

        return collect;

    }
}


