package com.digiwin.athena.dtdapp.service;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.athena.dtdapp.dao.st.*;
import com.digiwin.athena.dtdapp.dao.zentao.*;
import com.digiwin.athena.dtdapp.pojo.dto.st.ProjectDTO;
import com.digiwin.athena.dtdapp.pojo.dto.st.ProjectEmployeeRelationDTO;
import com.digiwin.athena.dtdapp.pojo.dto.st.SearchDTO;
import com.digiwin.athena.dtdapp.pojo.dto.st.WorkReportDetailDTO;
import com.digiwin.athena.dtdapp.pojo.entity.st.*;
import com.digiwin.athena.dtdapp.pojo.entity.zentao.*;
import com.digiwin.athena.dtdapp.pojo.vo.st.*;
import com.digiwin.athena.dtdapp.util.LoginUserUtils;
import com.digiwin.athena.esp.sdk.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;


import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service
@Slf4j
public class WorkReportService {

    @Autowired
    private EmployeeDAO employeeDAO;

    @Autowired
    private OrganizationDAO organizationDAO;


    @Autowired
    private ProjectDAO projectDAO;

    @Autowired
    private ProjectProductRelationDAO projectProductRelationDAO;

    @Autowired
    private WorkReportDetailDAO workReportDetailDAO;

    @Autowired
    private ProjectEmployeeRelationDAO projectEmployeeRelationDAO;

    @Autowired
    private ZtTaskDAO ztTaskDAO;

    @Autowired
    private ZtTypeAssociationsDAO ztTypeAssociationsDAO;

    @Autowired
    private WorkReportService workReportService;

    @Autowired
    private ZtProductDAO ztProductDAO;
    @Autowired
    private ZtProjectDAO ztProjectDAO;

    @Autowired
    private ZtEffortDAO ztEffortDAO;
    @Autowired
    private ZtUserDAO ztUserDAO;
    @Autowired
    private ZtProductplanDAO ztProductplanDAO;
    @Autowired
    private ZtStoryDAO ztStoryDAO;

    public Map queryEmployeeInfo(Map map) {
        log.info("queryEmployeeInfo:{}", map);
        JSONObject obj = JSON.parseObject(JSON.toJSONString(map));
        JSONArray jsonArray = obj.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("search_info");
        //获取分页数据
        Integer page = obj.getJSONObject("std_data").getJSONObject("parameter").getObject("page_no", Integer.class);
        Integer size = obj.getJSONObject("std_data").getJSONObject("parameter").getObject("page_size", Integer.class);
        Boolean use_has_next = obj.getJSONObject("std_data").getJSONObject("parameter").getObject("use_has_next", Boolean.class);
        List<EmployeeVO> result = new ArrayList<>();
        LambdaQueryWrapper<Employee> employeeLambdaQueryWrapper = new LambdaQueryWrapper<>();
        List<Employee> employees = new ArrayList<>();
        HashMap<String, Object> stringObjectMap = new HashMap<>();
        List<Employee> employees1 = employeeDAO.getBaseMapper().selectList(new LambdaQueryWrapper<Employee>().eq(Employee::getTenantsid, LoginUserUtils.getTenantSid()));
        Map<String, String> empMap = employees1.stream().collect(Collectors.toMap(s -> s.getEmployee_no(), s -> s.getEmployee_name()));

        if (jsonArray == null || jsonArray.size() == 0) {

            employees = this.employeeDAO.getBaseMapper().selectList(new QueryWrapper<Employee>()
                    .lambda().eq(Employee::getTenantsid, LoginUserUtils.getTenantSid()));
        } else {
            List<SearchDTO> searchDTOS = JSON.parseArray(JSON.toJSONString(jsonArray), SearchDTO.class);
            employeeLambdaQueryWrapper.eq(Employee::getTenantsid, LoginUserUtils.getTenantSid());
            String sql = "";
            sql = sql + "(";
            for (SearchDTO searchDTO : searchDTOS) {
                switch (searchDTO.getSearch_field()) {

                    case "org_name":
                        LambdaQueryWrapper<Organization> organizationLambdaQueryWrapper = new LambdaQueryWrapper<>();
                        organizationLambdaQueryWrapper.like(Organization::getOrg_name, searchDTO.getSearch_value().get(0))
                                .eq(Organization::getTenantsid, LoginUserUtils.getTenantSid());
                        List<Organization> organizations = organizationDAO.getBaseMapper().selectList(organizationLambdaQueryWrapper);
                        if (organizations == null || organizations.size() == 0) {
                            break;
                        }
                        ArrayList<String> objects = new ArrayList<>();
                        for (Organization organization : organizations) {
                            objects.add(organization.getOrg_no());
                        }
                        searchDTO.setSearch_operator("in");
                        searchDTO.setSearch_field("org_no");
                        searchDTO.setSearch_value(objects);
                        sql = sql + com.digiwin.athena.dtdapp.util.StringUtils.builderSQL(searchDTO, sql);
                        break;
                    default:
                        sql = sql + com.digiwin.athena.dtdapp.util.StringUtils.builderSQL(searchDTO, sql);
                        break;
                }
            }
            sql = sql + ")";
            employeeLambdaQueryWrapper.apply(sql);
            Page<Employee> pages = new Page<>(page, size);
            if (use_has_next != null && use_has_next) {
                Page<Employee> employeePage = employeeDAO.getBaseMapper().selectPage(pages, employeeLambdaQueryWrapper);
                employees = employeePage.getRecords();
                stringObjectMap.put("total_results", employeePage.getTotal());
                stringObjectMap.put("has_next", employeePage.hasNext());
            } else {
                employees = employeeDAO.getBaseMapper().selectList(employeeLambdaQueryWrapper);
            }
        }

        List<Employee> allEmp = employeeDAO.getBaseMapper().selectList(new LambdaQueryWrapper<Employee>()
                .eq(Employee::getTenantsid, LoginUserUtils.getTenantSid()));
        Map<String, Employee> employeeMap = allEmp.stream().collect(Collectors.toMap(Employee::getEmployee_no, Function.identity(), (a, b) -> a));


        if (CollectionUtils.isNotEmpty(employees)) {
            //补充组织信息
            List<Organization> organizations = this.organizationDAO.getBaseMapper().selectList(new LambdaQueryWrapper<Organization>().eq(Organization::getTenantsid, LoginUserUtils.getTenantSid()));
            Map<String, Organization> orgMap = organizations.stream().collect(Collectors.toMap(Organization::getOrg_no, Function.identity(), (a, b) -> a));
            employees.forEach(e -> {
                EmployeeVO employeeVO = new EmployeeVO();

                BeanUtils.copyProperties(e, employeeVO);
                if (StringUtil.isEmpty(employeeVO.getApproval_no())) {
                    employeeVO.setApproval_name("");
                    employeeVO.setApproval_no("");
                } else {
                    employeeVO.setApproval_no(e.getApproval_no());
                    employeeVO.setApproval_name(empMap.get(e.getApproval_no()));
                }
                Organization organization = orgMap.get(e.getOrg_no());
                if (organization != null) {
                    employeeVO.setOrg_name(organization.getOrg_name());
                    employeeVO.setOrg_supervisor_name(organization.getOrg_supervisor());

                    if (employeeMap.containsKey(organization.getOrg_supervisor_id())) {
                        employeeVO.setManage_no(organization.getOrg_supervisor_id());
                        employeeVO.setManage_name(organization.getOrg_supervisor());
                        employeeVO.setManage_email(employeeMap.get(organization.getOrg_supervisor_id()).getEmail());
                    }
                }
                result.add(employeeVO);
            });
        }

        stringObjectMap.put("employee_info", result);
        return stringObjectMap;
    }


    @Transactional
    public List updateEmployeeInfo(Map map) {
        log.info("queryEmployeeInfo:{}", map);
        JSONObject obj = JSON.parseObject(JSON.toJSONString(map));
        JSONArray jsonArray = obj.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("employee_info");
        if (jsonArray == null || jsonArray.size() == 0) {
            throw new DWRuntimeException("no data to update");
        }

        List<Employee> updateEmployees = JSON.parseArray(JSON.toJSONString(jsonArray), Employee.class);
        updateEmployees.forEach(e -> {
            this.employeeDAO.update(e, new UpdateWrapper<Employee>().lambda().eq(Employee::getEmployee_no, e.getEmployee_no())
                    .eq(Employee::getTenantsid, LoginUserUtils.getTenantSid()));
        });

        return updateEmployees;
    }

    public List queryOrgInfo(Map map) {
        log.info("queryEmployeeInfo:{}", map);
        JSONObject obj = JSON.parseObject(JSON.toJSONString(map));
        JSONArray jsonArray = obj.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("org_info");
        List<Organization> organizations = null;
        if (jsonArray == null || jsonArray.size() == 0) {

            organizations = this.organizationDAO.getBaseMapper().selectList(new QueryWrapper<Organization>().
                    lambda().eq(Organization::getTenantsid, LoginUserUtils.getTenantSid())
                    .eq(Organization::getStatus,'Y'));
        } else {
            List<Organization> query = JSON.parseArray(JSON.toJSONString(jsonArray), Organization.class);
            List<String> orgNos = query.stream().map(Organization::getOrg_no).collect(Collectors.toList());

            organizations = this.organizationDAO.getBaseMapper().selectList(
                    new QueryWrapper<Organization>().lambda().in(Organization::getOrg_no, orgNos)
                            .eq(Organization::getTenantsid, LoginUserUtils.getTenantSid())
                            .eq(Organization::getStatus,'Y'));
        }

        Map<String, Organization> orgMap = organizations.stream().collect(Collectors.toMap(Organization::getOrg_no, Function.identity(), (a, b) -> a));

        List<OrgVO> result = new ArrayList<>();
        organizations.forEach(e -> {
            OrgVO orgVO = new OrgVO();
            BeanUtils.copyProperties(e, orgVO);
            LinkedList<String> orgHierarchyList = new LinkedList<>();
            orgHierarchyList.push(e.getOrg_no());
            this.getOrgHierarchy(e.getSuper_org_no(), orgMap, orgHierarchyList);
            orgVO.setOrg_hierarchy(orgHierarchyList);
            result.add(orgVO);
        });

        return result;
    }


    private void getOrgHierarchy1(String superOrgNo, Map<String, Organization> orgMap, LinkedList<String> orgHierarchyList) {
        if (StringUtil.isEmpty(superOrgNo)) {
            return;
        } else {
            Organization organization = orgMap.get(superOrgNo);
            if (organization != null) {
                orgHierarchyList.push(superOrgNo);
                this.getOrgHierarchy(organization.getSuper_org_no(), orgMap, orgHierarchyList);
            } else {
                return;
            }
        }
    }

    private void getOrgHierarchy(String superOrgNo, Map<String, Organization> orgMap, LinkedList<String> orgHierarchyList) {
        if (StringUtil.isEmpty(superOrgNo)) {
            return;
        }

        Stack<String> orgStack = new Stack<>();
        orgStack.push(superOrgNo);

        while (!orgStack.isEmpty()) {
            String currentOrgNo = orgStack.pop();
            Organization organization = orgMap.get(currentOrgNo);

            if (organization != null) {
                orgHierarchyList.push(currentOrgNo);

                // 如果当前组织有上级组织，将其上级组织的编号推入栈中
                String parentOrgNo = organization.getSuper_org_no();
                if (StringUtil.isNotEmpty(superOrgNo) && !orgHierarchyList.contains(parentOrgNo)) {
                    orgStack.push(parentOrgNo);
                }
            }
        }
    }

    public Map<String, Object> queryProject(Map map) throws DWException {
        log.info("queryProjectInfo:{}", map);
        JSONObject jsonObject = JSON.parseObject(JSON.toJSONString(map));
        JSONArray jsonArray = jsonObject.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("search_info");
        JSONArray projectJsonArray = jsonObject.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("project_info");
        List<SearchDTO> searchDTOs = JSON.parseArray(JSON.toJSONString(jsonArray), SearchDTO.class);
        //获取分页数据
        Integer page = jsonObject.getJSONObject("std_data").getJSONObject("parameter").getObject("page_no", Integer.class);
        Integer size = jsonObject.getJSONObject("std_data").getJSONObject("parameter").getObject("page_size", Integer.class);
        Boolean use_has_next = jsonObject.getJSONObject("std_data").getJSONObject("parameter").getObject("use_has_next", Boolean.class);
        Page<Project> pages = new Page<>();
        Map<String, Object> stringObjectMap = new HashMap<>();
        List<Project> projectList = new ArrayList<>();
        List<ProjectVO> projectVOS = new ArrayList<>();
        if (jsonArray == null || jsonArray.size() == 0) {

            if (use_has_next != null && use_has_next) {
                pages = new Page<>(page, size);
                Page<Project> projectPage = null;
                if (projectJsonArray != null && projectJsonArray.size() != 0) {
                    List<Project> projects = JSON.parseArray(JSON.toJSONString(projectJsonArray), Project.class);
                    for (Project project : projects) {
                        projectPage = this.projectDAO.getBaseMapper().selectPage(pages, new LambdaQueryWrapper<Project>()
                                .eq(StringUtil.isNotEmpty(project.getProject_type()), Project::getProject_type, project.getProject_type())
                                .eq(StringUtil.isNotEmpty(project.getManage_status()), Project::getManage_status, project.getManage_status())
                                .eq(Project::getTenantsid, LoginUserUtils.getTenantSid()));
                    }
                } else {
                    projectPage = this.projectDAO.getBaseMapper().selectPage(pages, new LambdaQueryWrapper<Project>().eq(Project::getTenantsid, LoginUserUtils.getTenantSid()));
                }
                projectList = projectPage.getRecords();
                stringObjectMap.put("total_results", pages.getTotal());
                stringObjectMap.put("has_next", projectPage.hasNext());
            } else {
                projectList = this.projectDAO.getBaseMapper().selectList(new LambdaQueryWrapper<Project>().eq(Project::getTenantsid, LoginUserUtils.getTenantSid()));
            }
            if (projectList == null) {
                throw new DWException("table is not data");
            }
            for (Project project : projectList) {
                ProjectVO projectVO = new ProjectVO();
                BeanUtils.copyProperties(project, projectVO);

                if ("2".equals(project.getProject_type())) {
                    //通过项目产品表得到项目对应的id
                    LambdaQueryWrapper<ProjectProductRelation> wrapper = new LambdaQueryWrapper<>();
                    wrapper.eq(ProjectProductRelation::getProject_id, project.getProject_code());
                    wrapper.orderByDesc(ProjectProductRelation::getUpdate_time)
                            .eq(ProjectProductRelation::getTenantsid, LoginUserUtils.getTenantSid());
                    List<ProjectProductRelation> projectProductRelationList = projectProductRelationDAO.getBaseMapper().selectList(wrapper);
                    //根据项目对应的产品id，在项目表中找到产品
                    List<ProductVO> productList = new ArrayList<>();
                    for (ProjectProductRelation projectProductRelation : projectProductRelationList) {
                        Project product = projectDAO.getBaseMapper().selectOne(new LambdaQueryWrapper<Project>().eq(Project::getProject_code, projectProductRelation.getProduct_id())
                                .eq(Project::getTenantsid, LoginUserUtils.getTenantSid()));
                        if (Objects.nonNull(product)) {
                            ProductVO productVO = new ProductVO();
                            BeanUtils.copyProperties(product, productVO);
                            productList.add(productVO);
                        }
                    }
                    projectVO.setProduct(productList);

                }
                projectVOS.add(projectVO);

            }
        } else {
            LambdaQueryWrapper<Project> projectLambdaQueryWrapper = new LambdaQueryWrapper<>();
            projectLambdaQueryWrapper.eq(Project::getTenantsid, LoginUserUtils.getTenantSid());
            String sql = "";
            sql = sql + "(";
            for (SearchDTO searchDTO : searchDTOs) {
                switch (searchDTO.getSearch_field()) {
                    case "project_leader":
                        LambdaQueryWrapper<Employee> wrapper = new LambdaQueryWrapper<>();
                        wrapper.like(Employee::getEmployee_name, searchDTO.getSearch_value().get(0));
                        wrapper.eq(Employee::getTenantsid, LoginUserUtils.getTenantSid());
                        List<Employee> employees = employeeDAO.getBaseMapper().selectList(wrapper);
                        ArrayList<String> list = new ArrayList<>();
                        if (employees != null && employees.size() != 0) {
                            List<ProjectEmployeeRelation> projectEmployeeRelationS = new ArrayList<>();
                            for (Employee employee : employees) {
                                LambdaQueryWrapper<ProjectEmployeeRelation> relationLambdaQueryWrapper = new LambdaQueryWrapper<>();
                                relationLambdaQueryWrapper.eq(ProjectEmployeeRelation::getEmployee_no, employee.getEmployee_no())
                                        .eq(ProjectEmployeeRelation::getEmployee_role, "1")
                                        .eq(ProjectEmployeeRelation::getTenantsid, LoginUserUtils.getTenantSid());
                                List<ProjectEmployeeRelation> projectEmployeeRelations = projectEmployeeRelationDAO.getBaseMapper().selectList(relationLambdaQueryWrapper);
                                projectEmployeeRelationS.addAll(projectEmployeeRelations);
                            }
                            if (projectEmployeeRelationS != null && projectEmployeeRelationS.size() != 0) {

                                for (ProjectEmployeeRelation projectEmployeeRelation : projectEmployeeRelationS) {
                                    list.add(projectEmployeeRelation.getProject_id());
                                }
                                searchDTO.setSearch_field("project_code");
                                searchDTO.setSearch_operator("in");
                                searchDTO.setSearch_value(list);
                                sql = sql + com.digiwin.athena.dtdapp.util.StringUtils.builderSQL(searchDTO, sql);
                            } else {
                                searchDTO.setSearch_field("project_code");
                                list.add("000000");
                                searchDTO.setSearch_value(list);
                                sql = sql + com.digiwin.athena.dtdapp.util.StringUtils.builderSQL(searchDTO, sql);
                            }
                        } else {
                            searchDTO.setSearch_field("project_code");
                            list.add("000000");
                            searchDTO.setSearch_value(list);
                            sql = sql + com.digiwin.athena.dtdapp.util.StringUtils.builderSQL(searchDTO, sql);
                        }
                        break;
                    default:
                        sql = sql + com.digiwin.athena.dtdapp.util.StringUtils.builderSQL(searchDTO, sql);
                }

            }
            sql = sql + ")";
            projectLambdaQueryWrapper.apply(sql);
            if (use_has_next != null && use_has_next) {
                pages = new Page<>(page, size);
                Page<Project> projectPage = projectDAO.getBaseMapper().selectPage(pages, projectLambdaQueryWrapper);

                projectList = projectPage.getRecords();
                stringObjectMap.put("total_results", projectPage.getTotal());
                stringObjectMap.put("has_next", projectPage.hasNext());
            }
            for (Project project : projectList) {
                ProjectVO projectVO = new ProjectVO();
                BeanUtils.copyProperties(project, projectVO);
                projectVOS.add(projectVO);
            }
        }


        for (ProjectVO projectVO : projectVOS) {
            //获取所属产品
            if ("2".equals(projectVO.getProject_type())) {
                //通过项目产品表得到项目对应的id
                LambdaQueryWrapper<ProjectProductRelation> wrapper = new LambdaQueryWrapper<>();
                wrapper.eq(ProjectProductRelation::getProject_id, projectVO.getProject_code());
                wrapper.orderByDesc(ProjectProductRelation::getUpdate_time)
                        .eq(ProjectProductRelation::getTenantsid, LoginUserUtils.getTenantSid());
                List<ProjectProductRelation> projectProductRelationList = projectProductRelationDAO.getBaseMapper().selectList(wrapper);
                //根据项目对应的产品id，在项目表中找到产品
                List<ProductVO> productList = new ArrayList<>();
                for (ProjectProductRelation projectProductRelation : projectProductRelationList) {
                    Project product = projectDAO.getBaseMapper().selectOne(new LambdaQueryWrapper<Project>().eq(Project::getProject_code, projectProductRelation.getProduct_id())
                            .eq(Project::getTenantsid, LoginUserUtils.getTenantSid()));
                    if (Objects.nonNull(product)) {
                        ProductVO productVO = new ProductVO();
                        productVO.setProduct_name(product.getProject_name());
                        productVO.setProject_code(product.getProject_code());
                        productList.add(productVO);
                    }
                }
                projectVO.setProduct(productList);
            }
            //获取项目参与人
            projectVO.setProject_leader_id("");
            projectVO.setProject_leader("");
            LambdaQueryWrapper<ProjectEmployeeRelation> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(ProjectEmployeeRelation::getProject_id, projectVO.getProject_code())
                    .eq(ProjectEmployeeRelation::getTenantsid, LoginUserUtils.getTenantSid());
            List<ProjectEmployeeRelation> projectEmployeeRelationList
                    = projectEmployeeRelationDAO.getBaseMapper().selectList(queryWrapper);

            List<ProjectEmployeeRelationDTO> projectEmployeeRelationDTOList = new ArrayList<>();

            for (ProjectEmployeeRelation projectEmployeeRelation : projectEmployeeRelationList) {
                ProjectEmployeeRelationDTO projectEmployeeRelationDTO = new ProjectEmployeeRelationDTO();
                BeanUtils.copyProperties(projectEmployeeRelation, projectEmployeeRelationDTO);
                projectEmployeeRelationDTOList.add(projectEmployeeRelationDTO);
            }
            LambdaQueryWrapper<Employee> employeeLambdaQueryWrapper = null;
            ArrayList<ProjectEmployeeRelationDTO> projectEmployeeRelationDTOS = new ArrayList<>();

            for (ProjectEmployeeRelationDTO projectEmployeeRelationDTO : projectEmployeeRelationDTOList) {
                employeeLambdaQueryWrapper = new LambdaQueryWrapper<>();
                employeeLambdaQueryWrapper.eq(Employee::getEmployee_no, projectEmployeeRelationDTO.getEmployee_no())
                        .eq(Employee::getTenantsid, LoginUserUtils.getTenantSid());
                Employee employee = employeeDAO.getBaseMapper().selectOne(employeeLambdaQueryWrapper);
                if (employee != null) {
                    if ("1".equals(projectEmployeeRelationDTO.getEmployee_role())) {
                        projectVO.setProject_leader(employee.getEmployee_name());
                        projectVO.setProject_leader_id(employee.getEmployee_no());
                        continue;
                    }

                    projectEmployeeRelationDTO.setEmployee_name(employee.getEmployee_name());
                    projectEmployeeRelationDTOS.add(projectEmployeeRelationDTO);
                }
            }

            projectVO.setProject_participants(projectEmployeeRelationDTOS);
        }

        stringObjectMap.put("work_report_info", projectVOS);
        return stringObjectMap;
    }

    @Transactional(rollbackFor = Exception.class)
    public List updateProject(Map map) throws DWException {
        JSONObject jsonObject = JSON.parseObject(JSON.toJSONString(map));
        JSONArray jsonArray = jsonObject.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("project_info");
        if (jsonArray == null || jsonArray.size() == 0) {
            throw new DWException("no data to update");
        } else {
            List<ProjectDTO> projectDTOS = JSON.parseArray(JSON.toJSONString(jsonArray), ProjectDTO.class);
            for (ProjectDTO projectDTO : projectDTOS) {
                LambdaQueryWrapper<Project> queryWrapper = null;
                //获取项目信息
                queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(projectDTO.getProject_code() != null, Project::getProject_code, projectDTO.getProject_code())
                        .eq(Project::getTenantsid, LoginUserUtils.getTenantSid());
                if (projectDTO.getProject_code() == null) {
                    queryWrapper.eq(Project::getProject_name, projectDTO.getProject_name());
                }
                Project project = projectDAO.getBaseMapper().selectOne(queryWrapper);

                //1.判断更新的数据是专案型项目还是产品型项目
                if ("2".equals(projectDTO.getProject_type())) {
                    LambdaQueryWrapper<ProjectProductRelation> wapper = new LambdaQueryWrapper<>();
                    wapper.eq(ProjectProductRelation::getProject_id, project.getProject_code())
                            .eq(ProjectProductRelation::getTenantsid, LoginUserUtils.getTenantSid());
                    projectProductRelationDAO.remove(wapper);
                    if (projectDTO.getProduct() != null && projectDTO.getProduct().size() != 0) {
                        List<ProductVO> productList = projectDTO.getProduct();
                        for (ProductVO product : productList) {
                            ProjectProductRelation projectProductRelation = new ProjectProductRelation();
                            projectProductRelation.setProject_id(project.getProject_code());
                            projectProductRelation.setProduct_id(product.getProject_code());
                            projectProductRelationDAO.getBaseMapper().insert(projectProductRelation);
                        }
                    }


                } else if (("1").equals(projectDTO.getProject_type())) {
                    LambdaQueryWrapper<ProjectProductRelation> wapper = new LambdaQueryWrapper<>();
                    wapper.eq(ProjectProductRelation::getProject_id, project.getProject_code())
                            .eq(ProjectProductRelation::getTenantsid, LoginUserUtils.getTenantSid());
                    projectProductRelationDAO.remove(wapper);
                }
                //2.更新其他
                Project project1 = new Project();
                BeanUtils.copyProperties(projectDTO, project1);
                project1.setProject_code(project.getProject_code());
                projectDAO.getBaseMapper().updateById(project1);

                //3.人员更新 先删除后插入
                if (projectDTO.getProject_participants() != null) {
                    LambdaQueryWrapper<ProjectEmployeeRelation> relationLambdaQueryWrapper = new LambdaQueryWrapper<>();
                    relationLambdaQueryWrapper.eq(ProjectEmployeeRelation::getProject_id, project.getProject_code())
                            .eq(ProjectEmployeeRelation::getTenantsid, LoginUserUtils.getTenantSid());
                    projectEmployeeRelationDAO.remove(relationLambdaQueryWrapper);


                    List<ProjectEmployeeRelationDTO> projectParticipants = projectDTO.getProject_participants();
                    for (ProjectEmployeeRelationDTO projectEmployeeRelationDTO : projectParticipants) {
                        ProjectEmployeeRelation projectEmployeeRelation = new ProjectEmployeeRelation();
                        //防止将人员id当作id
                        projectEmployeeRelationDTO.setId(null);
                        BeanUtils.copyProperties(projectEmployeeRelationDTO, projectEmployeeRelation);
                        projectEmployeeRelation.setProject_id(project.getProject_code());
                        projectEmployeeRelation.setTenantsid(LoginUserUtils.getTenantSid());
                        projectEmployeeRelationDAO.getBaseMapper().insert(projectEmployeeRelation);
                    }
                }
                ProjectEmployeeRelation projectEmployeeRelation = new ProjectEmployeeRelation();
                projectEmployeeRelation.setEmployee_no(projectDTO.getProject_leader_id());
                projectEmployeeRelation.setEmployee_role("1");
                projectEmployeeRelation.setProject_id(project.getProject_code());
                projectEmployeeRelation.setTenantsid(LoginUserUtils.getTenantSid());
                projectEmployeeRelationDAO.getBaseMapper().insert(projectEmployeeRelation);
            }
        }
        List<ProjectDTO> projectDTOS = JSON.parseArray(JSON.toJSONString(jsonArray), ProjectDTO.class);
        List<Project> projects = new ArrayList<>();
        for (ProjectDTO projectDTO : projectDTOS) {
            List<Project> projectS = projectDAO.getBaseMapper().selectList(new QueryWrapper<Project>().lambda().eq(Project::getProject_name, projectDTO.getProject_code())
                    .eq(Project::getTenantsid, LoginUserUtils.getTenantSid()));
            projects.addAll(projectS);
        }
        return projects;
    }

    public List updateProjectStatus(Map map, String status) throws DWException {
        JSONObject jsonObject = JSON.parseObject(JSON.toJSONString(map));
        JSONArray jsonArray = jsonObject.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("project_info");
        List<Project> projects = new ArrayList<>();
        if (jsonArray == null || jsonArray.size() == 0) {
            throw new DWException("no data to update");
        } else {
            List<ProjectDTO> projectDTOS = JSON.parseArray(JSON.toJSONString(jsonArray), ProjectDTO.class);

            for (ProjectDTO projectDTO : projectDTOS) {
                LambdaQueryWrapper<Project> queryWrapper = null;
                //获取项目信息
                queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(projectDTO.getProject_code() != null, Project::getProject_code, projectDTO.getProject_code())
                        .eq(Project::getTenantsid, LoginUserUtils.getTenantSid());
                if (projectDTO.getProject_code() == null) {
                    queryWrapper.eq(Project::getProject_name, projectDTO.getProject_name());
                }
                Project project = new Project();
                project.setManage_status(status);
                queryWrapper.eq(Project::getTenantsid, LoginUserUtils.getTenantSid());
                projectDAO.getBaseMapper().update(project, queryWrapper);
                Project project1 = projectDAO.getBaseMapper().selectOne(queryWrapper);
                projects.add(project1);
            }
        }
        return projects;
    }

    @Transactional(rollbackFor = Exception.class)
    public List createProject(Map map) throws DWException {
        JSONObject jsonObject = JSON.parseObject(JSON.toJSONString(map));
        JSONArray jsonArray = jsonObject.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("project_info");
        if (jsonArray == null || jsonArray.size() == 0) {
            throw new DWException("no data to insert");
        } else {
            List<ProjectDTO> projectDTOs = JSON.parseArray(JSON.toJSONString(jsonArray), ProjectDTO.class);
            for (ProjectDTO projectDTO : projectDTOs) {
                Project project = new Project();
                BeanUtils.copyProperties(projectDTO, project);
                //状态默认未生效
                project.setManage_status("N");
                projectDAO.getBaseMapper().insert(project);
                project.setProject_code(project.getId().toString());
                projectDAO.getBaseMapper().updateById(project);
                if ("1".equals(projectDTO.getProject_type()) && projectDTO.getProject() != null && projectDTO.getProject().getProject_code() != null) {
                    Project project1 = projectDTO.getProject();
                    ProjectProductRelation projectProductRelation = new ProjectProductRelation();
                    projectProductRelation.setProject_id(project1.getProject_code());
                    projectProductRelation.setProduct_id(project.getProject_code());
                    projectProductRelation.setTenantsid(LoginUserUtils.getTenantSid());
                    projectProductRelationDAO.getBaseMapper().insert(projectProductRelation);
                }
                //插入人员
                List<ProjectEmployeeRelationDTO> projectParticipants = projectDTO.getProject_participants();
                for (ProjectEmployeeRelationDTO projectEmployeeRelationDTO : projectParticipants) {
                    ProjectEmployeeRelation projectEmployeeRelation = new ProjectEmployeeRelation();
                    //防止将人员id当作id
                    projectEmployeeRelationDTO.setId(null);
                    BeanUtils.copyProperties(projectEmployeeRelationDTO, projectEmployeeRelation);
                    projectEmployeeRelation.setProject_id(project.getProject_code());
                    projectEmployeeRelation.setTenantsid(LoginUserUtils.getTenantSid());
                    projectEmployeeRelationDAO.getBaseMapper().insert(projectEmployeeRelation);
                }
                ProjectEmployeeRelation projectEmployeeRelation = new ProjectEmployeeRelation();
                projectEmployeeRelation.setEmployee_no(projectDTO.getProject_leader_id());
                projectEmployeeRelation.setEmployee_role("1");
                projectEmployeeRelation.setProject_id(project.getProject_code());
                projectEmployeeRelation.setTenantsid(LoginUserUtils.getTenantSid());
                projectEmployeeRelationDAO.getBaseMapper().insert(projectEmployeeRelation);
            }
        }
        List<ProjectDTO> projectDTOS = JSON.parseArray(JSON.toJSONString(jsonArray), ProjectDTO.class);
        List<Project> projects = new ArrayList<>();
        for (ProjectDTO projectDTO : projectDTOS) {
            List<Project> projectS = projectDAO.getBaseMapper().selectList(new QueryWrapper<Project>().lambda().eq(Project::getProject_name, projectDTO.getProject_name())
                    .eq(Project::getTenantsid, LoginUserUtils.getTenantSid()));
            projects.addAll(projectS);
        }
        return projects;
    }


    public List<WorkReportDetailVO> queryWorkReportInfo(Map map) throws DWException {
        JSONObject jsonObject = JSON.parseObject(JSON.toJSONString(map));
        JSONArray jsonArray = jsonObject.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("work_report_info");
        List<WorkReportDetailDTO> workReportDetailDTOs = JSON.parseArray(JSON.toJSONString(jsonArray), WorkReportDetailDTO.class);
        //获取分页数据
        Integer page = jsonObject.getJSONObject("std_data").getJSONObject("parameter").getObject("page_no", Integer.class);
        Integer size = jsonObject.getJSONObject("std_data").getJSONObject("parameter").getObject("page_size", Integer.class);
        Boolean use_has_next = jsonObject.getJSONObject("std_data").getJSONObject("parameter").getObject("use_has_next", Boolean.class);
        Page<WorkReportDetail> pages = new Page<>();
        Map<String, Object> stringObjectMap = new HashMap<>();

        List<String> dateList = new ArrayList<>();
        List<WorkReportDetail> workReportDetailList = null;
        List<WorkReportDetailVO> workReportDetailVOList = new ArrayList<>();

        List<Project> projectList = projectDAO.getBaseMapper().selectList(new LambdaQueryWrapper<Project>().eq(Project::getTenantsid, LoginUserUtils.getTenantSid()));
        Map<String, Project> projectMap = projectList.stream().collect(Collectors.toMap(a -> a.getProject_code(), b -> b));
        for (WorkReportDetailDTO workReportDetailDTO : workReportDetailDTOs) {
            log.info("id={}",LoginUserUtils.getTenantSid());
            LambdaQueryWrapper<Employee> employeeLambdaQueryWrapper = new LambdaQueryWrapper<>();
            employeeLambdaQueryWrapper.eq(Employee::getEmail, workReportDetailDTO.getEmail())
                    .eq(Employee::getTenantsid, LoginUserUtils.getTenantSid());

            Employee employee = employeeDAO.getBaseMapper().selectOne(employeeLambdaQueryWrapper);
            LambdaQueryWrapper<WorkReportDetail> queryWrapper = new LambdaQueryWrapper<>();
            //查自己
            queryWrapper.eq(WorkReportDetail::getEmployee_no, employee.getEmployee_no())
                    .eq(WorkReportDetail::getTenantsid, LoginUserUtils.getTenantSid());
            //报工日期
            queryWrapper.in(workReportDetailDTO.getReport_date_list() != null, WorkReportDetail::getReport_date, workReportDetailDTO.getReport_date_list());
            //内容
            queryWrapper.like(StringUtil.isNotEmpty(workReportDetailDTO.getWork_content()), WorkReportDetail::getWork_content, workReportDetailDTO.getWork_content());
            //报工类型
            queryWrapper.eq(StringUtil.isNotEmpty(workReportDetailDTO.getReport_type()), WorkReportDetail::getReport_type, workReportDetailDTO.getReport_type());
            //报工来源
            queryWrapper.eq(StringUtil.isNotEmpty(workReportDetailDTO.getReport_source()), WorkReportDetail::getReport_source, workReportDetailDTO.getReport_source());
            //获取待处理时，先判断是否有报工信息，把有报工信息的时间的，剩下的时间就是没有报工信息的时间，需要从禅道中获取
            List<WorkReportDetail> workReportDetails = workReportDetailDAO.getBaseMapper().selectList(queryWrapper);
            for (WorkReportDetail workReportDetail : workReportDetails) {
                SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
                String format = sf.format(workReportDetail.getReport_date());
                dateList.add(format);
            }
            //状态
            if (StringUtil.isNotEmpty(workReportDetailDTO.getStatus())) {
                queryWrapper.eq(StringUtil.isNotEmpty(workReportDetailDTO.getStatus()), WorkReportDetail::getStatus, workReportDetailDTO.getStatus());
            } else if (workReportDetailDTO.getSeq() == null) {
                workReportDetailDTO.setStatus("3");
                queryWrapper.eq(WorkReportDetail::getStatus, "3");
            }
            queryWrapper.eq(workReportDetailDTO.getSeq() != null, WorkReportDetail::getSeq, workReportDetailDTO.getSeq());
            queryWrapper.eq(WorkReportDetail::getTenantsid, LoginUserUtils.getTenantSid());
            //workReportDetailList其实可以不用再次查数据库，通过workReportDetails做过滤获取，代码要考虑劲量减少数据库的查询次数
            workReportDetailList = workReportDetailDAO.getBaseMapper().selectList(queryWrapper);
            WorkReportDetailVO workReportDetailVO = null;

            for (WorkReportDetail reportDetail : workReportDetailList) {
                workReportDetailVO = new WorkReportDetailVO();
                BeanUtils.copyProperties(reportDetail, workReportDetailVO);
                workReportDetailVO.setReport_frequency(employee.getReport_frequency());
                workReportDetailVO.setEmail(employee.getEmail());
                workReportDetailVO.setFrom_zentao(false);
                if (!StringUtils.isEmpty(reportDetail.getBelong_project()) && projectMap.containsKey(reportDetail.getBelong_project())) {
                    workReportDetailVO.setBelong_project(reportDetail.getBelong_project());
                    workReportDetailVO.setBelong_project_name(projectMap.get(reportDetail.getBelong_project()).getProject_name());

                } else {
                    workReportDetailVO.setBelong_project_name("");
                    workReportDetailVO.setBelong_project("");
                }
                workReportDetailVOList.add(workReportDetailVO);
                SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
                String format = sf.format(reportDetail.getReport_date());
                dateList.add(format);
            }
            //将再报工中查到的时间移除
            if (workReportDetailDTO.getReport_date_list() != null) {
                workReportDetailDTO.getReport_date_list().removeAll(dateList);
            }

            //workReportDetails == null || workReportDetails.size() == 0 这个条件还需不需要？ 上面remove的是workReportDetailDTO里的数据并不是workReportDetails
            //CollectionUtils.isNotEmpty()
            if (
                    CollectionUtils.isNotEmpty(workReportDetailDTO.getReport_date_list())
                            && com.digiwin.athena.dtdapp.util.StringUtils.isNotEmpty(workReportDetailDTO.getStatus()) && workReportDetailDTO.getStatus().equals("3")) {

                //获取禅道account

                ZtUser ztuser = ztUserDAO.getBaseMapper().selectOne(new LambdaQueryWrapper<ZtUser>().eq(ZtUser::getEmail, employee.getEmail())
                        .eq(ZtUser::getDeleted, "0"));
                if (ztuser == null) {
                    log.error("email={}", employee.getEmail());
                    continue;
                }
                LambdaQueryWrapper<ZtEffort> ztEffortqueryWrapper = new LambdaQueryWrapper<>();
                ztEffortqueryWrapper.eq(ZtEffort::getAccount, ztuser.getAccount());
                ztEffortqueryWrapper.in(workReportDetailDTO.getReport_date_list() != null, ZtEffort::getDate, workReportDetailDTO.getReport_date_list());
                ztEffortqueryWrapper.eq(ZtEffort::getDeleted, "0");
                List<ZtEffort> ztEfforts = ztEffortDAO.getBaseMapper().selectList(ztEffortqueryWrapper);

                for (ZtEffort ztEffort : ztEfforts) {
                    workReportDetailVO = new WorkReportDetailVO();
                    if ("task".equals(ztEffort.getObjectType())) {
                        ZtTask ztTask = ztTaskDAO.getBaseMapper().selectOne(
                                new QueryWrapper<ZtTask>().lambda().eq(ZtTask::getId, ztEffort.getObjectID()));
                        workReportDetailVO.setPlan_hour(new BigDecimal(Float.toString(ztTask.getEstimate())).setScale(2, BigDecimal.ROUND_DOWN));
                        if (ztTask != null && ztTask.getType().length() >= 4 && "spec".equals(ztTask.getType().substring(0, 4))) {
                            ztTask.setType("specification");
                        }
                        if (ztTask != null && ztTask.getType().length() >= 4 && "cult".equals(ztTask.getType().substring(0, 4))) {
                            ztTask.setType("cultivate");
                        }
                        ZtTypeAssociations ztTypeAssociations = getZtTypeAssociationsByZtTaskType(ztTask.getType());
                        if(ztTypeAssociations == null){
                            log.info("=====not found ztTypeAssociations===>" + ztTask.getType());
                            workReportDetailVO.setReport_type("13"); // 没有找到类型，默认为其他
                        }else{
                            workReportDetailVO.setReport_type(ztTypeAssociations.getType_no());
                        }



                        workReportDetailVO.setReport_source("PROJECT");
                        if (ztTask != null && ztTask.getProject() != 0) {
                            workReportDetailVO.setBelong_project("zt_project_" + ztTask.getProject());
                            if (projectMap.containsKey("zt_project_" + ztTask.getProject())) {
                                workReportDetailVO.setBelong_project_name(projectMap.get("zt_project_" + ztTask.getProject()).getProject_name());
                            }
                        } else {
                            workReportDetailVO.setBelong_project_name("");
                            workReportDetailVO.setBelong_project("");
                        }
                    } else if ("story".equals(ztEffort.getObjectType())) {
                        ZtStory ztStory = ztStoryDAO.getBaseMapper().selectOne(
                                new QueryWrapper<ZtStory>().lambda().eq(ZtStory::getId, ztEffort.getObjectID()));
                        workReportDetailVO.setReport_source("PROJECT");
                        workReportDetailVO.setReport_type("16");//设置为事务
                        if (ztStory != null && ztStory.getProduct() != 0) {
                            workReportDetailVO.setBelong_project("zt_product_" + ztStory.getProduct());
                            if (projectMap.containsKey("zt_product_" + ztStory.getProduct())) {
                                workReportDetailVO.setBelong_project_name(projectMap.get("zt_product_" + ztStory.getProduct()).getProject_name());
                            }
                        } else {
                            workReportDetailVO.setBelong_project_name("");
                            workReportDetailVO.setBelong_project("");
                        }
                    } else if ("productplan".equals(ztEffort.getObjectType())) {
                        ZtProductplan ztProductplan = ztProductplanDAO.getBaseMapper().selectOne(
                                new QueryWrapper<ZtProductplan>().lambda().eq(ZtProductplan::getId, ztEffort.getObjectID()));
                        workReportDetailVO.setReport_source("PROJECT");
                        workReportDetailVO.setReport_type("16");//设置为事务
                        if (ztProductplan != null && ztProductplan.getProduct() != 0) {
                            workReportDetailVO.setBelong_project("zt_product_" + ztProductplan.getProduct());
                            if (projectMap.containsKey("zt_product_" + ztProductplan.getProduct())) {
                                workReportDetailVO.setBelong_project_name(projectMap.get("zt_product_" + ztProductplan.getProduct()).getProject_name());
                            }
                        } else {
                            workReportDetailVO.setBelong_project_name("");
                            workReportDetailVO.setBelong_project("");
                        }
                    } else if ("custom".equals(ztEffort.getObjectType())) {
                        workReportDetailVO.setReport_source("OTHER");
                        workReportDetailVO.setReport_type("16");//设置为事务
                    } else if ("bug".equals(ztEffort.getObjectType())) {
                        workReportDetailVO.setReport_source("PROJECT");
                        workReportDetailVO.setReport_type("7");//设置为bug处理
                        if (ztEffort.getProject() != null && ztEffort.getProject() != 0) {
                            workReportDetailVO.setBelong_project("zt_project_" + ztEffort.getProject());
                            if (projectMap.containsKey("zt_project_" + ztEffort.getProject())) {
                                workReportDetailVO.setBelong_project_name(projectMap.get("zt_project_" + ztEffort.getProject()).getProject_name());
                            }
                        } else {
                            workReportDetailVO.setBelong_project_name("");
                            workReportDetailVO.setBelong_project("");
                        }

                    } else if ("feedback".equals(ztEffort.getObjectType())) {
                        workReportDetailVO.setReport_type("18");//设置为技术支持
                        workReportDetailVO.setReport_source("PROJECT");
                        if (ztEffort.getProject() != null && ztEffort.getProject() != 0) {
                            workReportDetailVO.setBelong_project("zt_project_" + ztEffort.getProject());
                            if (projectMap.containsKey("zt_project_" + ztEffort.getProject())) {
                                workReportDetailVO.setBelong_project_name(projectMap.get("zt_project_" + ztEffort.getProject()).getProject_name());
                            }
                        } else if (StringUtils.isNotEmpty(ztEffort.getProduct()) && !",,".equals(ztEffort.getProduct())) {
                            workReportDetailVO.setBelong_project("zt_product_" + ztEffort.getProduct().split(",")[ztEffort.getProduct().split(",").length - 1]);
                            if (projectMap.containsKey("zt_product_" + ztEffort.getProduct().split(",")[ztEffort.getProduct().split(",").length - 1])) {
                                String projectName = projectMap.get("zt_product_" + ztEffort.getProduct().split(",")[ztEffort.getProduct().split(",").length - 1]).getProject_name();
                                workReportDetailVO.setBelong_project_name(projectName);
                            }
                        } else {
                            workReportDetailVO.setBelong_project_name("");
                            workReportDetailVO.setBelong_project("");
                        }
                    }


                    workReportDetailVO.setZentao_effort_id(ztEffort.getId().toString());
                    workReportDetailVO.setEmployee_no(employee.getEmployee_no());
                    workReportDetailVO.setEmail(employee.getEmail());
                    workReportDetailVO.setReport_date(ztEffort.getDate());
                    workReportDetailVO.setReport_frequency(employee.getReport_frequency());
                    workReportDetailVO.setFrom_zentao(true);
                    workReportDetailVO.setActual_hour(new BigDecimal(Float.toString(ztEffort.getConsumed())).setScale(2, BigDecimal.ROUND_DOWN));
                    workReportDetailVO.setUnfinished_hour(new BigDecimal(Float.toString(ztEffort.getLeft())).setScale(2, BigDecimal.ROUND_DOWN));

                    workReportDetailVO.setWork_content(ztEffort.getWork());


                    workReportDetailVO.setStatus("3");
                    SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
                    String format = sf.format(workReportDetailVO.getReport_date());
                    dateList.add(format);
                    if (workReportDetailDTO.getReport_date_list() != null) {
                        workReportDetailDTO.getReport_date_list().removeAll(dateList);
                    }
                    workReportDetailVOList.add(workReportDetailVO);
                }


            }

        }
        for (WorkReportDetailDTO workReportDetailDTO : workReportDetailDTOs) {
            log.info("id={}",LoginUserUtils.getTenantSid());
            LambdaQueryWrapper<Employee> employeeLambdaQueryWrapper = new LambdaQueryWrapper<>();
            employeeLambdaQueryWrapper.eq(Employee::getEmail, workReportDetailDTO.getEmail())
                    .eq(Employee::getTenantsid, LoginUserUtils.getTenantSid());

            Employee employee = employeeDAO.getBaseMapper().selectOne(employeeLambdaQueryWrapper);
            List<String> reportDateList = workReportDetailDTO.getReport_date_list();
            for (String date : reportDateList) {
                LambdaQueryWrapper<WorkReportDetail> allqw = new LambdaQueryWrapper<>();
                allqw.eq(workReportDetailDTO.getReport_date_list() != null, WorkReportDetail::getReport_date, date);
                allqw.eq(WorkReportDetail::getEmployee_no, employee.getEmployee_no())
                        .eq(WorkReportDetail::getTenantsid, LoginUserUtils.getTenantSid());
                List<WorkReportDetail> workReportDetails = workReportDetailDAO.getBaseMapper().selectList(allqw);
                if ("3".equals(workReportDetailDTO.getStatus()) && (workReportDetails == null || workReportDetails.size() == 0)) {
                    if (!CollectionUtils.isNotEmpty(workReportDetails)) { //此处的if判断是否和上面if的后半段重复了，此处多余
                        WorkReportDetailVO workReportDetailVO = new WorkReportDetailVO();
                        BeanUtils.copyProperties(workReportDetailDTO, workReportDetailVO);
                        SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd");
                        try {
                            java.util.Date parse = ft.parse(date);
                            workReportDetailVO.setReport_date(parse);
                        } catch (Exception e) {
                            log.info("日期转换错误");
                        }
                        com.digiwin.athena.dtdapp.util.StringUtils.noNullStringAttr(workReportDetailVO);
                        workReportDetailVOList.add(workReportDetailVO);
                    }
//                    if ("0".equals(workReportDetailDTO.getStatus()) && (workReportDetails == null || workReportDetails.size() == 0)) {
//                        workReportDetailVOList.add(null);
//                    }
                }

            }
        }

        if (use_has_next == null || (!use_has_next && workReportDetailVOList != null && !workReportDetailVOList.isEmpty())) {
            return workReportDetailVOList;
        }
        int startIndex = (page - 1) * size;
        int endIndex = Math.min(startIndex + size, workReportDetailVOList.size());
        List<WorkReportDetailVO> pagelist = workReportDetailVOList.subList(startIndex, endIndex);

        return pagelist;

    }

    //根据邮箱获取用户
    private Employee getEmployeeByEmail(String email) {
        Long tenantSid = LoginUserUtils.getTenantSid();
        log.info("id={}", tenantSid);
        LambdaQueryWrapper<Employee> employeeLambdaQueryWrapper = new LambdaQueryWrapper<>();
        employeeLambdaQueryWrapper.eq(Employee::getEmail, email)
                .eq(Employee::getTenantsid, LoginUserUtils.getTenantSid())
                .eq(Employee::getStatus, "Y");

        return employeeDAO.getBaseMapper().selectOne(employeeLambdaQueryWrapper);
    }

    private ZtTypeAssociations getZtTypeAssociationsByZtTaskType(String type) {
        LambdaQueryWrapper<ZtTypeAssociations> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(ZtTypeAssociations::getZt_report_type, type);
        return ztTypeAssociationsDAO.getBaseMapper().selectOne(lambdaQueryWrapper);
    }

    @Transactional
    public List CreateOrUpdateWorkReportInfo(Map map, String status) throws DWException, ParseException {
        JSONObject jsonObject = JSON.parseObject(JSON.toJSONString(map));
        JSONArray jsonArray = jsonObject.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("work_report_info");
        List<WorkReportDetailVO> workReportDetailS = new ArrayList<>();
        WorkReportDetail getWorkReportDetail = new WorkReportDetail();
        if (jsonArray == null || jsonArray.size() == 0) {
            throw new DWException("no data to create or update");
        } else {
            List<WorkReportDetailDTO> workReportDetailDTOs = JSON.parseArray(JSON.toJSONString(jsonArray), WorkReportDetailDTO.class);

            List<Project> projects = projectDAO.getBaseMapper().selectList(new LambdaQueryWrapper<Project>().eq(Project::getTenantsid, LoginUserUtils.getTenantSid()));
            Map<String, Project> projectHashMap = projects.stream().collect(Collectors.toMap(project -> project.getProject_code(), project -> project));

            for (WorkReportDetailDTO workReportDetail : workReportDetailDTOs) {
                LambdaQueryWrapper<Employee> employeeQueryWrapper = new LambdaQueryWrapper<>();
                employeeQueryWrapper.eq(StringUtil.isNotEmpty(workReportDetail.getEmail()), Employee::getEmail, workReportDetail.getEmail())
                        .eq(Employee::getTenantsid, LoginUserUtils.getTenantSid());
                Employee employee = employeeDAO.getBaseMapper().selectOne(employeeQueryWrapper);

                LambdaQueryWrapper<WorkReportDetail> queryWrapper = new LambdaQueryWrapper<>();
                queryWrapper.eq(WorkReportDetail::getEmployee_no, employee.getEmployee_no())
                        .eq(WorkReportDetail::getSeq, workReportDetail.getSeq())   //这边其实可以不用seq，页面传到后端的数组里每条数据都有个uuid字段
                        .eq(WorkReportDetail::getTenantsid, LoginUserUtils.getTenantSid());
                getWorkReportDetail = workReportDetailDAO.getBaseMapper().selectOne(queryWrapper);


                workReportDetail.setEmployee_no(employee.getEmployee_no());
                WorkReportDetail workReportDetail1 = new WorkReportDetail();
                workReportDetail1.setZentao_effort_id(workReportDetail.getZentao_effort_id());
                BeanUtils.copyProperties(workReportDetail, workReportDetail1);
                workReportDetail1.setTenantsid(LoginUserUtils.getTenantSid());
                //从禅道来的数据日期格式为List需要转换
                if (workReportDetail.getReport_date() == null) {
                    SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd");
                    Date parse = ft.parse(workReportDetail.getReport_date_list().get(0));
                    workReportDetail1.setReport_date(parse);
                }
                workReportDetail1.setStatus(status);
                if (getWorkReportDetail == null) {  //数据库没有，会新增一条记录？？
                    workReportDetailDAO.getBaseMapper().insert(workReportDetail1);
                    workReportDetail1.setSeq(workReportDetail1.getId().intValue());
                    workReportDetailDAO.getBaseMapper().updateById(workReportDetail1);
                    getWorkReportDetail = workReportDetailDAO.getById(workReportDetail1.getId());
                } else {
                    workReportDetailDAO.getBaseMapper().update(workReportDetail1, queryWrapper);
                    getWorkReportDetail = workReportDetailDAO.getBaseMapper().selectOne(queryWrapper);
                }
                WorkReportDetailVO workReportDetailVO = new WorkReportDetailVO();
                BeanUtils.copyProperties(getWorkReportDetail, workReportDetailVO);

                if (projectHashMap.containsKey(getWorkReportDetail.getBelong_project())) {
                    Project project = projectHashMap.get(workReportDetailVO.getBelong_project());
                    workReportDetailVO.setBelong_project_name(project.getProject_name());
                    workReportDetailVO.setBelong_project(com.digiwin.athena.dtdapp.util.StringUtils.isNotEmpty(workReportDetail.getBelong_project()) ? workReportDetail.getBelong_project() : "");
                } else {
                    workReportDetailVO.setBelong_project_name("");
                    workReportDetailVO.setBelong_project("");
                }
                workReportDetailS.add(workReportDetailVO);
            }
        }

        return workReportDetailS;

    }


    public List deleteWorkReportInfo(Map map) throws DWException {
        JSONObject jsonObject = JSON.parseObject(JSON.toJSONString(map));
        JSONArray jsonArray = jsonObject.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("work_report_info");
        if (jsonArray == null || jsonArray.size() == 0) {
            throw new DWException("data is empty");
        }
        List<WorkReportDetail> workReportDetails = JSON.parseArray(JSON.toJSONString(jsonArray), WorkReportDetail.class);
        workReportDetails.stream().forEach(workReportDetail -> {
            workReportDetailDAO.getBaseMapper().delete(new LambdaQueryWrapper<WorkReportDetail>().eq(WorkReportDetail::getSeq, workReportDetail.getSeq()));
        });
        return null;
    }

    public List<WorkReportDetailVO> auditWorkReportInfo(Map map) throws DWException {
        JSONObject jsonObject = JSON.parseObject(JSON.toJSONString(map));
        JSONArray jsonArray = jsonObject.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("work_report_infos");

        ArrayList<WorkReportDetailVO> returnWorkReportDetail = new ArrayList<>();
        if (jsonArray == null || jsonArray.size() == 0) {
            throw new DWException("data is empty");
        }

        List<Project> projects = projectDAO.getBaseMapper().selectList(new LambdaQueryWrapper<Project>().eq(Project::getTenantsid, LoginUserUtils.getTenantSid()));
        Map<String, Project> projectHashMap = projects.stream().collect(Collectors.toMap(project -> project.getProject_code(), project -> project));

        List<AuditWorkReportVO> auditWorkReportVOS = JSON.parseArray(JSON.toJSONString(jsonArray), AuditWorkReportVO.class);

        for (AuditWorkReportVO auditWorkReportVO : auditWorkReportVOS) {
            ArrayList<Long> ids = new ArrayList<>();
            ArrayList<WorkReportDetail> updateWorkReportDetails = new ArrayList<>();
            for (WorkReportDetailVO workReportDetailVO : auditWorkReportVO.getWork_report_info()) {
                LambdaQueryWrapper<WorkReportDetail> queryWrapper = new LambdaQueryWrapper<>();
                queryWrapper.eq(WorkReportDetail::getSeq, workReportDetailVO.getSeq())
                        .eq(WorkReportDetail::getTenantsid, LoginUserUtils.getTenantSid());
                WorkReportDetail updateWorkReport = new WorkReportDetail();
                updateWorkReport.setId(workReportDetailVO.getId());
                ids.add(workReportDetailVO.getId());
                updateWorkReport.setAudit_opinion(workReportDetailVO.getAudit_opinion());
                updateWorkReport.setStatus(workReportDetailVO.getStatus());
                if ("2".equals(workReportDetailVO.getStatus())) {
                    updateWorkReport.setTask_id("");
                }
                updateWorkReportDetails.add(updateWorkReport);
            }
            workReportDetailDAO.updateBatchById(updateWorkReportDetails);
            List<WorkReportDetail> returnWorkReportDetails = new ArrayList<>();
            if(!CollectionUtils.isEmpty(ids)){
                returnWorkReportDetails = workReportDetailDAO.getBaseMapper().
                        selectList(new LambdaQueryWrapper<WorkReportDetail>().in(WorkReportDetail::getId, ids));
            }
            for (WorkReportDetail workReportDetail : returnWorkReportDetails) {

                LambdaQueryWrapper<Employee> lambdaQueryWrapper = new LambdaQueryWrapper<>();
                lambdaQueryWrapper.eq(Employee::getEmployee_no, workReportDetail.getEmployee_no())
                        .eq(Employee::getTenantsid, LoginUserUtils.getTenantSid());
                Employee employee = employeeDAO.getBaseMapper().selectOne(lambdaQueryWrapper);
                WorkReportDetailVO workReportDetailVO1 = new WorkReportDetailVO();
                BeanUtils.copyProperties(workReportDetail, workReportDetailVO1);

                if (projectHashMap.containsKey(workReportDetail.getBelong_project())) {
                    Project project = projectHashMap.get(workReportDetailVO1.getBelong_project());
                    workReportDetailVO1.setBelong_project_name(project.getProject_name());
                    workReportDetailVO1.setBelong_project(!StringUtils.isEmpty(workReportDetail.getBelong_project()) ? workReportDetailVO1.getBelong_project() : "");
                } else {
                    workReportDetailVO1.setBelong_project_name("");
                    workReportDetailVO1.setBelong_project("");
                }
                workReportDetailVO1.setEmail(employee.getEmail());
                returnWorkReportDetail.add(workReportDetailVO1);
            }
        }


        return returnWorkReportDetail;
}


    public List queryNeedAuditWorkReportInfo(Map map) throws Exception {
        JSONObject jsonObject = JSON.parseObject(JSON.toJSONString(map));
        JSONArray jsonArray = jsonObject.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("work_report_infos");
        List<WorkReportDetailDTO> workReportDetailDTOs = JSON.parseArray(JSON.toJSONString(jsonArray), WorkReportDetailDTO.class);
        return needAuditWorkReportInfo(workReportDetailDTOs);
    }

    private List needAuditWorkReportInfo(List<WorkReportDetailDTO> workReportDetailDTOs) throws DWException, ParseException {
        ArrayList<WorkReportDetailVO> returnWorkReportDetailVOs = new ArrayList<>();
        ArrayList<WorkReportDetail> returnWorkReportDetails = new ArrayList<>();
        List<AuditWorkReportVO> auditWorkReportVOS = new ArrayList<>();
        ArrayList<WorkReportDetailVO> workReportDetailVOS = new ArrayList<>();

        List<Project> projects = projectDAO.getBaseMapper().selectList(new LambdaQueryWrapper<Project>().eq(Project::getTenantsid, LoginUserUtils.getTenantSid()));
        Map<String, Project> projectHashMap = projects.stream().collect(Collectors.toMap(project -> project.getProject_code(), project -> project));


        for (WorkReportDetailDTO workReportDetailDTO : workReportDetailDTOs) {
            LambdaQueryWrapper<WorkReportDetail> lambdaQueryWrapper = new LambdaQueryWrapper<>();
            lambdaQueryWrapper.eq(WorkReportDetail::getTask_id, workReportDetailDTO.getTask_id())
                    .eq(WorkReportDetail::getTenantsid, LoginUserUtils.getTenantSid());
            List<WorkReportDetail> taskS = workReportDetailDAO.getBaseMapper().selectList(lambdaQueryWrapper);
            if (CollectionUtils.isNotEmpty(taskS)) {
                List<WorkReportDetail> workReportDetails = new ArrayList<>();
                for (WorkReportDetail workReportDetail : taskS) {
                    if ("N".equals(workReportDetailDTO.getReport_status()) && "0".equals(workReportDetail.getStatus())) {
                        workReportDetails.add(workReportDetail);
                    } else if ("Y".equals(workReportDetailDTO.getReport_status()) && ("1".equals(workReportDetail.getStatus()) || "2".equals(workReportDetail.getStatus()))) {
                        workReportDetails.add(workReportDetail);
                    }
                }
                for (WorkReportDetail workReportDetail : workReportDetails) {
                    WorkReportDetailVO workReportDetailVO = new WorkReportDetailVO();
                    BeanUtils.copyProperties(workReportDetail, workReportDetailVO);

                    if (projectHashMap.containsKey(workReportDetail.getBelong_project())) {
                        Project project = projectHashMap.get(workReportDetail.getBelong_project());
                        workReportDetailVO.setBelong_project_name(project.getProject_name());
                        workReportDetailVO.setBelong_project(StringUtil.isNotEmpty(workReportDetail.getBelong_project()) ? workReportDetail.getBelong_project() : "");
                    } else {
                        workReportDetailVO.setBelong_project_name("");
                        workReportDetailVO.setBelong_project("");
                    }
                    Employee employee = employeeDAO.getBaseMapper().selectOne(new LambdaQueryWrapper<Employee>().eq(Employee::getEmployee_no, workReportDetail.getEmployee_no())
                            .eq(Employee::getTenantsid, LoginUserUtils.getTenantSid()));
                    workReportDetailVO.setEmail(employee.getEmail());
                    workReportDetailVO.setEmployee_name(employee.getEmployee_name());
                    workReportDetailVOS.add(workReportDetailVO);

                }

            } else {
                Employee employee1 = getEmployeeByEmail(workReportDetailDTO.getEmail());
                // 1.审核人可能是组织主管，也可能是自定义设置的，先查自定义设置的下要审批的员工信息
                List<Employee> employees1 = employeeDAO.getBaseMapper().selectList(new LambdaQueryWrapper<Employee>().eq(Employee::getApproval_no, employee1.getEmployee_no())
                        .eq(Employee::getTenantsid, LoginUserUtils.getTenantSid()));
                for (Employee employee : employees1) {
                    getWorkReportDetailVO(workReportDetailDTO, employee, workReportDetailVOS);
                }
                returnWorkReportDetailVOs.addAll(workReportDetailVOS);
                workReportDetailVOS.clear();
                List<Organization> organizationS = organizationDAO.getBaseMapper().selectList(new QueryWrapper<Organization>().lambda().eq(Organization::getOrg_supervisor_id, employee1.getEmployee_no())
                        .eq(Organization::getTenantsid, LoginUserUtils.getTenantSid()));
                organizationS.forEach(organization -> {
                    // 2.此处加上条件，自定义审核人为null或者''
                    List<Employee> employees = employeeDAO.getBaseMapper().selectList(new QueryWrapper<Employee>().lambda().eq(Employee::getOrg_no, organization.getOrg_no())
                            .and(wrapper -> wrapper.isNull(Employee::getApproval_no).or().eq(Employee::getApproval_no, ""))
                            .eq(Employee::getTenantsid, LoginUserUtils.getTenantSid()));

                    // 3.以下for循环抽出一个方法，供自定义审批人员时判断使用,此处是否能改为批量查询？
                    for (Employee employee : employees) {
                        getWorkReportDetailVO(workReportDetailDTO, employee, workReportDetailVOS);
                    }
                });
            }
            returnWorkReportDetailVOs.addAll(workReportDetailVOS);


        }
        SimpleDateFormat outputFormat = new SimpleDateFormat("yyyy-MM-dd");
        //将信息合并
        String reportStatus = null;
        Map<String, Map<String, List<WorkReportDetailVO>>> classifiedReport = new HashMap<>();
        for (WorkReportDetailVO report : returnWorkReportDetailVOs) {
            String employee_no = report.getEmployee_no();

            String date = outputFormat.format(report.getReport_date());
            String status = report.getStatus();
            if (status.equals("0")) {
                reportStatus = "N";
            } else if (status.equals("1") || status.equals("2")) {
                reportStatus = "Y";
            }
            // 检查是否已经存在对应人员和日期的分类，若不存在则创建
            if (!classifiedReport.containsKey(employee_no)) {
                classifiedReport.put(employee_no, new HashMap<>());

            }
            if (!classifiedReport.get(employee_no).containsKey(date)) {
                classifiedReport.get(employee_no).put(date, new ArrayList<>());
            }
            // 将报工信息添加到对应的分类中
            classifiedReport.get(employee_no).get(date).add(report);
        }

        for (String employee_no : classifiedReport.keySet()) {
            for (String date : classifiedReport.get(employee_no).keySet()) {
                AuditWorkReportVO entry = new AuditWorkReportVO();
                Employee employee = employeeDAO.getBaseMapper().selectOne(new LambdaQueryWrapper<Employee>().eq(Employee::getEmployee_no, employee_no)
                        .eq(Employee::getTenantsid, LoginUserUtils.getTenantSid()));
                entry.setEmployee_name(employee.getEmployee_name());
                entry.setEmployee_no(employee_no);

                entry.setReport_date(date);

                entry.setReport_status(reportStatus);
                entry.setWork_report_info(classifiedReport.get(employee_no).get(date));
                auditWorkReportVOS.add(entry);
            }
        }

        return auditWorkReportVOS;
    }

    //查询是否有需要审批的数据
    private List<WorkReportDetailVO> getWorkReportDetailVO(WorkReportDetailDTO workReportDetailDTO, Employee employee,
                                                           List<WorkReportDetailVO> workReportDetailVOS) {
        LambdaQueryWrapper<WorkReportDetail> lambdaQueryWrapper = new LambdaQueryWrapper<>();

        //先查询该任务卡是否为最新的
        lambdaQueryWrapper.eq(WorkReportDetail::getTask_id, workReportDetailDTO.getTask_id())
                .eq(WorkReportDetail::getTenantsid, LoginUserUtils.getTenantSid());
        List<WorkReportDetail> taskS = workReportDetailDAO.getBaseMapper().selectList(lambdaQueryWrapper);

        LambdaQueryWrapper<WorkReportDetail> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.and(i -> i.isNull(WorkReportDetail::getTask_id).or().eq(WorkReportDetail::getTask_id, ""))
                .eq(WorkReportDetail::getStatus, "0")
                .eq(WorkReportDetail::getEmployee_no, employee.getEmployee_no())
                .eq(WorkReportDetail::getTenantsid, LoginUserUtils.getTenantSid());
        List<WorkReportDetail> workReportDetails = workReportDetailDAO.getBaseMapper().selectList(queryWrapper);
        for (WorkReportDetail workReportDetail : workReportDetails) {
            workReportDetail.setTask_id(workReportDetailDTO.getTask_id());
            workReportDetailDAO.updateById(workReportDetail);
        }


        lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.eq(WorkReportDetail::getEmployee_no, employee.getEmployee_no());
        lambdaQueryWrapper.eq(WorkReportDetail::getTenantsid, LoginUserUtils.getTenantSid());
        if ("Y".equals(workReportDetailDTO.getReport_status())) {
            ArrayList<String> status = new ArrayList<>();
            status.add("1");
            status.add("2");
            lambdaQueryWrapper.in(WorkReportDetail::getStatus, status);
            lambdaQueryWrapper.eq(com.digiwin.athena.dtdapp.util.StringUtils.isNotEmpty(workReportDetailDTO.getTask_id()), WorkReportDetail::getTask_id, workReportDetailDTO.getTask_id());
        } else if ("N".equals(workReportDetailDTO.getReport_status())) {
            lambdaQueryWrapper.eq(WorkReportDetail::getStatus, "0")
                    .eq(WorkReportDetail::getTask_id, workReportDetailDTO.getTask_id());

        }

        List<WorkReportDetail> workReportDetailS = workReportDetailDAO.getBaseMapper().selectList(lambdaQueryWrapper);
        for (WorkReportDetail workReportDetail : workReportDetailS) {
            WorkReportDetailVO workReportDetailVO = new WorkReportDetailVO();
            BeanUtils.copyProperties(workReportDetail, workReportDetailVO);
            Project project = projectDAO.getBaseMapper().selectOne(new LambdaQueryWrapper<Project>().eq(Project::getProject_code, workReportDetail.getBelong_project())
                    .eq(Project::getTenantsid, LoginUserUtils.getTenantSid()));
            if (project != null) {
                workReportDetailVO.setBelong_project_name(project.getProject_name());
                workReportDetailVO.setBelong_project(StringUtil.isNotEmpty(workReportDetail.getBelong_project()) ? workReportDetail.getBelong_project() : "");
            } else {
                workReportDetailVO.setBelong_project_name("");
                workReportDetailVO.setBelong_project("");
            }
            workReportDetailVO.setEmail(employee.getEmail());
            workReportDetailVO.setEmployee_name(employee.getEmployee_name());
            workReportDetailVOS.add(workReportDetailVO);

        }
        return workReportDetailVOS;
    }


    public List<WorkReportDetail> getWarningWorkReportInfo(Map map) {
        return null;
    }


    public List<Employee> getApproverInfo(Map map) throws DWException {
        ArrayList<Employee> employees = new ArrayList<>();
        List<WorkReportDetail> workReportDetails = new ArrayList<>();
        // 1.通过employee表查询哪些员工有设置报工审批人（没设置的默认由所在组织主管审批）
        List<Employee> emp_nos = employeeDAO.getBaseMapper().selectList(new LambdaQueryWrapper<Employee>().and(i -> i.isNotNull(Employee::getApproval_no).ne(Employee::getApproval_no, ""))
                .eq(Employee::getTenantsid, LoginUserUtils.getTenantSid()));

        // 2.按审批人分组得到Map<String, List<>>
        Map<String, List<String>> approvalMap = emp_nos.stream()
                .collect(Collectors.groupingBy(Employee::getApproval_no,
                        Collectors.mapping(Employee::getEmployee_no, Collectors.toList())));
        //获取离职和未离职的审批人
        List<String> approval_nos = new ArrayList<>(approvalMap.keySet());
        List<Employee> approvals = employeeDAO.getBaseMapper().selectList(new LambdaQueryWrapper<Employee>().in(Employee::getEmployee_no, approval_nos)
                .eq(Employee::getTenantsid, LoginUserUtils.getTenantSid()));
        List<Employee> approvals_deport = approvals.stream().filter(employee -> "N".equals(employee.getStatus())).collect(Collectors.toList());
        List<String> approval_nos_deport = approvals_deport.stream().map(employee -> employee.getEmployee_no()).collect(Collectors.toList());
        //List<Employee> approval_nos_formal = approvals.stream().filter(employee -> "Y".equals(employee.getStatus())).collect(Collectors.toList());

        // 3.查询对应的List<>中的员工有无需要审批的数据，有则把审批人加入employees
        for (String s : approvalMap.keySet()) {
            LambdaQueryWrapper<WorkReportDetail> workReportDetailLambdaQueryWrapper = new LambdaQueryWrapper<>();
            workReportDetailLambdaQueryWrapper.in(WorkReportDetail::getEmployee_no, approvalMap.get(s));
            workReportDetailLambdaQueryWrapper.eq(WorkReportDetail::getTenantsid, LoginUserUtils.getTenantSid());
            workReportDetailLambdaQueryWrapper.eq(WorkReportDetail::getStatus, "0");
            workReportDetailLambdaQueryWrapper.and(wrapper -> wrapper.isNull(WorkReportDetail::getTask_id).or().eq(WorkReportDetail::getTask_id, ""));
            Long aLong = workReportDetailDAO.getBaseMapper().selectCount(workReportDetailLambdaQueryWrapper);
            if (aLong > 0) {
                LambdaQueryWrapper<Employee> employeeLambdaQueryWrapper = new LambdaQueryWrapper<>();
                Employee employee = employeeDAO.getBaseMapper().selectOne(employeeLambdaQueryWrapper
                        .eq(Employee::getEmployee_no, s).eq(Employee::getTenantsid, LoginUserUtils.getTenantSid())
                );
                // 下面直接改为 if(employee != null){employees.add(employee);} 然后再return之前统一判断是否有重复；用Stream流可以方便的判断
                employees.add(employee);

            }
        }


        List<Organization> organizations = organizationDAO.getBaseMapper().selectList(
                new QueryWrapper<Organization>().lambda()
                        .eq(Organization::getTenantsid, LoginUserUtils.getTenantSid()));

        for (Organization organization : organizations) {
            // 4.此处查询需增加个条件，employee中设置的审批人为null或者""或者审批人已离职
            List<Employee> employeeList = employeeDAO.getBaseMapper().selectList(new QueryWrapper<Employee>().lambda().eq(Employee::getOrg_no, organization.getOrg_no())
                    .and(wrapper -> wrapper.isNull(Employee::getApproval_no).or().eq(Employee::getApproval_no, "").or().in(CollectionUtils.isNotEmpty(approval_nos_deport),Employee::getApproval_no,approval_nos_deport))
                    .eq(Employee::getTenantsid, LoginUserUtils.getTenantSid())
            );

            LambdaQueryWrapper<WorkReportDetail> lambdaQueryWrapper = new LambdaQueryWrapper<>();
            workReportDetails = new ArrayList<>();
            ArrayList<String> emp_noList = new ArrayList<>();
            for (Employee allEmployee : employeeList) {
                emp_noList.add(allEmployee.getEmployee_no());
            }
            lambdaQueryWrapper = new LambdaQueryWrapper<>();
            if (emp_noList == null || emp_noList.size() == 0) {
                continue;
            }
            lambdaQueryWrapper.in(WorkReportDetail::getEmployee_no, emp_noList);
            lambdaQueryWrapper.eq(WorkReportDetail::getTenantsid, LoginUserUtils.getTenantSid());
            lambdaQueryWrapper.eq(WorkReportDetail::getStatus, "0");
            lambdaQueryWrapper.and(wrapper -> wrapper.isNull(WorkReportDetail::getTask_id).or().eq(WorkReportDetail::getTask_id, ""));
            Long aLong = workReportDetailDAO.getBaseMapper().selectCount(lambdaQueryWrapper);

            if (aLong > 0) {
                LambdaQueryWrapper<Employee> eq = new LambdaQueryWrapper<Employee>().eq(Employee::getEmployee_no, organization.getOrg_supervisor_id())
                        .eq(Employee::getStatus,"Y")
                        .eq(Employee::getTenantsid, LoginUserUtils.getTenantSid());
                Employee employee = employeeDAO.getBaseMapper().selectOne(eq);
                if(employee!=null) {
                    employees.add(employee);
                }
            }

        }


        // 统一判断employees对象是否重复
        List<Employee> collect = employees.stream().distinct().filter(employee -> "Y".equals(employee.getStatus())).collect(Collectors.toList());

        return collect;
    }


    public List getWorkReportByStatus(Map map) {
        JSONObject jsonObject = JSON.parseObject(JSON.toJSONString(map));
        JSONArray jsonArray = jsonObject.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("work_report_info");
        List<WorkReportDetailDTO> workReportDetailDTOs = JSON.parseArray(JSON.toJSONString(jsonArray), WorkReportDetailDTO.class);

        List<WorkReportDetail> workReportDetailList = null;
        List<WorkReportDetailVO> workReportDetailVOList = new ArrayList<>();

        List<Project> projects = projectDAO.getBaseMapper().selectList(new LambdaQueryWrapper<Project>().eq(Project::getTenantsid, LoginUserUtils.getTenantSid()));
        Map<String, Project> projectHashMap = projects.stream().collect(Collectors.toMap(project -> project.getProject_code(), project -> project));

        for (WorkReportDetailDTO workReportDetailDTO : workReportDetailDTOs) {
            Employee employee = getEmployeeByEmail(workReportDetailDTO.getEmail());
            LambdaQueryWrapper<WorkReportDetail> queryWrapper = new LambdaQueryWrapper<>();
            //查自己
            queryWrapper.eq(WorkReportDetail::getEmployee_no, employee.getEmployee_no())
                    .eq(WorkReportDetail::getTenantsid, LoginUserUtils.getTenantSid());
            //报工日期
            queryWrapper.eq(workReportDetailDTO.getReport_date() != null, WorkReportDetail::getReport_date, workReportDetailDTO.getReport_date());
            //状态
            queryWrapper.eq(WorkReportDetail::getStatus, workReportDetailDTO.getStatus());
            queryWrapper.eq(workReportDetailDTO.getSeq() != null, WorkReportDetail::getSeq, workReportDetailDTO.getSeq());
            queryWrapper.orderByDesc(WorkReportDetail::getUpdate_time);
            queryWrapper.eq(WorkReportDetail::getTenantsid, LoginUserUtils.getTenantSid());

            workReportDetailList = workReportDetailDAO.getBaseMapper().selectList(queryWrapper);
            WorkReportDetailVO workReportDetailVO = null;
            for (WorkReportDetail reportDetail : workReportDetailList) {
                workReportDetailVO = new WorkReportDetailVO();
                BeanUtils.copyProperties(reportDetail, workReportDetailVO);


                if (projectHashMap.containsKey(reportDetail.getBelong_project())) {
                    Project project = projectHashMap.get(reportDetail.getBelong_project());
                    workReportDetailVO.setBelong_project_name(project.getProject_name());
                    workReportDetailVO.setBelong_project(project.getProject_code());
                } else {
                    workReportDetailVO.setBelong_project_name("");
                    workReportDetailVO.setBelong_project("");
                }

                workReportDetailVO.setReport_frequency(employee.getReport_frequency());
                workReportDetailVO.setEmail(employee.getEmail());
                workReportDetailVO.setFrom_zentao(reportDetail.getFrom_zentao());
                workReportDetailVOList.add(workReportDetailVO);
            }

        }
        return workReportDetailVOList;
    }


    public Map<String, Object> getHistoryWorkReport(Map map) {
        JSONObject jsonObject = JSON.parseObject(JSON.toJSONString(map));
        JSONArray jsonArray = jsonObject.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("search_info");

        //获取分页数据
        Integer page = jsonObject.getJSONObject("std_data").getJSONObject("parameter").getObject("page_no", Integer.class);
        Integer size = jsonObject.getJSONObject("std_data").getJSONObject("parameter").getObject("page_size", Integer.class);
        Boolean use_has_next = jsonObject.getJSONObject("std_data").getJSONObject("parameter").getObject("use_has_next", Boolean.class);
        Page<WorkReportDetail> pages = new Page<>(page, size);
        Map<String, Object> stringObjectMap = new HashMap<>();
        LambdaQueryWrapper<WorkReportDetail> queryWrapper = new LambdaQueryWrapper<>();

        //获取报工类型
        List<ZtTypeAssociations> ztTypeAssociations = ztTypeAssociationsDAO.getBaseMapper().selectList(new QueryWrapper<>());
        Map<String, String> stringZtTypeAssociationsMap = new HashMap<>();
        for (ZtTypeAssociations ztTypeAssociation : ztTypeAssociations) {
            stringZtTypeAssociationsMap.put(ztTypeAssociation.getType_no(), ztTypeAssociation.getReport_type());
        }

        LambdaQueryWrapper<Employee> getEmployee = new LambdaQueryWrapper<Employee>();
        ArrayList<WorkReportDetail> workReportDetails = new ArrayList<>();
        String sql = "";
        queryWrapper.eq(WorkReportDetail::getTenantsid, LoginUserUtils.getTenantSid());
        if (!(jsonArray == null || jsonArray.size() == 0)) {
            List<SearchDTO> searchDTOS = JSON.parseArray(JSON.toJSONString(jsonArray), SearchDTO.class);
            sql = sql + "(";
            for (SearchDTO searchDTO : searchDTOS) {
                switch (searchDTO.getSearch_field()) {
                    case "email":
                        LambdaQueryWrapper<Employee> employeeLambdaQueryWrapper = new LambdaQueryWrapper<>();
                        employeeLambdaQueryWrapper.like(Employee::getEmail, searchDTO.getSearch_value().get(0))
                                .eq(Employee::getTenantsid, LoginUserUtils.getTenantSid());
                        List<Employee> employees2 = employeeDAO.getBaseMapper().selectList(employeeLambdaQueryWrapper);
                        List<String> listx = new ArrayList<String>();

                        if (CollectionUtils.isNotEmpty(employees2)) {
                            for (Employee emp : employees2) {
                                listx.add(emp.getEmployee_no());
                            }
                            searchDTO.setSearch_field("employee_no");
                            searchDTO.setSearch_operator("in");
                            searchDTO.setSearch_value(listx);
                            sql = sql + com.digiwin.athena.dtdapp.util.StringUtils.builderSQL(searchDTO, sql);
                        } else {
                            searchDTO.setSearch_field("employee_no");
                            listx.add("000000");
                            searchDTO.setSearch_value(listx);
                            sql = sql + com.digiwin.athena.dtdapp.util.StringUtils.builderSQL(searchDTO, sql);
                        }
                        break;
                    case "employee_name":
                        getEmployee = new LambdaQueryWrapper<Employee>().like(Employee::getEmployee_name, searchDTO.getSearch_value().get(0))
                                .eq(Employee::getTenantsid, LoginUserUtils.getTenantSid());

                        List<Employee> employee2 = employeeDAO.getBaseMapper().selectList(getEmployee);
                        List<String> list = new ArrayList<String>();

                        if (CollectionUtils.isNotEmpty(employee2)) {
                            for (Employee emp : employee2) {
                                list.add(emp.getEmployee_no());
                            }
                            searchDTO.setSearch_field("employee_no");
                            searchDTO.setSearch_operator("in");
                            searchDTO.setSearch_value(list);
                            sql = sql + com.digiwin.athena.dtdapp.util.StringUtils.builderSQL(searchDTO, sql);
                        } else {
                            searchDTO.setSearch_field("employee_no");
                            list.add("000000");
                            searchDTO.setSearch_value(list);
                            sql = sql + com.digiwin.athena.dtdapp.util.StringUtils.builderSQL(searchDTO, sql);
                        }
                        break;
                    case "org_no":
                        getEmployee = new LambdaQueryWrapper<Employee>().like(Employee::getOrg_no, searchDTO.getSearch_value().get(0))
                                .eq(Employee::getTenantsid, LoginUserUtils.getTenantSid());
                        List<Employee> employees = employeeDAO.getBaseMapper().selectList(getEmployee);
                        if (CollectionUtils.isNotEmpty(employees)) {
                            ArrayList<String> strings = new ArrayList<>();
                            for (Employee employee1 : employees) {
                                strings.add(employee1.getEmployee_no());
                            }
                            searchDTO.setSearch_field("employee_no");
                            searchDTO.setSearch_operator("in");
                            searchDTO.setSearch_value(strings);
                            sql = sql + com.digiwin.athena.dtdapp.util.StringUtils.builderSQL(searchDTO, sql);
                        } else {
                            searchDTO.setSearch_field("employee_no");
                            List<String> list1 = new ArrayList<String>();
                            list1.add("000000");
                            searchDTO.setSearch_value(list1);
                            sql = sql + com.digiwin.athena.dtdapp.util.StringUtils.builderSQL(searchDTO, sql);
                        }
                        break;
                    case "org_name":
                        LambdaQueryWrapper<Organization> eq = new LambdaQueryWrapper<Organization>().like(Organization::getOrg_name, searchDTO.getSearch_value().get(0))
                                .eq(Organization::getTenantsid, LoginUserUtils.getTenantSid());
                        List<Organization> organizations = organizationDAO.getBaseMapper().selectList(eq);
                        ArrayList<String> strings1 = new ArrayList<>();
                        if (CollectionUtils.isNotEmpty(organizations)) {
                            for (Organization organization : organizations) {
                                getEmployee = new LambdaQueryWrapper<Employee>().eq(Employee::getOrg_no, organization.getOrg_no())
                                        .eq(Employee::getTenantsid, LoginUserUtils.getTenantSid());
                                List<Employee> employees1 = employeeDAO.getBaseMapper().selectList(getEmployee);
                                for (Employee employee1 : employees1) {
                                    strings1.add(employee1.getEmployee_no());
                                }
                            }
                        }
                        if (CollectionUtils.isNotEmpty(strings1)) {
                            searchDTO.setSearch_field("employee_no");
                            searchDTO.setSearch_operator("in");
                            searchDTO.setSearch_value(strings1);
                            sql = sql + com.digiwin.athena.dtdapp.util.StringUtils.builderSQL(searchDTO, sql);
                        } else {
                            searchDTO.setSearch_field("employee_no");
                            List<String> list2 = new ArrayList<String>();
                            list2.add("000000");
                            searchDTO.setSearch_value(list2);
                            sql = sql + com.digiwin.athena.dtdapp.util.StringUtils.builderSQL(searchDTO, sql);
                        }
                        break;
                    case "belong_project_name":
                        List<Project> projects = projectDAO.getBaseMapper().selectList(new LambdaQueryWrapper<Project>().like(Project::getProject_name, searchDTO.getSearch_value().get(0))
                                .eq(Project::getTenantsid, LoginUserUtils.getTenantSid()));
                        if (CollectionUtils.isNotEmpty(projects)) {
                            ArrayList<String> strings = new ArrayList<>();
                            for (Project project : projects) {
                                strings.add(project.getProject_code());
                            }
                            searchDTO.setSearch_field("belong_project");
                            searchDTO.setSearch_operator("in");
                            searchDTO.setSearch_value(strings);
                            sql = sql + com.digiwin.athena.dtdapp.util.StringUtils.builderSQL(searchDTO, sql);
                            break;
                        }
                    case "approval_no":
                        getEmployee = new LambdaQueryWrapper<Employee>().eq(Employee::getApproval_no, searchDTO.getSearch_value().get(0))
                                .eq(Employee::getTenantsid, LoginUserUtils.getTenantSid());
                        List<Employee> employees1 = employeeDAO.getBaseMapper().selectList(getEmployee);
                        if (CollectionUtils.isNotEmpty(employees1)) {
                            ArrayList<String> strings = new ArrayList<>();
                            for (Employee employee1 : employees1) {
                                strings.add(employee1.getEmployee_no());
                            }
                            searchDTO.setSearch_field("employee_no");
                            searchDTO.setSearch_operator("in");
                            searchDTO.setSearch_value(strings);
                            sql = sql + com.digiwin.athena.dtdapp.util.StringUtils.builderSQL(searchDTO, sql);
                        } else {
                            searchDTO.setSearch_field("employee_no");
                            List<String> list1 = new ArrayList<String>();
                            list1.add("000000");
                            searchDTO.setSearch_value(list1);
                            sql = sql + com.digiwin.athena.dtdapp.util.StringUtils.builderSQL(searchDTO, sql);
                        }
                        break;
                    case "approval_name":
                        List<Employee> employees11 = employeeDAO.getBaseMapper().selectList(new LambdaQueryWrapper<Employee>().like(Employee::getEmployee_name, searchDTO.getSearch_value().get(0))
                                .eq(Employee::getTenantsid, LoginUserUtils.getTenantSid()));
                        List<String> collect = employees11.stream().map(e -> e.getEmployee_no()).collect(Collectors.toList());
                        getEmployee = new LambdaQueryWrapper<Employee>().in(Employee::getApproval_no, collect)
                                .eq(Employee::getTenantsid, LoginUserUtils.getTenantSid());
                        List<Employee> employees3 = employeeDAO.getBaseMapper().selectList(getEmployee);
                        if (CollectionUtils.isNotEmpty(employees3)) {
                            ArrayList<String> strings = new ArrayList<>();
                            for (Employee employee1 : employees3) {
                                strings.add(employee1.getEmployee_no());
                            }
                            searchDTO.setSearch_field("employee_no");
                            searchDTO.setSearch_operator("in");
                            searchDTO.setSearch_value(strings);
                            sql = sql + com.digiwin.athena.dtdapp.util.StringUtils.builderSQL(searchDTO, sql);
                        } else {
                            searchDTO.setSearch_field("employee_no");
                            List<String> list1 = new ArrayList<String>();
                            list1.add("000000");
                            searchDTO.setSearch_value(list1);
                            sql = sql + com.digiwin.athena.dtdapp.util.StringUtils.builderSQL(searchDTO, sql);
                        }
                        break;
                    default:
                        sql = sql + com.digiwin.athena.dtdapp.util.StringUtils.builderSQL(searchDTO, sql);
                        break;
                }
            }
            sql = sql + ")";
            queryWrapper.apply(sql);
        }


        List<WorkReportDetail> workReportDetailS = null;
        if (use_has_next != null && use_has_next) {
            Page<WorkReportDetail> workReportDetailPage = workReportDetailDAO.getBaseMapper().selectPage(pages, queryWrapper);
            workReportDetailS = workReportDetailPage.getRecords();
            stringObjectMap.put("total_results", workReportDetailPage.getTotal());
            stringObjectMap.put("has_next", workReportDetailPage.hasNext());
        } else {
            workReportDetailS = workReportDetailDAO.getBaseMapper().selectList(queryWrapper);
        }


        List<WorkReportDetail> pagelist = workReportDetailS;

        ArrayList<WorkReportDetailVO> workReportDetailVOS = new ArrayList<>();
        List<Employee> employeeList = employeeDAO.getBaseMapper().selectList(new LambdaQueryWrapper<Employee>()
                .eq(Employee::getTenantsid, LoginUserUtils.getTenantSid()));
        Map<String, Employee> employeeMap = employeeList.stream().collect(Collectors.toMap(a -> a.getEmployee_no(), a -> a));

        List<Organization> organizationList = organizationDAO.getBaseMapper().selectList(new LambdaQueryWrapper<Organization>()
                .eq(Organization::getTenantsid, LoginUserUtils.getTenantSid()));
        Map<String, Organization> organizationMap = organizationList.stream().collect(Collectors.toMap(a -> a.getOrg_no(), a -> a));

        for (WorkReportDetail workReportDetail : pagelist) {
            WorkReportDetailVO workReportDetailVO = new WorkReportDetailVO();
            BeanUtils.copyProperties(workReportDetail, workReportDetailVO);

            Employee employee = employeeMap.get(workReportDetail.getEmployee_no());
            workReportDetailVO.setEmployee_name(employee.getEmployee_name());
            workReportDetailVO.setEmail(employee.getEmail());
            workReportDetailVO.setTitle(employee.getTitle());
            workReportDetailVO.setReport_type(stringZtTypeAssociationsMap.get(workReportDetailVO.getReport_type()));
            workReportDetailVO.setOrg_no(employee.getOrg_no());
            workReportDetailVO.setOrg_name(organizationMap.get(employee.getOrg_no()).getOrg_name());
            workReportDetailVO.setApproval_no(employeeMap.containsKey(employee.getApproval_no()) ? employeeMap.get(employee.getApproval_no()).getEmployee_no() : "");
            workReportDetailVO.setApproval_name(employeeMap.containsKey(employee.getApproval_no()) ? employeeMap.get(employee.getApproval_no()).getEmployee_name() : "");

            Organization organization = organizationDAO.getBaseMapper().selectOne(new LambdaQueryWrapper<Organization>().eq(Organization::getOrg_no, employee.getOrg_no())
                    .eq(Organization::getTenantsid, LoginUserUtils.getTenantSid()));
            workReportDetailVO.setOrg_name(organization.getOrg_name());

            if (StringUtil.isNotEmpty(workReportDetail.getBelong_project())) {
                Project project = projectDAO.getBaseMapper().selectOne(new LambdaQueryWrapper<Project>().eq(Project::getProject_code, workReportDetail.getBelong_project())
                        .eq(Project::getTenantsid, LoginUserUtils.getTenantSid()));
                if (project != null) {
                    workReportDetailVO.setBelong_project_name(project.getProject_name());
                }

            }
            workReportDetailVOS.add(workReportDetailVO);
        }


        stringObjectMap.put("work_report_info", workReportDetailVOS);
        return stringObjectMap;
    }

    @Transactional
    public void updateZtProduct() {
        List<Project> projectList = new ArrayList<>();
        List<ProjectEmployeeRelation> projectEmployeeRelationList = new ArrayList<>();
        //拿到所有项目信息
        List<Project> projects = projectDAO.getBaseMapper().selectList(new LambdaQueryWrapper<Project>().eq(Project::getTenantsid, LoginUserUtils.getTenantSid()));
        Map<String, Project> projectMap = new HashMap<>();
        for (Project project : projects) {
            projectMap.put(project.getProject_code(), project);
        }
        LambdaQueryWrapper<ProjectEmployeeRelation> queryWrapper = new LambdaQueryWrapper<ProjectEmployeeRelation>().eq(ProjectEmployeeRelation::getEmployee_role, "1")
                .eq(ProjectEmployeeRelation::getTenantsid, LoginUserUtils.getTenantSid());
        List<ProjectEmployeeRelation> projectEmployeeRelations = projectEmployeeRelationDAO.getBaseMapper().selectList(queryWrapper);
        Map<String, ProjectEmployeeRelation> projectEmployeeRelationMap = new HashMap<>();
        for (ProjectEmployeeRelation projectEmployeeRelation : projectEmployeeRelations) {
            projectEmployeeRelationMap.put(projectEmployeeRelation.getProject_id(), projectEmployeeRelation);
        }

        List<ZtProduct> ztProducts = ztProductDAO.getBaseMapper().selectList(new QueryWrapper<>());
        for (ZtProduct ztProduct : ztProducts) {
            Project project = new Project();
            project.setProject_code("zt_product_" + ztProduct.getId());
            project.setProject_name(ztProduct.getName());
            project.setProject_type("1");
            switch (ztProduct.getStatus()) {
                case "normal":
                    project.setManage_status("Y");
                    break;
                case "closed":
                    project.setManage_status("V");
                    break;
            }
            if (projectMap.containsKey(project.getProject_code())) {
                project.setId(projectMap.get(project.getProject_code()).getId());
            }
            projectList.add(project);
            projectMap.put(project.getProject_code(), project);
            if (projectList.size() % 1000 == 0) {
                projectDAO.saveOrUpdateBatch(projectList);
                projectList.clear();
            }
            //得到PO
            if (StringUtil.isNotEmpty(ztProduct.getPo())) {
                ZtUser ztUser = ztUserDAO.getBaseMapper().selectOne(new LambdaQueryWrapper<ZtUser>().eq(ZtUser::getAccount, ztProduct.getPo())
                        .eq(ZtUser::getDeleted, "0"));
                if (ztUser == null) {
                    continue;
                }
                Employee employee = getEmployeeByEmail(ztUser.getEmail());
                if (employee == null) {
                    continue;
                }
                ProjectEmployeeRelation projectEmployeeRelation = new ProjectEmployeeRelation();
                projectEmployeeRelation.setProject_id(project.getProject_code());
                projectEmployeeRelation.setEmployee_no(employee.getEmployee_no());
                projectEmployeeRelation.setEmployee_role("1");

                if (projectEmployeeRelationMap.containsKey(project.getProject_code())) {
                    //存在，则更新
                    projectEmployeeRelation.setId(projectEmployeeRelationMap.get(project.getProject_code()).getId());
                }
                projectEmployeeRelationList.add(projectEmployeeRelation);
                if (projectEmployeeRelationList.size() % 500 == 0) {
                    projectEmployeeRelationDAO.saveOrUpdateBatch(projectEmployeeRelationList);
                    projectEmployeeRelationList.clear();
                }
            }
        }
        if (!projectList.isEmpty()) {
            projectDAO.saveOrUpdateBatch(projectList);
            projectList.clear();
        }
        if (!projectEmployeeRelationList.isEmpty()) {
            projectEmployeeRelationDAO.saveOrUpdateBatch(projectEmployeeRelationList);
            projectEmployeeRelationList.clear();

        }
    }


    @Transactional
    public void updateZtProject() {
        List<Project> projectList = new ArrayList<>();
        List<ProjectEmployeeRelation> projectEmployeeRelationList = new ArrayList<>();
        //拿到所有项目信息
        List<Project> projects = projectDAO.getBaseMapper().selectList(new LambdaQueryWrapper<Project>().eq(Project::getTenantsid, LoginUserUtils.getTenantSid()));
        Map<String, Project> projectMap = new HashMap<>();
        for (Project project : projects) {
            projectMap.put(project.getProject_code(), project);
        }
        LambdaQueryWrapper<ProjectEmployeeRelation> queryWrapper = new LambdaQueryWrapper<ProjectEmployeeRelation>().eq(ProjectEmployeeRelation::getEmployee_role, "1")
                .eq(ProjectEmployeeRelation::getTenantsid, LoginUserUtils.getTenantSid());
        List<ProjectEmployeeRelation> projectEmployeeRelations = projectEmployeeRelationDAO.getBaseMapper().selectList(queryWrapper);
        Map<String, ProjectEmployeeRelation> projectEmployeeRelationMap = new HashMap<>();
        for (ProjectEmployeeRelation projectEmployeeRelation : projectEmployeeRelations) {
            projectEmployeeRelationMap.put(projectEmployeeRelation.getProject_id(), projectEmployeeRelation);
        }

        List<ZtProject> ztProjects = ztProjectDAO.getBaseMapper().selectList(new QueryWrapper<>());
        for (ZtProject ztProject : ztProjects) {
            Project project = new Project();
            project.setProject_code("zt_project_" + ztProject.getId());
            project.setProject_name(ztProject.getName());
            project.setProject_type("2");
            switch (ztProject.getStatus()) {
                case "wait":
                case "pause":
                case "cancel":
                    project.setManage_status("N");
                    break;
                case "doing":
                    project.setManage_status("Y");
                    break;
                case "done":
                case "closed":
                    project.setManage_status("V");
                    break;
            }
            if (projectMap.containsKey(project.getProject_code())) {
                project.setId(projectMap.get(project.getProject_code()).getId());
            }
            projectList.add(project);
            projectMap.put(project.getProject_code(), project);
            if (projectList.size() % 1000 == 0) {
                projectDAO.saveOrUpdateBatch(projectList);
                projectList.clear();
            }
            //得到PO
            if (StringUtil.isNotEmpty(ztProject.getPo())) {
                ZtUser ztUser = ztUserDAO.getBaseMapper().selectOne(new LambdaQueryWrapper<ZtUser>().eq(ZtUser::getAccount, ztProject.getPo())
                        .eq(ZtUser::getDeleted, "0"));
                if (ztUser == null) {
                    continue;
                }
                Employee employee = getEmployeeByEmail(ztUser.getEmail());
                if (employee == null) {
                    continue;
                }
                ProjectEmployeeRelation projectEmployeeRelation = new ProjectEmployeeRelation();
                projectEmployeeRelation.setProject_id(project.getProject_code());
                projectEmployeeRelation.setEmployee_no(employee.getEmployee_no());
                projectEmployeeRelation.setEmployee_role("1");

                if (projectEmployeeRelationMap.containsKey(project.getProject_code())) {
                    //存在，则更新
                    projectEmployeeRelation.setId(projectEmployeeRelationMap.get(project.getProject_code()).getId());
                }
                projectEmployeeRelationList.add(projectEmployeeRelation);
                if (projectEmployeeRelationList.size() % 500 == 0) {
                    projectEmployeeRelationDAO.saveOrUpdateBatch(projectEmployeeRelationList);
                    projectEmployeeRelationList.clear();
                }
            }
        }
        if (!projectList.isEmpty()) {
            projectDAO.saveOrUpdateBatch(projectList);
            projectList.clear();
        }
        if (!projectEmployeeRelationList.isEmpty()) {
            projectEmployeeRelationDAO.saveOrUpdateBatch(projectEmployeeRelationList);
            projectEmployeeRelationList.clear();

        }
    }

    @Transactional
    public List getZtWorkReport(Map map) throws DWException {
        JSONObject jsonObject = JSON.parseObject(JSON.toJSONString(map));
        JSONArray jsonArray = jsonObject.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("zentao_work_report");

        if (jsonArray == null || jsonArray.size() == 0) {
            throw new DWException("no date");
        }
        WorkReportDetailVO workReportDetailVO = null;
        List<WorkReportDetailVO> workReportDetailVOList = new ArrayList<>();
        List<WorkReportDetailDTO> workReportDetailDTOS = JSON.parseArray(JSON.toJSONString(jsonArray), WorkReportDetailDTO.class);

        List<Project> projectList = projectDAO.getBaseMapper().selectList(new LambdaQueryWrapper<Project>().eq(Project::getTenantsid, LoginUserUtils.getTenantSid()));
        Map<String, Project> projectMap = projectList.stream().collect(Collectors.toMap(a -> a.getProject_code(), b -> b));

        for (WorkReportDetailDTO reportDetailDTO : workReportDetailDTOS) {
            Employee employee = getEmployeeByEmail(reportDetailDTO.getEmail());

            ZtUser ztuser = ztUserDAO.getBaseMapper().selectOne(new LambdaQueryWrapper<ZtUser>().eq(ZtUser::getEmail, reportDetailDTO.getEmail())
                    .eq(ZtUser::getDeleted, "0"));


            LambdaQueryWrapper<ZtEffort> ztEffortqueryWrapper = new LambdaQueryWrapper<>();
            ztEffortqueryWrapper.eq(ZtEffort::getAccount, ztuser.getAccount());
            ztEffortqueryWrapper.in(reportDetailDTO.getReport_date_list() != null, ZtEffort::getDate, reportDetailDTO.getReport_date_list());
            ztEffortqueryWrapper.eq(ZtEffort::getDeleted, "0");
            List<ZtEffort> ztEfforts = ztEffortDAO.getBaseMapper().selectList(ztEffortqueryWrapper);

            for (ZtEffort ztEffort : ztEfforts) {

                workReportDetailVO = new WorkReportDetailVO();

                if ("task".equals(ztEffort.getObjectType())) {
                    ZtTask ztTask = ztTaskDAO.getBaseMapper().selectOne(
                            new QueryWrapper<ZtTask>().lambda().eq(ZtTask::getId, ztEffort.getObjectID()));
                    workReportDetailVO.setPlan_hour(new BigDecimal(Float.toString(ztTask.getEstimate())).setScale(2, BigDecimal.ROUND_DOWN));
                    if (ztTask != null && ztTask.getType().length() >= 4 && "spec".equals(ztTask.getType().substring(0, 4))) {
                        ztTask.setType("specification");
                    }
                    if (ztTask != null && ztTask.getType().length() >= 4 && "cult".equals(ztTask.getType().substring(0, 4))) {
                        ztTask.setType("cultivate");
                    }
                    ZtTypeAssociations ztTypeAssociations = getZtTypeAssociationsByZtTaskType(ztTask.getType());
                    workReportDetailVO.setReport_type(ztTypeAssociations.getType_no());
                    workReportDetailVO.setReport_source("PROJECT");
                    if (ztTask != null && ztTask.getProject() != 0) {
                        workReportDetailVO.setBelong_project("zt_project_" + ztTask.getProject());
                        if (projectMap.containsKey("zt_project_" + ztTask.getProject())) {
                            workReportDetailVO.setBelong_project_name(projectMap.get("zt_project_" + ztTask.getProject()).getProject_name());
                        }
                    } else {
                        workReportDetailVO.setBelong_project_name("");
                        workReportDetailVO.setBelong_project("");
                    }
                } else if ("story".equals(ztEffort.getObjectType())) {
                    ZtStory ztStory = ztStoryDAO.getBaseMapper().selectOne(
                            new QueryWrapper<ZtStory>().lambda().eq(ZtStory::getId, ztEffort.getObjectID())
                                    .eq(ZtStory::getDeleted, "0"));
                    workReportDetailVO.setReport_source("PROJECT");
                    workReportDetailVO.setReport_type("16");//设置为事务
                    if (ztStory != null && ztStory.getProduct() != 0) {
                        workReportDetailVO.setBelong_project("zt_product_" + ztStory.getProduct());
                        if (projectMap.containsKey("zt_product_" + ztStory.getProduct())) {
                            workReportDetailVO.setBelong_project_name(projectMap.get("zt_product_" + ztStory.getProduct()).getProject_name());
                        }
                    } else {
                        workReportDetailVO.setBelong_project_name("");
                        workReportDetailVO.setBelong_project("");
                    }
                } else if ("productplan".equals(ztEffort.getObjectType())) {
                    ZtProductplan ztProductplan = ztProductplanDAO.getBaseMapper().selectOne(
                            new QueryWrapper<ZtProductplan>().lambda().eq(ZtProductplan::getId, ztEffort.getObjectID())
                                    .eq(ZtProductplan::getDeleted, "0"));
                    workReportDetailVO.setReport_source("PROJECT");
                    workReportDetailVO.setReport_type("16");//设置为事务
                    if (ztProductplan != null && ztProductplan.getProduct() != 0) {
                        workReportDetailVO.setBelong_project("zt_product_" + ztProductplan.getProduct());
                        if (projectMap.containsKey("zt_product_" + ztProductplan.getProduct())) {
                            workReportDetailVO.setBelong_project_name(projectMap.get("zt_product_" + ztProductplan.getProduct()).getProject_name());
                        }
                    } else {
                        workReportDetailVO.setBelong_project_name("");
                        workReportDetailVO.setBelong_project("");
                    }

                } else if ("custom".equals(ztEffort.getObjectType())) {
                    workReportDetailVO.setReport_source("OTHER");
                    workReportDetailVO.setReport_type("16");//设置为事务
                } else if ("bug".equals(ztEffort.getObjectType())) {
                    workReportDetailVO.setReport_source("PROJECT");
                    workReportDetailVO.setReport_type("7");//设置为bug处理
                    if (ztEffort.getProject() != null && ztEffort.getProject() != 0) {
                        workReportDetailVO.setBelong_project("zt_project_" + ztEffort.getProject());

                        if (projectMap.containsKey("zt_project_" + ztEffort.getProject())) {
                            workReportDetailVO.setBelong_project_name(projectMap.get("zt_project_" + ztEffort.getProject()).getProject_name());
                        }
                    } else {
                        workReportDetailVO.setBelong_project_name("");
                        workReportDetailVO.setBelong_project("");
                    }
                }


                workReportDetailVO.setZentao_effort_id(ztEffort.getId().toString());
                workReportDetailVO.setEmployee_no(employee.getEmployee_no());
                workReportDetailVO.setEmail(employee.getEmail());
                workReportDetailVO.setReport_date(ztEffort.getDate());
                workReportDetailVO.setReport_frequency(employee.getReport_frequency());
                workReportDetailVO.setFrom_zentao(true);
                workReportDetailVO.setActual_hour(new BigDecimal(Float.toString(ztEffort.getConsumed())).setScale(2, BigDecimal.ROUND_DOWN));
                workReportDetailVO.setUnfinished_hour(new BigDecimal(Float.toString(ztEffort.getLeft())).setScale(2, BigDecimal.ROUND_DOWN));

                workReportDetailVO.setWork_content(ztEffort.getWork());

                workReportDetailVO.setStatus("3");

                LambdaQueryWrapper<WorkReportDetail> queryWrapper = new LambdaQueryWrapper<>();
                queryWrapper.eq(WorkReportDetail::getEmployee_no, employee.getEmployee_no());
                queryWrapper.eq(WorkReportDetail::getZentao_effort_id, ztEffort.getId());
                queryWrapper.eq(WorkReportDetail::getTenantsid, LoginUserUtils.getTenantSid());
                WorkReportDetail workInfo = workReportDetailDAO.getBaseMapper().selectOne(queryWrapper);
                if (workInfo != null) {
                    if ("3".equals(workInfo.getStatus())) {
                        WorkReportDetailVO workVO1 = new WorkReportDetailVO();
                        BeanUtils.copyProperties(workInfo, workVO1);
                        workVO1.setReport_frequency(employee.getReport_frequency());
                        workVO1.setEmail(employee.getEmail());
                        workVO1.setFrom_zentao(false);
                        if (com.digiwin.athena.dtdapp.util.StringUtils.isNotEmpty(workInfo.getBelong_project())) {
                            //这边for循环里多次查project表，也是可以优化的
                            Project project = projectDAO.getBaseMapper().selectOne(new LambdaQueryWrapper<Project>().eq(Project::getProject_code, workInfo.getBelong_project())
                                    .eq(Project::getTenantsid, LoginUserUtils.getTenantSid()));
                            workVO1.setBelong_project_name(project.getProject_name());
                        } else {
                            workVO1.setBelong_project_name("");
                            workVO1.setBelong_project("");
                        }
                        workReportDetailVOList.add(workVO1);
                    }
                } else {
                    workReportDetailVOList.add(workReportDetailVO);
                }

            }
            LambdaQueryWrapper<WorkReportDetail> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(WorkReportDetail::getEmployee_no, employee.getEmployee_no());
            queryWrapper.eq(WorkReportDetail::getTenantsid, LoginUserUtils.getTenantSid());
            queryWrapper.eq(WorkReportDetail::getStatus, "3");
            queryWrapper.in(WorkReportDetail::getReport_date, reportDetailDTO.getReport_date_list());
            queryWrapper.eq(WorkReportDetail::getFrom_zentao, false);
            List<WorkReportDetail> workReportDetails = workReportDetailDAO.getBaseMapper().selectList(queryWrapper);
            for (WorkReportDetail workReportDetail : workReportDetails) {
                WorkReportDetailVO workVO1 = new WorkReportDetailVO();
                BeanUtils.copyProperties(workReportDetail, workVO1);
                workVO1.setReport_frequency(employee.getReport_frequency());
                workVO1.setEmail(employee.getEmail());
                workVO1.setFrom_zentao(false);
                if (com.digiwin.athena.dtdapp.util.StringUtils.isNotEmpty(workReportDetail.getBelong_project())) {
                    //这边for循环里多次查project表，也是可以优化的
                    Project project = projectDAO.getBaseMapper().selectOne(new LambdaQueryWrapper<Project>().eq(Project::getProject_code, workReportDetail.getBelong_project())
                            .eq(Project::getTenantsid, LoginUserUtils.getTenantSid()));
                    workVO1.setBelong_project_name(project.getProject_name());
                } else {
                    workVO1.setBelong_project_name("");
                    workVO1.setBelong_project("");
                }
                workReportDetailVOList.add(workVO1);
            }

        }

        return workReportDetailVOList;
    }

    public Map<String, Object> getSupplementaryWorkReport(Map map) throws DWException {
        JSONObject obj = JSON.parseObject(JSON.toJSONString(map));
        String email = obj.getJSONObject("std_data").getJSONObject("parameter").getObject("email", String.class);
        JSONArray jsonArray = obj.getJSONObject("std_data").getJSONObject("parameter").getJSONArray("search_info");
        //获取分页数据
        Integer page = obj.getJSONObject("std_data").getJSONObject("parameter").getObject("page_no", Integer.class);
        Integer size = obj.getJSONObject("std_data").getJSONObject("parameter").getObject("page_size", Integer.class);
        Boolean use_has_next = obj.getJSONObject("std_data").getJSONObject("parameter").getObject("use_has_next", Boolean.class);
        HashMap<String, Object> stringObjectHashMap = new HashMap<>();
        List<WorkReportDetail> workReportDetails = new ArrayList<>();

        List<Project> projects = projectDAO.getBaseMapper().selectList(new LambdaQueryWrapper<Project>().eq(Project::getTenantsid, LoginUserUtils.getTenantSid()));
        Map<String, Project> projectMap = new HashMap<>();
        for (Project project : projects) {
            projectMap.put(project.getProject_code(), project);
        }
        List<WorkReportDetailVO> workReportDetailVOS = new ArrayList<>();
        Employee employee = getEmployeeByEmail(email);
        LambdaQueryWrapper<WorkReportDetail> queryWrapper1 = new LambdaQueryWrapper<>();
        queryWrapper1.eq(WorkReportDetail::getEmployee_no, employee.getEmployee_no())
                .eq(WorkReportDetail::getFrom_supplement, true)
                .eq(WorkReportDetail::getTenantsid, LoginUserUtils.getTenantSid());
        queryWrapper1.orderByDesc(WorkReportDetail::getReport_date);

        if (jsonArray != null && jsonArray.size() != 0) {
            List<SearchDTO> searchDTOS = JSON.parseArray(JSON.toJSONString(jsonArray), SearchDTO.class);

            String sql = "";
            for (SearchDTO searchDTO : searchDTOS) {
                switch (searchDTO.getSearch_field()) {

                    case "email":
                        searchDTO.setSearch_field("employee_no");
                        List<String> strings = new ArrayList<>();
                        strings.add(employee.getEmployee_no());
                        searchDTO.setSearch_value(strings);
                        sql = com.digiwin.athena.dtdapp.util.StringUtils.builderSQL(searchDTO, sql);
                        break;
                    default:
                        sql = com.digiwin.athena.dtdapp.util.StringUtils.builderSQL(searchDTO, sql);
                        break;
                }
            }
            queryWrapper1.eq(WorkReportDetail::getTenantsid, LoginUserUtils.getTenantSid());
            queryWrapper1.apply(sql);
        }
        queryWrapper1.orderByDesc(WorkReportDetail::getReport_date);
        if (use_has_next != null && use_has_next) {
            Page<WorkReportDetail> pages = new Page<>(page, size);
            Page<WorkReportDetail> workReportDetailPage = new Page<>(page, size);
            workReportDetailPage = workReportDetailDAO.getBaseMapper().selectPage(pages, queryWrapper1);
            workReportDetails = workReportDetailPage.getRecords();

            stringObjectHashMap.put("total_results", workReportDetailPage.getTotal());
            stringObjectHashMap.put("has_next", workReportDetailPage.hasNext());
        } else {
            workReportDetails = workReportDetailDAO.getBaseMapper().selectList(queryWrapper1);
        }

        for (WorkReportDetail workReportDetail : workReportDetails) {
            WorkReportDetailVO workReportDetailVO = new WorkReportDetailVO();
            BeanUtils.copyProperties(workReportDetail, workReportDetailVO);
            workReportDetailVO.setEmail(email);
            if (StringUtil.isNotEmpty(workReportDetail.getBelong_project())) {
                workReportDetailVO.setBelong_project_name(projectMap.get(workReportDetailVO.getBelong_project()).getProject_name());
            }
            workReportDetailVO.setEmployee_name(employee.getEmployee_name());
            workReportDetailVOS.add(workReportDetailVO);
        }

        stringObjectHashMap.put("work_report_info", workReportDetailVOS);
        return stringObjectHashMap;
    }
}

