package com.digiwin.athena.dtdapp.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.dtdapp.pojo.dto.zt.ZtUserDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@Service
public class ZentaoRestfulService {

    private final static String zenTaoAccount = "wumz";

    private final static String zenTaoUrl = "https://athena-devops-zentao.digiwincloud.com.cn";

    private final static String zenTaoPWD = "wmzwmz930523";


    @Autowired
    private RestTemplate restTemplate;

    private final static String ZENTAO_TOKEN = "/api.php/v1/tokens";

    private final static String ZENTAO_USER = "/api.php/v1/users/%s";

    private final static String ZENTAO_CREATE = "/api.php/v1/users";


    public String getZentaoToken() throws Exception{

        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json;charset=UTF-8");
        restTemplate.getMessageConverters().set(1,new StringHttpMessageConverter(StandardCharsets.UTF_8));

        Map<String, Object> requestMap = new HashMap<>();
        requestMap.put("account", zenTaoAccount);
        requestMap.put("password", zenTaoPWD);
        HttpEntity<Map> requestEntity = new HttpEntity<>(requestMap, headers);
        ResponseEntity<String> resEntity = restTemplate.exchange(zenTaoUrl + ZENTAO_TOKEN, HttpMethod.POST, requestEntity, String.class);
        if(Objects.nonNull(resEntity.getBody())) {
            JSONObject loginJsonObject = JSON.parseObject(resEntity.getBody());
            if(Objects.nonNull(loginJsonObject) && Objects.nonNull(loginJsonObject.getString("token"))){
                return loginJsonObject.getString("token");
            }
        }
        return "";
    }

    public Object zenTaoUserOperat(HttpMethod httpMethod, String token, ZtUserDTO ztUserDTO){
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json;charset=UTF-8");
        headers.add("token", token);
        restTemplate.getMessageConverters().set(1,new StringHttpMessageConverter(StandardCharsets.UTF_8));

        if(HttpMethod.GET.equals(httpMethod)) {
            Map<String, Object> requestMap = new HashMap<>();
            HttpEntity<Map> requestEntity = new HttpEntity<>(requestMap, headers);

            ResponseEntity<String> resEntity = restTemplate.exchange(String.format(zenTaoUrl + ZENTAO_USER, ztUserDTO.getId().toString()), HttpMethod.GET, requestEntity, String.class);
            if(Objects.nonNull(resEntity.getBody())) {
                JSONObject data = JSON.parseObject(resEntity.getBody());
                if(Objects.nonNull(data) ){
                    return data;
                }
            }
        }else if(HttpMethod.PUT.equals(httpMethod)) {
            Map<String, Object> requestMap = new HashMap<>();
            HttpEntity<Map> requestEntity = new HttpEntity<>(requestMap, headers);
            requestMap.put("dept",ztUserDTO.getDept());
            ResponseEntity<String> resEntity = restTemplate.exchange(String.format(zenTaoUrl + ZENTAO_USER,ztUserDTO.getId().toString()), HttpMethod.PUT, requestEntity, String.class);
            if(Objects.nonNull(resEntity.getBody())) {
                JSONObject data = JSON.parseObject(resEntity.getBody());
                if(Objects.nonNull(data) ){
                    return data;
                }
            }
        }
        return null;
    }


    public Object zenTaoUserCreate(String token, ZtUserDTO ztUserDTO){
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json;charset=UTF-8");
        headers.add("token", token);
        restTemplate.getMessageConverters().set(1,new StringHttpMessageConverter(StandardCharsets.UTF_8));

        Map<String, Object> requestMap = new HashMap<>();
        HttpEntity<Map> requestEntity = new HttpEntity<>(requestMap, headers);
        requestMap.put("account",ztUserDTO.getAccount());
        requestMap.put("password",ztUserDTO.getPassword());
        requestMap.put("realname",ztUserDTO.getRealname());
        ResponseEntity<String> resEntity = restTemplate.exchange(zenTaoUrl + ZENTAO_CREATE, HttpMethod.POST, requestEntity, String.class);

        if(Objects.nonNull(resEntity.getBody())) {
                JSONObject data = JSON.parseObject(resEntity.getBody());
                if(Objects.nonNull(data) ){
                    return data;
                }
        }
        return null;
    }
}
