package com.digiwin.athena.dtdapp.service;

import com.alibaba.excel.EasyExcel;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.digiwin.athena.dtdapp.pojo.constants.Constant;
import com.digiwin.athena.dtdapp.dao.zentao.*;
import com.digiwin.athena.dtdapp.pojo.entity.zentao.*;
import com.digiwin.athena.dtdapp.pojo.enums.KanBanStatus;
import com.digiwin.athena.dtdapp.pojo.vo.ztkanban.*;
import com.google.common.collect.Lists;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

@Service
@Slf4j
public class ZtKanBanService {

    @Autowired
    private ZtProjectDAO ztProjectDAO;
    @Autowired
    private ZtProjectStoryDAO ztProjectStoryDAO;
    @Autowired
    private ZtTaskDAO ztTaskDAO;
    @Autowired
    private ZtBugDAO ztBugDAO;
    @Autowired
    private ZtStoryDAO ztStoryDAO;
    @Autowired
    private ZtProductDAO ztProductDAO;
    @Autowired
    private ZtModuleDAO ztModuleDAO;
    @Autowired
    private ZtProductplanDAO ztProductplanDAO;
    @Autowired
    private ZtUserDAO ztUserDAO;
    @Autowired
    private ZtDeptDAO ztDeptDAO;

    private static int compareValuesDate(LocalDate value1, LocalDate value2, String sortOrder) {
        if (value1 == null && value2 == null) return 0;
        if (value1 == null) return 1;
        if (value2 == null) return -1;
        if (StringUtils.isEmpty(sortOrder)) {
            return 0;
        } else if ("ascend".equals(sortOrder)) {
            return value1.compareTo(value2);
        } else if ("descend".equals(sortOrder)) {
            return value2.compareTo(value1);
        } else {
            return 0;
        }
    }

    private static int compareValuesInt(int value1, int value2, String sortOrder) {
        if (StringUtils.isEmpty(sortOrder)) {
            return 0;
        } else if ("ascend".equals(sortOrder)) {
            return Integer.compare(value1, value2);
        } else if ("descend".equals(sortOrder)) {
            return Integer.compare(value2, value1);
        } else {
            return 0;
        }
    }

    private static int compareValuesFloat(Float value1, Float value2, String sortOrder) {
        if (StringUtils.isEmpty(sortOrder)) {
            return 0;
        } else if ("ascend".equals(sortOrder)) {
            return Float.compare(value1, value2);
        } else if ("descend".equals(sortOrder)) {
            return Float.compare(value2, value1);
        } else {
            return 0;
        }
    }

    public List<ZtProjectLevelVO> getProgramLevel() {
        List<String> programIds = new ArrayList<>();
        programIds.add("394900");
        return getProgramsWithLevels(programIds);
    }

    private List<ZtProjectLevelVO> getProgramsWithLevels(List<String> programIds) {
        List<ZtProjectLevelVO> programs = new ArrayList<>();
        List<ZtProject> ztProjects = ztProjectDAO.getBaseMapper().selectList(new LambdaQueryWrapper<ZtProject>()
                .in(ZtProject::getParent, programIds)
                .eq(ZtProject::getDeleted, "0"));
        for (ZtProject project : ztProjects) {
            if ("program".equals(project.getType())) {
                List<ZtProject> childProjects = ztProjectDAO.getBaseMapper().selectList(new LambdaQueryWrapper<ZtProject>()
                        .eq(ZtProject::getParent, project.getId().toString())
                        .eq(ZtProject::getType, "program")
                        .eq(ZtProject::getDeleted, "0"));
                ZtProjectLevelVO projectLevelVO = new ZtProjectLevelVO();
                projectLevelVO.setId(project.getId());
                projectLevelVO.setName(project.getName());
                projectLevelVO.setChildren(convertToProjectLevelVOs(childProjects));
                programs.add(projectLevelVO);
                if (!(childProjects.isEmpty() || !hasProgramChild(childProjects))) {

                    for (ZtProjectLevelVO ztProjectLevelVO : projectLevelVO.getChildren()) {
                        List<String> collect = new ArrayList<>();
                        collect.add(ztProjectLevelVO.getId().toString());
                        ztProjectLevelVO.setChildren(getProgramsWithLevels(collect));
                    }
                }
            }
        }
        return programs;
    }

    private List<ZtProjectLevelVO> convertToProjectLevelVOs(List<ZtProject> projects) {
        List<ZtProjectLevelVO> projectLevelVOs = new ArrayList<>();
        for (ZtProject project : projects) {
            ZtProjectLevelVO projectLevelVO = new ZtProjectLevelVO();
            projectLevelVO.setId(project.getId());
            projectLevelVO.setName(project.getName());
            projectLevelVOs.add(projectLevelVO);
        }
        return projectLevelVOs;
    }

    private List<ZtProject> getProgram1(List<String> programIds) {
        List<String> programIds2 = new ArrayList<>();
        List<ZtProject> programs = new ArrayList<>();
        for (String programId : programIds) {
            ZtProject program = ztProjectDAO.getBaseMapper().selectOne(new LambdaQueryWrapper<ZtProject>()
                    .in(ZtProject::getId, programId)
                    .eq(ZtProject::getDeleted, "0"));

            List<ZtProject> ztProjects = ztProjectDAO.getBaseMapper().selectList(new LambdaQueryWrapper<ZtProject>()
                    .eq(ZtProject::getParent, program.getId())
                    .eq(ZtProject::getDeleted, "0"));
            for (ZtProject project : ztProjects) {
                if ("program".equals(project.getType())) {
                    List<ZtProject> childProjects = ztProjectDAO.getBaseMapper().selectList(new LambdaQueryWrapper<ZtProject>()
                            .eq(ZtProject::getParent, project.getId().toString())
                            .eq(ZtProject::getDeleted, "0"));
                    if (childProjects.isEmpty() || !hasProgramChild(childProjects)) {
                        programs.add(project);
                    } else {
                        programIds2.add(project.getId().toString());
                    }
                } else if ("project".equals(project.getType())) {
                    programs.add(program);
                    break;
                }
            }
            if (!programIds2.isEmpty()) {
                programs.addAll(getProgram1(programIds2));
            }
        }
        return programs;
    }

    private boolean hasProgramChild(List<ZtProject> projects) {
        for (ZtProject project : projects) {
            if ("program".equals(project.getType())) {
                return true;
            }
        }
        return false;
    }

    public List<ZtProject> getProjectByProgramAndType(String id, String type, Boolean isShowAll) {
        List<Integer> ids = new ArrayList<>();
        List<ZtProject> program = getProgram(id);
        ids = program.stream().map(a -> a.getId()).collect(Collectors.toList());

        List<ZtProject> ztProjects = ztProjectDAO.getBaseMapper().selectList(new LambdaQueryWrapper<ZtProject>().in(ZtProject::getParent, ids)
                .eq(ZtProject::getType, type)
                .eq(ZtProject::getDeleted, "0")
                .ne(!isShowAll, ZtProject::getStatus, "closed"));
        return ztProjects;
    }

    private List<ZtProject> getProgram(String id) {
        List<String> programIds = new ArrayList<>();
        if (StringUtils.isEmpty(id)) {
            id = "4004";
        }
        programIds.add(id);
        return getProgram1(programIds);
    }

    private Comparator<ZtProjectVO> createComparator1(String begin_sort, String end_sort, String total_demand_sort,
                                                      String completed_demand_sort, String residue_sort) {
        return (p1, p2) -> {
            LocalDate date1 = null;
            LocalDate date2 = null;
            if (StringUtils.isNotEmpty(p1.getBegin())) {
                date1 = LocalDate.parse(p1.getBegin());
            }
            if (StringUtils.isNotEmpty(p2.getBegin())) {
                date2 = LocalDate.parse(p2.getBegin());
            }
            int beginComparison = compareValuesDate(date1, date2, begin_sort);
            if (beginComparison != 0) return beginComparison;
            LocalDate endDate1 = null;
            LocalDate endDate2 = null;
            if (StringUtils.isNotEmpty(p1.getEnd())) {
                endDate1 = LocalDate.parse(p1.getEnd());
            }
            if (StringUtils.isNotEmpty(p2.getEnd())) {
                endDate2 = LocalDate.parse(p2.getEnd());
            }

            int endComparison = compareValuesDate(endDate1, endDate2, end_sort);
            if (endComparison != 0) return endComparison;

            int totalDemandComparison = compareValuesInt(p1.getTotal_demand(), p2.getTotal_demand(), total_demand_sort);
            if (totalDemandComparison != 0) return totalDemandComparison;

            int completedDemandComparison = compareValuesInt(p1.getCompleted_demand(), p2.getCompleted_demand(), completed_demand_sort);
            if (completedDemandComparison != 0) return completedDemandComparison;


            int residueSortComparison = compareValuesInt(p1.getResidue(), p2.getResidue(), residue_sort);
            if (residueSortComparison != 0) return residueSortComparison;

            return 0;
        };
    }

    public PageVO<ZtProjectVO> getProjectByProgramAndProject(String projectId, Integer page, Integer size, Boolean isShowAll,
                                                             String begin_sort, String end_sort, String total_demand_sort,
                                                             String completed_demand_sort, String residue_sort) {

        //获取层级为4的项目
        List<ZtProject> grade4Project = getGrade4Project(projectId);
        if (!isShowAll) {
            grade4Project = grade4Project.stream()
                    .filter(project -> !"closed".equals(project.getStatus()))
                    .collect(Collectors.toList());
        }
        //排序


        PageVO<ZtProjectVO> pageVO = new PageVO();
        pageVO.setPage(page.longValue());
        pageVO.setSize(size.longValue());
        pageVO.setTotal(new Integer(grade4Project.size()).longValue());
        pageVO.setHasNext((int) Math.ceil((double) pageVO.getTotal() / pageVO.getSize()) > pageVO.getPage());

        List<ZtProjectVO> ztProjectVOS = new ArrayList<>();
        for (ZtProject ztProject : grade4Project) {
            ZtProjectVO ztProjectVO = new ZtProjectVO();
            BeanUtils.copyProperties(ztProject, ztProjectVO);
            LocalDate now = LocalDate.now();
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            if ("wait".equals(ztProjectVO.getStatus()) || "doing".equals(ztProjectVO.getStatus())) {
                LocalDate end = LocalDate.parse(ztProjectVO.getEnd(), dateTimeFormatter);
                boolean before = now.isAfter(end);
                if (before) {
                    ztProjectVO.setStatus("extension");
                }
            }
            List<ZtProject> sprints = ztProjectDAO.getProjectByProgramAndType(ztProjectVO.getId().toString(), "sprint");
            for (ZtProject sprint : sprints) {
                if ("wait".equals(sprint.getStatus()) || "doing".equals(sprint.getStatus())) {
                    LocalDate end = LocalDate.parse(sprint.getEnd(), dateTimeFormatter);
                    boolean before = now.isAfter(end);
                    if (before) {
                        sprint.setStatus("extension");
                    }
                }
            }
            List<ZtStory> ztStories = ztStoryDAO.getProjectDemandByProjectId(ztProject.getId());
            Long closedCount = ztStories.stream().filter(ztStory -> "closed".equals(ztStory.getStatus())).count();
            Long activeCount = ztStories.stream().filter(ztStory -> "active".equals(ztStory.getStatus())).count();
            ztProjectVO.setTotal_demand(ztStories.size());
            ztProjectVO.setCompleted_demand(closedCount.intValue());
            ztProjectVO.setResidue(activeCount.intValue());
            ztProjectVO.setSprint_list(sprints);
            ztProjectVOS.add(ztProjectVO);
        }
        ztProjectVOS.sort(createComparator1(begin_sort, end_sort, total_demand_sort, completed_demand_sort, residue_sort));
        List<ZtProjectVO> subList = ztProjectVOS.stream().skip((page - 1) * size).limit(size).
                collect(Collectors.toList());
        pageVO.setProject(subList);
        return pageVO;
    }

    private List<ZtProject> getGrade4Project(String id) {
        List<ZtProject> resultProjectIds = new ArrayList<>();
        ZtProject project = ztProjectDAO.getBaseMapper().selectOne(new LambdaQueryWrapper<ZtProject>().eq(ZtProject::getId, id)
                .eq(ZtProject::getDeleted, "0"));
        if (project != null && "project".equals(project.getType())) {
            resultProjectIds.add(project);
            return resultProjectIds;
        }
        if (StringUtils.isEmpty(id)) {
            // 默认查数智方案研发中心
            id = "4004";
        }
        List<String> parentIds = new ArrayList<>();
        parentIds.add(id);

        List<ZtProject> program1 = getProgram1(parentIds);
        List<Integer> collect = program1.stream().map(a -> a.getId()).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(program1)) {
            List<ZtProject> ztProjects = ztProjectDAO.getBaseMapper().selectList(new LambdaQueryWrapper<ZtProject>().in(ZtProject::getParent, collect)
                    .eq(ZtProject::getDeleted, "0"));
            resultProjectIds.addAll(ztProjects);
        } else {
            List<ZtProject> ztProjects = ztProjectDAO.getBaseMapper().selectList(new LambdaQueryWrapper<ZtProject>().eq(ZtProject::getParent, id)
                    .eq(ZtProject::getDeleted, "0"));
            if (!CollectionUtils.isEmpty(ztProjects)) {
                resultProjectIds.addAll(ztProjects);
            }
        }
        return resultProjectIds;

    }


    public List<ZtProject> getSprintByProgramAndType(List<String> ids, String sprint, Boolean isShowAll) {
        ArrayList<ZtProject> returnZtProjects = new ArrayList<>();
        if (CollectionUtils.isEmpty(ids)) {
            ids.add("4004");
        }
        for (String id : ids) {

            List<ZtProject> grade4Project = getGrade4Project(id);
            if (!isShowAll) {
                grade4Project = grade4Project.stream()
                        .filter(project -> !"closed".equals(project.getStatus()))
                        .collect(Collectors.toList());
            }

            List<String> projectIds = grade4Project.stream().map(a -> a.getId().toString()).collect(Collectors.toList());
            List<ZtProject> ztProjects = ztProjectDAO.getBaseMapper().selectList(new LambdaQueryWrapper<ZtProject>().select(ZtProject::getId, ZtProject::getName)
                    .in(ZtProject::getParent, projectIds)
                    .eq(ZtProject::getDeleted, "0")
                    .eq(ZtProject::getType, sprint));
            returnZtProjects.addAll(ztProjects);
        }
        return returnZtProjects;
    }

    private Comparator<ZtStoryVO> createComparator2(String id_sort, String plan_end_sort, String pri_sort,
                                                    String estimate_sort, String consumed_sort, String associated_tasks_number_sort,
                                                    String associated_bugs_number_sort) {
        return (p1, p2) -> {
            if (!StringUtils.isEmpty(id_sort)) {
                int idSortComparison = compareValuesInt(Integer.parseInt(p1.getId()), Integer.parseInt(p2.getId()), id_sort);
                if (idSortComparison != 0) return idSortComparison;
            }
            if (!StringUtils.isEmpty(plan_end_sort)) {
                LocalDate date1 = null;
                LocalDate date2 = null;
                if (StringUtils.isNotEmpty(p1.getPlan_end())) {
                    date1 = LocalDate.parse(p1.getPlan_end());
                }
                if (StringUtils.isNotEmpty(p2.getPlan_end())) {
                    date2 = LocalDate.parse(p2.getPlan_end());
                }
                int planEndComparison = compareValuesDate(date1, date2, plan_end_sort);
                if (planEndComparison != 0) return planEndComparison;
            }
            if (!StringUtils.isEmpty(pri_sort)) {
                int priComparison = compareValuesInt(Integer.parseInt(p1.getPri()), Integer.parseInt(p2.getPri()), pri_sort);
                if (priComparison != 0) return priComparison;
            }
            if (!StringUtils.isEmpty(estimate_sort)) {
                int estimateComparison = compareValuesInt(p1.getEstimate(), p2.getEstimate(), estimate_sort);
                if (estimateComparison != 0) return estimateComparison;
            }
            if (!StringUtils.isEmpty(consumed_sort)) {
                int consumedSortComparison = compareValuesFloat(p1.getConsumed(), p2.getConsumed(), consumed_sort);
                if (consumedSortComparison != 0) return consumedSortComparison;
            }
            if (!StringUtils.isEmpty(associated_bugs_number_sort)) {
                int associatedTasksNumberSortComparison = compareValuesInt(p1.getAssociated_tasks_number(), p2.getAssociated_tasks_number(), associated_tasks_number_sort);
                if (associatedTasksNumberSortComparison != 0) return associatedTasksNumberSortComparison;
            }
            if (!StringUtils.isEmpty(associated_bugs_number_sort)) {
                int associatedBugsNumberSortComparison = compareValuesInt(p1.getAssociated_bugs_number(), p2.getAssociated_bugs_number(), associated_bugs_number_sort);
                if (associatedBugsNumberSortComparison != 0) return associatedBugsNumberSortComparison;
            }
            return 0;
        };
    }

    public PageVO<ZtStoryVO> getStoryByProjectOrSprint(String programId, List<Integer> projectIds, String sprintId, Integer page, Integer size, Boolean isShowAll,String status
            , String id_sort, String plan_end_sort, String pri_sort, String estimate_sort, String consumed_sort,
                                                       String associated_tasks_sort, String associated_bugs_sort) {
        List<ZtStoryVO> ztStoryVOS = getStoryByProjectOrSprint(programId, projectIds, sprintId,isShowAll);
        switch (status){
            case "total" :
                break;
            case "completed":
                ztStoryVOS = ztStoryVOS.stream().filter(ztStoryVO -> ("closed".equals(ztStoryVO.getStage()) || "released".equals(ztStoryVO.getStage()))).collect(Collectors.toList());
                break;
            case "unfinished":
                ztStoryVOS = ztStoryVOS.stream().filter(ztStoryVO -> !("closed".equals(ztStoryVO.getStage()) || "released".equals(ztStoryVO.getStage()))).collect(Collectors.toList());
                break;
        }
        Integer storyCountByProjectId = ztStoryVOS.size();
        ztStoryVOS.sort(createComparator2(id_sort, plan_end_sort, pri_sort, estimate_sort, consumed_sort, associated_tasks_sort, associated_bugs_sort));
        List<ZtStoryVO> subList = ztStoryVOS.stream().skip((page - 1) * size).limit(size).
                collect(Collectors.toList());
        PageVO<ZtStoryVO> ztProjectVOPageVO = new PageVO<>();
        ztProjectVOPageVO.setPage(page.longValue());
        ztProjectVOPageVO.setSize(size.longValue());
        ztProjectVOPageVO.setProject(subList);
        ztProjectVOPageVO.setPage(page.longValue());
        ztProjectVOPageVO.setSize(size.longValue());
        ztProjectVOPageVO.setTotal(storyCountByProjectId.longValue());
        ztProjectVOPageVO.setHasNext((int) Math.ceil((double) ztProjectVOPageVO.getTotal() / ztProjectVOPageVO.getSize()) > ztProjectVOPageVO.getPage());
        return ztProjectVOPageVO;
    }

    private List<ZtStoryVO> getStoryByProjectOrSprint(String programId,List<Integer> projectIds,String sprintId,Boolean isShowAll){
        List<ZtStoryVO> ztStoryVOS = new ArrayList<>();
        List<Integer> sprintIds = new ArrayList<>();
        List<ZtProject> grade4Project;
        List<Integer> getProjectIds;
        List<ZtStory> storys = new ArrayList<>();
        Date sprintStart = null;
        Date sprintEnd = null;
        if (StringUtils.isEmpty(sprintId)) {
            if (CollectionUtils.isEmpty(projectIds)) {
                grade4Project = getGrade4Project(programId);
                if (!isShowAll) {
                    grade4Project = grade4Project.stream()
                            .filter(project -> !"closed".equals(project.getStatus()))
                            .collect(Collectors.toList());
                }
                //获取项目id
                getProjectIds = grade4Project.stream().map(t -> t.getId()).collect(Collectors.toList());
                List<ZtProject> ztProjects = ztProjectDAO.getBaseMapper().selectList(new LambdaQueryWrapper<ZtProject>().in(ZtProject::getParent, getProjectIds)
                        .eq(ZtProject::getDeleted, "0"));
                sprintIds.addAll(getProjectIds);
                sprintIds.addAll(ztProjects.stream().map(a -> a.getId()).collect(Collectors.toList()));

            } else {
                sprintIds.addAll(projectIds);
            }
        } else {
            List<ZtProject> ztProjects = ztProjectDAO.getBaseMapper().selectList(new LambdaQueryWrapper<ZtProject>()
                    .select(ZtProject::getId,ZtProject::getRealBegan,ZtProject::getRealEnd)
                    .in(ZtProject::getId, sprintId)
                    .eq(ZtProject::getDeleted, "0")
                    .eq(ZtProject::getType, "sprint"));
            sprintIds = ztProjects.stream().map(t -> t.getId()).collect(Collectors.toList());
            sprintStart = ztProjects.get(0).getRealBegan();
            sprintEnd = ztProjects.get(0).getRealEnd();
        }

        List<ZtProjectStory> ztProjectStories = ztProjectStoryDAO.getBaseMapper().selectList(new LambdaQueryWrapper<ZtProjectStory>()
                .select(ZtProjectStory::getProject, ZtProjectStory::getStory)
                .in(ZtProjectStory::getProject, sprintIds));
        List<Integer> storyIds = ztProjectStories.stream().map(a -> a.getStory()).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(storyIds)) {
            storys = ztProjectStoryDAO.getStoryByProjectId(storyIds);
        }


        // 获取所有 task
        List<ZtTask> allZtTasks;
        // 获取相关 bug
        List<ZtBug> allZtBugs;
        if (!CollectionUtils.isEmpty(storys)) {
            if(!StringUtils.isEmpty(sprintId)) {
                allZtTasks = ztTaskDAO.getBaseMapper().selectList(new LambdaQueryWrapper<ZtTask>()
                        .select(ZtTask::getId, ZtTask::getConsumed, ZtTask::getLeft, ZtTask::getStatus, ZtTask::getStory)
                        .in(ZtTask::getStory, storyIds)
                        .eq(ZtTask::getDeleted, "0")
                        .eq(ZtTask::getExecution,sprintId));
                allZtBugs = ztBugDAO.getBaseMapper().selectList(new LambdaQueryWrapper<ZtBug>()
                        .select(ZtBug::getId, ZtBug::getStory, ZtBug::getStatus)
                        .in(ZtBug::getStory, storyIds)
                        .ge(ZtBug::getExecution,sprintId));
            }else {
                allZtTasks = ztTaskDAO.getBaseMapper().selectList(new LambdaQueryWrapper<ZtTask>()
                        .select(ZtTask::getId, ZtTask::getConsumed, ZtTask::getLeft, ZtTask::getStatus, ZtTask::getStory)
                        .in(ZtTask::getStory, storyIds)
                        .eq(ZtTask::getDeleted, "0"));
                allZtBugs = ztBugDAO.getBaseMapper().selectList(new LambdaQueryWrapper<ZtBug>()
                        .select(ZtBug::getId, ZtBug::getStory, ZtBug::getStatus)
                        .in(ZtBug::getStory, storyIds)
                        .ge(ZtBug::getExecution,sprintId));
            }
        } else {
            allZtTasks = new ArrayList<>();
            allZtBugs = new ArrayList<>();
        }

        Map<String, List<ZtTask>> ztTaskMap = allZtTasks.stream()
                .filter(task -> task.getStory()!= null)
                .collect(Collectors.groupingBy(task -> task.getStory().toString()));

        Map<String, List<ZtBug>> ztBugMap = allZtBugs.stream()
                .filter(ztBug -> ztBug.getStory()!= null)
                .collect(Collectors.groupingBy(bug -> bug.getStory().toString()));

        // 获取所有产品、模块、计划、负责人
        List<ZtProduct> allZtProducts = ztProductDAO.getBaseMapper().selectList(new LambdaQueryWrapper<ZtProduct>()
                .select(ZtProduct::getId, ZtProduct::getName));
        Map<Integer, ZtProduct> ztProductMap = allZtProducts.stream().collect(Collectors.toMap(product -> product.getId(), product -> product));

        List<ZtModule> allZtModules = ztModuleDAO.getBaseMapper().selectList(new LambdaQueryWrapper<ZtModule>()
                .select(ZtModule::getId, ZtModule::getName));
        Map<Integer, ZtModule> ztModuleMap = allZtModules.stream().collect(Collectors.toMap(ztModule -> ztModule.getId(), ztModule -> ztModule));

        List<ZtProductplan> allZtProductplans = ztProductplanDAO.getBaseMapper().selectList(new LambdaQueryWrapper<ZtProductplan>()
                .select(ZtProductplan::getId, ZtProductplan::getEnd));
        Map<String, ZtProductplan> ztProductplanMap = allZtProductplans.stream().collect(Collectors.toMap(ztProductplan -> ztProductplan.getId(), ztProductplan -> ztProductplan));

        List<ZtUser> allZtUsers = ztUserDAO.getBaseMapper().selectList(new LambdaQueryWrapper<ZtUser>()
                .select(ZtUser::getId, ZtUser::getAccount, ZtUser::getRealname));
        Map<String, ZtUser> ztUserMap = allZtUsers.stream().collect(Collectors.toMap(ztUser -> ztUser.getAccount(), ztUser -> ztUser));

        // 使用流处理故事列表，直接在原对象上进行修改，避免创建新的对象
        return storys.stream().map(story -> {
            ZtStoryVO ztStoryVO = new ZtStoryVO();
            BeanUtils.copyProperties(story, ztStoryVO);

            // 获取相关 task
            List<ZtTask> getZtTasks = ztTaskMap.getOrDefault(story.getId(), new ArrayList<>());
            double consumedSum = getZtTasks.stream().collect(Collectors.summingDouble(ZtTask::getConsumed));
            double leftSum = getZtTasks.stream().collect(Collectors.summingDouble(ZtTask::getLeft));
            ztStoryVO.setConsumed((float) consumedSum);
            ztStoryVO.setLeft((float) leftSum);
            ztStoryVO.setAssociated_tasks_number(getZtTasks.size());
            Long completed_tasks_number = getZtTasks.stream()
                    .filter(task -> "done".equals(task.getStatus().getValue()) || "closed".equals(task.getStatus().getValue()))
                    .count();
            ztStoryVO.setCompleted_tasks_number(completed_tasks_number.intValue());

            // 获取相关 bug
            List<ZtBug> getZtBugs = ztBugMap.getOrDefault(story.getId(), new ArrayList<>());
            ztStoryVO.setAssociated_bugs_number(getZtBugs.size());
            Long completed_bugs_number = getZtBugs.stream()
                    .filter(bug -> "resolved".equals(bug.getStatus()) || "closed".equals(bug.getStatus()))
                    .count();
            ztStoryVO.setCompleted_bugs_number(completed_bugs_number.intValue());

            // 获取产品 id 对应的名称
            ZtProduct ztProduct = ztProductMap.get(ztStoryVO.getProduct());
            ztStoryVO.setProduct_name(ztProduct == null? "" : ztProduct.getName());

            // 获取模块 id 对应的名称
            ZtModule ztModule = ztModuleMap.get(ztStoryVO.getModule());
            ztStoryVO.setModule_name(ztModule == null? "" : ztModule.getName());

            // 获取计划结束时间
            ZtProductplan ztProductplan = ztProductplanMap.get(story.getPlan());
            ztStoryVO.setPlan_end(ztProductplan == null? null : ztProductplan.getEnd());

            // 负责人
            ZtUser ztUser = ztUserMap.get(story.getAssignedTo());
            ztStoryVO.setAssignedTo(ztUser == null? null : ztUser.getRealname());

            return ztStoryVO;
        }).collect(Collectors.toList());
    }

    public List<ZtProduct> getProductByProgram(String programId, Boolean isShowAll) {

        if (StringUtils.isEmpty(programId)) {
            programId = "4004";
        }

        List<ZtProject> projectList = getProjectByProgramAndType(programId, "project", isShowAll);
        List<Integer> projectIds = projectList.stream().map(project -> project.getId()).collect(Collectors.toList());

        List<ZtProduct> ztProducts = ztProductDAO.getProductByProject(projectIds);
        if (!isShowAll) {
            ztProducts = ztProducts.stream()
                    .filter(ztProduct -> !"closed".equals(ztProduct.getStatus()))
                    .collect(Collectors.toList());
        }
        return ztProducts;
    }


    public List<ZtModuleLevelVO> getModuleByProduct(String programId, String productId, Boolean isShowAll) {
        List<Integer> productIds = new ArrayList<>();
        //获取产品id
        if (StringUtils.isEmpty(productId)) {
            List<ZtProduct> productByProgram = getProductByProgram(programId, isShowAll);
            productIds = productByProgram.stream().map(a -> a.getId()).collect(Collectors.toList());
        } else {
            productIds.add(Integer.parseInt(productId));
        }

        List<ZtModule> ztModules = ztModuleDAO.getBaseMapper().selectList(new LambdaQueryWrapper<ZtModule>()
                .select(ZtModule::getId, ZtModule::getName, ZtModule::getParent)
                .in(ZtModule::getRoot, productIds)
                .eq(ZtModule::getType, "story")
                .eq(ZtModule::getDeleted, "0"));

        List<ZtModuleLevelVO> ztModuleLevelVOS = buildHierarchy(ztModules);

        return ztModuleLevelVOS;
    }

    private List<ZtModuleLevelVO> buildHierarchy(List<ZtModule> ztModules) {
        // 将 ZtModule 对象转换为 ZtModuleLevelVO 对象的映射
        Map<Integer, ZtModuleLevelVO> voMap = ztModules.stream()
                .map(module -> new ZtModuleLevelVO(module.getId(), module.getName(), module.getParent(), new ArrayList<ZtModuleLevelVO>()))
                .collect(Collectors.toMap(ZtModuleLevelVO::getId, vo -> vo));

        List<ZtModuleLevelVO> rootModules = new ArrayList<>();

        // 构建层级结构
        for (ZtModuleLevelVO vo : voMap.values()) {
            if (vo.getParent() == null || vo.getParent() == 0) {
                // 如果是根模块
                rootModules.add(vo);
            } else {
                ZtModuleLevelVO parentVO = voMap.get(vo.getParent());
                if (parentVO != null) {
                    if (CollectionUtils.isEmpty(parentVO.getChildren())) {
                        parentVO.setChildren(new ArrayList<>());
                    }
                    parentVO.getChildren().add(vo);
                }
            }
        }

        return rootModules;
    }

    public PageVO<ZtStoryVO> getStoryByProductOrModule(String programId, String productId, List<String> moduleIds, Integer page, Integer size, Boolean isShowAll,String status,
                                               String id_sort, String plan_end_sort, String pri_sort, String estimate_sort, String consumed_sort,
                                               String associated_tasks_sort, String associated_bugs_sort) {
        //List<ZtStory> storys;
        List<String> storyIds;
        // 模块 id 为空，获取所有产品 id 下的需求即可
        if (CollectionUtils.isEmpty(moduleIds)) {
            if (StringUtils.isEmpty(productId)) {
                List<ZtProduct> productByProgram = getProductByProgram(programId, isShowAll);
                List<Integer> productIds = productByProgram.stream().map(ZtProduct::getId).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(productIds)) {
                    return null;
                }
                storyIds = ztStoryDAO.getStoryIdByProductIds(productIds);
//                storys = ztStoryDAO.getBaseMapper().selectList(new LambdaQueryWrapper<ZtStory>()
//                        .select(ZtStory::getId)
//                        .in(ZtStory::getProduct, productIds)
//                        .eq(ZtStory::getDeleted, "0"));
            } else {
                int productIdInt = Integer.parseInt(productId);
                List<Integer> productIds = new ArrayList<>();
                productIds.add(productIdInt);
                storyIds = ztStoryDAO.getStoryIdByProductIds(productIds);
//                storys = ztStoryDAO.getBaseMapper().selectList(new LambdaQueryWrapper<ZtStory>()
//                        .select(ZtStory::getId)
//                        .eq(ZtStory::getProduct, productIdInt)
//                        .eq(ZtStory::getDeleted, "0"));
            }
        } else {
            List<ZtModule> ztModules = ztModuleDAO.getBaseMapper().selectList(new LambdaQueryWrapper<ZtModule>()
                    .select(ZtModule::getId)
                    .in(ZtModule::getParent, moduleIds)
                    .eq(ZtModule::getDeleted, "0"));
            moduleIds.addAll(ztModules.stream().map(a -> a.getId().toString()).collect(Collectors.toList()));
            storyIds = ztStoryDAO.getStoryIdByModuleIds(moduleIds);
//            storys = ztStoryDAO.getBaseMapper().selectList(new LambdaQueryWrapper<ZtStory>()
//                    .select(ZtStory::getId)
//                    .in(ZtStory::getModule, moduleIds)
//                    .eq(ZtStory::getDeleted, "0"));
        }

        if (storyIds == null || storyIds.isEmpty()) {
            return null;
        }
        Integer page1 = (page-1)*size;
        Integer size1 = page*size;
      //  List<String> storyIds = storys.stream().map(s -> s.getId()).collect(Collectors.toList());

        //获取所有需求数量
        Long total = ztStoryDAO.getStoryByProductIdOrModuleIdSum(storyIds,status);
        List<ZtStoryVO> ztStoryVOS = ztStoryDAO.getStoryByProductIdOrModuleId(storyIds, id_sort, plan_end_sort, pri_sort, estimate_sort, consumed_sort, associated_tasks_sort, associated_bugs_sort, page1, size1,status);


        //ztStoryVOS.sort(createComparator2(id_sort, plan_end_sort, pri_sort, estimate_sort, consumed_sort, associated_tasks_sort, associated_bugs_sort));
        //List<ZtStoryVO> subList = ztStoryVOS.stream().skip((page - 1) * size).limit(size).
        //      collect(Collectors.toList());

        PageVO<ZtStoryVO> ztProjectVOPageVO = new PageVO<>();
        ztProjectVOPageVO.setPage(page.longValue());
        ztProjectVOPageVO.setSize(size.longValue());
        ztProjectVOPageVO.setProject(ztStoryVOS);
        ztProjectVOPageVO.setTotal(total);
        ztProjectVOPageVO.setPage(page.longValue());
        ztProjectVOPageVO.setSize(ztProjectVOPageVO.getTotal() > size.longValue() ? size.longValue(): ztProjectVOPageVO.getTotal());
        ztProjectVOPageVO.setHasNext((int) Math.ceil((double) ztProjectVOPageVO.getTotal() / ztProjectVOPageVO.getSize()) > ztProjectVOPageVO.getPage());
        return ztProjectVOPageVO;
    }
//    private List<ZtStoryVO> getStoryByProductOrModule(String programId, String productId, List<String> moduleIds,Boolean isShowAll){
//        List<ZtStory> storys;
//        // 模块 id 为空，获取所有产品 id 下的需求即可
//        if (CollectionUtils.isEmpty(moduleIds)) {
//            if (StringUtils.isEmpty(productId)) {
//                List<ZtProduct> productByProgram = getProductByProgram(programId, isShowAll);
//                List<Integer> productIds = productByProgram.stream().map(ZtProduct::getId).collect(Collectors.toList());
//                if (CollectionUtils.isEmpty(productIds)) {
//                    return null;
//                }
//                storys = ztStoryDAO.getBaseMapper().selectList(new LambdaQueryWrapper<ZtStory>()
//                        .in(ZtStory::getProduct, productIds)
//                        .eq(ZtStory::getDeleted, "0"));
//            } else {
//                int productIdInt = Integer.parseInt(productId);
//                storys = ztStoryDAO.getBaseMapper().selectList(new LambdaQueryWrapper<ZtStory>()
//                        .eq(ZtStory::getProduct, productIdInt)
//                        .eq(ZtStory::getDeleted, "0"));
//            }
//        } else {
//            List<ZtModule> ztModules = ztModuleDAO.getBaseMapper().selectList(new LambdaQueryWrapper<ZtModule>()
//                    .select(ZtModule::getId)
//                    .in(ZtModule::getParent, moduleIds)
//                    .eq(ZtModule::getDeleted, "0"));
//
//            moduleIds.addAll(ztModules.stream().map(a -> a.getId().toString()).collect(Collectors.toList()));
//            storys = ztStoryDAO.getBaseMapper().selectList(new LambdaQueryWrapper<ZtStory>()
//                    .in(ZtStory::getModule, moduleIds)
//                    .eq(ZtStory::getDeleted, "0"));
//        }
//
//        if (storys == null || storys.isEmpty()) {
//            return null;
//        }
//
//        List<String> storyIds = storys.stream().map(s -> s.getId()).collect(Collectors.toList());
//        ztStoryDAO.getStoryByProductIdOrModuleId(storyIds)
//        // 获取所有 task
//        List<ZtTask> allZtTasks;
//        if (!CollectionUtils.isEmpty(storys)) {
//            allZtTasks = ztTaskDAO.getBaseMapper().selectList(new LambdaQueryWrapper<ZtTask>()
//                    .select(ZtTask::getId, ZtTask::getConsumed, ZtTask::getLeft, ZtTask::getStatus, ZtTask::getStory)
//                    .in(ZtTask::getStory, storyIds)
//                    .eq(ZtTask::getDeleted, "0"));
//        } else {
//            allZtTasks = new ArrayList<>();
//        }
//
//        Map<String, List<ZtTask>> ztTaskMap = allZtTasks.stream()
//                .filter(task -> task.getStory()!= null)
//                .collect(Collectors.groupingBy(task -> task.getStory().toString()));
//
//        // 获取相关 bug
//        List<ZtBug> allZtBugs;
//        if (!CollectionUtils.isEmpty(storys)) {
//            allZtBugs = ztBugDAO.getBaseMapper().selectList(new LambdaQueryWrapper<ZtBug>()
//                    .select(ZtBug::getId, ZtBug::getStory, ZtBug::getStatus)
//                    .in(ZtBug::getStory, storyIds));
//        } else {
//            allZtBugs = new ArrayList<>();
//        }
//
//        Map<String, List<ZtBug>> ztBugMap = allZtBugs.stream()
//                .filter(ztBug -> ztBug.getStory()!= null)
//                .collect(Collectors.groupingBy(bug -> bug.getStory().toString()));
//
//        // 获取所有产品、模块、计划、负责人
//        List<ZtProduct> allZtProducts = ztProductDAO.getBaseMapper().selectList(new LambdaQueryWrapper<ZtProduct>()
//                .select(ZtProduct::getId, ZtProduct::getName));
//        Map<Integer, ZtProduct> ztProductMap = allZtProducts.stream().collect(Collectors.toMap(product -> product.getId(), product -> product));
//
//        List<ZtModule> allZtModules = ztModuleDAO.getBaseMapper().selectList(new LambdaQueryWrapper<ZtModule>()
//                .select(ZtModule::getId, ZtModule::getName));
//        Map<Integer, ZtModule> ztModuleMap = allZtModules.stream().collect(Collectors.toMap(ztModule -> ztModule.getId(), ztModule -> ztModule));
//
//        List<ZtProductplan> allZtProductplans = ztProductplanDAO.getBaseMapper().selectList(new LambdaQueryWrapper<ZtProductplan>()
//                .select(ZtProductplan::getId, ZtProductplan::getEnd));
//        Map<String, ZtProductplan> ztProductplanMap = allZtProductplans.stream().collect(Collectors.toMap(ztProductplan -> ztProductplan.getId(), ztProductplan -> ztProductplan));
//
//        List<ZtUser> allZtUsers = ztUserDAO.getBaseMapper().selectList(new LambdaQueryWrapper<ZtUser>()
//                .select(ZtUser::getId, ZtUser::getAccount, ZtUser::getRealname));
//        Map<String, ZtUser> ztUserMap = allZtUsers.stream().collect(Collectors.toMap(ztUser -> ztUser.getAccount(), ztUser -> ztUser));
//
//        // 使用流处理故事列表，直接在原对象上进行修改，避免创建新的对象
//        return storys.stream().map(story -> {
//            ZtStoryVO ztStoryVO = new ZtStoryVO();
//            BeanUtils.copyProperties(story, ztStoryVO);
//
//            // 获取相关 task
//            List<ZtTask> getZtTasks = ztTaskMap.getOrDefault(story.getId(), new ArrayList<>());
//            double consumedSum = getZtTasks.stream().collect(Collectors.summingDouble(ZtTask::getConsumed));
//            double leftSum = getZtTasks.stream().collect(Collectors.summingDouble(ZtTask::getLeft));
//            ztStoryVO.setConsumed((float) consumedSum);
//            ztStoryVO.setLeft((float) leftSum);
//            ztStoryVO.setAssociated_tasks_number(getZtTasks.size());
//            Long completed_tasks_number = getZtTasks.stream()
//                    .filter(task -> "done".equals(task.getStatus().getValue()) || "closed".equals(task.getStatus().getValue()))
//                    .count();
//            ztStoryVO.setCompleted_tasks_number(completed_tasks_number.intValue());
//
//            // 获取相关 bug
//            List<ZtBug> getZtBugs = ztBugMap.getOrDefault(story.getId(), new ArrayList<>());
//            ztStoryVO.setAssociated_bugs_number(getZtBugs.size());
//            Long completed_bugs_number = getZtBugs.stream()
//                    .filter(bug -> "resolved".equals(bug.getStatus()) || "closed".equals(bug.getStatus()))
//                    .count();
//            ztStoryVO.setCompleted_bugs_number(completed_bugs_number.intValue());
//
//            // 获取产品 id 对应的名称
//            ZtProduct ztProduct = ztProductMap.get(ztStoryVO.getProduct());
//            ztStoryVO.setProduct_name(ztProduct == null? "" : ztProduct.getName());
//
//            // 获取模块 id 对应的名称
//            ZtModule ztModule = ztModuleMap.get(ztStoryVO.getModule());
//            ztStoryVO.setModule_name(ztModule == null? "" : ztModule.getName());
//
//            // 获取计划结束时间
//            ZtProductplan ztProductplan = ztProductplanMap.get(story.getPlan());
//            ztStoryVO.setPlan_end(ztProductplan == null? null : ztProductplan.getEnd());
//
//            // 负责人
//            ZtUser ztUser = ztUserMap.get(story.getAssignedTo());
//            ztStoryVO.setAssignedTo(ztUser == null? null : ztUser.getRealname());
//
//            return ztStoryVO;
//        }).collect(Collectors.toList());
//    }
    @SneakyThrows
    private HttpServletResponse getHttpServletResponse() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        HttpServletResponse response = ((ServletRequestAttributes) requestAttributes).getResponse();
        //设置编码格式
        response.setCharacterEncoding("utf-8");
        //设置导出文件名称（避免乱码）
        String fileName = URLEncoder.encode("项目详情表".concat(".xlsx"), "UTF-8");
        //设置内容类型
        response.setHeader("content-type", "application/octet-stream");
        //设置响应的编码格式
        response.setHeader("content-disposition",
                "attachment;filename=" + fileName);
        return response;
    }


    public void getProjectToExcel(String programId, Integer page, Integer size, Boolean isShowAll) {

        HttpServletResponse response = this.getHttpServletResponse();
        PageVO<ZtProjectVO> projectByProgramAndProject = getProjectByProgramAndProject(programId, page, size, isShowAll, null, null, null, null, null);
        ArrayList<ZtProjectExcelVO> ztProjectExcelVOS = new ArrayList<>();
        for (ZtProjectVO ztProjectVO : projectByProgramAndProject.getProject()) {
            ZtProjectExcelVO ztProjectExcelVO = new ZtProjectExcelVO();
            BeanUtils.copyProperties(ztProjectVO, ztProjectExcelVO);
            ztProjectExcelVO.setStatus(KanBanStatus.fromValue(ztProjectVO.getStatus()));
            if (!CollectionUtils.isEmpty(ztProjectVO.getSprint_list())) {
                for (ZtProject ztProject : ztProjectVO.getSprint_list()) {

                    ztProjectExcelVO.setSprint_name(ztProject.getName());
                    ztProjectExcelVO.setSprint_begin(ztProject.getBegin());
                    ztProjectExcelVO.setSprint_end(ztProject.getEnd());
                }
            }
            ztProjectExcelVOS.add(ztProjectExcelVO);
        }

        try {
            EasyExcel.write(response.getOutputStream(),
                    ZtProjectExcelVO.class).sheet("项目详情表").doWrite(ztProjectExcelVOS);
        } catch (Exception e) {
            log.info(e.getMessage());
        }

    }

    public void getStoryByProjectToExcel(String programId, List<Integer> projectId, String sprintId, Integer page, Integer size, Boolean isShowAll,String status) {
        HttpServletResponse response = this.getHttpServletResponse();


        PageVO<ZtStoryVO> ztStoryVOPageVO = getStoryByProjectOrSprint(programId, projectId, sprintId, page, size, isShowAll, status,null, null, null, null, null, null, null);
        ArrayList<ZtStoryExcelVO> ztStoryExcelVOS = new ArrayList<>();
        for (ZtStoryVO ztStoryVO : ztStoryVOPageVO.getProject()) {
            ZtStoryExcelVO ztStoryExcelVO = new ZtStoryExcelVO();
            BeanUtils.copyProperties(ztStoryVO, ztStoryExcelVO);
            ztStoryExcelVO.setStatus(KanBanStatus.fromValue(ztStoryVO.getStatus()));
            ztStoryExcelVO.setStage(KanBanStatus.fromValue(ztStoryVO.getStage()));
            ztStoryExcelVOS.add(ztStoryExcelVO);
        }
        try {
            EasyExcel.write(response.getOutputStream(),
                    ZtStoryExcelVO.class).sheet("项目需求表").doWrite(ztStoryExcelVOS);
        } catch (Exception e) {
            log.info(e.getMessage());
        }
    }

    public void getStoryByProductToExcel(String programId, String productId, List<String> moduleId, Integer page, Integer size, Boolean isShowAll,String status) {
        HttpServletResponse response = this.getHttpServletResponse();

        PageVO<ZtStoryVO> storyByProduct = getStoryByProductOrModule(programId, productId, moduleId, page, size, isShowAll, status,null, null, null, null, null, null, null);
        ArrayList<ZtStoryExcelVO> ztStoryExcelVOS = new ArrayList<>();
        for (ZtStoryVO ztStoryVO : storyByProduct.getProject()) {
            ZtStoryExcelVO ztStoryExcelVO = new ZtStoryExcelVO();
            BeanUtils.copyProperties(ztStoryVO, ztStoryExcelVO);
            ztStoryExcelVO.setStatus(KanBanStatus.fromValue(ztStoryVO.getStatus()));
            ztStoryExcelVO.setStage(KanBanStatus.fromValue(ztStoryVO.getStage()));
            ztStoryExcelVOS.add(ztStoryExcelVO);
        }
        try {
            EasyExcel.write(response.getOutputStream(),
                    ZtStoryExcelVO.class).sheet("产品需求表").doWrite(ztStoryExcelVOS);
        } catch (Exception e) {
            log.info(e.getMessage());
        }
    }

//    public DemandVO getDemandCompleteStatus(String programId, List<Integer> projectIds, String date) {
//        if (CollectionUtils.isEmpty(projectIds)) {
//            List<ZtProject> projectList = getProjectByProgramAndType(programId, "project", true);
//            List<Integer> ids = projectList.stream().map(project -> project.getId()).collect(Collectors.toList());
//            projectIds.addAll(ids);
//        }
//        LocalDate currentFirstDay = null;
//        LocalDate currentLastDay = null;
//        LocalDate nextMonthFirstDay = null;
//        LocalDate nextMonthLastDay = null;
//        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM");
//
//        try {
//            YearMonth yearMonth = YearMonth.parse(date, dateTimeFormatter);
//            currentFirstDay = yearMonth.atDay(1);
//            currentLastDay = yearMonth.atEndOfMonth();
//            nextMonthFirstDay = currentFirstDay.plusMonths(1);
//            nextMonthLastDay = nextMonthFirstDay.with(TemporalAdjusters.lastDayOfMonth());
//        } catch (Exception e) {
//            log.info(e.getMessage());
//        }
//        List<ZtProduct> ztProducts = ztProductDAO.getProductByProject(projectIds);
//        List<Integer> ztProductIds = ztProducts.stream().map(ztProduct -> ztProduct.getId()).collect(Collectors.toList());
//        List<ZtProductplan> currentZtProductPlans = ztProductplanDAO.getBaseMapper().selectList(new LambdaQueryWrapper<ZtProductplan>()
//                .select(ZtProductplan::getId, ZtProductplan::getTitle, ZtProductplan::getEnd)
//                .between(ZtProductplan::getEnd, currentFirstDay, currentLastDay)
//                .in(ZtProductplan::getProduct, ztProductIds)
//                .eq(ZtProductplan::getDeleted, "0"));
//
//        List<String> currentZtProductPlanIds = currentZtProductPlans.stream().map(z -> z.getId()).collect(Collectors.toList());
//
//        List<ZtProductplan> nextZtProductPlans = ztProductplanDAO.getBaseMapper().selectList(new LambdaQueryWrapper<ZtProductplan>()
//                .select(ZtProductplan::getId, ZtProductplan::getTitle, ZtProductplan::getEnd)
//                .in(ZtProductplan::getProduct, ztProductIds)
//                .eq(ZtProductplan::getDeleted, "0")
//                .between(ZtProductplan::getEnd, nextMonthFirstDay, nextMonthLastDay));
//        List<String> nextZtProductPlanIds = nextZtProductPlans.stream().map(z -> z.getId()).collect(Collectors.toList());
//
//        DemandVO demandVO = new DemandVO();
//
//        demandVO.setCurrent_month(currentFirstDay.format(dateTimeFormatter));
//        demandVO.setCurrent_month_plan(CollectionUtils.isEmpty(currentZtProductPlanIds) ? 0 : ztStoryDAO.getStoryByPlanId(currentZtProductPlanIds, null));
//        demandVO.setCurrent_month_actual(CollectionUtils.isEmpty(currentZtProductPlanIds) ? 0 : ztStoryDAO.getStoryByPlanId(currentZtProductPlanIds, "released"));
//        demandVO.setNext_month(nextMonthFirstDay.format(dateTimeFormatter));
//        demandVO.setNext_month_plan(CollectionUtils.isEmpty(nextZtProductPlanIds) ? 0 : ztStoryDAO.getStoryByPlanId(nextZtProductPlanIds, null));
//
//        return demandVO;
//    }


    public DemandVO getProjectDemandCompleteStatus(String programId, List<Integer> projectIds, String sprintId,Boolean isShow) {
        List<ZtStoryVO> ztStoryVOS = new ArrayList<>();
        List<Integer> sprintIds = new ArrayList<>();
        List<ZtProject> grade4Project;
        List<Integer> getProjectIds;
        List<ZtStory> storys = new ArrayList<>();

        if (StringUtils.isEmpty(sprintId)) {
            if (CollectionUtils.isEmpty(projectIds)) {
                grade4Project = getGrade4Project(programId);
                if (!isShow) {
                    grade4Project = grade4Project.stream()
                            .filter(project -> !"closed".equals(project.getStatus()))
                            .collect(Collectors.toList());
                }
                //获取项目id
                getProjectIds = grade4Project.stream().map(t -> t.getId()).collect(Collectors.toList());
                List<ZtProject> ztProjects = ztProjectDAO.getBaseMapper().selectList(new LambdaQueryWrapper<ZtProject>().in(ZtProject::getParent, getProjectIds)
                        .eq(ZtProject::getDeleted, "0"));
                sprintIds.addAll(getProjectIds);
                sprintIds.addAll(ztProjects.stream().map(a -> a.getId()).collect(Collectors.toList()));

            } else {
                sprintIds.addAll(projectIds);
            }
        } else {
            List<ZtProject> ztProjects = ztProjectDAO.getBaseMapper().selectList(new LambdaQueryWrapper<ZtProject>()
                    .select(ZtProject::getId,ZtProject::getRealBegan,ZtProject::getRealEnd)
                    .in(ZtProject::getId, sprintId)
                    .eq(ZtProject::getDeleted, "0")
                    .eq(ZtProject::getType, "sprint"));
            sprintIds = ztProjects.stream().map(t -> t.getId()).collect(Collectors.toList());

        }

        List<ZtProjectStory> ztProjectStories = ztProjectStoryDAO.getBaseMapper().selectList(new LambdaQueryWrapper<ZtProjectStory>()
                .select(ZtProjectStory::getProject, ZtProjectStory::getStory)
                .in(ZtProjectStory::getProject, sprintIds));
        List<Integer> storyIds = ztProjectStories.stream().map(a -> a.getStory()).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(storyIds)) {
            storys = ztProjectStoryDAO.getStoryByProjectId(storyIds);
        }

        // 获取所有 task
        List<ZtTask> allZtTasks;
        if (!CollectionUtils.isEmpty(storys)) {
            if(!StringUtils.isEmpty(sprintId)) {
                allZtTasks = ztTaskDAO.getBaseMapper().selectList(new LambdaQueryWrapper<ZtTask>()
                        .select(ZtTask::getId, ZtTask::getConsumed, ZtTask::getLeft, ZtTask::getStatus, ZtTask::getStory)
                        .in(ZtTask::getStory, storyIds)
                        .eq(ZtTask::getDeleted, "0")
                        .eq(ZtTask::getExecution, sprintId));
            }else {
                allZtTasks = ztTaskDAO.getBaseMapper().selectList(new LambdaQueryWrapper<ZtTask>()
                        .select(ZtTask::getId, ZtTask::getConsumed, ZtTask::getLeft, ZtTask::getStatus, ZtTask::getStory)
                        .in(ZtTask::getStory, storyIds)
                        .eq(ZtTask::getDeleted, "0"));
            }
        } else {
            allZtTasks = new ArrayList<>();
        }

        Map<String, List<ZtTask>> ztTaskMap = allZtTasks.stream()
                .filter(task -> task.getStory()!= null)
                .collect(Collectors.groupingBy(task -> task.getStory().toString()));

        // 使用流处理故事列表，直接在原对象上进行修改，避免创建新的对象
        ztStoryVOS = storys.stream().map(story -> {
            ZtStoryVO ztStoryVO = new ZtStoryVO();
            BeanUtils.copyProperties(story, ztStoryVO);

            // 获取相关 task
            List<ZtTask> getZtTasks = ztTaskMap.getOrDefault(story.getId(), new ArrayList<>());
            double consumedSum = getZtTasks.stream().collect(Collectors.summingDouble(ZtTask::getConsumed));
            double leftSum = getZtTasks.stream().collect(Collectors.summingDouble(ZtTask::getLeft));
            ztStoryVO.setConsumed((float) consumedSum);
            ztStoryVO.setLeft((float) leftSum);
            ztStoryVO.setAssociated_tasks_number(getZtTasks.size());
            Long completed_tasks_number = getZtTasks.stream()
                    .filter(task -> "done".equals(task.getStatus().getValue()) || "closed".equals(task.getStatus().getValue()))
                    .count();
            ztStoryVO.setCompleted_tasks_number(completed_tasks_number.intValue());
            return ztStoryVO;
        }).collect(Collectors.toList());

        int estimateSum = ztStoryVOS.stream().mapToInt(ZtStoryVO::getEstimate).sum();
        List<Float> collect = ztStoryVOS.stream().map(ztStoryVO -> ztStoryVO.getConsumed()).collect(Collectors.toList());
        float consumedSum = 0;
        for (Float a : collect) {
            consumedSum = add(consumedSum,a);
        }

        List<ZtStoryVO> completedStorys = ztStoryVOS.stream().filter(ztStoryVO -> ("closed".equals(ztStoryVO.getStage()) || "released".equals(ztStoryVO.getStage()))).collect(Collectors.toList());
        int  completedEstimate = completedStorys.stream().mapToInt(ZtStoryVO::getEstimate).sum();
        List<Float> completedStorysConsumed = completedStorys.stream().map(ztStoryVO -> ztStoryVO.getConsumed()).collect(Collectors.toList());
        float completedStorysConsumedSum = 0;
        for (Float a : completedStorysConsumed) {
            completedStorysConsumedSum = add(completedStorysConsumedSum,a);
        }

        List<ZtStoryVO> unfinishedStorys = ztStoryVOS.stream().filter(ztStoryVO -> !("closed".equals(ztStoryVO.getStage()) || "released".equals(ztStoryVO.getStage()))).collect(Collectors.toList());
        int  unfinishedEstimate = unfinishedStorys.stream().mapToInt(ZtStoryVO::getEstimate).sum();
        List<Float> unfinishedStorysConsumed = unfinishedStorys.stream().map(ztStoryVO -> ztStoryVO.getConsumed()).collect(Collectors.toList());
        float unfinishedStorysConsumedSum = 0;
        for (Float a : unfinishedStorysConsumed) {
            unfinishedStorysConsumedSum = add(unfinishedStorysConsumedSum,a);
        }

        DemandVO demandVO = new DemandVO();

        demandVO.setStory_sum(ztStoryVOS.size());
        demandVO.setCompleted_story_sum(completedStorys.size());
        demandVO.setUnfinished_story_sum(unfinishedStorys.size());
        demandVO.setTotal_story_points_sum(estimateSum);
        demandVO.setTotal_consume(consumedSum);
        demandVO.setCompleted_story_points_sum(completedEstimate);
        demandVO.setCompleted_consume(completedStorysConsumedSum);
        demandVO.setUnfinished_story_points_sum(unfinishedEstimate);
        demandVO.setUnfinished_consume(unfinishedStorysConsumedSum);

        return demandVO;
    }


    public DemandVO getProductDemandCompleteStatus(String programId,  String productId, List<String> moduleIds,Boolean isShow) {
        List<ZtStory> storys;
        // 模块 id 为空，获取所有产品 id 下的需求即可
        if (CollectionUtils.isEmpty(moduleIds)) {
            if (StringUtils.isEmpty(productId)) {
                List<ZtProduct> productByProgram = getProductByProgram(programId, isShow);
                List<Integer> productIds = productByProgram.stream().map(ZtProduct::getId).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(productIds)) {
                    return null;
                }
                storys = ztStoryDAO.getBaseMapper().selectList(new LambdaQueryWrapper<ZtStory>()
                        .in(ZtStory::getProduct, productIds)
                        .eq(ZtStory::getDeleted, "0"));
            } else {
                int productIdInt = Integer.parseInt(productId);
                storys = ztStoryDAO.getBaseMapper().selectList(new LambdaQueryWrapper<ZtStory>()
                        .eq(ZtStory::getProduct, productIdInt)
                        .eq(ZtStory::getDeleted, "0"));
            }
        } else {
            List<ZtModule> ztModules = ztModuleDAO.getBaseMapper().selectList(new LambdaQueryWrapper<ZtModule>()
                    .select(ZtModule::getId)
                    .in(ZtModule::getParent, moduleIds)
                    .eq(ZtModule::getDeleted, "0"));

            moduleIds.addAll(ztModules.stream().map(a -> a.getId().toString()).collect(Collectors.toList()));
            storys = ztStoryDAO.getBaseMapper().selectList(new LambdaQueryWrapper<ZtStory>()
                    .in(ZtStory::getModule, moduleIds)
                    .eq(ZtStory::getDeleted, "0"));
        }

        if (storys == null || storys.isEmpty()) {
            return null;
        }

        List<String> storyIds = storys.stream().map(s -> s.getId()).collect(Collectors.toList());
        // 获取所有 task
        List<ZtTask> allZtTasks;
        if (!CollectionUtils.isEmpty(storys)) {
            allZtTasks = ztTaskDAO.getBaseMapper().selectList(new LambdaQueryWrapper<ZtTask>()
                    .select(ZtTask::getId, ZtTask::getConsumed, ZtTask::getLeft, ZtTask::getStatus, ZtTask::getStory)
                    .in(ZtTask::getStory, storyIds)
                    .eq(ZtTask::getDeleted, "0"));
        } else {
            allZtTasks = new ArrayList<>();
        }

        Map<String, List<ZtTask>> ztTaskMap = allZtTasks.stream()
                .filter(task -> task.getStory()!= null)
                .collect(Collectors.groupingBy(task -> task.getStory().toString()));
        allZtTasks.clear();
        ConcurrentHashMap<String, List<ZtTask>> concurrentHashMap = new ConcurrentHashMap();
        ztTaskMap.forEach((key, value)->concurrentHashMap.put(key, value));


        // 使用并行流处理故事列表，多线程处理每个故事的转换
        List<ZtStoryVO> ztStoryVOS = storys.parallelStream().map(story -> {
            ZtStoryVO ztStoryVO = new ZtStoryVO();
            BeanUtils.copyProperties(story, ztStoryVO);

            // 获取相关 task
            List<ZtTask> getZtTasks = concurrentHashMap.getOrDefault(story.getId(), new ArrayList<>());
            double consumedSum = getZtTasks.stream().collect(Collectors.summingDouble(ZtTask::getConsumed));
            ztStoryVO.setConsumed((float) consumedSum);
            return ztStoryVO;
        }).collect(Collectors.toList());

        int estimateSum = ztStoryVOS.stream().mapToInt(ZtStoryVO::getEstimate).sum();
        List<Float> collect = ztStoryVOS.stream().map(ztStoryVO -> ztStoryVO.getConsumed()).collect(Collectors.toList());
        float consumedSum = 0;
        for (Float a : collect) {
            consumedSum = add(consumedSum, a);
        }

        List<ZtStoryVO> completedStorys = ztStoryVOS.stream()
                .filter(ztStoryVO -> "closed".equals(ztStoryVO.getStage()) || "released".equals(ztStoryVO.getStage()))
                .collect(Collectors.toList());

        int completedEstimate = completedStorys.stream().mapToInt(ZtStoryVO::getEstimate).sum();

        float completedStorysConsumedSum =(float) completedStorys.stream()
                .mapToDouble(ZtStoryVO::getConsumed)
                .sum();


        List<ZtStoryVO> unfinishedStorys = ztStoryVOS.stream()
                .filter(ztStoryVO -> !"closed".equals(ztStoryVO.getStage()) && !"released".equals(ztStoryVO.getStage()))
                .collect(Collectors.toList());
        int unfinishedEstimate = unfinishedStorys.stream()
                .mapToInt(ZtStoryVO::getEstimate)
                .sum();
        float unfinishedStorysConsumedSum =(float) unfinishedStorys.stream()
                .mapToDouble(ZtStoryVO::getConsumed)
                .sum();

        DemandVO demandVO = new DemandVO();

        demandVO.setStory_sum(ztStoryVOS.size());
        demandVO.setCompleted_story_sum(completedStorys.size());
        demandVO.setUnfinished_story_sum(unfinishedStorys.size());
        demandVO.setTotal_story_points_sum(estimateSum);
        demandVO.setTotal_consume(consumedSum);
        demandVO.setCompleted_story_points_sum(completedEstimate);
        demandVO.setCompleted_consume(completedStorysConsumedSum);
        demandVO.setUnfinished_story_points_sum(unfinishedEstimate);
        demandVO.setUnfinished_consume(unfinishedStorysConsumedSum);

        return demandVO;
    }

    private static Float add(float v1, float v2) {
        BigDecimal b1 = new BigDecimal(Float.toString(v1));
        BigDecimal b2 = new BigDecimal(Float.toString(v2));
        return b1.add(b2).floatValue();
    }

    /**
     * 根据部门id获取当前部门及子部门列表
     * 不传deptId默认查询"數據自決研發中心"部门
     *
     * @param deptId 部门id
     * @return 返回
     */
    public List<ZtDeptVO> queryDeptList(@RequestParam Integer deptId) {
        deptId = ObjectUtils.isEmpty(deptId) ? Constant.DATA_SELF_DETERMINATION_DEVELOPMENT_CENTER_DEPT_ID : deptId;
        List<ZtDept> deptList = ztDeptDAO.queryDeptList(deptId);
        if (CollectionUtils.isEmpty(deptList)) {
            return Lists.newArrayList();
        }
        List<ZtDeptVO> deptRespList = deptList.stream().map(x -> {
            ZtDeptVO ztDeptVO = new ZtDeptVO();
            BeanUtils.copyProperties(x, ztDeptVO);
            return ztDeptVO;
        }).collect(Collectors.toList());

        // 组装成树结构
        Integer parentGrade = deptList.stream().map(ZtDept::getGrade).min(Integer::compareTo).get();
        for (ZtDeptVO dept : deptRespList) {
            deptRespList.forEach(t -> {
                if (dept.getId().equals(t.getParent())) {
                    if (dept.getChildren() == null) {
                        dept.setChildren(Lists.newArrayList());
                    }
                    dept.getChildren().add(t);
                }
            });
        }
        return deptRespList.stream().filter(v -> parentGrade.equals(v.getGrade())).collect(Collectors.toList());
    }

    /**
     * 根据部门id查询用户(角色为研发和测试)列表
     * 不传deptId默认查询"數據自決研發中心"部门下的用户
     *
     * @param deptId 部门id
     * @return 返回用户信息
     */
    public List<ZtUser> queryUserList(Integer deptId) {
        return ztUserDAO.queryUserList(deptId);
    }

    /**
     * 根据项目集id查询当前项目集及子项目集列表
     * 不传programId默认查询"数据自决研发中心"项目集及子项目集
     *
     * @param programId 项目集id
     * @return 返回
     */
    public List<ZtProjectLevelVO> queryProgramList(Integer programId) {
        // 查询项目集列表
        programId = ObjectUtils.isEmpty(programId) ? Constant.DATA_SELF_DETERMINATION_DEVELOPMENT_CENTER_PROGRAM_ID : programId;
        List<ZtProject> programList = ztProjectDAO.queryProgramList(programId);
        if (CollectionUtils.isEmpty(programList)) {
            return Lists.newArrayList();
        }
        List<ZtProjectLevelVO> programVOList = programList.stream().map(x -> {
            ZtProjectLevelVO projectLevelVO = new ZtProjectLevelVO();
            BeanUtils.copyProperties(x, projectLevelVO);
            return projectLevelVO;
        }).collect(Collectors.toList());

        // 组装成树结构
        Integer parentGrade = programList.stream().map(ZtProject::getGrade).min(Integer::compareTo).get();
        for (ZtProjectLevelVO projectLevelVO : programVOList) {
            programVOList.forEach(t -> {
                if (projectLevelVO.getId().equals(t.getParent())) {
                    if (projectLevelVO.getChildren() == null) {
                        projectLevelVO.setChildren(Lists.newArrayList());
                    }
                    projectLevelVO.getChildren().add(t);
                }
            });
        }
        return programVOList.stream().filter(v -> parentGrade.equals(v.getGrade())).collect(Collectors.toList());
    }

    /**
     * 根据项目集id查询当前项目集下的项目列表
     * 不传programId默认查询"数据自决研发中心"项目集及子项目集
     *
     * @param programId 项目集id
     * @return 返回
     */
    public List<ZtProjectLevelVO> queryProjectList(Integer programId) {
        // 查询项目集列表
        programId = ObjectUtils.isEmpty(programId) ? Constant.DATA_SELF_DETERMINATION_DEVELOPMENT_CENTER_PROGRAM_ID : programId;
        List<ZtProject> projectList = ztProjectDAO.queryProjectList(programId);
        if (CollectionUtils.isEmpty(projectList)) {
            return Lists.newArrayList();
        }
        return projectList.stream().map(x -> {
            ZtProjectLevelVO projectLevelVO = new ZtProjectLevelVO();
            BeanUtils.copyProperties(x, projectLevelVO);
            return projectLevelVO;
        }).collect(Collectors.toList());
    }

    /**
     * 根据项目集id或项目id查询当前所有冲刺
     * 不传id默认查询"数据自决研发中心"项目集下所有冲刺
     *
     * @param id 项目集id或项目id
     * @return 返回
     */
    public List<ZtProjectLevelVO> querySprintList(Integer id) {
        // 查询项目冲刺表
        id = ObjectUtils.isEmpty(id) ? Constant.DATA_SELF_DETERMINATION_DEVELOPMENT_CENTER_PROGRAM_ID : id;
        List<ZtProject> sprintList = ztProjectDAO.querySprintList(id);
        if (CollectionUtils.isEmpty(sprintList)) {
            return Lists.newArrayList();
        }
        return sprintList.stream().map(x -> {
            ZtProjectLevelVO projectLevelVO = new ZtProjectLevelVO();
            BeanUtils.copyProperties(x, projectLevelVO);
            return projectLevelVO;
        }).collect(Collectors.toList());
    }
}
