/*
 * FileName: DateUtils
 * Author:   DONGSK
 * Datetime: 2020/9/16 21:11
 * Description: 日期操作类
 * History:
 * 作者姓名 --修改时间 --版本号--描述
 */
package com.digiwin.athena.dtdapp.util;
//import io.seata.common.util.StringUtils;

import com.digiwin.athena.esp.sdk.util.StringUtil;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.List;

/**
 * DateUtils
 * 日期操作类
 *
 * @author DONGSK
 * @date 2020/9/16
 * @since 1.0.0
 */
public class DateUtils {

    /**
     * 时间格式
     */
    public static final String DATE_FORMAT_ONE = "yyyy-MM-dd";

    /**
     * 时间格式
     */
    public static final String DATE_FORMAT_TWO = "yyyy/MM/dd";

    /**
     * 获取当前日期时间
     *
     * @return
     */
    public static Date getDateTimeNow() {
        LocalDateTime localDateTime = LocalDateTime.now();
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date parseStringToDate(String dateString, String format) throws ParseException {
        if (StringUtil.isEmpty(dateString)) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.parse(dateString);
    }

    public static long calculateWorkingDays(LocalDate start, LocalDate end) {
        long daysBetween = ChronoUnit.DAYS.between(start, end) + 1; // 包括结束日期
        long weekendDays = 0;

        for (long i = 0; i < daysBetween; i++) {
            LocalDate date = start.plusDays(i);
            if (date.getDayOfWeek().getValue() == 6 || date.getDayOfWeek().getValue() == 7) {
                weekendDays++;
            }
        }

        return daysBetween - weekendDays;
    }

    /**
     * 计算法定的工作日
     *
     * @param start       开始时间
     * @param end         结束时间
     * @param holidayList 法定假期
     * @param workingList 补班日期
     * @return 返回
     */
    public static long calculateLegalWorkingDays(LocalDate start, LocalDate end, List<String> holidayList, List<String> workingList) {
        long daysBetween = ChronoUnit.DAYS.between(start, end) + 1; // 包括结束日期
        long holidayDays = 0;
        for (long i = 0; i < daysBetween; i++) {
            LocalDate date = start.plusDays(i);
            String dateStr = parseLocalDateToString(date, DATE_FORMAT_ONE);
            // 如果是周末且不需要补班 或 是法定假期
            if (((date.getDayOfWeek().getValue() == 6 || date.getDayOfWeek().getValue() == 7) && !workingList.contains(dateStr))
                    || holidayList.contains(dateStr)) {
                holidayDays++;
            }
        }
        return daysBetween - holidayDays;
    }

    public static LocalDate convertStringToLocalDate(String dateString) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd"); // 指定日期格式

        try {
            return LocalDate.parse(dateString, formatter);
        } catch (DateTimeParseException e) {
            System.out.println("日期格式不正确: " + e.getMessage());
            return null;
        }
    }

    /**
     * localDate转为String格式
     *
     * @param localDate 日期
     * @return 返回
     */
    public static String parseLocalDateToString(LocalDate localDate, String pattern) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern); // 指定日期格式
        return formatter.format(localDate);
    }

    /**
     * 计算两个日期之间间隔的天数
     *
     * @param startDate 开始日期
     * @param endDate   结束日期
     * @return 返回
     */
    public static long calculateDateDifference(LocalDate startDate, LocalDate endDate) {
        return ChronoUnit.DAYS.between(startDate, endDate);
    }
}
