/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dtdapp.config;

import com.digiwin.athena.dtdapp.util.LoginUserUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Properties;
import jodd.util.StringUtil;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class DtdAppMybatisInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(DtdAppMybatisInterceptor.class);

    public Object intercept(Invocation invocation) throws Throwable {
        Field[] fields;
        String loginUserId;
        MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
        String sqlId = mappedStatement.getId();
        log.debug("------sqlId------" + sqlId);
        SqlCommandType sqlCommandType = mappedStatement.getSqlCommandType();
        Object parameter = invocation.getArgs()[1];
        log.debug("------sqlCommandType------" + sqlCommandType);
        if (parameter == null) {
            return invocation.proceed();
        }
        if (SqlCommandType.INSERT == sqlCommandType) {
            loginUserId = LoginUserUtils.getLoginUserId();
            for (Field field : fields = DtdAppMybatisInterceptor.getAllFields(parameter)) {
                log.debug("------field.name------" + field.getName());
                try {
                    if ("create_by".equals(field.getName())) {
                        field.setAccessible(true);
                        Object local_createBy = field.get(parameter);
                        field.setAccessible(false);
                        if ((local_createBy == null || local_createBy.equals("")) && StringUtil.isNotEmpty((CharSequence)loginUserId)) {
                            field.setAccessible(true);
                            field.set(parameter, loginUserId);
                            field.setAccessible(false);
                        }
                    }
                    if ("create_time".equals(field.getName())) {
                        field.setAccessible(true);
                        Object local_createDate = field.get(parameter);
                        field.setAccessible(false);
                        if (local_createDate == null || local_createDate.equals("")) {
                            field.setAccessible(true);
                            field.set(parameter, new Date());
                            field.setAccessible(false);
                        }
                    }
                    if (!"tenantsid".equals(field.getName())) continue;
                    field.setAccessible(true);
                    Object local_tenantSid = field.get(parameter);
                    field.setAccessible(false);
                    if (local_tenantSid != null && !local_tenantSid.equals("") || LoginUserUtils.getTenantSid() == null) continue;
                    field.setAccessible(true);
                    field.set(parameter, LoginUserUtils.getTenantSid());
                    field.setAccessible(false);
                }
                catch (Exception local_tenantSid) {
                    // empty catch block
                }
            }
        }
        if (SqlCommandType.UPDATE == sqlCommandType) {
            loginUserId = LoginUserUtils.getLoginUserId();
            fields = null;
            if (parameter instanceof MapperMethod.ParamMap) {
                MapperMethod.ParamMap p = (MapperMethod.ParamMap)parameter;
                if ((parameter = p.containsKey((Object)"et") ? p.get((Object)"et") : p.get((Object)"param1")) == null) {
                    return invocation.proceed();
                }
                fields = DtdAppMybatisInterceptor.getAllFields(parameter);
            } else {
                fields = DtdAppMybatisInterceptor.getAllFields(parameter);
            }
            for (Field field : fields) {
                log.debug("------field.name------" + field.getName());
                try {
                    if ("update_by".equals(field.getName()) && StringUtil.isNotEmpty((CharSequence)loginUserId)) {
                        field.setAccessible(true);
                        field.set(parameter, loginUserId);
                        field.setAccessible(false);
                    }
                    if (!"update_time".equals(field.getName())) continue;
                    field.setAccessible(true);
                    field.set(parameter, new Date());
                    field.setAccessible(false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    public static Field[] getAllFields(Object object) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            fieldList.addAll(new ArrayList<Field>(Arrays.asList(clazz.getDeclaredFields())));
        }
        Field[] fields = new Field[fieldList.size()];
        fieldList.toArray(fields);
        return fields;
    }
}

