/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dtdapp.mapperzentao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.dtdapp.pojo.dto.zt.ZtBugWarningDTO;
import com.digiwin.athena.dtdapp.pojo.entity.zentao.ZtDept;
import java.util.List;
import org.apache.ibatis.annotations.Select;

public interface ZtDeptMapper
extends BaseMapper<ZtDept> {
    @Select(value={"SELECT A.title                                   AS bugName\n     , A.id                                         bugNum\n     , l.name                                    AS assignedDepartment\n     , DATE_FORMAT((A.openedDate), '%Y-%m-%d')      createTime\n     , D.code                                    AS productCode\n     , D.name                                       productName\n     , CASE\n           WHEN A.severity = 1 THEN '1.A\u7c7b\u4e25\u91cdBUG'\n           WHEN A.severity = 2 THEN '2.\u8f83\u4e25\u91cdBUG'\n           WHEN A.severity = 3 THEN '3.\u4e00\u822cBUG'\n           WHEN A.severity = 4 THEN '4.\u8f7b\u5faeBUG'\n    END                                             severity\n     , A.pri                                     AS priorityOrder\n     , CASE\n           WHEN A.resolution <> '' THEN\n               DATEDIFF(DATE_FORMAT((A.resolvedDate), '%Y-%m-%d'), DATE_FORMAT((A.openedDate), '%Y-%m-%d'))\n           ELSE\n               DATEDIFF(CURDATE(), DATE_FORMAT((A.openedDate), '%Y-%m-%d'))\n    END                                             processingDays\n\n     , CASE\n           WHEN A.resolution <> '' THEN\n               TIMESTAMPDIFF(HOUR, A.openedDate, A.resolvedDate)\n           ELSE\n               TIMESTAMPDIFF(HOUR, A.openedDate, NOW())\n    END                                             processingHours\n     , B.realname                                AS questioner\n     , G.realname                                AS receiver\n     , CASE\n           WHEN E.parent = 0 THEN E.name\n           WHEN E.parent <> 0 THEN E2.name\n    END                                             receiverDept\n     , H.realname                                AS externalBugTracker\n     , CASE\n           WHEN A.type = 'security' THEN '\u5b89\u5168\u76f8\u5173'\n           WHEN A.type IN ('codeerror') THEN '\u4ee3\u7801\u9519\u8bef'\n           WHEN A.type = 'otherserror' THEN '\u4ed6\u4ebaBug'\n           WHEN A.type = 'ERPbug' THEN '\u7a33\u6001erpBUG'\n           WHEN A.type IN ('config', 'application') THEN '\u914d\u7f6e\u76f8\u5173'\n           WHEN A.type = 'BMbug' THEN '\u4e1a\u52a1\u4e2d\u53f0BUG'\n           WHEN A.type = 'application' THEN '\u5e94\u7528\u95ee\u9898'\n           WHEN A.type = 'designdefect' THEN '\u8bbe\u8ba1\u7f3a\u9677'\n           WHEN A.type = 'install' THEN '\u5b89\u88c5\u90e8\u7f72'\n           WHEN A.type = 'performance' THEN '\u6027\u80fd\u95ee\u9898'\n           WHEN A.type = 'automation' THEN '\u6d4b\u8bd5\u811a\u672c'\n           WHEN A.type = 'codeimprovement' THEN '\u4ee3\u7801\u6539\u8fdb'\n           WHEN A.type = 'others' THEN '\u5176\u4ed6'\n           WHEN A.type = 'platform' THEN '\u5e73\u53f0\u539f\u56e0'\n           WHEN A.type = 'customization' THEN '\u5b9a\u5236\u95ee\u9898'\n           WHEN A.type = 'TBB' THEN 'TBB\u62a5\u8868\u95ee\u9898'\n           WHEN A.type = 'ksc' THEN '\u77e5\u8bc6\u4e2d\u5fc3\u95ee\u9898'\n           WHEN A.type = 'Yixin' THEN '\u4ebf\u4fe1\u62a5\u8868\u95ee\u9898'\n           WHEN A.type = 'nobug' THEN ' \u975eBUG '\n           WHEN A.type = 'standard' THEN '\u6807\u51c6\u89c4\u8303'\n           WHEN A.type = 'designdefect_ux' THEN '\u8bbe\u8ba1\u7f3a\u9677(UX\u95ee\u9898)'\n           WHEN A.type = 'designdefect_req' THEN '\u8bbe\u8ba1\u7f3a\u9677(\u9700\u6c42\u95ee\u9898)'\n           WHEN A.type = 'experience' THEN '\u4f7f\u7528\u9ad4\u9a57\u4e0d\u4f73'\n           WHEN A.type = 'code_compatibility' THEN '\u4ee3\u7801\u517c\u5bb9\u6027'\n           WHEN A.type = 'browser_compatibility' THEN '\u6d4f\u89c8\u5668\u517c\u5bb9\u6027'\n           WHEN A.type = 'user_experience' THEN '\u7528\u6237\u4f53\u9a8c'\n           WHEN A.type = 'multilingual' THEN '\u591a\u8bed\u7cfb\u95ee\u9898'\n           WHEN A.type = 'data_issue' THEN '\u6570\u636e\u95ee\u9898'\n           WHEN A.type = 'DAP' THEN 'DAP\u95ee\u9898'\n           WHEN A.type = 'external' THEN '\u73af\u5883\u95ee\u9898'\n           WHEN A.type = 'Episodic' THEN '\u5f85\u89c2\u5bdf'\n           WHEN A.type = 'gnwj' THEN '\u529f\u80fd\u8bef\u89e3'\n           ELSE A.type\n    END                                             bugType\n     , CASE\n           WHEN A.BugDepartment = 'platform' THEN 'Athena\u5e73\u53f0'\n           WHEN A.BugDepartment = 'customization' THEN '\u5b9a\u5236\u524d\u7aef'\n           WHEN A.BugDepartment = 'application' THEN '\u6807\u51c6\u524d\u7aef'\n           WHEN A.BugDepartment = 'TBB' THEN 'TBB\u62a5\u8868'\n           WHEN A.BugDepartment = 'ksc' THEN '\u77e5\u8bc6\u4e2d\u5fc3'\n           WHEN A.BugDepartment = 'Yixin' THEN '\u4ebf\u4fe1\u62a5\u8868'\n           WHEN A.BugDepartment = 'BM' THEN '\u4e1a\u52a1\u4e2d\u53f0'\n           WHEN A.BugDepartment = 'ERP' THEN '\u7a33\u6001ERP'\n           WHEN A.BugDepartment = 'DAP' THEN 'DAP\u5e73\u53f0'\n           WHEN A.BugDepartment = 'ADD' THEN '\u5e94\u7528\u7814\u53d1\u4e2d\u5fc3'\n           WHEN A.BugDepartment = 'EMD' THEN '\u88c5\u5907\u5236\u9020\u4e8b\u4e1a\u90e8'\n           WHEN A.BugDepartment = 'DC' THEN '\u6570\u636e\u4e2d\u53f0'\n           WHEN A.BugDepartment = 'Other' THEN '\u5176\u4ed6'\n           WHEN A.BugDepartment = 'YiFei' THEN '\u7a33\u6001-\u6613\u98de'\n           WHEN A.BugDepartment = 'Mobile' THEN '\u79fb\u52a8\u7aef'\n           WHEN A.BugDepartment = 'PLM' THEN 'PLM'\n           WHEN A.BugDepartment = 'Service' THEN '\u670d\u52a1\u4e91'\n           WHEN A.BugDepartment = 'T' THEN '\u7a33\u6001-T\u4ea7\u54c1'\n           WHEN A.BugDepartment = 'E10' THEN '\u7a33\u6001-E10'\n           WHEN A.BugDepartment = 'WF' THEN '\u7a33\u6001-WF'\n           WHEN A.BugDepartment = 'BM01' THEN '\u4e1a\u52a1\u4e2d\u53f0-\u5e94\u7528\u5f00\u53d1'\n           ELSE A.BugDepartment\n    END                                             bugBelongToDept\n\n     , CASE\n           WHEN A.status = 'active' THEN '\u6fc0\u6d3b'\n           WHEN A.status = 'resolved' THEN '\u5df2\u89e3\u51b3'\n           WHEN A.status = 'closed' THEN '\u5df2\u5173\u95ed'\n    END                                             bugState\n     , C.realname                                AS solver\n     , CASE\n           WHEN A.bugType = 'internal' THEN '\u5185\u90e8BUG'\n           WHEN A.bugType = '' THEN ''\n           WHEN A.bugType = 'external' THEN '\u5916\u90e8BUG'\n    END                                             bugClassification\n     , CASE\n           WHEN A.bugType = 'internal' THEN 0\n           WHEN A.bugType = '' THEN 0\n           WHEN A.bugType = 'external' THEN 1\n    END                                             customerRequestsBugCount\n     , CASE\n           WHEN A.bugType = 'internal' and\n                (D.name = 'Athena' or D.name = 'ATHENA\u5e73\u53f0\u9700\u6c42' or D.name = 'Athena-PaaS\u5e73\u53f0' or\n                 D.name = 'Athena\u5e73\u53f0\u904b\u7dad\u4e8b\u52d9' or D.name = 'athena\u4f4e\u4ee3\u7801\u5f00\u53d1\u8bbe\u8ba1\u5668' or D.name = '\u8868\u683c\u5185\u6d4b' or\n                 D.name = '\u91c7\u8d2d\u81ea\u52a8\u5206\u6d3e(\u94c1\u79d1)') THEN 1\n    END                                             platformPresentsBugCount\n     , CASE\n           WHEN A.bugType = 'internal' and\n                (D.name <> 'Athena' and D.name <> 'ATHENA\u5e73\u53f0\u9700\u6c42' and D.name <> 'Athena-PaaS\u5e73\u53f0' and\n                 D.name <> 'Athena\u5e73\u53f0\u904b\u7dad\u4e8b\u52d9' and D.name <> 'athena\u4f4e\u4ee3\u7801\u5f00\u53d1\u8bbe\u8ba1\u5668' AND D.name <> '\u8868\u683c\u5185\u6d4b' AND\n                 D.name <> '\u91c7\u8d2d\u81ea\u52a8\u5206\u6d3e(\u94c1\u79d1)') THEN 1\n    END                                             applicationRaisesBugCount\n     , DATE_FORMAT((A.resolvedDate), '%Y-%m-%d') AS settlementDate\n     , CASE\n           WHEN A.openedDate >= '2024-11-25' and A.openedDate < '2025-1-7' THEN 'S9'\n           WHEN A.openedDate >= '2024-10-14' and A.openedDate < '2024-11-25' THEN 'S8'\n           WHEN A.openedDate >= '2024-8-27' and A.openedDate < '2024-10-14' THEN 'S7'\n           WHEN A.openedDate >= '2024-7-16' and A.openedDate < '2024-8-27' THEN 'S6'\n           WHEN A.openedDate >= '2024-6-3' and A.openedDate < '2024-7-16' THEN 'S5'\n           WHEN A.openedDate >= '2024-4-19' and A.openedDate < '2024-6-3' THEN 'S4'\n           WHEN A.openedDate >= '2024-3-28' and A.openedDate < '2024-4-19' THEN 'S3'\n           WHEN A.openedDate >= '2024-3-8' and A.openedDate < '2024-3-28' THEN 'S2'\n           WHEN A.openedDate >= '2024-2-2' and A.openedDate < '2024-3-8' THEN 'S1'\n           WHEN A.openedDate >= '2024-1-16' and A.openedDate < '2024-2-2' THEN 'P9S16'\n           WHEN A.openedDate >= '2023-12-21' and A.openedDate < '2024-1-16' THEN 'P8S15'\n    END                                             owningSprint\n     , CASE\n           WHEN A.resolution = 'modicode' THEN '\u4fee\u6539\u4ee3\u7801'\n           WHEN A.resolution = 'modiconfig' THEN '\u4fee\u6539\u914d\u7f6e'\n           WHEN A.resolution = 'bydesign' THEN '\u8bbe\u8ba1\u5982\u6b64'\n           WHEN A.resolution = 'duplicate' THEN '\u91cd\u590d\u63d0\u5355'\n           WHEN A.resolution = 'external' THEN '\u5916\u90e8\u539f\u56e0'\n           WHEN A.resolution = 'fixed' THEN '\u5df2\u5904\u7406'\n           WHEN A.resolution = 'notrepro' THEN '\u6ca1\u6709\u91cd\u73b0'\n           WHEN A.resolution = 'postponed' THEN '\u5ef6\u671f\u5904\u7406'\n           WHEN A.resolution = 'tostory' THEN '\u8f6c\u4e3a\u7814\u53d1\u9700\u6c42'\n           WHEN A.resolution = 'willnotfix' THEN '\u4e0d\u5904\u7406'\n           WHEN A.resolution = 'nobug' THEN '\u975eBUG'\n           WHEN A.resolution = 'spec' THEN '\u89c4\u683c\u95ee\u9898'\n           WHEN A.resolution = 'restart' THEN '\u91cd\u542f\u670d\u52a1'\n           WHEN A.resolution = 'fixpublisherror' THEN '\u53d1\u7248\u9519\u8bef\u91cd\u65b0\u90e8\u7f72'\n           WHEN A.resolution = 'patchfix' THEN '\u5e73\u53f0\u5f02\u52a8\u8ddf\u4fee'\n           WHEN A.resolution = 'improve_perform' THEN '\u6027\u80fd\u4f18\u5316'\n           WHEN A.resolution = 'dirtydataclean' THEN '\u810f\u6570\u636e\u6e05\u7406'\n           WHEN A.resolution = 'Episodic' THEN '\u5f85\u89c2\u5bdf'\n           ELSE A.resolution\n    END                                             solution\n     , smPredictTtime                            AS estimatedTimeOfResolution\n     , A.replyToCustomer                         AS processingResponse\n     , M.realname                                AS shutter\n     , DATE_FORMAT((A.closedDate), '%Y-%m-%d')   AS colseDate\n\n     , customerNameT                             AS customerInformationInTaiwan\n     , customerNameC                             AS customerInformationInMainland\n\n     , isFillData                                AS isFilldata\n     , filldataPath                              AS FilldataPath\n     , influenceOthers                           AS affectOtherTenants\n     , InternalClosingIdentification             AS internalClosingIdentification\n     , reasonsofproblem                          as reasonsofproblem\n     , Processingprocess                         as processingHistory\n     , improvementmeasure                        as improvementmeasure\n     , DemandOrder                               as DemandOrder\n     , relation                                  as relation\n     , A.probreason                              AS probreason\n     , A.approach                                AS approach\n     , A.influence                               AS influence\n     , CASE\n           WHEN A.serviceSource = 'C' THEN '\u5927\u9646\u533a\u670d\u52a1\u4e91'\n           WHEN A.serviceSource = 'T' THEN '\u53f0\u6e7e\u533a\u670d\u52a1\u4e91'\n    END                                             serviceCloudSource\n     , CASE\n           WHEN A.AREA = 'hw-test' THEN '\u534e\u4e3a\u6d4b\u8bd5\u533a'\n           WHEN A.AREA = 'pass' THEN 'paas\u533a'\n           WHEN A.AREA = 'other' THEN '\u5176\u4ed6\u533a'\n           WHEN A.AREA = 'hw-pre-test' THEN '\u534e\u4e3a\u9884\u6d4b\u8bd5\u533a'\n           WHEN A.AREA = 'ms-test' THEN '\u5fae\u8f6f\u6d4b\u8bd5\u533a'\n           WHEN A.AREA = 'ms-pre-prod' THEN '\u5fae\u8f6f\u9884\u6d4b\u8bd5\u533a'\n           WHEN A.AREA = 'hw-prod' THEN '\u534e\u4e3a\u6b63\u5f0f\u533a'\n           WHEN A.AREA = 'hw-pre-prod' THEN '\u534e\u4e3a\u9884\u751f\u4ea7\u533a'\n    END                                             owningRegion\n     , CASE\n           WHEN A.returningtype IN ('1', '2', '3', '4') = '1' THEN '\u6d41\u7a0b\u673a\u5236'\n           WHEN A.returningtype = '5' THEN '\u6267\u884c\u56e0\u7d20'\n           WHEN A.returningtype IN ('6', '7') THEN '\u6280\u672f\u65b9\u6848'\n           WHEN A.returningtype = '8' THEN '\u4e1a\u52a1\u65b9\u6848'\n           WHEN A.returningtype IN ('9', '10') THEN '\u4eba\u5458\u80fd\u529b'\n           WHEN A.returningtype = '11' THEN '\u7c97\u5fc3\u5927\u610f'\n           WHEN A.returningtype = '12' THEN '\u573a\u666f\u9057\u6f0f'\n    END                                             rootCauseClassification\n\n     , CASE\n           WHEN A.returningtype = '1' THEN '\u6d41\u7a0b\u673a\u5236\u2014\u2014\u6c9f\u901a\u673a\u5236'\n           WHEN A.returningtype = '2' THEN '\u6d41\u7a0b\u673a\u5236\u2014\u2014\u7f3a\u5c11\u89c4\u8303\u6216\u6807\u51c6'\n           WHEN A.returningtype = '3' THEN '\u6d41\u7a0b\u673a\u5236\u2014\u2014\u65f6\u95f4\u5206\u914d\u4e0d\u8db3'\n           WHEN A.returningtype = '4' THEN '\u6d41\u7a0b\u673a\u5236\u2014\u2014\u5176\u5b83'\n           WHEN A.returningtype = '5' THEN '\u6267\u884c\u56e0\u7d20\u2014\u2014\u672a\u6309\u89c4\u8303\u6216\u6807\u51c6\u6267\u884c'\n           WHEN A.returningtype = '6' THEN '\u6280\u672f\u65b9\u6848\u2014\u2014\u5386\u53f2\u8bbe\u8ba1\u7f3a\u9677'\n           WHEN A.returningtype = '7' THEN '\u6280\u672f\u65b9\u6848\u2014\u2014\u65b0\u9700\u6c42\u65b9\u6848\u7f3a\u9677'\n           WHEN A.returningtype = '8' THEN '\u4e1a\u52a1\u65b9\u6848\u2014\u2014\u9700\u6c42\u89c4\u683c\u7f3a\u9677'\n           WHEN A.returningtype = '9' THEN '\u4eba\u5458\u80fd\u529b\u2014\u2014\u65b0\u5458\u5de5\u7ecf\u9a8c\u4e0d\u8db3'\n           WHEN A.returningtype = '10' THEN '\u4eba\u5458\u80fd\u529b\u2014\u2014\u7ec4\u7ec7\u7f3a\u5c11\u8d4b\u80fd'\n           WHEN A.returningtype = '11' THEN '\u7c97\u5fc3\u5927\u610f\u2014\u2014\u7b14\u8bef\u7b49\u4f4e\u7ea7\u9519\u8bef'\n           WHEN A.returningtype = '12' THEN '\u573a\u666f\u9057\u6f0f\u2014\u2014\u4e1a\u52a1\u573a\u666f\u8003\u8651\u4e0d\u5168'\n    END                                             rootCauseType\n     , CASE\n           WHEN A.bugsourcetype = '1' THEN '\u5386\u53f2BUG'\n           WHEN A.bugsourcetype = '2' THEN '\u65b0\u9700\u6c42\u5f15\u53d1'\n           WHEN A.bugsourcetype = '3' THEN '\u4fee\u6539BUG\u5f15\u53d1'\n    END                                             bugsourcetype\n     , BUGbelonger                                  BUGbelonger\n     , createBy                                     createBy\n     , debugtimes                                   debugtimes\n     , A.checktime                                  checktime\n     , A.activatedCount                             activatedCount\nFROM zt_bug AS A\n         LEFT JOIN zt_user B ON A.openedBy = B.account\n         LEFT JOIN zt_user C ON A.resolvedBy = C.account\n         LEFT JOIN zt_user G ON A.assignedTo = G.account\n         LEFT JOIN zt_user H ON A.exBugFollower = H.account\n         LEFT JOIN zt_product D ON A.product = D.id\n         LEFT JOIN zt_dept E ON G.dept = E.id\n         LEFT JOIN zt_dept E2 ON E.parent = E2.id\n         LEFT JOIN zt_project F ON A.`execution` = F.`id`\n         LEFT JOIN zt_user M ON A.closedBy = M.account\n         LEFT JOIN zt_dept l ON l.id = G.dept\n         LEFT JOIN zt_dept l2 ON B.dept = l2.id\nWHERE A.deleted NOT IN ('1') and A.bugType = 'external' and A.status in ('active','resolved')   and A.openedDate >= #{startTime}\n  and A.openedDate <= #{endTime} -- \u521b\u5efa\u65e5\u671f\n  and l2.path not like ',1,%'\nORDER BY DATE_FORMAT((A.openedDate), '%Y-%m-%d') desc"})
    public List<ZtBugWarningDTO> findAllExternalBugs(String var1, String var2);

    @Select(value={"SELECT A.title                                   AS bugName\n     , A.id                                         bugNum\n     , l.name                                    AS assignedDepartment\n     , DATE_FORMAT((A.openedDate), '%Y-%m-%d')      createTime\n     , D.code                                    AS productCode\n     , D.name                                       productName\n     , CASE\n           WHEN A.severity = 1 THEN '1.A\u7c7b\u4e25\u91cdBUG'\n           WHEN A.severity = 2 THEN '2.\u8f83\u4e25\u91cdBUG'\n           WHEN A.severity = 3 THEN '3.\u4e00\u822cBUG'\n           WHEN A.severity = 4 THEN '4.\u8f7b\u5faeBUG'\n    END                                             severity\n     , A.pri                                     AS priorityOrder\n     , CASE\n           WHEN A.resolution <> '' THEN\n               DATEDIFF(DATE_FORMAT((A.resolvedDate), '%Y-%m-%d'), DATE_FORMAT((A.openedDate), '%Y-%m-%d'))\n           ELSE\n               DATEDIFF(CURDATE(), DATE_FORMAT((A.openedDate), '%Y-%m-%d'))\n    END                                             processingDays\n\n     , CASE\n           WHEN A.resolution <> '' THEN\n               TIMESTAMPDIFF(HOUR, A.openedDate, A.resolvedDate)\n           ELSE\n               TIMESTAMPDIFF(HOUR, A.openedDate, NOW())\n    END                                             processingHours\n     , B.realname                                AS questioner\n     , G.realname                                AS receiver\n     , CASE\n           WHEN E.parent = 0 THEN E.name\n           WHEN E.parent <> 0 THEN E2.name\n    END                                             receiverDept\n     , H.realname                                AS externalBugTracker\n     , CASE\n           WHEN A.type = 'security' THEN '\u5b89\u5168\u76f8\u5173'\n           WHEN A.type IN ('codeerror') THEN '\u4ee3\u7801\u9519\u8bef'\n           WHEN A.type = 'otherserror' THEN '\u4ed6\u4ebaBug'\n           WHEN A.type = 'ERPbug' THEN '\u7a33\u6001erpBUG'\n           WHEN A.type IN ('config', 'application') THEN '\u914d\u7f6e\u76f8\u5173'\n           WHEN A.type = 'BMbug' THEN '\u4e1a\u52a1\u4e2d\u53f0BUG'\n           WHEN A.type = 'application' THEN '\u5e94\u7528\u95ee\u9898'\n           WHEN A.type = 'designdefect' THEN '\u8bbe\u8ba1\u7f3a\u9677'\n           WHEN A.type = 'install' THEN '\u5b89\u88c5\u90e8\u7f72'\n           WHEN A.type = 'performance' THEN '\u6027\u80fd\u95ee\u9898'\n           WHEN A.type = 'automation' THEN '\u6d4b\u8bd5\u811a\u672c'\n           WHEN A.type = 'codeimprovement' THEN '\u4ee3\u7801\u6539\u8fdb'\n           WHEN A.type = 'others' THEN '\u5176\u4ed6'\n           WHEN A.type = 'platform' THEN '\u5e73\u53f0\u539f\u56e0'\n           WHEN A.type = 'customization' THEN '\u5b9a\u5236\u95ee\u9898'\n           WHEN A.type = 'TBB' THEN 'TBB\u62a5\u8868\u95ee\u9898'\n           WHEN A.type = 'ksc' THEN '\u77e5\u8bc6\u4e2d\u5fc3\u95ee\u9898'\n           WHEN A.type = 'Yixin' THEN '\u4ebf\u4fe1\u62a5\u8868\u95ee\u9898'\n           WHEN A.type = 'nobug' THEN ' \u975eBUG '\n           WHEN A.type = 'standard' THEN '\u6807\u51c6\u89c4\u8303'\n           WHEN A.type = 'designdefect_ux' THEN '\u8bbe\u8ba1\u7f3a\u9677(UX\u95ee\u9898)'\n           WHEN A.type = 'designdefect_req' THEN '\u8bbe\u8ba1\u7f3a\u9677(\u9700\u6c42\u95ee\u9898)'\n           WHEN A.type = 'experience' THEN '\u4f7f\u7528\u9ad4\u9a57\u4e0d\u4f73'\n           WHEN A.type = 'code_compatibility' THEN '\u4ee3\u7801\u517c\u5bb9\u6027'\n           WHEN A.type = 'browser_compatibility' THEN '\u6d4f\u89c8\u5668\u517c\u5bb9\u6027'\n           WHEN A.type = 'user_experience' THEN '\u7528\u6237\u4f53\u9a8c'\n           WHEN A.type = 'multilingual' THEN '\u591a\u8bed\u7cfb\u95ee\u9898'\n           WHEN A.type = 'data_issue' THEN '\u6570\u636e\u95ee\u9898'\n           WHEN A.type = 'DAP' THEN 'DAP\u95ee\u9898'\n           WHEN A.type = 'external' THEN '\u73af\u5883\u95ee\u9898'\n           WHEN A.type = 'Episodic' THEN '\u5f85\u89c2\u5bdf'\n           WHEN A.type = 'gnwj' THEN '\u529f\u80fd\u8bef\u89e3'\n           ELSE A.type\n    END                                             bugType\n     , CASE\n           WHEN A.BugDepartment = 'platform' THEN 'Athena\u5e73\u53f0'\n           WHEN A.BugDepartment = 'customization' THEN '\u5b9a\u5236\u524d\u7aef'\n           WHEN A.BugDepartment = 'application' THEN '\u6807\u51c6\u524d\u7aef'\n           WHEN A.BugDepartment = 'TBB' THEN 'TBB\u62a5\u8868'\n           WHEN A.BugDepartment = 'ksc' THEN '\u77e5\u8bc6\u4e2d\u5fc3'\n           WHEN A.BugDepartment = 'Yixin' THEN '\u4ebf\u4fe1\u62a5\u8868'\n           WHEN A.BugDepartment = 'BM' THEN '\u4e1a\u52a1\u4e2d\u53f0'\n           WHEN A.BugDepartment = 'ERP' THEN '\u7a33\u6001ERP'\n           WHEN A.BugDepartment = 'DAP' THEN 'DAP\u5e73\u53f0'\n           WHEN A.BugDepartment = 'ADD' THEN '\u5e94\u7528\u7814\u53d1\u4e2d\u5fc3'\n           WHEN A.BugDepartment = 'EMD' THEN '\u88c5\u5907\u5236\u9020\u4e8b\u4e1a\u90e8'\n           WHEN A.BugDepartment = 'DC' THEN '\u6570\u636e\u4e2d\u53f0'\n           WHEN A.BugDepartment = 'Other' THEN '\u5176\u4ed6'\n           WHEN A.BugDepartment = 'YiFei' THEN '\u7a33\u6001-\u6613\u98de'\n           WHEN A.BugDepartment = 'Mobile' THEN '\u79fb\u52a8\u7aef'\n           WHEN A.BugDepartment = 'PLM' THEN 'PLM'\n           WHEN A.BugDepartment = 'Service' THEN '\u670d\u52a1\u4e91'\n           WHEN A.BugDepartment = 'T' THEN '\u7a33\u6001-T\u4ea7\u54c1'\n           WHEN A.BugDepartment = 'E10' THEN '\u7a33\u6001-E10'\n           WHEN A.BugDepartment = 'WF' THEN '\u7a33\u6001-WF'\n           WHEN A.BugDepartment = 'BM01' THEN '\u4e1a\u52a1\u4e2d\u53f0-\u5e94\u7528\u5f00\u53d1'\n           ELSE A.BugDepartment\n    END                                             bugBelongToDept\n\n     , CASE\n           WHEN A.status = 'active' THEN '\u6fc0\u6d3b'\n           WHEN A.status = 'resolved' THEN '\u5df2\u89e3\u51b3'\n           WHEN A.status = 'closed' THEN '\u5df2\u5173\u95ed'\n    END                                             bugState\n     , C.realname                                AS solver\n     , CASE\n           WHEN A.bugType = 'internal' THEN '\u5185\u90e8BUG'\n           WHEN A.bugType = '' THEN ''\n           WHEN A.bugType = 'external' THEN '\u5916\u90e8BUG'\n    END                                             bugClassification\n     , CASE\n           WHEN A.bugType = 'internal' THEN 0\n           WHEN A.bugType = '' THEN 0\n           WHEN A.bugType = 'external' THEN 1\n    END                                             customerRequestsBugCount\n     , CASE\n           WHEN A.bugType = 'internal' and\n                (D.name = 'Athena' or D.name = 'ATHENA\u5e73\u53f0\u9700\u6c42' or D.name = 'Athena-PaaS\u5e73\u53f0' or\n                 D.name = 'Athena\u5e73\u53f0\u904b\u7dad\u4e8b\u52d9' or D.name = 'athena\u4f4e\u4ee3\u7801\u5f00\u53d1\u8bbe\u8ba1\u5668' or D.name = '\u8868\u683c\u5185\u6d4b' or\n                 D.name = '\u91c7\u8d2d\u81ea\u52a8\u5206\u6d3e(\u94c1\u79d1)') THEN 1\n    END                                             platformPresentsBugCount\n     , CASE\n           WHEN A.bugType = 'internal' and\n                (D.name <> 'Athena' and D.name <> 'ATHENA\u5e73\u53f0\u9700\u6c42' and D.name <> 'Athena-PaaS\u5e73\u53f0' and\n                 D.name <> 'Athena\u5e73\u53f0\u904b\u7dad\u4e8b\u52d9' and D.name <> 'athena\u4f4e\u4ee3\u7801\u5f00\u53d1\u8bbe\u8ba1\u5668' AND D.name <> '\u8868\u683c\u5185\u6d4b' AND\n                 D.name <> '\u91c7\u8d2d\u81ea\u52a8\u5206\u6d3e(\u94c1\u79d1)') THEN 1\n    END                                             applicationRaisesBugCount\n     , DATE_FORMAT((A.resolvedDate), '%Y-%m-%d') AS settlementDate\n     , CASE\n           WHEN A.openedDate >= '2024-11-25' and A.openedDate < '2025-1-7' THEN 'S9'\n           WHEN A.openedDate >= '2024-10-14' and A.openedDate < '2024-11-25' THEN 'S8'\n           WHEN A.openedDate >= '2024-8-27' and A.openedDate < '2024-10-14' THEN 'S7'\n           WHEN A.openedDate >= '2024-7-16' and A.openedDate < '2024-8-27' THEN 'S6'\n           WHEN A.openedDate >= '2024-6-3' and A.openedDate < '2024-7-16' THEN 'S5'\n           WHEN A.openedDate >= '2024-4-19' and A.openedDate < '2024-6-3' THEN 'S4'\n           WHEN A.openedDate >= '2024-3-28' and A.openedDate < '2024-4-19' THEN 'S3'\n           WHEN A.openedDate >= '2024-3-8' and A.openedDate < '2024-3-28' THEN 'S2'\n           WHEN A.openedDate >= '2024-2-2' and A.openedDate < '2024-3-8' THEN 'S1'\n           WHEN A.openedDate >= '2024-1-16' and A.openedDate < '2024-2-2' THEN 'P9S16'\n           WHEN A.openedDate >= '2023-12-21' and A.openedDate < '2024-1-16' THEN 'P8S15'\n    END                                             owningSprint\n     , CASE\n           WHEN A.resolution = 'modicode' THEN '\u4fee\u6539\u4ee3\u7801'\n           WHEN A.resolution = 'modiconfig' THEN '\u4fee\u6539\u914d\u7f6e'\n           WHEN A.resolution = 'bydesign' THEN '\u8bbe\u8ba1\u5982\u6b64'\n           WHEN A.resolution = 'duplicate' THEN '\u91cd\u590d\u63d0\u5355'\n           WHEN A.resolution = 'external' THEN '\u5916\u90e8\u539f\u56e0'\n           WHEN A.resolution = 'fixed' THEN '\u5df2\u5904\u7406'\n           WHEN A.resolution = 'notrepro' THEN '\u6ca1\u6709\u91cd\u73b0'\n           WHEN A.resolution = 'postponed' THEN '\u5ef6\u671f\u5904\u7406'\n           WHEN A.resolution = 'tostory' THEN '\u8f6c\u4e3a\u7814\u53d1\u9700\u6c42'\n           WHEN A.resolution = 'willnotfix' THEN '\u4e0d\u5904\u7406'\n           WHEN A.resolution = 'nobug' THEN '\u975eBUG'\n           WHEN A.resolution = 'spec' THEN '\u89c4\u683c\u95ee\u9898'\n           WHEN A.resolution = 'restart' THEN '\u91cd\u542f\u670d\u52a1'\n           WHEN A.resolution = 'fixpublisherror' THEN '\u53d1\u7248\u9519\u8bef\u91cd\u65b0\u90e8\u7f72'\n           WHEN A.resolution = 'patchfix' THEN '\u5e73\u53f0\u5f02\u52a8\u8ddf\u4fee'\n           WHEN A.resolution = 'improve_perform' THEN '\u6027\u80fd\u4f18\u5316'\n           WHEN A.resolution = 'dirtydataclean' THEN '\u810f\u6570\u636e\u6e05\u7406'\n           WHEN A.resolution = 'Episodic' THEN '\u5f85\u89c2\u5bdf'\n           ELSE A.resolution\n    END                                             solution\n     , smPredictTtime                            AS estimatedTimeOfResolution\n     , A.replyToCustomer                         AS processingResponse\n     , M.realname                                AS shutter\n     , DATE_FORMAT((A.closedDate), '%Y-%m-%d')   AS colseDate\n\n     , customerNameT                             AS customerInformationInTaiwan\n     , customerNameC                             AS customerInformationInMainland\n\n     , isFillData                                AS isFilldata\n     , filldataPath                              AS FilldataPath\n     , influenceOthers                           AS affectOtherTenants\n     , InternalClosingIdentification             AS internalClosingIdentification\n     , reasonsofproblem                          as reasonsofproblem\n     , Processingprocess                         as processingHistory\n     , improvementmeasure                        as improvementmeasure\n     , DemandOrder                               as DemandOrder\n     , relation                                  as relation\n     , A.probreason                              AS probreason\n     , A.approach                                AS approach\n     , A.influence                               AS influence\n     , CASE\n           WHEN A.serviceSource = 'C' THEN '\u5927\u9646\u533a\u670d\u52a1\u4e91'\n           WHEN A.serviceSource = 'T' THEN '\u53f0\u6e7e\u533a\u670d\u52a1\u4e91'\n    END                                             serviceCloudSource\n     , CASE\n           WHEN A.AREA = 'hw-test' THEN '\u534e\u4e3a\u6d4b\u8bd5\u533a'\n           WHEN A.AREA = 'pass' THEN 'paas\u533a'\n           WHEN A.AREA = 'other' THEN '\u5176\u4ed6\u533a'\n           WHEN A.AREA = 'hw-pre-test' THEN '\u534e\u4e3a\u9884\u6d4b\u8bd5\u533a'\n           WHEN A.AREA = 'ms-test' THEN '\u5fae\u8f6f\u6d4b\u8bd5\u533a'\n           WHEN A.AREA = 'ms-pre-prod' THEN '\u5fae\u8f6f\u9884\u6d4b\u8bd5\u533a'\n           WHEN A.AREA = 'hw-prod' THEN '\u534e\u4e3a\u6b63\u5f0f\u533a'\n           WHEN A.AREA = 'hw-pre-prod' THEN '\u534e\u4e3a\u9884\u751f\u4ea7\u533a'\n    END                                             owningRegion\n     , CASE\n           WHEN A.returningtype IN ('1', '2', '3', '4') = '1' THEN '\u6d41\u7a0b\u673a\u5236'\n           WHEN A.returningtype = '5' THEN '\u6267\u884c\u56e0\u7d20'\n           WHEN A.returningtype IN ('6', '7') THEN '\u6280\u672f\u65b9\u6848'\n           WHEN A.returningtype = '8' THEN '\u4e1a\u52a1\u65b9\u6848'\n           WHEN A.returningtype IN ('9', '10') THEN '\u4eba\u5458\u80fd\u529b'\n           WHEN A.returningtype = '11' THEN '\u7c97\u5fc3\u5927\u610f'\n           WHEN A.returningtype = '12' THEN '\u573a\u666f\u9057\u6f0f'\n    END                                             rootCauseClassification\n\n     , CASE\n           WHEN A.returningtype = '1' THEN '\u6d41\u7a0b\u673a\u5236\u2014\u2014\u6c9f\u901a\u673a\u5236'\n           WHEN A.returningtype = '2' THEN '\u6d41\u7a0b\u673a\u5236\u2014\u2014\u7f3a\u5c11\u89c4\u8303\u6216\u6807\u51c6'\n           WHEN A.returningtype = '3' THEN '\u6d41\u7a0b\u673a\u5236\u2014\u2014\u65f6\u95f4\u5206\u914d\u4e0d\u8db3'\n           WHEN A.returningtype = '4' THEN '\u6d41\u7a0b\u673a\u5236\u2014\u2014\u5176\u5b83'\n           WHEN A.returningtype = '5' THEN '\u6267\u884c\u56e0\u7d20\u2014\u2014\u672a\u6309\u89c4\u8303\u6216\u6807\u51c6\u6267\u884c'\n           WHEN A.returningtype = '6' THEN '\u6280\u672f\u65b9\u6848\u2014\u2014\u5386\u53f2\u8bbe\u8ba1\u7f3a\u9677'\n           WHEN A.returningtype = '7' THEN '\u6280\u672f\u65b9\u6848\u2014\u2014\u65b0\u9700\u6c42\u65b9\u6848\u7f3a\u9677'\n           WHEN A.returningtype = '8' THEN '\u4e1a\u52a1\u65b9\u6848\u2014\u2014\u9700\u6c42\u89c4\u683c\u7f3a\u9677'\n           WHEN A.returningtype = '9' THEN '\u4eba\u5458\u80fd\u529b\u2014\u2014\u65b0\u5458\u5de5\u7ecf\u9a8c\u4e0d\u8db3'\n           WHEN A.returningtype = '10' THEN '\u4eba\u5458\u80fd\u529b\u2014\u2014\u7ec4\u7ec7\u7f3a\u5c11\u8d4b\u80fd'\n           WHEN A.returningtype = '11' THEN '\u7c97\u5fc3\u5927\u610f\u2014\u2014\u7b14\u8bef\u7b49\u4f4e\u7ea7\u9519\u8bef'\n           WHEN A.returningtype = '12' THEN '\u573a\u666f\u9057\u6f0f\u2014\u2014\u4e1a\u52a1\u573a\u666f\u8003\u8651\u4e0d\u5168'\n    END                                             rootCauseType\n     , CASE\n           WHEN A.bugsourcetype = '1' THEN '\u5386\u53f2BUG'\n           WHEN A.bugsourcetype = '2' THEN '\u65b0\u9700\u6c42\u5f15\u53d1'\n           WHEN A.bugsourcetype = '3' THEN '\u4fee\u6539BUG\u5f15\u53d1'\n    END                                             bugsourcetype\n     , BUGbelonger                                  BUGbelonger\n     , createBy                                     createBy\n     , debugtimes                                   debugtimes\n     , A.checktime                                  checktime\n     , A.activatedCount                             activatedCount\nFROM zt_bug AS A\n         LEFT JOIN zt_user B ON A.openedBy = B.account\n         LEFT JOIN zt_user C ON A.resolvedBy = C.account\n         LEFT JOIN zt_user G ON A.assignedTo = G.account\n         LEFT JOIN zt_user H ON A.exBugFollower = H.account\n         LEFT JOIN zt_product D ON A.product = D.id\n         LEFT JOIN zt_dept E ON G.dept = E.id\n         LEFT JOIN zt_dept E2 ON E.parent = E2.id\n         LEFT JOIN zt_project F ON A.`execution` = F.`id`\n         LEFT JOIN zt_user M ON A.closedBy = M.account\n         LEFT JOIN zt_dept l ON l.id = G.dept\n         LEFT JOIN zt_dept l2 ON B.dept = l2.id\nWHERE A.deleted NOT IN ('1')\n  and A.bugType = 'internal'\n  and A.status in ('active')\n  and A.severity in (1,2)\n  and A.openedDate >= #{startTime}\n  and A.openedDate <= #{endTime}  -- \u521b\u5efa\u65e5\u671f\n  and l2.path not like ',1,%'\nORDER BY DATE_FORMAT((A.openedDate), '%Y-%m-%d') desc"})
    public List<ZtBugWarningDTO> findAllSeriousBugs(String var1, String var2);

    @Select(value={"SELECT A.title                                   AS bugName\n     , A.id                                         bugNum\n     , l.name                                    AS assignedDepartment\n     , DATE_FORMAT((A.openedDate), '%Y-%m-%d')      createTime\n     , D.code                                    AS productCode\n     , D.name                                       productName\n     , CASE\n           WHEN A.severity = 1 THEN '1.A\u7c7b\u4e25\u91cdBUG'\n           WHEN A.severity = 2 THEN '2.\u8f83\u4e25\u91cdBUG'\n           WHEN A.severity = 3 THEN '3.\u4e00\u822cBUG'\n           WHEN A.severity = 4 THEN '4.\u8f7b\u5faeBUG'\n    END                                             severity\n     , A.pri                                     AS priorityOrder\n     , CASE\n           WHEN A.resolution <> '' THEN\n               DATEDIFF(DATE_FORMAT((A.resolvedDate), '%Y-%m-%d'), DATE_FORMAT((A.openedDate), '%Y-%m-%d'))\n           ELSE\n               DATEDIFF(CURDATE(), DATE_FORMAT((A.openedDate), '%Y-%m-%d'))\n    END                                             processingDays\n\n     , CASE\n           WHEN A.resolution <> '' THEN\n               TIMESTAMPDIFF(HOUR, A.openedDate, A.resolvedDate)\n           ELSE\n               TIMESTAMPDIFF(HOUR, A.openedDate, NOW())\n    END                                             processingHours\n     , B.realname                                AS questioner\n     , G.realname                                AS receiver\n     , CASE\n           WHEN E.parent = 0 THEN E.name\n           WHEN E.parent <> 0 THEN E2.name\n    END                                             receiverDept\n     , H.realname                                AS externalBugTracker\n     , CASE\n           WHEN A.type = 'security' THEN '\u5b89\u5168\u76f8\u5173'\n           WHEN A.type IN ('codeerror') THEN '\u4ee3\u7801\u9519\u8bef'\n           WHEN A.type = 'otherserror' THEN '\u4ed6\u4ebaBug'\n           WHEN A.type = 'ERPbug' THEN '\u7a33\u6001erpBUG'\n           WHEN A.type IN ('config', 'application') THEN '\u914d\u7f6e\u76f8\u5173'\n           WHEN A.type = 'BMbug' THEN '\u4e1a\u52a1\u4e2d\u53f0BUG'\n           WHEN A.type = 'application' THEN '\u5e94\u7528\u95ee\u9898'\n           WHEN A.type = 'designdefect' THEN '\u8bbe\u8ba1\u7f3a\u9677'\n           WHEN A.type = 'install' THEN '\u5b89\u88c5\u90e8\u7f72'\n           WHEN A.type = 'performance' THEN '\u6027\u80fd\u95ee\u9898'\n           WHEN A.type = 'automation' THEN '\u6d4b\u8bd5\u811a\u672c'\n           WHEN A.type = 'codeimprovement' THEN '\u4ee3\u7801\u6539\u8fdb'\n           WHEN A.type = 'others' THEN '\u5176\u4ed6'\n           WHEN A.type = 'platform' THEN '\u5e73\u53f0\u539f\u56e0'\n           WHEN A.type = 'customization' THEN '\u5b9a\u5236\u95ee\u9898'\n           WHEN A.type = 'TBB' THEN 'TBB\u62a5\u8868\u95ee\u9898'\n           WHEN A.type = 'ksc' THEN '\u77e5\u8bc6\u4e2d\u5fc3\u95ee\u9898'\n           WHEN A.type = 'Yixin' THEN '\u4ebf\u4fe1\u62a5\u8868\u95ee\u9898'\n           WHEN A.type = 'nobug' THEN ' \u975eBUG '\n           WHEN A.type = 'standard' THEN '\u6807\u51c6\u89c4\u8303'\n           WHEN A.type = 'designdefect_ux' THEN '\u8bbe\u8ba1\u7f3a\u9677(UX\u95ee\u9898)'\n           WHEN A.type = 'designdefect_req' THEN '\u8bbe\u8ba1\u7f3a\u9677(\u9700\u6c42\u95ee\u9898)'\n           WHEN A.type = 'experience' THEN '\u4f7f\u7528\u9ad4\u9a57\u4e0d\u4f73'\n           WHEN A.type = 'code_compatibility' THEN '\u4ee3\u7801\u517c\u5bb9\u6027'\n           WHEN A.type = 'browser_compatibility' THEN '\u6d4f\u89c8\u5668\u517c\u5bb9\u6027'\n           WHEN A.type = 'user_experience' THEN '\u7528\u6237\u4f53\u9a8c'\n           WHEN A.type = 'multilingual' THEN '\u591a\u8bed\u7cfb\u95ee\u9898'\n           WHEN A.type = 'data_issue' THEN '\u6570\u636e\u95ee\u9898'\n           WHEN A.type = 'DAP' THEN 'DAP\u95ee\u9898'\n           WHEN A.type = 'external' THEN '\u73af\u5883\u95ee\u9898'\n           WHEN A.type = 'Episodic' THEN '\u5f85\u89c2\u5bdf'\n           WHEN A.type = 'gnwj' THEN '\u529f\u80fd\u8bef\u89e3'\n           ELSE A.type\n    END                                             bugType\n     , CASE\n           WHEN A.BugDepartment = 'platform' THEN 'Athena\u5e73\u53f0'\n           WHEN A.BugDepartment = 'customization' THEN '\u5b9a\u5236\u524d\u7aef'\n           WHEN A.BugDepartment = 'application' THEN '\u6807\u51c6\u524d\u7aef'\n           WHEN A.BugDepartment = 'TBB' THEN 'TBB\u62a5\u8868'\n           WHEN A.BugDepartment = 'ksc' THEN '\u77e5\u8bc6\u4e2d\u5fc3'\n           WHEN A.BugDepartment = 'Yixin' THEN '\u4ebf\u4fe1\u62a5\u8868'\n           WHEN A.BugDepartment = 'BM' THEN '\u4e1a\u52a1\u4e2d\u53f0'\n           WHEN A.BugDepartment = 'ERP' THEN '\u7a33\u6001ERP'\n           WHEN A.BugDepartment = 'DAP' THEN 'DAP\u5e73\u53f0'\n           WHEN A.BugDepartment = 'ADD' THEN '\u5e94\u7528\u7814\u53d1\u4e2d\u5fc3'\n           WHEN A.BugDepartment = 'EMD' THEN '\u88c5\u5907\u5236\u9020\u4e8b\u4e1a\u90e8'\n           WHEN A.BugDepartment = 'DC' THEN '\u6570\u636e\u4e2d\u53f0'\n           WHEN A.BugDepartment = 'Other' THEN '\u5176\u4ed6'\n           WHEN A.BugDepartment = 'YiFei' THEN '\u7a33\u6001-\u6613\u98de'\n           WHEN A.BugDepartment = 'Mobile' THEN '\u79fb\u52a8\u7aef'\n           WHEN A.BugDepartment = 'PLM' THEN 'PLM'\n           WHEN A.BugDepartment = 'Service' THEN '\u670d\u52a1\u4e91'\n           WHEN A.BugDepartment = 'T' THEN '\u7a33\u6001-T\u4ea7\u54c1'\n           WHEN A.BugDepartment = 'E10' THEN '\u7a33\u6001-E10'\n           WHEN A.BugDepartment = 'WF' THEN '\u7a33\u6001-WF'\n           WHEN A.BugDepartment = 'BM01' THEN '\u4e1a\u52a1\u4e2d\u53f0-\u5e94\u7528\u5f00\u53d1'\n           ELSE A.BugDepartment\n    END                                             bugBelongToDept\n\n     , CASE\n           WHEN A.status = 'active' THEN '\u6fc0\u6d3b'\n           WHEN A.status = 'resolved' THEN '\u5df2\u89e3\u51b3'\n           WHEN A.status = 'closed' THEN '\u5df2\u5173\u95ed'\n    END                                             bugState\n     , C.realname                                AS solver\n     , CASE\n           WHEN A.bugType = 'internal' THEN '\u5185\u90e8BUG'\n           WHEN A.bugType = '' THEN ''\n           WHEN A.bugType = 'external' THEN '\u5916\u90e8BUG'\n    END                                             bugClassification\n     , CASE\n           WHEN A.bugType = 'internal' THEN 0\n           WHEN A.bugType = '' THEN 0\n           WHEN A.bugType = 'external' THEN 1\n    END                                             customerRequestsBugCount\n     , CASE\n           WHEN A.bugType = 'internal' and\n                (D.name = 'Athena' or D.name = 'ATHENA\u5e73\u53f0\u9700\u6c42' or D.name = 'Athena-PaaS\u5e73\u53f0' or\n                 D.name = 'Athena\u5e73\u53f0\u904b\u7dad\u4e8b\u52d9' or D.name = 'athena\u4f4e\u4ee3\u7801\u5f00\u53d1\u8bbe\u8ba1\u5668' or D.name = '\u8868\u683c\u5185\u6d4b' or\n                 D.name = '\u91c7\u8d2d\u81ea\u52a8\u5206\u6d3e(\u94c1\u79d1)') THEN 1\n    END                                             platformPresentsBugCount\n     , CASE\n           WHEN A.bugType = 'internal' and\n                (D.name <> 'Athena' and D.name <> 'ATHENA\u5e73\u53f0\u9700\u6c42' and D.name <> 'Athena-PaaS\u5e73\u53f0' and\n                 D.name <> 'Athena\u5e73\u53f0\u904b\u7dad\u4e8b\u52d9' and D.name <> 'athena\u4f4e\u4ee3\u7801\u5f00\u53d1\u8bbe\u8ba1\u5668' AND D.name <> '\u8868\u683c\u5185\u6d4b' AND\n                 D.name <> '\u91c7\u8d2d\u81ea\u52a8\u5206\u6d3e(\u94c1\u79d1)') THEN 1\n    END                                             applicationRaisesBugCount\n     , DATE_FORMAT((A.resolvedDate), '%Y-%m-%d') AS settlementDate\n     , CASE\n           WHEN A.openedDate >= '2024-11-25' and A.openedDate < '2025-1-7' THEN 'S9'\n           WHEN A.openedDate >= '2024-10-14' and A.openedDate < '2024-11-25' THEN 'S8'\n           WHEN A.openedDate >= '2024-8-27' and A.openedDate < '2024-10-14' THEN 'S7'\n           WHEN A.openedDate >= '2024-7-16' and A.openedDate < '2024-8-27' THEN 'S6'\n           WHEN A.openedDate >= '2024-6-3' and A.openedDate < '2024-7-16' THEN 'S5'\n           WHEN A.openedDate >= '2024-4-19' and A.openedDate < '2024-6-3' THEN 'S4'\n           WHEN A.openedDate >= '2024-3-28' and A.openedDate < '2024-4-19' THEN 'S3'\n           WHEN A.openedDate >= '2024-3-8' and A.openedDate < '2024-3-28' THEN 'S2'\n           WHEN A.openedDate >= '2024-2-2' and A.openedDate < '2024-3-8' THEN 'S1'\n           WHEN A.openedDate >= '2024-1-16' and A.openedDate < '2024-2-2' THEN 'P9S16'\n           WHEN A.openedDate >= '2023-12-21' and A.openedDate < '2024-1-16' THEN 'P8S15'\n    END                                             owningSprint\n     , CASE\n           WHEN A.resolution = 'modicode' THEN '\u4fee\u6539\u4ee3\u7801'\n           WHEN A.resolution = 'modiconfig' THEN '\u4fee\u6539\u914d\u7f6e'\n           WHEN A.resolution = 'bydesign' THEN '\u8bbe\u8ba1\u5982\u6b64'\n           WHEN A.resolution = 'duplicate' THEN '\u91cd\u590d\u63d0\u5355'\n           WHEN A.resolution = 'external' THEN '\u5916\u90e8\u539f\u56e0'\n           WHEN A.resolution = 'fixed' THEN '\u5df2\u5904\u7406'\n           WHEN A.resolution = 'notrepro' THEN '\u6ca1\u6709\u91cd\u73b0'\n           WHEN A.resolution = 'postponed' THEN '\u5ef6\u671f\u5904\u7406'\n           WHEN A.resolution = 'tostory' THEN '\u8f6c\u4e3a\u7814\u53d1\u9700\u6c42'\n           WHEN A.resolution = 'willnotfix' THEN '\u4e0d\u5904\u7406'\n           WHEN A.resolution = 'nobug' THEN '\u975eBUG'\n           WHEN A.resolution = 'spec' THEN '\u89c4\u683c\u95ee\u9898'\n           WHEN A.resolution = 'restart' THEN '\u91cd\u542f\u670d\u52a1'\n           WHEN A.resolution = 'fixpublisherror' THEN '\u53d1\u7248\u9519\u8bef\u91cd\u65b0\u90e8\u7f72'\n           WHEN A.resolution = 'patchfix' THEN '\u5e73\u53f0\u5f02\u52a8\u8ddf\u4fee'\n           WHEN A.resolution = 'improve_perform' THEN '\u6027\u80fd\u4f18\u5316'\n           WHEN A.resolution = 'dirtydataclean' THEN '\u810f\u6570\u636e\u6e05\u7406'\n           WHEN A.resolution = 'Episodic' THEN '\u5f85\u89c2\u5bdf'\n           ELSE A.resolution\n    END                                             solution\n     , smPredictTtime                            AS estimatedTimeOfResolution\n     , A.replyToCustomer                         AS processingResponse\n     , M.realname                                AS shutter\n     , DATE_FORMAT((A.closedDate), '%Y-%m-%d')   AS colseDate\n\n     , customerNameT                             AS customerInformationInTaiwan\n     , customerNameC                             AS customerInformationInMainland\n\n     , isFillData                                AS isFilldata\n     , filldataPath                              AS FilldataPath\n     , influenceOthers                           AS affectOtherTenants\n     , InternalClosingIdentification             AS internalClosingIdentification\n     , reasonsofproblem                          as reasonsofproblem\n     , Processingprocess                         as processingHistory\n     , improvementmeasure                        as improvementmeasure\n     , DemandOrder                               as DemandOrder\n     , relation                                  as relation\n     , A.probreason                              AS probreason\n     , A.approach                                AS approach\n     , A.influence                               AS influence\n     , CASE\n           WHEN A.serviceSource = 'C' THEN '\u5927\u9646\u533a\u670d\u52a1\u4e91'\n           WHEN A.serviceSource = 'T' THEN '\u53f0\u6e7e\u533a\u670d\u52a1\u4e91'\n    END                                             serviceCloudSource\n     , CASE\n           WHEN A.AREA = 'hw-test' THEN '\u534e\u4e3a\u6d4b\u8bd5\u533a'\n           WHEN A.AREA = 'pass' THEN 'paas\u533a'\n           WHEN A.AREA = 'other' THEN '\u5176\u4ed6\u533a'\n           WHEN A.AREA = 'hw-pre-test' THEN '\u534e\u4e3a\u9884\u6d4b\u8bd5\u533a'\n           WHEN A.AREA = 'ms-test' THEN '\u5fae\u8f6f\u6d4b\u8bd5\u533a'\n           WHEN A.AREA = 'ms-pre-prod' THEN '\u5fae\u8f6f\u9884\u6d4b\u8bd5\u533a'\n           WHEN A.AREA = 'hw-prod' THEN '\u534e\u4e3a\u6b63\u5f0f\u533a'\n           WHEN A.AREA = 'hw-pre-prod' THEN '\u534e\u4e3a\u9884\u751f\u4ea7\u533a'\n    END                                             owningRegion\n     , CASE\n           WHEN A.returningtype IN ('1', '2', '3', '4') = '1' THEN '\u6d41\u7a0b\u673a\u5236'\n           WHEN A.returningtype = '5' THEN '\u6267\u884c\u56e0\u7d20'\n           WHEN A.returningtype IN ('6', '7') THEN '\u6280\u672f\u65b9\u6848'\n           WHEN A.returningtype = '8' THEN '\u4e1a\u52a1\u65b9\u6848'\n           WHEN A.returningtype IN ('9', '10') THEN '\u4eba\u5458\u80fd\u529b'\n           WHEN A.returningtype = '11' THEN '\u7c97\u5fc3\u5927\u610f'\n           WHEN A.returningtype = '12' THEN '\u573a\u666f\u9057\u6f0f'\n    END                                             rootCauseClassification\n\n     , CASE\n           WHEN A.returningtype = '1' THEN '\u6d41\u7a0b\u673a\u5236\u2014\u2014\u6c9f\u901a\u673a\u5236'\n           WHEN A.returningtype = '2' THEN '\u6d41\u7a0b\u673a\u5236\u2014\u2014\u7f3a\u5c11\u89c4\u8303\u6216\u6807\u51c6'\n           WHEN A.returningtype = '3' THEN '\u6d41\u7a0b\u673a\u5236\u2014\u2014\u65f6\u95f4\u5206\u914d\u4e0d\u8db3'\n           WHEN A.returningtype = '4' THEN '\u6d41\u7a0b\u673a\u5236\u2014\u2014\u5176\u5b83'\n           WHEN A.returningtype = '5' THEN '\u6267\u884c\u56e0\u7d20\u2014\u2014\u672a\u6309\u89c4\u8303\u6216\u6807\u51c6\u6267\u884c'\n           WHEN A.returningtype = '6' THEN '\u6280\u672f\u65b9\u6848\u2014\u2014\u5386\u53f2\u8bbe\u8ba1\u7f3a\u9677'\n           WHEN A.returningtype = '7' THEN '\u6280\u672f\u65b9\u6848\u2014\u2014\u65b0\u9700\u6c42\u65b9\u6848\u7f3a\u9677'\n           WHEN A.returningtype = '8' THEN '\u4e1a\u52a1\u65b9\u6848\u2014\u2014\u9700\u6c42\u89c4\u683c\u7f3a\u9677'\n           WHEN A.returningtype = '9' THEN '\u4eba\u5458\u80fd\u529b\u2014\u2014\u65b0\u5458\u5de5\u7ecf\u9a8c\u4e0d\u8db3'\n           WHEN A.returningtype = '10' THEN '\u4eba\u5458\u80fd\u529b\u2014\u2014\u7ec4\u7ec7\u7f3a\u5c11\u8d4b\u80fd'\n           WHEN A.returningtype = '11' THEN '\u7c97\u5fc3\u5927\u610f\u2014\u2014\u7b14\u8bef\u7b49\u4f4e\u7ea7\u9519\u8bef'\n           WHEN A.returningtype = '12' THEN '\u573a\u666f\u9057\u6f0f\u2014\u2014\u4e1a\u52a1\u573a\u666f\u8003\u8651\u4e0d\u5168'\n    END                                             rootCauseType\n     , CASE\n           WHEN A.bugsourcetype = '1' THEN '\u5386\u53f2BUG'\n           WHEN A.bugsourcetype = '2' THEN '\u65b0\u9700\u6c42\u5f15\u53d1'\n           WHEN A.bugsourcetype = '3' THEN '\u4fee\u6539BUG\u5f15\u53d1'\n    END                                             bugsourcetype\n     , BUGbelonger                                  BUGbelonger\n     , createBy                                     createBy\n     , debugtimes                                   debugtimes\n     , A.checktime                                  checktime\n     , A.activatedCount                             activatedCount\nFROM zt_bug AS A\n         LEFT JOIN zt_user B ON A.openedBy = B.account\n         LEFT JOIN zt_user C ON A.resolvedBy = C.account\n         LEFT JOIN zt_user G ON A.assignedTo = G.account\n         LEFT JOIN zt_user H ON A.exBugFollower = H.account\n         LEFT JOIN zt_product D ON A.product = D.id\n         LEFT JOIN zt_dept E ON G.dept = E.id\n         LEFT JOIN zt_dept E2 ON E.parent = E2.id\n         LEFT JOIN zt_project F ON A.`execution` = F.`id`\n         LEFT JOIN zt_user M ON A.closedBy = M.account\n         LEFT JOIN zt_dept l ON l.id = G.dept\n         LEFT JOIN zt_dept l2 ON B.dept = l2.id\nWHERE A.deleted NOT IN ('1')\n  and A.bugType = 'internal'\n  and A.status in ('active')\n  and A.severity in (3,4)\n  and (\n        CASE\n           WHEN A.resolution <> '' THEN\n              0            ELSE\n               DATEDIFF(CURDATE(), DATE_FORMAT((A.openedDate), '%Y-%m-%d'))\n        END\n      ) > 2\n  and A.openedDate >= #{startTime}\n  and A.openedDate <= #{endTime}  -- \u521b\u5efa\u65e5\u671f\n  and l2.path not like ',1,%'\nORDER BY DATE_FORMAT((A.openedDate), '%Y-%m-%d') desc"})
    public List<ZtBugWarningDTO> findAllNormalBugs(String var1, String var2);

    public List<ZtDept> queryDeptList(Integer var1);
}

