/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dtdapp.provider.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.dtdapp.pojo.constants.Constant;
import com.digiwin.athena.dtdapp.pojo.dto.ztkanban.queryTaskReq;
import com.digiwin.athena.dtdapp.pojo.entity.zentao.ZtProduct;
import com.digiwin.athena.dtdapp.pojo.entity.zentao.ZtProject;
import com.digiwin.athena.dtdapp.pojo.entity.zentao.ZtUser;
import com.digiwin.athena.dtdapp.pojo.vo.ztkanban.DemandVO;
import com.digiwin.athena.dtdapp.pojo.vo.ztkanban.PageVO;
import com.digiwin.athena.dtdapp.pojo.vo.ztkanban.ZtDeptVO;
import com.digiwin.athena.dtdapp.pojo.vo.ztkanban.ZtModuleLevelVO;
import com.digiwin.athena.dtdapp.pojo.vo.ztkanban.ZtProjectLevelVO;
import com.digiwin.athena.dtdapp.pojo.vo.ztkanban.ZtProjectVO;
import com.digiwin.athena.dtdapp.pojo.vo.ztkanban.ZtStoryVO;
import com.digiwin.athena.dtdapp.pojo.vo.ztkanban.ZtTaskRespVO;
import com.digiwin.athena.dtdapp.provider.IZtKanBanService;
import com.digiwin.athena.dtdapp.service.DtdappProjectService;
import com.digiwin.athena.dtdapp.service.ZtKanBanService;
import com.digiwin.athena.dtdapp.util.DateUtils;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class ZtKanBanServiceImpl
implements IZtKanBanService {
    @Autowired
    private ZtKanBanService ztKanBanService;
    @Autowired
    private DtdappProjectService projectService;

    @Override
    public List<ZtProjectLevelVO> getProgram() {
        return this.ztKanBanService.getProgramLevel();
    }

    @Override
    public List<ZtProject> getProjectByProgram(String requestMap) {
        Map map = (Map)JSON.parseObject((String)requestMap, Map.class);
        JSONObject jsonObject = JSONObject.parseObject((String)JSON.toJSONString((Object)map));
        String id = (String)jsonObject.getObject("id", String.class);
        Boolean isShowAll = (Boolean)jsonObject.getObject("isShowAll", Boolean.class);
        return this.ztKanBanService.getProjectByProgramAndType(id, "project", isShowAll);
    }

    @Override
    public PageVO<ZtProjectVO> getProjectByProgramAndProject(String requestMap) {
        Map map = (Map)JSON.parseObject((String)requestMap, Map.class);
        JSONObject jsonObject = JSONObject.parseObject((String)JSON.toJSONString((Object)map));
        String projectId = (String)jsonObject.getObject("project_id", String.class);
        Integer page = (Integer)jsonObject.getObject("page", Integer.class);
        Integer size = (Integer)jsonObject.getObject("size", Integer.class);
        Boolean isShowAll = (Boolean)jsonObject.getObject("isShowAll", Boolean.class);
        String begin_sort = (String)jsonObject.getObject("begin_sort", String.class);
        String end_sort = (String)jsonObject.getObject("end_sort", String.class);
        String total_demand_sort = (String)jsonObject.getObject("total_demand_sort", String.class);
        String completed_demand_sort = (String)jsonObject.getObject("completed_demand_sort", String.class);
        String residue_sort = (String)jsonObject.getObject("residue_sort", String.class);
        return this.ztKanBanService.getProjectByProgramAndProject(projectId, page, size, isShowAll, begin_sort, end_sort, total_demand_sort, completed_demand_sort, residue_sort);
    }

    @Override
    public List<ZtProject> getSprintByProject(String request) {
        Map map = (Map)JSON.parseObject((String)request, Map.class);
        JSONObject jsonObject = JSONObject.parseObject((String)JSON.toJSONString((Object)map));
        JSONArray jsonArray = jsonObject.getJSONArray("id");
        List projectIds = JSON.parseArray((String)JSON.toJSONString((Object)jsonArray), String.class);
        Boolean isShowAll = (Boolean)jsonObject.getObject("isShowAll", Boolean.class);
        return this.ztKanBanService.getSprintByProgramAndType(projectIds, "sprint", isShowAll);
    }

    @Override
    public PageVO<ZtStoryVO> getStoryByProjectOrSprint(String requestMap) {
        Map map = (Map)JSON.parseObject((String)requestMap, Map.class);
        JSONObject jsonObject = JSONObject.parseObject((String)JSON.toJSONString((Object)map));
        String programId = (String)jsonObject.getObject("program_id", String.class);
        JSONArray jsonArray = jsonObject.getJSONArray("project_id");
        List projectIds = JSON.parseArray((String)JSON.toJSONString((Object)jsonArray), Integer.class);
        String sprintId = (String)jsonObject.getObject("sprint_id", String.class);
        Integer page = (Integer)jsonObject.getObject("page", Integer.class);
        Integer size = (Integer)jsonObject.getObject("size", Integer.class);
        Boolean isShowAll = (Boolean)jsonObject.getObject("isShowAll", Boolean.class);
        String id_sort = (String)jsonObject.getObject("id_sort", String.class);
        String plan_end_sort = (String)jsonObject.getObject("plan_end_sort", String.class);
        String pri_sort = (String)jsonObject.getObject("pri_sort", String.class);
        String estimate_sort = (String)jsonObject.getObject("estimate_sort", String.class);
        String consumed_sort = (String)jsonObject.getObject("consumed_sort", String.class);
        String associated_tasks_sort = (String)jsonObject.getObject("associated_tasks_number_sort", String.class);
        String associated_bugs_sort = (String)jsonObject.getObject("associated_bugs_number_sort", String.class);
        page = page == null || page == 0 ? 1 : page;
        size = size == null || size == 0 ? 10 : size;
        String status = (String)jsonObject.getObject("story_status", String.class);
        return this.ztKanBanService.getStoryByProjectOrSprint(programId, projectIds, sprintId, page, size, isShowAll, status, id_sort, plan_end_sort, pri_sort, estimate_sort, consumed_sort, associated_tasks_sort, associated_bugs_sort);
    }

    @Override
    public List<ZtProduct> getProductByProgram(String requestMap) {
        Map map = (Map)JSON.parseObject((String)requestMap, Map.class);
        JSONObject jsonObject = JSONObject.parseObject((String)JSON.toJSONString((Object)map));
        String id = (String)jsonObject.getObject("id", String.class);
        Boolean isShowAll = (Boolean)jsonObject.getObject("isShowAll", Boolean.class);
        return this.ztKanBanService.getProductByProgram(id, isShowAll);
    }

    @Override
    public List<ZtModuleLevelVO> getModuleByProduct(String requestMap) {
        Map map = (Map)JSON.parseObject((String)requestMap, Map.class);
        JSONObject jsonObject = JSONObject.parseObject((String)JSON.toJSONString((Object)map));
        String programId = (String)jsonObject.getObject("program_id", String.class);
        String productId = (String)jsonObject.getObject("product_id", String.class);
        Boolean isShowAll = (Boolean)jsonObject.getObject("isShowAll", Boolean.class);
        return this.ztKanBanService.getModuleByProduct(programId, productId, isShowAll);
    }

    @Override
    public PageVO<ZtStoryVO> getStoryByProduct(String requestMap) {
        Map map = (Map)JSON.parseObject((String)requestMap, Map.class);
        JSONObject jsonObject = JSONObject.parseObject((String)JSON.toJSONString((Object)map));
        String programId = (String)jsonObject.getObject("program_id", String.class);
        String productId = (String)jsonObject.getObject("product_id", String.class);
        JSONArray jsonArray = jsonObject.getJSONArray("module_id");
        List moduleId = JSON.parseArray((String)JSON.toJSONString((Object)jsonArray), String.class);
        String id_sort = (String)jsonObject.getObject("id_sort", String.class);
        String plan_end_sort = (String)jsonObject.getObject("plan_end_sort", String.class);
        String pri_sort = (String)jsonObject.getObject("pri_sort", String.class);
        String estimate_sort = (String)jsonObject.getObject("estimate_sort", String.class);
        String consumed_sort = (String)jsonObject.getObject("consumed_sort", String.class);
        String associated_tasks_sort = (String)jsonObject.getObject("associated_tasks_number_sort", String.class);
        String associated_bugs_sort = (String)jsonObject.getObject("associated_tasks_number_sort", String.class);
        Integer page = (Integer)jsonObject.getObject("page", Integer.class);
        Integer size = (Integer)jsonObject.getObject("size", Integer.class);
        page = page == null || page == 0 ? 1 : page;
        size = size == null || page == 0 ? 10 : size;
        Boolean isShowAll = (Boolean)jsonObject.getObject("isShowAll", Boolean.class);
        String status = (String)jsonObject.getObject("story_status", String.class);
        return this.ztKanBanService.getStoryByProductOrModule(programId, productId, moduleId, page, size, isShowAll, status, id_sort, plan_end_sort, pri_sort, estimate_sort, consumed_sort, associated_tasks_sort, associated_bugs_sort);
    }

    @Override
    public void getProjectToExcel(Map<String, String> requestMap) {
        String projectId = requestMap.get("project_id");
        Boolean isShowAll = Boolean.parseBoolean(requestMap.get("isShowAll"));
        Integer page = 1;
        Integer size = 999999;
        this.ztKanBanService.getProjectToExcel(projectId, page, size, isShowAll);
    }

    @Override
    public void getStoryByProjectToExcel(String requestMap) {
        Map map = (Map)JSON.parseObject((String)requestMap, Map.class);
        JSONObject jsonObject = JSONObject.parseObject((String)JSON.toJSONString((Object)map));
        String programId = (String)jsonObject.getObject("program_id", String.class);
        JSONArray jsonArray = jsonObject.getJSONArray("project_id");
        List projectIds = JSON.parseArray((String)JSON.toJSONString((Object)jsonArray), Integer.class);
        String sprintId = (String)jsonObject.getObject("sprint_id", String.class);
        Boolean isShowAll = (Boolean)jsonObject.getObject("isShowAll", Boolean.class);
        Integer page = 1;
        Integer size = 999999;
        String status = (String)jsonObject.getObject("story_status", String.class);
        this.ztKanBanService.getStoryByProjectToExcel(programId, projectIds, sprintId, page, size, isShowAll, status);
    }

    @Override
    public void getStoryByProductToExcel(String requestMap) {
        JSONObject jsonObject = JSONObject.parseObject((String)requestMap);
        String programId = (String)jsonObject.getObject("program_id", String.class);
        String productId = (String)jsonObject.getObject("product_id", String.class);
        Boolean isShowAll = (Boolean)jsonObject.getObject("isShowAll", Boolean.class);
        JSONArray jsonArray = jsonObject.getJSONArray("module_id");
        List moduleId = JSON.parseArray((String)JSON.toJSONString((Object)jsonArray), String.class);
        Integer page = 1;
        Integer size = 999999;
        String status = (String)jsonObject.getObject("story_status", String.class);
        this.ztKanBanService.getStoryByProductToExcel(programId, productId, moduleId, page, size, isShowAll, status);
    }

    @Override
    public DemandVO getProjectDemandCompleteStatus(String requestMap) {
        Map map = (Map)JSON.parseObject((String)requestMap, Map.class);
        JSONObject jsonObject = JSONObject.parseObject((String)JSON.toJSONString((Object)map));
        String programId = (String)jsonObject.getObject("program_id", String.class);
        JSONArray jsonArray = jsonObject.getJSONArray("project_id");
        List projectIds = JSON.parseArray((String)JSON.toJSONString((Object)jsonArray), Integer.class);
        String sprintId = (String)jsonObject.getObject("sprint_id", String.class);
        Boolean isShow = (Boolean)jsonObject.getObject("is_show", Boolean.class);
        return this.ztKanBanService.getProjectDemandCompleteStatus(programId, projectIds, sprintId, isShow);
    }

    @Override
    public DemandVO getProductDemandCompleteStatus(String requestMap) {
        Map map = (Map)JSON.parseObject((String)requestMap, Map.class);
        JSONObject jsonObject = JSONObject.parseObject((String)JSON.toJSONString((Object)map));
        String programId = (String)jsonObject.getObject("program_id", String.class);
        String productId = (String)jsonObject.getObject("product_id", String.class);
        JSONArray jsonArray = jsonObject.getJSONArray("module_id");
        List moduleIds = JSON.parseArray((String)JSON.toJSONString((Object)jsonArray), String.class);
        Boolean isShow = (Boolean)jsonObject.getObject("is_show", Boolean.class);
        return this.ztKanBanService.getProductDemandCompleteStatus(programId, productId, moduleIds, isShow);
    }

    @Override
    public List<ZtDeptVO> queryDeptList(Integer deptId) {
        return this.ztKanBanService.queryDeptList(deptId);
    }

    @Override
    public List<ZtUser> queryUserList(Integer deptId) {
        return this.ztKanBanService.queryUserList(deptId);
    }

    @Override
    public List<ZtProjectLevelVO> queryProgramList(Integer programId) {
        return this.ztKanBanService.queryProgramList(programId);
    }

    @Override
    public List<ZtProjectLevelVO> queryProjectList(Integer programId) {
        return this.ztKanBanService.queryProjectList(programId);
    }

    @Override
    public List<ZtProjectLevelVO> querySprintList(Integer id) {
        return this.ztKanBanService.querySprintList(id);
    }

    @Override
    public ZtTaskRespVO queryTaskListByDept(queryTaskReq queryTaskReq2) {
        List<ZtProjectLevelVO> projectList;
        if (ObjectUtils.isEmpty((Object)queryTaskReq2.getDeptId())) {
            queryTaskReq2.setDeptId(Constant.DATA_SELF_DETERMINATION_DEVELOPMENT_CENTER_DEPT_ID);
        }
        if (StringUtils.isBlank((CharSequence)queryTaskReq2.getStartTime()) || StringUtils.isBlank((CharSequence)queryTaskReq2.getEndTime())) {
            LocalDate previousDate = LocalDate.now().minusMonths(1L);
            queryTaskReq2.setStartTime(DateUtils.parseLocalDateToString(previousDate, "yyyy-MM-dd"));
            queryTaskReq2.setEndTime(DateUtils.parseLocalDateToString(LocalDate.now(), "yyyy-MM-dd"));
        }
        if (CollectionUtils.isEmpty(projectList = this.ztKanBanService.queryProjectList(null))) {
            return new ZtTaskRespVO();
        }
        List<Integer> projectIdList = projectList.stream().map(ZtProjectLevelVO::getId).collect(Collectors.toList());
        queryTaskReq2.setProjectIdList(projectIdList);
        return this.projectService.queryTaskListByCondition(queryTaskReq2, Constant.QUERY_TASK_LIST_SCENE_WITH_DEPT);
    }

    @Override
    public ZtTaskRespVO queryTaskListByProject(queryTaskReq queryTaskReq2) {
        if (ObjectUtils.isEmpty((Object)queryTaskReq2.getProgramId())) {
            queryTaskReq2.setProgramId(Constant.DATA_SELF_DETERMINATION_DEVELOPMENT_CENTER_PROGRAM_ID);
        }
        if (ObjectUtils.isEmpty((Object)queryTaskReq2.getProjectId())) {
            List<ZtProjectLevelVO> projectList = this.ztKanBanService.queryProjectList(queryTaskReq2.getProgramId());
            if (CollectionUtils.isEmpty(projectList)) {
                return new ZtTaskRespVO();
            }
            queryTaskReq2.setProjectId(projectList.get(0).getId());
        }
        if (ObjectUtils.isEmpty((Object)queryTaskReq2.getDeptId())) {
            queryTaskReq2.setDeptId(Constant.DATA_SELF_DETERMINATION_DEVELOPMENT_CENTER_DEPT_ID);
        }
        if (StringUtils.isBlank((CharSequence)queryTaskReq2.getStartTime()) || LocalDate.parse(queryTaskReq2.getStartTime()).isBefore(Constant.CAL_AVAILABLE_DURATION_START_DATE)) {
            queryTaskReq2.setStartTime(DateUtils.parseLocalDateToString(Constant.CAL_AVAILABLE_DURATION_START_DATE, "yyyy-MM-dd"));
        }
        if (StringUtils.isBlank((CharSequence)queryTaskReq2.getEndTime()) || LocalDate.parse(queryTaskReq2.getEndTime()).isAfter(Constant.CAL_AVAILABLE_DURATION_END_DATE)) {
            queryTaskReq2.setEndTime(DateUtils.parseLocalDateToString(Constant.CAL_AVAILABLE_DURATION_END_DATE, "yyyy-MM-dd"));
        }
        return this.projectService.queryTaskListByCondition(queryTaskReq2, Constant.QUERY_TASK_LIST_SCENE_WITH_PROJECT);
    }
}

