/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dtdapp.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.dtdapp.dao.DorDoDCheckItemDAO;
import com.digiwin.athena.dtdapp.dao.DorDoDCheckResultDAO;
import com.digiwin.athena.dtdapp.dao.DorDodCheckInfoDAO;
import com.digiwin.athena.dtdapp.mapper.DorDodCheckItemMapper;
import com.digiwin.athena.dtdapp.mapper.DorDodCheckResultMapper;
import com.digiwin.athena.dtdapp.mapper.DorDodInfoMapper;
import com.digiwin.athena.dtdapp.pojo.entity.DorDodCheckItem;
import com.digiwin.athena.dtdapp.pojo.entity.DorDodCheckResult;
import com.digiwin.athena.dtdapp.pojo.entity.DorDodInfo;
import com.digiwin.athena.dtdapp.pojo.vo.DorDodCallBackVO;
import com.digiwin.athena.dtdapp.pojo.vo.DorDodCheckItemVO;
import com.digiwin.athena.dtdapp.pojo.vo.DorDodCheckResultVO;
import com.digiwin.athena.dtdapp.pojo.vo.DorDodInfoVO;
import com.digiwin.athena.dtdapp.util.DateUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DorDodService {
    @Autowired
    private DorDodCheckInfoDAO dorDodCheckInfoDAO;
    @Autowired
    private DorDoDCheckResultDAO dorDodCheckResultDAO;
    @Autowired
    private DorDoDCheckItemDAO dorDoDCheckItemDAO;

    @Transactional
    public void initDorDodInfo(List<DorDodInfoVO> dorDodInfoList) throws Exception {
        Map profile = DWServiceContext.getContext().getProfile();
        String userId = String.valueOf(profile.get("userId"));
        ArrayList<DorDodInfo> list = new ArrayList<DorDodInfo>();
        for (DorDodInfoVO dorDodInfoVO : dorDodInfoList) {
            DorDodInfo dorDodInfo = new DorDodInfo();
            BeanUtils.copyProperties((Object)dorDodInfoVO, (Object)dorDodInfo);
            List<DorDodCheckItem> develop_dor_info = dorDodInfoVO.getDevelop_dor_info();
            List devDorIds = develop_dor_info.stream().map(DorDodCheckItem::getId).collect(Collectors.toList());
            List<DorDodCheckItem> qc_dor_info = dorDodInfoVO.getQc_dor_info();
            List qcDorIds = qc_dor_info.stream().map(DorDodCheckItem::getId).collect(Collectors.toList());
            List<DorDodCheckItem> develop_dod_info = dorDodInfoVO.getDevelop_dod_info();
            List devDoDIds = develop_dod_info.stream().map(DorDodCheckItem::getId).collect(Collectors.toList());
            List<DorDodCheckItem> qc_dod_info = dorDodInfoVO.getQc_dod_info();
            List qcDodIds = qc_dod_info.stream().map(DorDodCheckItem::getId).collect(Collectors.toList());
            dorDodInfo.setDevelop_dor(StringUtils.join(devDorIds, (String)","));
            dorDodInfo.setDevelop_dod(StringUtils.join(devDoDIds, (String)","));
            dorDodInfo.setQc_dor(StringUtils.join(qcDorIds, (String)","));
            dorDodInfo.setQc_dod(StringUtils.join(qcDodIds, (String)","));
            dorDodInfo.setCreate_by(userId);
            dorDodInfo.setCreate_time(DateUtils.getDateTimeNow());
            String uuid = UUID.randomUUID().toString();
            dorDodInfo.setTrace_id(uuid);
            dorDodInfoVO.setTrace_id(uuid);
            list.add(dorDodInfo);
        }
        this.dorDodCheckInfoDAO.saveBatch(list);
        this.initDorDodCheckResult(dorDodInfoList);
    }

    private void initDorDodCheckResult(List<DorDodInfoVO> dorDodInfoList) throws Exception {
        ArrayList<DorDodCheckResult> dorDodCheckResults = new ArrayList<DorDodCheckResult>();
        List dorDodCheckItems = ((DorDodCheckItemMapper)this.dorDoDCheckItemDAO.getBaseMapper()).selectList((Wrapper)new QueryWrapper());
        Map collect = dorDodCheckItems.stream().collect(Collectors.toMap(DorDodCheckItem::getId, Function.identity(), (a, b) -> b));
        for (DorDodInfoVO dorDodInfo : dorDodInfoList) {
            DorDodCheckItem dorDodCheckItem;
            DorDodCheckResult dorDodCheckResult;
            List<DorDodCheckItem> develop_dor_info = dorDodInfo.getDevelop_dor_info();
            List<DorDodCheckItem> qc_dor_info = dorDodInfo.getQc_dor_info();
            List<DorDodCheckItem> develop_dod_info = dorDodInfo.getDevelop_dod_info();
            List<DorDodCheckItem> qc_dod_info = dorDodInfo.getQc_dod_info();
            for (DorDodCheckItem s : develop_dor_info) {
                dorDodCheckResult = new DorDodCheckResult();
                BeanUtils.copyProperties((Object)dorDodInfo, (Object)dorDodCheckResult);
                dorDodCheckItem = (DorDodCheckItem)collect.get(s.getId());
                dorDodCheckResult.setCheck_id(s.getId());
                dorDodCheckResult.setCheck_type(dorDodCheckItem.getCheck_type());
                dorDodCheckResult.setCheck_item(s.getCheck_item());
                dorDodCheckResult.setCheck_result_type(dorDodCheckItem.getCheck_result_type());
                dorDodCheckResult.setChecker_id(dorDodInfo.getDeveloper_id());
                dorDodCheckResult.setChecker_name(dorDodInfo.getDeveloper_name());
                dorDodCheckResult.setCreate_time(DateUtils.getDateTimeNow());
                dorDodCheckResult.setStatus("0");
                dorDodCheckResults.add(dorDodCheckResult);
            }
            for (DorDodCheckItem s : qc_dor_info) {
                dorDodCheckResult = new DorDodCheckResult();
                BeanUtils.copyProperties((Object)dorDodInfo, (Object)dorDodCheckResult);
                dorDodCheckItem = (DorDodCheckItem)collect.get(s.getId());
                dorDodCheckResult.setCheck_id(s.getId());
                dorDodCheckResult.setCheck_type(dorDodCheckItem.getCheck_type());
                dorDodCheckResult.setCheck_item(s.getCheck_item());
                dorDodCheckResult.setCheck_result_type(dorDodCheckItem.getCheck_result_type());
                dorDodCheckResult.setChecker_id(dorDodInfo.getQc_id());
                dorDodCheckResult.setChecker_name(dorDodInfo.getQc_name());
                dorDodCheckResult.setCreate_time(DateUtils.getDateTimeNow());
                dorDodCheckResult.setStatus("0");
                dorDodCheckResults.add(dorDodCheckResult);
            }
            for (DorDodCheckItem s : develop_dod_info) {
                dorDodCheckResult = new DorDodCheckResult();
                BeanUtils.copyProperties((Object)dorDodInfo, (Object)dorDodCheckResult);
                dorDodCheckItem = (DorDodCheckItem)collect.get(s.getId());
                dorDodCheckResult.setCheck_id(s.getId());
                dorDodCheckResult.setCheck_type(dorDodCheckItem.getCheck_type());
                dorDodCheckResult.setCheck_item(s.getCheck_item());
                dorDodCheckResult.setCheck_result_type(dorDodCheckItem.getCheck_result_type());
                dorDodCheckResult.setChecker_id(dorDodInfo.getDeveloper_id());
                dorDodCheckResult.setChecker_name(dorDodInfo.getDeveloper_name());
                dorDodCheckResult.setCreate_time(DateUtils.getDateTimeNow());
                dorDodCheckResult.setStatus("0");
                dorDodCheckResults.add(dorDodCheckResult);
            }
            for (DorDodCheckItem s : qc_dod_info) {
                dorDodCheckResult = new DorDodCheckResult();
                BeanUtils.copyProperties((Object)dorDodInfo, (Object)dorDodCheckResult);
                dorDodCheckItem = (DorDodCheckItem)collect.get(s.getId());
                dorDodCheckResult.setCheck_id(s.getId());
                dorDodCheckResult.setCheck_type(dorDodCheckItem.getCheck_type());
                dorDodCheckResult.setCheck_item(s.getCheck_item());
                dorDodCheckResult.setCheck_result_type(dorDodCheckItem.getCheck_result_type());
                dorDodCheckResult.setChecker_id(dorDodInfo.getQc_id());
                dorDodCheckResult.setChecker_name(dorDodInfo.getQc_name());
                dorDodCheckResult.setCreate_time(DateUtils.getDateTimeNow());
                dorDodCheckResult.setStatus("0");
                dorDodCheckResults.add(dorDodCheckResult);
            }
        }
        this.dorDodCheckResultDAO.saveBatch(dorDodCheckResults);
    }

    public List<DorDodCheckResultVO> getDorDodCheckResult(List<DorDodCheckResult> queryList) throws Exception {
        List dorDodCheckResults;
        ArrayList<DorDodCheckResultVO> result = new ArrayList<DorDodCheckResultVO>();
        DorDodCheckResult dorDodCheckResult = queryList.get(0);
        List queryTraceIds = queryList.stream().map(DorDodCheckResult::getTrace_id).collect(Collectors.toList());
        String batch_no = dorDodCheckResult.getBatch_no();
        String checker_id = dorDodCheckResult.getChecker_id();
        String status = dorDodCheckResult.getStatus();
        String audit_status = dorDodCheckResult.getAudit_status();
        String check_type = dorDodCheckResult.getCheck_type();
        QueryWrapper queryWrapper = new QueryWrapper();
        LambdaQueryWrapper queryWrapperLambada = (LambdaQueryWrapper)queryWrapper.lambda().eq(DorDodCheckResult::getBatch_no, (Object)batch_no);
        if (StringUtils.isNotEmpty((CharSequence)checker_id)) {
            queryWrapperLambada.eq(DorDodCheckResult::getChecker_id, (Object)checker_id);
        }
        if (StringUtils.isNotEmpty((CharSequence)status)) {
            queryWrapperLambada.eq(DorDodCheckResult::getStatus, (Object)status);
        }
        if (StringUtils.isNotEmpty((CharSequence)audit_status)) {
            queryWrapperLambada.eq(DorDodCheckResult::getAudit_status, (Object)audit_status);
        }
        if (StringUtils.isNotEmpty((CharSequence)check_type)) {
            switch (check_type) {
                case "dor": {
                    queryWrapperLambada.in(DorDodCheckResult::getCheck_type, Arrays.asList("dev_dor", "qc_dor"));
                    break;
                }
                case "dod": {
                    queryWrapperLambada.in(DorDodCheckResult::getCheck_type, Arrays.asList("dev_dod", "qc_dod"));
                    break;
                }
                default: {
                    queryWrapperLambada.eq(DorDodCheckResult::getCheck_type, (Object)check_type);
                }
            }
        }
        if (CollectionUtils.isNotEmpty(queryTraceIds)) {
            queryWrapperLambada.in(DorDodCheckResult::getTrace_id, queryTraceIds);
        }
        if (CollectionUtils.isEmpty((Collection)(dorDodCheckResults = ((DorDodCheckResultMapper)this.dorDodCheckResultDAO.getBaseMapper()).selectList((Wrapper)queryWrapper)))) {
            return result;
        }
        List collect = dorDodCheckResults.stream().map(DorDodCheckResult::getTrace_id).collect(Collectors.toList());
        List dorDodInfos = ((DorDodInfoMapper)this.dorDodCheckInfoDAO.getBaseMapper()).selectList((Wrapper)new QueryWrapper().lambda().in(DorDodInfo::getTrace_id, collect));
        for (DorDodInfo dorDodInfo : dorDodInfos) {
            DorDodCheckResultVO dorDodCheckResultVO = new DorDodCheckResultVO();
            BeanUtils.copyProperties((Object)dorDodInfo, (Object)dorDodCheckResultVO);
            List collect2 = dorDodCheckResults.stream().filter(e -> StringUtils.equals((CharSequence)dorDodInfo.getTrace_id(), (CharSequence)e.getTrace_id())).collect(Collectors.toList());
            List dorDodCheckItemVOS = JSONArray.parseArray((String)JSON.toJSONString(collect2), DorDodCheckItemVO.class);
            dorDodCheckResultVO.setCheck_item_info(dorDodCheckItemVOS);
            dorDodCheckResultVO.setChecker_id(((DorDodCheckResult)collect2.get(0)).getChecker_id());
            dorDodCheckResultVO.setChecker_name(((DorDodCheckResult)collect2.get(0)).getChecker_name());
            result.add(dorDodCheckResultVO);
        }
        return result;
    }

    @Transactional
    public void updateDorDodCheckResult(List<DorDodCheckResultVO> dorDodCheckResults) throws Exception {
        for (DorDodCheckResultVO dorDodCheckResultVO : dorDodCheckResults) {
            List<DorDodCheckItemVO> check_item_info = dorDodCheckResultVO.getCheck_item_info();
            for (DorDodCheckItemVO dorDodCheckItemVO : check_item_info) {
                DorDodCheckResult dorDodCheckResult = new DorDodCheckResult();
                dorDodCheckResult.setStatus("1");
                dorDodCheckResult.setAudit_status("0");
                dorDodCheckResult.setNeed_check(dorDodCheckItemVO.getNeed_check());
                dorDodCheckResult.setCheck_result(dorDodCheckItemVO.getCheck_result());
                dorDodCheckResult.setUpdate_time(DateUtils.getDateTimeNow());
                this.dorDodCheckResultDAO.update(dorDodCheckResult, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().eq(DorDodCheckResult::getTrace_id, (Object)dorDodCheckResultVO.getTrace_id())).eq(DorDodCheckResult::getCheck_id, (Object)dorDodCheckItemVO.getCheck_id())).eq(DorDodCheckResult::getChecker_id, (Object)dorDodCheckResultVO.getChecker_id()));
            }
        }
    }

    @Transactional
    public void auditDorDodCheckResult(List<DorDodCheckResultVO> dorDodCheckResults) throws Exception {
        for (DorDodCheckResultVO dorDodCheckResultVO : dorDodCheckResults) {
            List<DorDodCheckItemVO> check_item_info = dorDodCheckResultVO.getCheck_item_info();
            for (DorDodCheckItemVO dorDodCheckItemVO : check_item_info) {
                DorDodCheckResult dorDodCheckResult = new DorDodCheckResult();
                dorDodCheckResult.setAudit_status("1");
                dorDodCheckResult.setNeed_check(dorDodCheckItemVO.getNeed_check());
                dorDodCheckResult.setCheck_result(dorDodCheckItemVO.getCheck_result());
                dorDodCheckResult.setAudit_time(DateUtils.getDateTimeNow());
                this.dorDodCheckResultDAO.update(dorDodCheckResult, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().eq(DorDodCheckResult::getTrace_id, (Object)dorDodCheckResultVO.getTrace_id())).eq(DorDodCheckResult::getCheck_id, (Object)dorDodCheckItemVO.getCheck_id())).eq(DorDodCheckResult::getChecker_id, (Object)dorDodCheckResultVO.getChecker_id()));
            }
            List checkTypeList = check_item_info.stream().map(DorDodCheckItemVO::getCheck_type).filter(e -> e.contains("dor")).distinct().collect(Collectors.toList());
            if (!CollectionUtils.isNotEmpty(checkTypeList)) continue;
            ArrayList<String> dodCheckTypeList = new ArrayList<String>();
            if (checkTypeList.contains("dev_dor")) {
                dodCheckTypeList.add("dev_dod");
            }
            if (checkTypeList.contains("qc_dor")) {
                dodCheckTypeList.add("qc_dod");
            }
            LambdaUpdateWrapper lambdaUpdateWrapper2 = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().eq(DorDodCheckResult::getTrace_id, (Object)dorDodCheckResultVO.getTrace_id())).eq(DorDodCheckResult::getChecker_id, (Object)dorDodCheckResultVO.getChecker_id())).in(DorDodCheckResult::getCheck_type, dodCheckTypeList);
            DorDodCheckResult dorDodCheckResult2 = new DorDodCheckResult();
            dorDodCheckResult2.setStatus("0");
            dorDodCheckResult2.setUpdate_time(DateUtils.getDateTimeNow());
            this.dorDodCheckResultDAO.update(dorDodCheckResult2, (Wrapper)lambdaUpdateWrapper2);
        }
    }

    @Transactional
    public void callbackDorDodCheckResult(List<DorDodCallBackVO> dorDodCallBackVOLists) throws Exception {
        for (DorDodCallBackVO dodCallBackVO : dorDodCallBackVOLists) {
            String flag = dodCallBackVO.getFlag();
            List<DorDodCheckItemVO> check_item_info = dodCallBackVO.getCheck_item_info();
            List<Object> checkIdList = new ArrayList();
            List<Object> checkTypeList = new ArrayList();
            if (CollectionUtils.isNotEmpty(check_item_info)) {
                checkIdList = check_item_info.stream().map(DorDodCheckItemVO::getCheck_id).distinct().collect(Collectors.toList());
                checkTypeList = check_item_info.stream().map(DorDodCheckItemVO::getCheck_type).distinct().collect(Collectors.toList());
            }
            DorDodCheckResult dorDodCheckResult = new DorDodCheckResult();
            dorDodCheckResult.setStatus("0");
            dorDodCheckResult.setAudit_status("-1");
            dorDodCheckResult.setUpdate_time(DateUtils.getDateTimeNow());
            LambdaUpdateWrapper lambdaUpdateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().eq(DorDodCheckResult::getTrace_id, (Object)dodCallBackVO.getTrace_id())).eq(DorDodCheckResult::getChecker_id, (Object)dodCallBackVO.getChecker_id());
            if (CollectionUtils.isNotEmpty(checkIdList)) {
                lambdaUpdateWrapper.in(DorDodCheckResult::getCheck_id, checkIdList);
            }
            this.dorDodCheckResultDAO.update(dorDodCheckResult, (Wrapper)lambdaUpdateWrapper);
            if (!StringUtils.equalsIgnoreCase((CharSequence)flag, (CharSequence)"1")) continue;
            ArrayList<String> dodCheckTypeList = new ArrayList<String>();
            if (checkTypeList.contains("dev_dor")) {
                dodCheckTypeList.add("dev_dod");
            }
            if (checkTypeList.contains("qc_dor")) {
                dodCheckTypeList.add("qc_dod");
            }
            LambdaUpdateWrapper lambdaUpdateWrapper2 = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().eq(DorDodCheckResult::getTrace_id, (Object)dodCallBackVO.getTrace_id())).eq(DorDodCheckResult::getChecker_id, (Object)dodCallBackVO.getChecker_id())).in(DorDodCheckResult::getCheck_type, dodCheckTypeList);
            DorDodCheckResult dorDodCheckResult2 = new DorDodCheckResult();
            dorDodCheckResult2.setStatus("-1");
            dorDodCheckResult2.setAudit_status("-1");
            dorDodCheckResult2.setUpdate_time(DateUtils.getDateTimeNow());
            this.dorDodCheckResultDAO.update(dorDodCheckResult2, (Wrapper)lambdaUpdateWrapper2);
        }
    }

    public List<DorDodCheckResult> getDorDodCheckResultDetail(JSONObject queryParam) throws Exception {
        List dorDodCheckResults;
        ArrayList<DorDodCheckResult> result = new ArrayList<DorDodCheckResult>();
        String batch_no = queryParam.getString("batch_no");
        String checker_id = queryParam.getString("checker_id");
        String status = queryParam.getString("status");
        String audit_status = queryParam.getString("audit_status");
        String check_type = queryParam.getString("check_type");
        QueryWrapper queryWrapper = new QueryWrapper();
        LambdaQueryWrapper queryWrapperLambada = (LambdaQueryWrapper)queryWrapper.lambda().eq(DorDodCheckResult::getBatch_no, (Object)batch_no);
        if (StringUtils.isNotEmpty((CharSequence)checker_id)) {
            queryWrapperLambada.eq(DorDodCheckResult::getChecker_id, (Object)checker_id);
        }
        if (StringUtils.isNotEmpty((CharSequence)status)) {
            queryWrapperLambada.eq(DorDodCheckResult::getStatus, (Object)status);
        }
        if (StringUtils.isNotEmpty((CharSequence)audit_status)) {
            queryWrapperLambada.eq(DorDodCheckResult::getAudit_status, (Object)audit_status);
        }
        if (StringUtils.isNotEmpty((CharSequence)check_type)) {
            switch (check_type) {
                case "dor": {
                    queryWrapperLambada.in(DorDodCheckResult::getCheck_type, Arrays.asList("dev_dor", "qc_dor"));
                    break;
                }
                case "dod": {
                    queryWrapperLambada.in(DorDodCheckResult::getCheck_type, Arrays.asList("dev_dod", "qc_dod"));
                    break;
                }
                default: {
                    queryWrapperLambada.eq(DorDodCheckResult::getCheck_type, (Object)check_type);
                }
            }
        }
        if (CollectionUtils.isEmpty((Collection)(dorDodCheckResults = ((DorDodCheckResultMapper)this.dorDodCheckResultDAO.getBaseMapper()).selectList((Wrapper)queryWrapper)))) {
            return result;
        }
        return dorDodCheckResults;
    }
}

