/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dtdapp.util;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.dtdapp.pojo.esp.EspBody;
import com.digiwin.athena.dtdapp.pojo.esp.EspResponse;
import com.digiwin.athena.esp.sdk.Invoker;
import com.digiwin.athena.esp.sdk.model.RequestModel;
import com.digiwin.athena.esp.sdk.model.ResponseModel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESPInvokeUtil {
    private static final Logger log = LoggerFactory.getLogger(ESPInvokeUtil.class);
    private static final Set<String> SUCCESS_CODES = new HashSet<String>();

    private ESPInvokeUtil() {
    }

    public static EspResponse invokeRestSync(String serviceName, String productName, String token, String tenantId, String jsonMsg, Map<String, Object> headerParamMap, Map<String, String> eocMap, String pinpointId) throws DWException {
        RequestModel requestModel = new RequestModel();
        requestModel.setHostProd("dtdapp");
        requestModel.setHostVer("1.0");
        requestModel.setHostId("dtdapp");
        requestModel.setHostAcct("athena");
        requestModel.setLanguage("zh_CN");
        requestModel.setTenantId(tenantId);
        requestModel.setServiceProd(productName);
        requestModel.setServiceName(serviceName);
        HashMap<String, String> eocMap2 = new HashMap<String, String>();
        eocMap2.putAll(eocMap);
        requestModel.setEocMap(eocMap2);
        String body = null;
        body = StringUtils.isNotEmpty((CharSequence)jsonMsg) ? "{\"std_data\":{\"parameter\":" + jsonMsg + "}}" : "{\"std_data\":{\"parameter\":" + JSONObject.toJSONString((Object)new JSONObject()) + "}}";
        requestModel.setBodyJsonString(body);
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("token", token);
        headerMap.put("routerKey", tenantId);
        if (headerParamMap != null) {
            Set<Map.Entry<String, Object>> entries = headerParamMap.entrySet();
            for (Map.Entry<String, Object> entry : entries) {
                headerMap.put(entry.getKey(), String.valueOf(entry.getValue()));
            }
        }
        requestModel.setHeaderMap(headerMap);
        try {
            ResponseModel responseModel = Invoker.invokeRestSync((RequestModel)requestModel);
            String response = responseModel.getBodyJsonString();
            log.info("invoke Result:{}", (Object)response);
            EspBody espBody = (EspBody)JSONObject.parseObject((String)response, EspBody.class);
            EspResponse espResponse = new EspResponse();
            if (SUCCESS_CODES.contains(espBody.getStd_data().getExecution().getCode())) {
                espResponse.setStatus(EspResponse.Status.SUCCESS);
                espResponse.setData(espBody);
                return espResponse;
            }
            espResponse.setMsg(espBody.getStd_data().getExecution().getDescription());
            espResponse.setStatus(EspResponse.Status.FAILED);
            return espResponse;
        }
        catch (Exception e) {
            log.error("call esp error:{}", (Throwable)e);
            throw new DWException(e.getMessage());
        }
    }

    public static EspResponse invokeRestFasync(String serviceName, String productName, String token, String tenantId, String jsonMsg, Map<String, Object> headerParamMap, Map<String, String> eocMap, String callBackId) throws DWException {
        RequestModel requestModel = new RequestModel();
        requestModel.setHostProd("dtdapp");
        requestModel.setHostVer("1.0");
        requestModel.setHostId("dtdapp");
        requestModel.setHostAcct("athena");
        requestModel.setLanguage("zh_CN");
        requestModel.setTenantId(tenantId);
        requestModel.setServiceProd(productName);
        requestModel.setServiceName(serviceName);
        HashMap<String, String> eocMap2 = new HashMap<String, String>();
        eocMap2.putAll(eocMap);
        requestModel.setEocMap(eocMap2);
        String body = null;
        body = StringUtils.isNotEmpty((CharSequence)jsonMsg) ? "{\"std_data\":{\"parameter\":" + jsonMsg + "}}" : "{\"std_data\":{\"parameter\":" + JSONObject.toJSONString((Object)new JSONObject()) + "}}";
        requestModel.setBodyJsonString(body);
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("token", token);
        headerMap.put("routerKey", tenantId);
        if (headerParamMap != null) {
            Set<Map.Entry<String, Object>> entries = headerParamMap.entrySet();
            for (Map.Entry<String, Object> entry : entries) {
                headerMap.put(entry.getKey(), String.valueOf(entry.getValue()));
            }
        }
        requestModel.setHeaderMap(headerMap);
        try {
            ResponseModel responseModel = Invoker.invokeRestFasync((RequestModel)requestModel, (String)callBackId);
            String response = responseModel.getBodyJsonString();
            log.info("invoke Result:{}", (Object)response);
            EspBody espBody = (EspBody)JSONObject.parseObject((String)response, EspBody.class);
            EspResponse espResponse = new EspResponse();
            if (SUCCESS_CODES.contains(espBody.getStd_data().getExecution().getCode())) {
                espResponse.setStatus(EspResponse.Status.SUCCESS);
                espResponse.setData(espBody);
                return espResponse;
            }
            espResponse.setMsg(espBody.getStd_data().getExecution().getDescription());
            espResponse.setStatus(EspResponse.Status.FAILED);
            return espResponse;
        }
        catch (Exception e) {
            log.error("call esp error:{}", (Throwable)e);
            throw new DWException(e.getMessage());
        }
    }

    static {
        SUCCESS_CODES.add("0");
        SUCCESS_CODES.add("000");
    }
}

