/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.esp.sdk.dap.log;

import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DynamicDapLogLoggerInfo {
    private static Log log = LogFactory.getLog(DynamicDapLogLoggerInfo.class);
    public static final String KEY_LOGGER_NAME = "espDapLogLoggerName";
    public static final String KEY_IS_LOGGER_MODE = "espDapLogIsLoggerMode";
    public static final String KEY_FILE_PATH = "espDapLogFilePath";
    public static final String KEY_ROLLING_FILE_MAX_VALUE_OF_COUNTER = "espDapLogRollingFileMaxValueOfCounter";
    public static final String KEY_FILE_NAME_WITHOUT_EXTENSION = "espDapLogFileNameWithoutExtension";
    public static final String KEY_FILE_EXTENSION = "espDapLogFileExtension";
    public static final String KEY_SIZE_BASED_TRIGGERING_POLICY_SIZE = "espDapLogSizeBasedTriggeringPolicySize";
    public static final String KEY_SIZE_DELETE_ACTION_LAST_MODIFIED_AGE = "espDapLogDeleteActionLastModifiedAge";
    private boolean isLoggerMode = false;
    private String loggerName = "dweaiEspDapLogLogger";
    private String logFilePath = "platform/log/esplog/";
    private String logFileNameWithoutExtension = "esp";
    private String logFileExtension = "log";
    private String logFileName;
    private String rollingFilePattern;
    private String rollingFileMaxValueOfCounter = "15";
    private String deleteActionBasePath;
    private String deleteActionNameCondition;
    private String deleteActionLastModifiedAge = "7d";
    private String sizeBasedTriggeringPolicySize = "10MB";

    public boolean isLoggerMode() {
        return this.isLoggerMode;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public String getLogFilePath() {
        return this.logFilePath;
    }

    public String getLogFileNameWithoutExtension() {
        return this.logFileNameWithoutExtension;
    }

    public String getLogFileExtension() {
        return this.logFileExtension;
    }

    public String getLogFileName() {
        return this.logFileName;
    }

    public String getRollingFilePattern() {
        return this.rollingFilePattern;
    }

    public String getRollingFileMaxValueOfCounter() {
        return this.rollingFileMaxValueOfCounter;
    }

    public String getDeleteActionBasePath() {
        return this.deleteActionBasePath;
    }

    public String getDeleteActionNameCondition() {
        return this.deleteActionNameCondition;
    }

    public String getDeleteActionLastModifiedAge() {
        return this.deleteActionLastModifiedAge;
    }

    public String getSizeBasedTriggeringPolicySize() {
        return this.sizeBasedTriggeringPolicySize;
    }

    private void initLogPathBaseInfo() {
        DynamicDapLogLoggerInfo.initCustomizableFieldValue(KEY_IS_LOGGER_MODE, "Is Logger Mode", customValue -> {
            this.isLoggerMode = Boolean.parseBoolean(customValue);
        });
        DynamicDapLogLoggerInfo.initCustomizableFieldValue(KEY_LOGGER_NAME, "Logger Name", customValue -> {
            if (customValue != null && !customValue.isEmpty()) {
                this.loggerName = customValue;
            }
        });
        DynamicDapLogLoggerInfo.initCustomizableFieldValue(KEY_SIZE_DELETE_ACTION_LAST_MODIFIED_AGE, "Delete action last modified age", customValue -> {
            this.deleteActionLastModifiedAge = customValue;
        });
        DynamicDapLogLoggerInfo.initCustomizableFieldValue(KEY_FILE_PATH, "File Path", customValue -> {
            this.logFilePath = customValue;
        });
        DynamicDapLogLoggerInfo.initCustomizableFieldValue(KEY_FILE_NAME_WITHOUT_EXTENSION, "File Name without extension", customValue -> {
            this.logFileNameWithoutExtension = customValue;
        });
        DynamicDapLogLoggerInfo.initCustomizableFieldValue(KEY_FILE_EXTENSION, "File extension", customValue -> {
            this.logFileExtension = customValue;
        });
        DynamicDapLogLoggerInfo.initCustomizableFieldValue(KEY_ROLLING_FILE_MAX_VALUE_OF_COUNTER, "Rolling file max value of counter", customValue -> {
            this.rollingFileMaxValueOfCounter = customValue;
        });
    }

    public static DynamicDapLogLoggerInfo createFilePathInfo() {
        DynamicDapLogLoggerInfo pathInfo = new DynamicDapLogLoggerInfo();
        pathInfo.initLogPathBaseInfo();
        String hostName = DynamicDapLogLoggerInfo.getSystemOrEnvProperty("HOSTNAME");
        if (hostName == null || hostName.isEmpty()) {
            hostName = DynamicDapLogLoggerInfo.getSystemOrEnvProperty("COMPUTERNAME");
        }
        log.info((Object)("> Host name = " + hostName));
        String actualLogFileNameWithoutExtension = pathInfo.logFileNameWithoutExtension;
        if (hostName != null && !hostName.isEmpty()) {
            actualLogFileNameWithoutExtension = String.format("%s_%s", actualLogFileNameWithoutExtension, hostName);
        }
        actualLogFileNameWithoutExtension = pathInfo.logFilePath + actualLogFileNameWithoutExtension;
        pathInfo.logFileName = actualLogFileNameWithoutExtension + "." + pathInfo.logFileExtension;
        pathInfo.rollingFilePattern = actualLogFileNameWithoutExtension + "-%d{yyyy-MM-dd}.%i." + pathInfo.logFileExtension;
        pathInfo.deleteActionBasePath = pathInfo.logFilePath;
        pathInfo.deleteActionNameCondition = pathInfo.logFileNameWithoutExtension + "*." + pathInfo.logFileExtension;
        DynamicDapLogLoggerInfo.initCustomizableFieldValue(KEY_SIZE_BASED_TRIGGERING_POLICY_SIZE, "Size based triggering policy size", customValue -> {
            pathInfo.sizeBasedTriggeringPolicySize = customValue;
        });
        DynamicDapLogLoggerInfo.logFieldValue(pathInfo.isLoggerMode, "isLoggerMode");
        DynamicDapLogLoggerInfo.logFieldValue(pathInfo.loggerName, "loggerName");
        DynamicDapLogLoggerInfo.logFieldValue(pathInfo.logFilePath, "logFilePath");
        DynamicDapLogLoggerInfo.logFieldValue(pathInfo.logFileNameWithoutExtension, "logFileNameWithoutExtension");
        DynamicDapLogLoggerInfo.logFieldValue(pathInfo.logFileExtension, "logFileExtension");
        DynamicDapLogLoggerInfo.logFieldValue(pathInfo.logFileName, "logFileName");
        DynamicDapLogLoggerInfo.logFieldValue(pathInfo.rollingFilePattern, "rollingFilePattern");
        DynamicDapLogLoggerInfo.logFieldValue(pathInfo.rollingFileMaxValueOfCounter, "rollingFileMaxValueOfCounter");
        DynamicDapLogLoggerInfo.logFieldValue(pathInfo.deleteActionBasePath, "deleteActionBasePath");
        DynamicDapLogLoggerInfo.logFieldValue(pathInfo.deleteActionNameCondition, "deleteActionNameCondition");
        DynamicDapLogLoggerInfo.logFieldValue(pathInfo.deleteActionLastModifiedAge, "deleteActionLastModifiedAge");
        DynamicDapLogLoggerInfo.logFieldValue(pathInfo.sizeBasedTriggeringPolicySize, "sizeBasedTriggeringPolicySize");
        return pathInfo;
    }

    private static void initCustomizableFieldValue(String propertyKey, String description, Consumer<String> customValueConsumer) {
        String customValue = DynamicDapLogLoggerInfo.getSystemOrEnvProperty(propertyKey);
        if (customValue != null && !customValue.isEmpty()) {
            customValueConsumer.accept(customValue);
            log.info((Object)String.format("esp-sdk Found custom ESP Dap Log - %s, variable %s = %s", description, propertyKey, customValue));
        }
    }

    private static void logFieldValue(Object value, String description) {
        log.info((Object)String.format(">esp-sdk Dap Log Logger - %s = %s", description, value));
    }

    public static String getSystemOrEnvProperty(String key) {
        String systemValue = System.getProperty(key);
        if (systemValue == null || systemValue.isEmpty()) {
            return System.getenv(key);
        }
        return systemValue;
    }
}

