/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.esp.sdk;

import com.digiwin.athena.esp.sdk.AbstractInvoker;
import com.digiwin.athena.esp.sdk.InvokerFactory;
import com.digiwin.athena.esp.sdk.constants.URLConstant;
import com.digiwin.athena.esp.sdk.enums.InvokeTypeEnum;
import com.digiwin.athena.esp.sdk.model.EtlMessageModel;
import com.digiwin.athena.esp.sdk.model.EtlRequestModel;
import com.digiwin.athena.esp.sdk.model.EtlResponseModel;
import com.digiwin.athena.esp.sdk.model.MessageModel;
import com.digiwin.athena.esp.sdk.model.RequestModel;
import com.digiwin.athena.esp.sdk.model.ResponseModel;
import com.digiwin.athena.esp.sdk.parameter.ApplicationParameter;
import com.digiwin.athena.esp.sdk.util.DAPSelectInvokeType;
import com.digiwin.athena.esp.sdk.util.EocOmTransformUtil;
import com.digiwin.athena.esp.sdk.util.HttpInvokeUtil;
import com.digiwin.athena.esp.sdk.util.JsonUtil;
import com.digiwin.athena.esp.sdk.util.MQUtil;
import com.digiwin.athena.esp.sdk.util.StringUtil;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;

public class Invoker {
    public static EtlResponseModel invokeEtlSync(EtlRequestModel requestModel) throws Exception {
        requestModel.setInvokeType(InvokeTypeEnum.SYNC);
        EtlMessageModel messageModel = new EtlMessageModel();
        messageModel.setEtlRequestModel(requestModel);
        HttpPost tHttpPost = new HttpPost(URLConstant.ESP_REST_BASE_URL + "/invokeEtl");
        Map<String, Object> headers = messageModel.getEtlRequestModel().getHttpHeaders();
        Set<String> tKeySet = messageModel.getEtlRequestModel().getHttpHeaders().keySet();
        for (String tKey : tKeySet) {
            tHttpPost.setHeader(tKey, headers.get(tKey).toString());
        }
        StringEntity tStringEntity = new StringEntity(messageModel.getEtlRequestModel().getBodyJsonString(), ContentType.APPLICATION_JSON);
        tHttpPost.setEntity((HttpEntity)tStringEntity);
        HttpResponse tHttpResponse = HttpInvokeUtil.executeHttp((HttpUriRequest)tHttpPost);
        HashMap<String, Object> tHeaders = new HashMap<String, Object>();
        for (Header tHeader : tHttpResponse.getAllHeaders()) {
            tHeaders.put(tHeader.getName(), tHeader.getValue());
        }
        EtlResponseModel responseModel = new EtlResponseModel(tHeaders, EntityUtils.toString((HttpEntity)tHttpResponse.getEntity()));
        messageModel.setEtlResponseModel(responseModel);
        return responseModel;
    }

    @Deprecated
    public static String invokeRestSync(String hostProd, String hostVer, String hostId, String hostAcct, String tenantId, String serviceProd, String serviceProdUid, String serviceName, Map<String, String> datakeys, Map<String, String> headers, String bodyJsonString) throws Exception {
        return Invoker.invokeRestSync(hostProd, hostVer, hostId, hostAcct, tenantId, serviceProd, serviceProdUid, serviceName, datakeys, headers, bodyJsonString, null);
    }

    @Deprecated
    public static String invokeRestSync(String hostProd, String hostVer, String hostId, String hostAcct, String tenantId, String serviceProd, String serviceProdUid, String serviceName, Map<String, String> datakeys, Map<String, String> headers, String bodyJsonString, Map<String, String> eocIds) throws Exception {
        MessageModel tMessageModel = Invoker.convertToMessageModel(InvokeTypeEnum.SYNC, hostProd, hostVer, hostId, hostAcct, tenantId, serviceProd, serviceProdUid, serviceName, datakeys, headers, bodyJsonString, eocIds);
        Invoker.invokeRest(tMessageModel);
        if (!DAPSelectInvokeType.canDapInvoke(tMessageModel)) {
            EocOmTransformUtil.transformResponse(tMessageModel);
        }
        return tMessageModel.getResponseModel().getBodyJsonString();
    }

    @Deprecated
    public static ResponseModel invokeRestFasync(String hostProd, String hostVer, String hostId, String hostAcct, String tenantId, String serviceProd, String serviceProdUid, String serviceName, Map<String, String> datakeys, Map<String, String> headers, String bodyJsonString) throws Exception {
        return Invoker.invokeRestFasync(hostProd, hostVer, hostId, hostAcct, tenantId, serviceProd, serviceProdUid, serviceName, datakeys, headers, bodyJsonString, null);
    }

    @Deprecated
    public static ResponseModel invokeRestFasync(String hostProd, String hostVer, String hostId, String hostAcct, String tenantId, String serviceProd, String serviceProdUid, String serviceName, Map<String, String> datakeys, Map<String, String> headers, String bodyJsonString, Map<String, String> eocIds) throws Exception {
        MessageModel tMessageModel = Invoker.convertToMessageModel(InvokeTypeEnum.FASYNC, hostProd, hostVer, hostId, hostAcct, tenantId, serviceProd, serviceProdUid, serviceName, datakeys, headers, bodyJsonString, eocIds);
        Invoker.invokeRest(tMessageModel);
        return tMessageModel.getResponseModel();
    }

    public static ResponseModel invokeRestSync(RequestModel requestModel) throws Exception {
        requestModel.setInvokeType(InvokeTypeEnum.SYNC);
        MessageModel tMessageModel = Invoker.convertToMessageModel(requestModel);
        Invoker.invokeRest(tMessageModel);
        if (!DAPSelectInvokeType.canDapInvoke(tMessageModel)) {
            EocOmTransformUtil.transformResponse(tMessageModel);
        }
        return tMessageModel.getResponseModel();
    }

    public static ResponseModel invokeRestFasync(RequestModel requestModel) throws Exception {
        requestModel.setInvokeType(InvokeTypeEnum.FASYNC);
        MessageModel tMessageModel = Invoker.convertToMessageModel(requestModel);
        Invoker.invokeRest(tMessageModel);
        return tMessageModel.getResponseModel();
    }

    public static ResponseModel invokeRestFasync(RequestModel requestModel, String callbackId, Map<String, String> parentCallbackHeaders) throws Exception {
        String parentId = null;
        if (parentCallbackHeaders.containsKey("digi-callback-parent-reqid")) {
            parentId = parentCallbackHeaders.get("digi-callback-parent-reqid");
        } else if (parentCallbackHeaders.containsKey("digi-reqid")) {
            parentId = parentCallbackHeaders.get("digi-reqid");
        }
        if (parentId != null) {
            requestModel.addHeader("digi-callback-parent-reqid", parentId);
        }
        return Invoker.invokeRestFasync(requestModel, callbackId);
    }

    public static ResponseModel invokeRestFasync(RequestModel requestModel, String callbackId) throws Exception {
        requestModel.addHeader("digi-callback-callback", callbackId);
        requestModel.addHeader("digi-callback-token", requestModel.getHeader("token"));
        return Invoker.invokeRestFasync(requestModel);
    }

    private static void invokeRest(MessageModel messageModel) throws Exception {
        EocOmTransformUtil.transformRequest(messageModel);
        AbstractInvoker invoker = Invoker.getInvoker(messageModel);
        invoker.execute(messageModel);
        if (!StringUtil.isEmptyOrSpace(URLConstant.MQ_URL) && !messageModel.getRequestModel().getServiceName().trim().endsWith(".get") && !messageModel.getRequestModel().getServiceName().trim().endsWith(".check") && "000".equals(messageModel.getResponseModel().getSrvCode())) {
            MQUtil.sendApiInvokeInfo(messageModel);
        }
    }

    private static MessageModel convertToMessageModel(RequestModel requestModel) {
        MessageModel messageModel = new MessageModel();
        messageModel.setRequestModel(requestModel);
        return messageModel;
    }

    private static MessageModel convertToMessageModel(InvokeTypeEnum type, String hostProd, String hostVer, String hostId, String hostAcct, String tenantId, String serviceProd, String serviceProdUid, String serviceName, Map<String, String> datakeys, Map<String, String> headers, String bodyJsonString, Map<String, String> eocIds) {
        RequestModel requestModel = new RequestModel();
        requestModel.setInvokeType(type);
        requestModel.setHostProd(hostProd);
        requestModel.setHostVer(hostVer);
        requestModel.setHostId(hostId);
        requestModel.setHostAcct(hostAcct);
        requestModel.setTenantId(tenantId);
        requestModel.setServiceProd(serviceProd);
        requestModel.setServiceProdUid(serviceProdUid);
        requestModel.setServiceName(serviceName);
        requestModel.setDatakeyMap(datakeys);
        requestModel.setHeaderMap(headers);
        requestModel.setBodyJsonString(bodyJsonString);
        requestModel.setEocMapStr(eocIds);
        return Invoker.convertToMessageModel(requestModel);
    }

    private static AbstractInvoker getInvoker(MessageModel messageModel) {
        String type;
        if (DAPSelectInvokeType.canDapInvoke(messageModel)) {
            return InvokerFactory.getDapInvoker();
        }
        if (messageModel.getRequestModel().getEocDispatchInfoModelList() != null && !messageModel.getRequestModel().getEocDispatchInfoModelList().isEmpty()) {
            return InvokerFactory.getEspdpInvoker();
        }
        if (ApplicationParameter.getParameter("enableEspRouting") == null || ((Boolean)ApplicationParameter.getParameter("enableEspRouting")).booleanValue()) {
            return InvokerFactory.getEspInvoker();
        }
        JsonObject mappingJsonObject = messageModel.getEocMappingJsonObject();
        if (JsonUtil.isNullOrEmpty(mappingJsonObject.get("prod_type"))) {
            return InvokerFactory.getEspInvoker();
        }
        switch (type = mappingJsonObject.get("prod_type").getAsString().trim()) {
            case "agile": {
                return InvokerFactory.getAppInvoker();
            }
            case "standard": {
                return InvokerFactory.getEspInvoker();
            }
        }
        return InvokerFactory.getEspInvoker();
    }
}

