/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.esp.sdk.configuration;

import com.digiwin.athena.esp.sdk.dap.ESPTraceIdProvider;
import com.digiwin.athena.esp.sdk.dap.log.log4j2.Log4j2ESPLogger;
import com.digiwin.athena.esp.sdk.dap.log.service.DapLogService;
import com.digiwin.athena.esp.sdk.init.EspSdkInitialize;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.core.LoggerContext;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(name={"org.apache.logging.log4j.core.appender.RollingFileAppender"})
@ConditionalOnProperty(name={"espDapLogIsDynamicLogger"}, havingValue="true", matchIfMissing=true)
public class ESPDynamicLog4jLoggerAutoConfiguration {
    private static Log log = LogFactory.getLog(ESPDynamicLog4jLoggerAutoConfiguration.class);

    public ESPDynamicLog4jLoggerAutoConfiguration(ObjectProvider<ESPTraceIdProvider> traceIdProviderInstanceProvider) {
        log.info((Object)"ESPDynamicLog4jLoggerAutoConfiguration ready to init Log4j2ESPLogger...");
        LoggerContext loggerContext = null;
        try {
            ClassLoader classLoader = EspSdkInitialize.deduceClassLoader();
            if (classLoader != null) {
                Class<?> dwLoggerContextClazz = classLoader.loadClass("com.digiwin.app.log.DWLoggerContext");
                Method targetMethod = dwLoggerContextClazz.getDeclaredMethod("getContext", new Class[0]);
                loggerContext = (LoggerContext)targetMethod.invoke(null, new Object[0]);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.error((Object)"EspSdkInitialize.initLogger failed!", (Throwable)e);
        }
        Log4j2ESPLogger espLogger = new Log4j2ESPLogger(loggerContext);
        DapLogService.setEspLogLogger(espLogger, (ESPTraceIdProvider)traceIdProviderInstanceProvider.getIfAvailable(() -> null));
    }
}

