/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.esp.sdk.configuration;

import com.digiwin.athena.esp.sdk.dap.ESPTraceIdProvider;
import com.digiwin.athena.esp.sdk.dap.log.service.DapLogService;
import com.digiwin.athena.esp.sdk.dap.log.slf4j.Slf4jESPLogger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.ConfigurationCondition;

@Conditional(value={Slf4jESPLoggerCondition.class})
public class ESPStaticLoggerAutoConfiguration {
    private static Log log = LogFactory.getLog(ESPStaticLoggerAutoConfiguration.class);

    public ESPStaticLoggerAutoConfiguration(ObjectProvider<ESPTraceIdProvider> traceIdProviderInstanceProvider) {
        log.info((Object)"ESPStaticLoggerAutoConfiguration ready to init Slf4jESPLogger...");
        Slf4jESPLogger espLogger = new Slf4jESPLogger();
        DapLogService.setEspLogLogger(espLogger, (ESPTraceIdProvider)traceIdProviderInstanceProvider.getIfAvailable(() -> null));
    }

    public static class Slf4jESPLoggerCondition
    extends AnyNestedCondition {
        public Slf4jESPLoggerCondition() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @ConditionalOnProperty(name={"espDapLogIsDynamicLogger"}, havingValue="false", matchIfMissing=false)
        static class PropertyCondition {
            PropertyCondition() {
            }
        }

        @ConditionalOnMissingClass(value={"org.apache.logging.log4j.core.appender.RollingFileAppender"})
        static class RollingFileAppenderNotPresentCondition {
            RollingFileAppenderNotPresentCondition() {
            }
        }
    }
}

