/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.esp.sdk.dap.log.service;

import com.digiwin.athena.esp.sdk.constants.URLConstant;
import com.digiwin.athena.esp.sdk.dap.ESPTraceIdProvider;
import com.digiwin.athena.esp.sdk.dap.log.ESPLogLogger;
import com.digiwin.athena.esp.sdk.dap.log.dto.DapLogDto;
import com.digiwin.athena.esp.sdk.util.DapLogHttpClientFactory;
import com.digiwin.athena.esp.sdk.util.JsonUtil;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class DapLogService {
    private static Log log = LogFactory.getLog(DapLogService.class);
    private static final String PATH = URLConstant.ESP_REST_BASE_URL + "/saveDapLogs";
    private static ExecutorService executorService = new ThreadPoolExecutor(10, 30, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1000), (r, executor) -> log.error((Object)"Dap log send queue is full will discard current work !!!"));
    private static CloseableHttpClient httpClient;
    private static ESPLogLogger espLogLogger;
    private static ESPTraceIdProvider traceIdProvider;

    public DapLogService() {
        httpClient = DapLogHttpClientFactory.createHttpClient();
    }

    public static void setEspLogLogger(ESPLogLogger espLogLogger, ESPTraceIdProvider traceIdProvider) {
        DapLogService.espLogLogger = espLogLogger;
        if (traceIdProvider != null) {
            DapLogService.traceIdProvider = traceIdProvider;
        }
        log.info((Object)("setEspLogLogger, esp log logger instance = " + espLogLogger));
        log.info((Object)("setEspLogLogger, trace id provider instance = " + traceIdProvider));
        if (espLogLogger != null) {
            espLogLogger.initialize();
        }
    }

    public static ESPLogLogger getEspLogLogger() {
        if (espLogLogger == null) {
            throw new IllegalArgumentException("ESP-SDK ESP Log Logger is not ready, please contact DAP for this issue!");
        }
        return espLogLogger;
    }

    protected void saveLogToFile(DapLogDto dapLogDto) {
        DapLogDto[] logArray = new DapLogDto[]{dapLogDto};
        String logContent = JsonUtil.toString(logArray);
        if (espLogLogger == null) {
            log.warn((Object)"esp-sdk DapLogService.espLogLogger is null, maybe you forgot to call EspSdkInitialize.initConfig method first?");
        } else {
            espLogLogger.log(logContent);
        }
    }

    public void saveLog(DapLogDto dapLogDto) {
        dapLogDto.setPtxid(traceIdProvider.get());
        if (espLogLogger != null && espLogLogger.getEspLogConfig().isLoggerMode()) {
            log.info((Object)"esp-sdk start to log Dap log to log4j logger...");
            this.saveLogToFile(dapLogDto);
            log.info((Object)"esp-sdk log Dap log completed.");
            return;
        }
        log.info((Object)("esp-sdk submit Dap log :" + dapLogDto));
        executorService.submit(() -> {
            boolean result = true;
            String path = URLConstant.ESP_REST_BASE_URL + "/saveDapLogs";
            log.info((Object)("esp-sdk start to send Dap log :" + dapLogDto + ", logpath:" + path));
            DapLogDto[] logArray = new DapLogDto[]{dapLogDto};
            HttpPost httpPost = new HttpPost(path);
            StringEntity stringEntity = new StringEntity(JsonUtil.toString(logArray), ContentType.APPLICATION_JSON);
            httpPost.setEntity((HttpEntity)stringEntity);
            try {
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                String body = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                log.info((Object)String.format("esp-sdk send Dap log, response status code=%s, body=%s", response.getStatusLine().getStatusCode(), body));
            }
            catch (Exception e) {
                result = false;
                log.error((Object)("esp-sdk send Dap log  error log:" + dapLogDto + ", e:{}"), (Throwable)e);
            }
            if (result) {
                log.info((Object)("esp-sdk send Dap log success log :" + dapLogDto + ", logpath:" + path));
            }
        });
    }

    static {
        traceIdProvider = () -> null;
    }
}

