/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.esp.sdk.model;

import com.digiwin.athena.esp.sdk.constants.AppConstant;
import com.digiwin.athena.esp.sdk.enums.InvokeTypeEnum;
import com.digiwin.athena.esp.sdk.util.DigestUtil;
import com.digiwin.athena.esp.sdk.util.StringUtil;
import com.google.gson.JsonObject;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class EtlRequestModel {
    private InvokeTypeEnum invokeType;
    private String hostProd;
    private String hostVer;
    private String hostId;
    private String hostAcct;
    private String hostEmpAcct;
    private String language;
    private String tenantId;
    private String jobName;
    private String jobVer;
    private Map<String, String> headers;
    private Map<String, String> datakeys;
    private String bodyJsonString;

    public InvokeTypeEnum getInvokeType() {
        return this.invokeType;
    }

    public void setInvokeType(InvokeTypeEnum invokeType) {
        this.invokeType = invokeType;
    }

    public String getHostProd() {
        return this.hostProd;
    }

    public void setHostProd(String hostProd) {
        this.hostProd = hostProd;
    }

    public String getHostVer() {
        return this.hostVer;
    }

    public void setHostVer(String hostVer) {
        this.hostVer = hostVer;
    }

    public String getHostId() {
        return this.hostId;
    }

    public void setHostId(String hostId) {
        this.hostId = hostId;
    }

    public String getHostAcct() {
        return this.hostAcct;
    }

    public void setHostAcct(String hostAcct) {
        this.hostAcct = hostAcct;
    }

    public String getHostEmpAcct() {
        return this.hostEmpAcct;
    }

    public void setHostEmpAcct(String hostEmpAcct) {
        this.hostEmpAcct = hostEmpAcct;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getJobVer() {
        return this.jobVer;
    }

    public void setJobVer(String jobVer) {
        this.jobVer = jobVer;
    }

    public String getBodyJsonString() {
        return this.bodyJsonString;
    }

    public void setBodyJsonString(String bodyJsonString) {
        this.bodyJsonString = bodyJsonString;
    }

    public Map<String, String> getDatakeyMap() {
        return this.datakeys;
    }

    public void setDatakeyMap(Map<String, String> datakeymap) {
        this.datakeys = datakeymap;
    }

    public String getDatakey(String key) {
        if (this.datakeys == null) {
            return null;
        }
        return this.datakeys.get(key);
    }

    public void addDatakey(String key, String value) {
        if (this.datakeys == null) {
            this.datakeys = new HashMap<String, String>();
        }
        this.datakeys.put(key, value);
    }

    public Map<String, String> getHeaderMap() {
        return this.headers;
    }

    public void setHeaderMap(Map<String, String> headermap) {
        this.headers = headermap;
    }

    public String getHeader(String key) {
        if (this.headers == null) {
            return null;
        }
        return this.headers.get(key);
    }

    public void addHeader(String key, String value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(key, value);
    }

    public Map<String, Object> getHttpHeaders() {
        HashMap<String, Object> tMap = new HashMap<String, Object>();
        tMap.put("digi-type", this.invokeType.toString().toLowerCase());
        JsonObject tHostJsonObject = new JsonObject();
        tHostJsonObject.addProperty("prod", this.hostProd);
        tHostJsonObject.addProperty("ver", this.hostVer);
        tHostJsonObject.addProperty("ip", "");
        if (this.hostId != null) {
            tHostJsonObject.addProperty("id", this.hostId);
        }
        tHostJsonObject.addProperty("timestamp", new SimpleDateFormat("yyyyMMddHHmmssSSS").format(Calendar.getInstance().getTime()));
        if (this.language != null) {
            tHostJsonObject.addProperty("lang", this.language);
            tMap.put("locale", this.language);
        }
        if (this.hostAcct != null) {
            tHostJsonObject.addProperty("eoc_acct", this.hostAcct);
        }
        if (this.hostEmpAcct != null) {
            tHostJsonObject.addProperty("acct", this.hostEmpAcct);
        }
        tMap.put("digi-host", tHostJsonObject);
        JsonObject tEtlJsonObject = new JsonObject();
        tEtlJsonObject.addProperty("name", this.jobName);
        tEtlJsonObject.addProperty("tenant_id", this.tenantId);
        if (this.jobVer != null) {
            tEtlJsonObject.addProperty("ver", this.jobVer);
        }
        tMap.put("digi-etljob", tEtlJsonObject);
        String keyStr = tHostJsonObject.toString();
        String md5Key = DigestUtil.getDigestCode("MD5", keyStr);
        tMap.put("digi-key", md5Key);
        if (this.datakeys != null && !this.datakeys.isEmpty()) {
            JsonObject tDatakeyJsonObject = new JsonObject();
            for (String tKey : this.datakeys.keySet()) {
                tDatakeyJsonObject.addProperty(tKey, this.datakeys.get(tKey));
            }
            tMap.put("digi-datakey", tDatakeyJsonObject);
        }
        tMap.put("routerKey", this.getTenantId());
        if (!StringUtil.isEmptyOrSpace(AppConstant.APP_TOKEN)) {
            tMap.put("digi-middleware-auth-app", AppConstant.APP_TOKEN);
        }
        if (!StringUtil.isEmptyOrSpace(AppConstant.APP_SECRET)) {
            tMap.put("digi-middleware-auth-app-secret", AppConstant.APP_SECRET);
        }
        if (this.headers != null) {
            tMap.putAll(this.headers);
        }
        return tMap;
    }
}

