/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.esp.sdk.util;

import com.digiwin.athena.esp.sdk.connection.HttpClientFactory;
import com.digiwin.athena.esp.sdk.constants.ParamConstant;
import com.digiwin.athena.esp.sdk.exception.InvocationException;
import com.digiwin.athena.esp.sdk.init.EspHttpClientConfig;
import com.digiwin.athena.esp.sdk.util.JsonUtil;
import com.digiwin.athena.esp.sdk.util.LogUtil;
import com.digiwin.athena.esp.sdk.util.StringUtil;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public class HttpInvokeUtil {
    private static Log log = LogFactory.getLog(HttpInvokeUtil.class);
    public static final String KEY_IDEMPOTENCE = "idempotence";

    public static Boolean getIdempotence(HttpContext httpContext) {
        return (Boolean)httpContext.getAttribute(KEY_IDEMPOTENCE);
    }

    public static void setIdempotence(HttpContext httpContext, boolean idempotence) {
        httpContext.setAttribute(KEY_IDEMPOTENCE, (Object)idempotence);
    }

    public static HttpResponse executeHttp(HttpUriRequest httpRequest) throws Exception {
        return HttpInvokeUtil.executeHttp(httpRequest, true);
    }

    protected static int retryExceptionCheck(int retryTimes, Exception e) throws Exception {
        log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]HTTP request retryExceptionCheck: retryTimes:" + retryTimes));
        if (--retryTimes <= 0) {
            throw e;
        }
        try {
            Thread.sleep(ParamConstant.RETRY_INTERVAL);
        }
        catch (InterruptedException e1) {
            log.warn((Object)("[Thread.id " + Thread.currentThread().getId() + "]" + e1));
            Thread.currentThread().interrupt();
            throw e;
        }
        return retryTimes;
    }

    protected static void checkErrorCode(JsonObject tReturnJsonObject, String reqId) {
        JsonElement errorCodeE = tReturnJsonObject.get("errorCode");
        if (!JsonUtil.isNull(errorCodeE)) {
            String errorCode = errorCodeE.getAsString();
            String errorMessage = tReturnJsonObject.get("errorMessage") == null ? "" : tReturnJsonObject.get("errorMessage").getAsString();
            JsonObject instructors = tReturnJsonObject.getAsJsonObject("errorInstructors");
            String chainInfo = "";
            if (null != instructors) {
                chainInfo = instructors.get("chainInfo") == null ? "" : instructors.get("chainInfo").getAsString();
            }
            throw new InvocationException(errorCode, errorMessage, chainInfo, reqId);
        }
    }

    @Deprecated
    public static HttpResponse executeHttpRequest(HttpUriRequest httpRequest) throws ClientProtocolException, IOException {
        CloseableHttpClient tClient = HttpClientFactory.createHttpClient();
        int retryCount = ParamConstant.RETRY_COUNT;
        while (true) {
            try {
                CloseableHttpResponse tResponse;
                int tStatusCode;
                while ((tStatusCode = (tResponse = tClient.execute(httpRequest)).getStatusLine().getStatusCode()) == 404 || tStatusCode == 502) {
                    if (--retryCount <= 0) {
                        log.warn((Object)("[Thread.id " + Thread.currentThread().getId() + "]http status " + tStatusCode + ", and retry limit has been exceeded."));
                        LogUtil.saveHttpErrorLogToLMC(httpRequest.getMethod(), httpRequest.getURI().toString(), tResponse.getStatusLine().getStatusCode());
                        return tResponse;
                    }
                    log.warn((Object)("[Thread.id " + Thread.currentThread().getId() + "]http status " + tStatusCode + ", waiting for retry..."));
                    try {
                        Thread.sleep(ParamConstant.RETRY_INTERVAL);
                    }
                    catch (InterruptedException e1) {
                        log.warn((Object)("[Thread.id " + Thread.currentThread().getId() + "]" + e1));
                        Thread.currentThread().interrupt();
                        return tResponse;
                    }
                }
                return tResponse;
            }
            catch (Exception e) {
                log.warn((Object)("[Thread.id " + Thread.currentThread().getId() + "]" + e));
                if (--retryCount <= 0) {
                    throw e;
                }
                try {
                    Thread.sleep(ParamConstant.RETRY_INTERVAL);
                }
                catch (InterruptedException e1) {
                    log.warn((Object)("[Thread.id " + Thread.currentThread().getId() + "]" + e1));
                    Thread.currentThread().interrupt();
                    throw e;
                }
            }
        }
    }

    public static HttpResponse executeHttpWithDapRetry(HttpUriRequest httpRequest, boolean idempotency) throws Exception {
        CloseableHttpClient tClient = EspHttpClientConfig.getDefaultHttpClient();
        BasicHttpContext httpContext = new BasicHttpContext();
        HttpInvokeUtil.setIdempotence((HttpContext)httpContext, idempotency);
        CloseableHttpResponse tResponse = tClient.execute(httpRequest, (HttpContext)httpContext);
        JsonObject tReturnJsonObject = null;
        try {
            HttpEntity entity = tResponse.getEntity();
            entity = new BufferedHttpEntity(entity);
            tResponse.setEntity(entity);
            tReturnJsonObject = JsonUtil.parseHttpResponseBody((HttpResponse)tResponse, null);
        }
        catch (Exception e) {
            log.error((Object)("[Thread.id " + Thread.currentThread().getId() + "][url:" + httpRequest.getURI() + "]Http Response Body parse fail:{}"), (Throwable)e);
            HttpInvokeUtil.processParseException(httpRequest, (HttpResponse)tResponse);
        }
        if (null != tReturnJsonObject) {
            HttpInvokeUtil.checkErrorCode(tReturnJsonObject, HttpInvokeUtil.getReqId((HttpResponse)tResponse));
        }
        return tResponse;
    }

    public static HttpResponse executeHttp(HttpUriRequest httpRequest, boolean idempotency) throws Exception {
        if (!EspHttpClientConfig.isLegacyMode()) {
            return HttpInvokeUtil.executeHttpWithDapRetry(httpRequest, idempotency);
        }
        CloseableHttpClient tClient = HttpClientFactory.createHttpClient();
        int retryCount = ParamConstant.RETRY_COUNT;
        while (true) {
            try {
                CloseableHttpResponse tResponse;
                int tStatusCode;
                while ((tStatusCode = (tResponse = tClient.execute(httpRequest)).getStatusLine().getStatusCode()) == 404 || tStatusCode == 502) {
                    if (--retryCount <= 0 || !idempotency) {
                        log.warn((Object)("[Thread.id " + Thread.currentThread().getId() + "][url:" + httpRequest.getURI() + "]http status " + tStatusCode + ", and retry limit has been exceeded."));
                        LogUtil.saveHttpErrorLogToLMC(httpRequest.getMethod(), httpRequest.getURI().toString(), tResponse.getStatusLine().getStatusCode());
                        return tResponse;
                    }
                    log.warn((Object)("[Thread.id " + Thread.currentThread().getId() + "][url:" + httpRequest.getURI() + "]http status " + tStatusCode + ", waiting for retry..."));
                    try {
                        Thread.sleep(ParamConstant.RETRY_INTERVAL);
                    }
                    catch (InterruptedException e1) {
                        log.warn((Object)("[Thread.id " + Thread.currentThread().getId() + "]" + e1));
                        Thread.currentThread().interrupt();
                        return tResponse;
                    }
                }
                JsonObject tReturnJsonObject = null;
                try {
                    HttpEntity entity = tResponse.getEntity();
                    entity = new BufferedHttpEntity(entity);
                    tResponse.setEntity(entity);
                    tReturnJsonObject = JsonUtil.parseHttpResponseBody((HttpResponse)tResponse, null);
                }
                catch (Exception e) {
                    log.error((Object)("[Thread.id " + Thread.currentThread().getId() + "][url:" + httpRequest.getURI() + "]Http Response Body parse fail:{}"), (Throwable)e);
                    HttpInvokeUtil.processParseException(httpRequest, (HttpResponse)tResponse);
                }
                if (null != tReturnJsonObject) {
                    HttpInvokeUtil.checkErrorCode(tReturnJsonObject, HttpInvokeUtil.getReqId((HttpResponse)tResponse));
                }
                return tResponse;
            }
            catch (InvocationException e) {
                throw e;
            }
            catch (NoHttpResponseException e) {
                log.warn((Object)("[Thread.id " + Thread.currentThread().getId() + "][url:" + httpRequest.getURI() + "]HTTP request NoHttpResponseException:{}"), (Throwable)e);
                tClient = HttpClientFactory.reCreateHttpClient();
                retryCount = HttpInvokeUtil.retryExceptionCheck(retryCount, (Exception)((Object)e));
                continue;
            }
            catch (Exception e) {
                log.warn((Object)("[Thread.id " + Thread.currentThread().getId() + "][url:" + httpRequest.getURI() + "]HTTP request Exception:{}" + e));
                retryCount = HttpInvokeUtil.retryExceptionCheck(retryCount, e);
                continue;
            }
            break;
        }
    }

    protected static String getReqId(HttpResponse httpResponse) {
        Header header = httpResponse.getLastHeader("digi-reqid");
        return header != null ? header.getValue() : null;
    }

    protected static void processParseException(HttpUriRequest httpRequest, HttpResponse httpResponse) {
        Header header = httpRequest.getLastHeader("digi-service");
        if (null != header) {
            int tStatusCode = httpResponse.getStatusLine().getStatusCode();
            JsonParser tJsonParser = new JsonParser();
            JsonObject jsonObject = (JsonObject)tJsonParser.parse(header.getValue());
            JsonElement prodEle = jsonObject.get("prod");
            JsonElement nameEle = jsonObject.get("name");
            if (null != prodEle && !StringUtil.isEmpty(prodEle.getAsString()) && null != nameEle && !StringUtil.isEmpty(nameEle.getAsString())) {
                String errorCode = "P." + prodEle.getAsString() + "." + tStatusCode + ".0999";
                String errorMessage = "\u8bf7\u6c42" + prodEle.getAsString() + "\u670d\u52a1:" + nameEle.getAsString() + "\u53cd\u9988" + tStatusCode;
                throw new InvocationException(errorCode, errorMessage, "", HttpInvokeUtil.getReqId(httpResponse));
            }
        }
    }
}

