/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.esp.sdk.util;

import com.digiwin.athena.esp.sdk.connection.HttpClientFactory;
import com.digiwin.athena.esp.sdk.constants.AppConstant;
import com.digiwin.athena.esp.sdk.constants.URLConstant;
import com.digiwin.athena.esp.sdk.util.JsonUtil;
import com.digiwin.athena.esp.sdk.util.LogModel;
import com.digiwin.athena.esp.sdk.util.StringUtil;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Calendar;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class LogUtil {
    private static final ExecutorService EXECUTOR_SERVICE = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors() << 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());

    public static void saveHttpErrorLogToLMC(final String httpMethod, final String uri, final int httpStatus) {
        final Calendar timestamp = Calendar.getInstance();
        if (StringUtil.isEmptyOrSpace(URLConstant.LMC_BASE_URL)) {
            return;
        }
        EXECUTOR_SERVICE.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    LogModel logModel = new LogModel();
                    logModel.setAppId("esp");
                    logModel.setEventType(0);
                    logModel.setRequestType(httpMethod);
                    logModel.setEventId("httpError");
                    logModel.setEventName("httpError");
                    logModel.setTimeStamp(timestamp.getTimeInMillis());
                    logModel.sethttpStatus(httpStatus);
                    logModel.addContent("URI", uri);
                    if (AppConstant.APP_ID != null) {
                        logModel.addContent("appid", AppConstant.APP_ID);
                    }
                    HttpPost tHttpPost = new HttpPost(URLConstant.LMC_BASE_URL + "/api/lmc/v1/eventlog");
                    CloseableHttpClient tClient = HttpClientFactory.createHttpClient();
                    if (AppConstant.APP_TOKEN != null) {
                        tHttpPost.setHeader("digi-middleware-auth-app", AppConstant.APP_TOKEN);
                    }
                    StringEntity tStringEntity = new StringEntity(JsonUtil.toString(logModel), ContentType.APPLICATION_JSON);
                    tHttpPost.setEntity((HttpEntity)tStringEntity);
                    CloseableHttpResponse response = tClient.execute((HttpUriRequest)tHttpPost);
                    EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static void saveLogToLMC(final String eventId, final String tenantId, final Map<String, Object> requestHeaders, final Integer httpstatus, final Map<String, Object> headers, final String messageBody, final Exception ex) throws ClientProtocolException, IOException {
        final Calendar timestamp = Calendar.getInstance();
        EXECUTOR_SERVICE.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    LogModel logModel = new LogModel();
                    logModel.setAppId("esp");
                    logModel.setEventType(0);
                    logModel.setRequestType("POST");
                    logModel.setEventId(eventId);
                    logModel.setEventName(eventId);
                    logModel.setTenantId(tenantId);
                    logModel.setTimeStamp(timestamp.getTimeInMillis());
                    logModel.setRequestHeader(requestHeaders);
                    if (ex != null) {
                        logModel.setStatus(1);
                        logModel.setHeader("");
                        logModel.setBody("");
                        StringWriter stackTrace = new StringWriter();
                        ex.printStackTrace(new PrintWriter(stackTrace));
                        logModel.setErrorMessage(ex.getMessage() != null ? ex.getMessage() : "");
                        logModel.setStackTrace(stackTrace.toString());
                    } else {
                        logModel.setStatus(httpstatus != null && !httpstatus.toString().startsWith("2") ? 1 : 0);
                        logModel.sethttpStatus(httpstatus);
                        logModel.setHeader(headers);
                        try {
                            JsonObject tLogBodyObject = (JsonObject)new Gson().fromJson(messageBody, JsonObject.class);
                            logModel.setBody(tLogBodyObject);
                        }
                        catch (JsonSyntaxException e) {
                            logModel.setBody(messageBody);
                        }
                    }
                    HttpPost tHttpPost = new HttpPost(URLConstant.LMC_BASE_URL + "/api/lmc/v1/eventlog");
                    CloseableHttpClient tClient = HttpClientFactory.createHttpClient();
                    if (AppConstant.APP_TOKEN != null) {
                        tHttpPost.setHeader("digi-middleware-auth-app", AppConstant.APP_TOKEN);
                    }
                    StringEntity tStringEntity = new StringEntity(JsonUtil.toString(logModel), ContentType.APPLICATION_JSON);
                    tHttpPost.setEntity((HttpEntity)tStringEntity);
                    CloseableHttpResponse response = tClient.execute((HttpUriRequest)tHttpPost);
                    EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

