/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.esp.sdk.util;

import com.digiwin.athena.esp.sdk.constants.URLConstant;
import com.digiwin.athena.esp.sdk.util.HttpInvokeUtil;
import com.digiwin.athena.esp.sdk.util.JsonUtil;
import com.digiwin.athena.esp.sdk.util.StringUtil;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

public class MDCUtil {
    private static Log log = LogFactory.getLog(MDCUtil.class);
    private static final String MDC_APIMETADATA_GET = "/restful/standard/mdc/ApiBaseInfo/Get";
    private static final String MDC_PARENTSERVICENAME_GET = "/restful/standard/mdc/ApiRelation/Get";
    private static final String MDC_SERVICE_BASE_INFO_GET = "/restful/standard/mdc/ServiceBaseInfo/get";

    public static boolean getApiIdempotency(String apiName, String tenantId) {
        String tURL = URLConstant.MDC_BASE_URL + MDC_APIMETADATA_GET;
        HttpPost tHttpPost = new HttpPost(tURL);
        JsonObject tJsonObject = new JsonObject();
        tJsonObject.addProperty("api_name", apiName);
        tJsonObject.addProperty("tenant_id", tenantId);
        StringEntity tStringEntity = new StringEntity(tJsonObject.toString(), ContentType.APPLICATION_JSON);
        tHttpPost.setEntity((HttpEntity)tStringEntity);
        try {
            HttpResponse tHttpResponse = HttpInvokeUtil.executeHttp((HttpUriRequest)tHttpPost);
            JsonObject tReturnJsonObject = JsonUtil.parseHttpResponseBody(tHttpResponse, tURL);
            return tReturnJsonObject.getAsJsonObject("data").get("idempotency").getAsBoolean();
        }
        catch (Exception e) {
            log.warn((Object)("[Thread.id " + Thread.currentThread().getId() + "]mdc get Api Idempotency fail;apiName:" + apiName + ", tenantId: " + tenantId + ", e:{}"), (Throwable)e);
            return false;
        }
    }

    public static String getParentServiceName(String serviceName, String tenantId) {
        String tURL = URLConstant.MDC_BASE_URL + MDC_PARENTSERVICENAME_GET;
        HttpPost tHttpPost = new HttpPost(tURL);
        JsonObject tJsonObject = new JsonObject();
        tJsonObject.addProperty("api_name", serviceName);
        tJsonObject.addProperty("tenant_id", tenantId);
        StringEntity tStringEntity = new StringEntity(tJsonObject.toString(), ContentType.APPLICATION_JSON);
        tHttpPost.setEntity((HttpEntity)tStringEntity);
        try {
            HttpResponse tHttpResponse = HttpInvokeUtil.executeHttp((HttpUriRequest)tHttpPost);
            JsonObject tReturnJsonObject = JsonUtil.parseHttpResponseBody(tHttpResponse, tURL);
            JsonElement parentApiName = tReturnJsonObject.getAsJsonObject("data").get("parentApiName");
            if (StringUtil.isNotEmpty(parentApiName)) {
                return parentApiName.getAsString();
            }
        }
        catch (Exception e) {
            log.error((Object)("[Thread.id " + Thread.currentThread().getId() + "]mdc getParentServiceName fail;apiName:" + serviceName + ", tenantId: " + tenantId + ", e:{}"), (Throwable)e);
        }
        return null;
    }

    public static JsonElement getServiceBaseInfo(String serviceName, String tenantId, String serviceProdUid, String serviceProd, boolean needDispatch, boolean needIdempotency) {
        String tURL = URLConstant.MDC_BASE_URL + MDC_SERVICE_BASE_INFO_GET;
        HttpPost tHttpPost = new HttpPost(tURL);
        JsonObject tJsonObject = new JsonObject();
        tJsonObject.addProperty("apiName", serviceName);
        tJsonObject.addProperty("tenantId", tenantId);
        tJsonObject.addProperty("serviceProdUid", serviceProdUid);
        tJsonObject.addProperty("serviceProd", serviceProd);
        tJsonObject.addProperty("needDispatch", Boolean.valueOf(needDispatch));
        tJsonObject.addProperty("needIdempotency", Boolean.valueOf(needIdempotency));
        StringEntity tStringEntity = new StringEntity(tJsonObject.toString(), ContentType.APPLICATION_JSON);
        tHttpPost.setEntity((HttpEntity)tStringEntity);
        try {
            HttpResponse tHttpResponse = HttpInvokeUtil.executeHttp((HttpUriRequest)tHttpPost);
            JsonObject tReturnJsonObject = JsonUtil.parseHttpResponseBody(tHttpResponse, tURL);
            JsonElement data = tReturnJsonObject.getAsJsonObject("data").get("parentApiName");
            return data;
        }
        catch (Exception e) {
            log.error((Object)("[Thread.id " + Thread.currentThread().getId() + "]mdc getParentServiceName fail;apiName:" + serviceName + ", tenantId: " + tenantId + ", e:{}"), (Throwable)e);
            return null;
        }
    }
}

