/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.esp.sdk.init;

import com.digiwin.athena.esp.sdk.constants.AppConstant;
import com.digiwin.athena.esp.sdk.constants.DAPConstant;
import com.digiwin.athena.esp.sdk.constants.ParamConstant;
import com.digiwin.athena.esp.sdk.constants.URLConstant;
import com.digiwin.athena.esp.sdk.dap.spi.ProdNameTransformService;
import com.digiwin.athena.esp.sdk.dap.spi.localroute.LocalRouteProcess;
import com.digiwin.athena.esp.sdk.parameter.ApplicationParameter;
import com.digiwin.athena.esp.sdk.util.StringUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ServiceLoader;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class EspSdkInitialize {
    private static Log log = LogFactory.getLog(EspSdkInitialize.class);

    public static void initMQConfig(String mqUrl) {
        URLConstant.MQ_URL = mqUrl.trim();
    }

    public static void initAppConfig(String appid, String apptoken) {
        AppConstant.APP_ID = appid.trim();
        AppConstant.APP_TOKEN = apptoken.trim();
    }

    public static void initAppSecret(String appsecret) {
        AppConstant.APP_SECRET = appsecret.trim();
    }

    public static void setAppAuthExclude(String authExclude) {
        if (!StringUtil.isEmptyOrSpace(authExclude)) {
            AppConstant.APP_AUTH_EXCLUDE = authExclude.split(",");
        }
    }

    public static void initLmcConfig(String lmcUrl) {
        if (lmcUrl != null) {
            URLConstant.LMC_BASE_URL = lmcUrl.trim().startsWith("http") ? lmcUrl.trim() : "http://" + lmcUrl.trim();
        }
    }

    public static void enableEspRouting(Boolean value) {
        ApplicationParameter.setParameter("enableEspRouting", value);
    }

    public static void initConfig(String espDomain, String mdcDomain) {
        EspSdkInitialize.initConfig(espDomain, mdcDomain, null, null, null);
    }

    public static void initConfig(String espDomain, String mdcDomain, String kmDomain) {
        EspSdkInitialize.initConfig(espDomain, mdcDomain, kmDomain, null, null);
    }

    public static void initConfig(String espDomain, String mdcDomain, String kmDomain, String eocDomain) {
        EspSdkInitialize.initConfig(espDomain, mdcDomain, kmDomain, eocDomain, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initConfig(String espDomain, String mdcDomain, String kmDomain, String eocDomain, String iamDomain) {
        Class<EspSdkInitialize> clazz = EspSdkInitialize.class;
        synchronized (EspSdkInitialize.class) {
            if (espDomain != null) {
                if (espDomain.trim().startsWith("http")) {
                    URLConstant.ESP_REST_BASE_URL = espDomain.trim() + "/CROSS/RESTful";
                    URLConstant.ESPDP_BASE_URL = espDomain.trim().replaceFirst("esp", "espdp");
                } else {
                    URLConstant.ESP_REST_BASE_URL = "http://" + espDomain.trim() + "/CROSS/RESTful";
                    URLConstant.ESPDP_BASE_URL = "http://" + espDomain.trim().replaceFirst("esp", "espdp");
                }
            }
            if (mdcDomain != null) {
                URLConstant.MDC_BASE_URL = mdcDomain.trim().startsWith("http") ? mdcDomain.trim() : "http://" + mdcDomain.trim();
            }
            if (kmDomain != null) {
                URLConstant.TM_BASE_URL = kmDomain.trim().startsWith("http") ? kmDomain.trim() : "http://" + kmDomain.trim();
            }
            if (eocDomain != null) {
                URLConstant.EOC_BASE_URL = eocDomain.trim().startsWith("http") ? eocDomain.trim() : "http://" + eocDomain.trim();
            }
            if (iamDomain != null) {
                URLConstant.IAM_BASE_URL = iamDomain.trim().startsWith("http") ? iamDomain.trim() : "http://" + iamDomain.trim();
            }
            EspSdkInitialize.initLoadbalanceReouteConfig();
            EspSdkInitialize.initLogger();
            EspSdkInitialize.initLocalRequestConfig();
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    @Deprecated
    private static void initLogger() {
    }

    public static ClassLoader deduceClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null && (cl = EspSdkInitialize.class.getClassLoader()) == null) {
            try {
                cl = ClassLoader.getSystemClassLoader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return cl;
    }

    public static void initHttpParamConfig(Integer maxTotal, Integer defaultMaxPerroute, Integer connectTimeOut) {
        ParamConstant.CONNECT_TIME_OUT = connectTimeOut;
        ParamConstant.DEFAULT_MAX_PERROUTE = defaultMaxPerroute;
        ParamConstant.MAX_TOTAL = maxTotal;
    }

    public static void initRetryParamConfig(Integer retryCount, Long retryInterval) {
        ParamConstant.RETRY_COUNT = retryCount;
        ParamConstant.RETRY_INTERVAL = retryInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initLoadbalanceReouteConfig() {
        Class<EspSdkInitialize> clazz = EspSdkInitialize.class;
        synchronized (EspSdkInitialize.class) {
            block16: {
                if (DAPConstant.INITED) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return;
                }
                DAPConstant.INITED = true;
                try {
                    ClassLoader classLoader = EspSdkInitialize.deduceClassLoader();
                    if (classLoader == null) break block16;
                    Class<?> espLoadBalanceUtilaClass = classLoader.loadClass("com.digiwin.loadbalance.esp.ESPLoadBalanceUtil");
                    DAPConstant.LOADBALANCE_ENABLE = true;
                    try {
                        espLoadBalanceUtilaClass.getField("EAI_ID_SERACH_SERVICE_NAME_KEY");
                    }
                    catch (NoSuchFieldException e) {
                        DAPConstant.LOADBALANCE_ENABLE = false;
                    }
                    DAPConstant.SUPPORT_REROUTE = true;
                    try {
                        espLoadBalanceUtilaClass.getDeclaredMethod("getDwMainExecWrapper", new Class[0]);
                    }
                    catch (NoSuchMethodException e) {
                        DAPConstant.SUPPORT_REROUTE = false;
                    }
                    DAPConstant.SUPPORT_ASYNC_ALARM = DAPConstant.LOADBALANCE_ENABLE;
                    try {
                        espLoadBalanceUtilaClass.getDeclaredMethod("requestPostProcess", String.class, String.class, String.class, String.class, String.class);
                    }
                    catch (NoSuchMethodException e) {
                        DAPConstant.SUPPORT_ASYNC_ALARM = false;
                    }
                    try {
                        boolean isCacheAnonymous;
                        Method isCacheAnonymousMethod = espLoadBalanceUtilaClass.getDeclaredMethod("isCacheAnonymous", new Class[0]);
                        DAPConstant.SUPPORT_MDCPRODNAME_CACHE = isCacheAnonymous = ((Boolean)isCacheAnonymousMethod.invoke(null, new Object[0])).booleanValue();
                    }
                    catch (NoSuchMethodException e) {
                        DAPConstant.SUPPORT_MDCPRODNAME_CACHE = false;
                    }
                    DAPConstant.LOADBALANCE_IGNORE_MDC = true;
                    try {
                        espLoadBalanceUtilaClass.getDeclaredMethod("getIgnoreMDC", new Class[0]);
                    }
                    catch (NoSuchMethodException e) {
                        DAPConstant.LOADBALANCE_IGNORE_MDC = false;
                    }
                }
                catch (Exception e) {
                    DAPConstant.LOADBALANCE_ENABLE = false;
                    DAPConstant.SUPPORT_REROUTE = false;
                    DAPConstant.SUPPORT_ASYNC_ALARM = false;
                    DAPConstant.SUPPORT_MDCPRODNAME_CACHE = false;
                    DAPConstant.LOADBALANCE_IGNORE_MDC = false;
                }
            }
            EspSdkInitialize.initDapProperty();
            ProdNameTransformService.loadService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void initLocalRequestConfig() {
        DAPConstant.LOCAL_REQUET_ROUTE_ENABLE = EspSdkInitialize.getPropertyFromSystemAndEnv(DAPConstant.LOCAL_REQUET_ROUTE_ENABLE_KEY, false, value -> Boolean.parseBoolean(value));
        DAPConstant.LOCAL_CALLBACK_REQUET_URL = EspSdkInitialize.getPropertyFromSystemAndEnv(DAPConstant.LOCAL_CALLBACK_REQUET_URL_KEY, "", value -> value);
        if (StringUtils.isBlank((CharSequence)DAPConstant.LOCAL_CALLBACK_REQUET_URL)) {
            DAPConstant.LOCAL_REQUET_ROUTE_ENABLE = false;
        }
        if (DAPConstant.LOCAL_REQUET_ROUTE_ENABLE) {
            ServiceLoader<LocalRouteProcess> localRouteProcesses = ServiceLoader.load(LocalRouteProcess.class);
            ArrayList<LocalRouteProcess> localRouteProcessList = new ArrayList<LocalRouteProcess>();
            for (LocalRouteProcess localRouteProcess : localRouteProcesses) {
                localRouteProcessList.add(localRouteProcess);
            }
            Collections.sort(localRouteProcessList);
            if (localRouteProcessList.size() > 0) {
                DAPConstant.LOCALROUTEPROCESS = (LocalRouteProcess)localRouteProcessList.get(0);
            } else {
                DAPConstant.LOCAL_REQUET_ROUTE_ENABLE = false;
            }
        }
    }

    private static void initDapProperty() {
        if (DAPConstant.LOADBALANCE_ENABLE) {
            DAPConstant.MAX_REQUEST_BODY_SIZE = EspSdkInitialize.getPropertyFromSystemAndEnv(DAPConstant.MAX_REQUEST_BODY_SIZE_KEY, DAPConstant.DEFAULT_MAX_REQUEST_BODY_SIZE, value -> Long.parseLong(value));
            DAPConstant.CONNECT_TIMEOUT_MILLIS = EspSdkInitialize.getPropertyFromSystemAndEnv(DAPConstant.CONNECT_TIMEOUT_MILLIS_KEY, DAPConstant.DEFAULT_CONNECT_TIMEOUT_MILLIS, value -> Integer.parseInt(value));
            DAPConstant.READ_TIMEOUT_MILLIS = EspSdkInitialize.getPropertyFromSystemAndEnv(DAPConstant.READ_TIMEOUT_MILLIS_KEY, DAPConstant.DEFAULT_READ_TIMEOUT_MILLIS, value -> Integer.parseInt(value));
            DAPConstant.SOCKET_TIMEOUT_MILLIS = EspSdkInitialize.getPropertyFromSystemAndEnv(DAPConstant.SOCKET_TIMEOUT_MILLIS_KEY, DAPConstant.DEFAULT_SOCKET_TIMEOUT_MILLIS, value -> Integer.parseInt(value));
            DAPConstant.REQUEST_BODY_SIZE_LIMIT_ENABLE = EspSdkInitialize.getPropertyFromSystemAndEnv(DAPConstant.REQUEST_BODY_SIZE_LIMIT_KEY, false, value -> Boolean.parseBoolean(value));
            DAPConstant.REQUEST_TIME_LIMIT_ENABLE = EspSdkInitialize.getPropertyFromSystemAndEnv(DAPConstant.REQUEST_TIME_LIMIT_ENABLE_KEY, false, value -> Boolean.parseBoolean(value));
        }
    }

    public static void setDapRequestConfig(long maxBodysize, int connectTimeoutMillis, int readTimeoutMillis, int socketTimeoutMillis) {
        EspSdkInitialize.setDapRequestConfig(true, false, maxBodysize, connectTimeoutMillis, readTimeoutMillis, socketTimeoutMillis);
    }

    public static void setDapRequestConfig(boolean bodySizeLimitEnable, boolean requestTimeLimitEnable, Long maxBodysize, int connectTimeoutMillis, int readTimeoutMillis, int socketTimeoutMillis) {
        if (DAPConstant.INITED) {
            throw new RuntimeException("SDK initialized,can not use setDapRequestConfig");
        }
        DAPConstant.REQUEST_BODY_SIZE_LIMIT_ENABLE = bodySizeLimitEnable;
        DAPConstant.REQUEST_TIME_LIMIT_ENABLE = requestTimeLimitEnable;
        DAPConstant.MAX_REQUEST_BODY_SIZE = maxBodysize;
        DAPConstant.CONNECT_TIMEOUT_MILLIS = connectTimeoutMillis;
        DAPConstant.READ_TIMEOUT_MILLIS = readTimeoutMillis;
        DAPConstant.SOCKET_TIMEOUT_MILLIS = socketTimeoutMillis;
    }

    public static void setDapRequestConfig(boolean bodySizeLimitEnable, boolean requestTimeLimitEnable) {
        EspSdkInitialize.setDapRequestConfig(bodySizeLimitEnable, requestTimeLimitEnable, DAPConstant.MAX_REQUEST_BODY_SIZE, DAPConstant.CONNECT_TIMEOUT_MILLIS, DAPConstant.READ_TIMEOUT_MILLIS, DAPConstant.SOCKET_TIMEOUT_MILLIS);
    }

    private static <T> T getPropertyFromSystemAndEnv(String key, T defalutvalue, Function<String, T> function) {
        String property = System.getProperty(key);
        if (StringUtils.isBlank((CharSequence)property)) {
            property = System.getenv().get(key);
        }
        if (StringUtils.isNotBlank((CharSequence)property)) {
            return function.apply(property);
        }
        return defalutvalue;
    }
}

