package com.digiwin.athena.eventcenter.core.util;


import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @author huwei
 */
public final class BeanUtils extends org.springframework.beans.BeanUtils {

    private static final Logger logger = LoggerFactory.getLogger(BeanUtils.class);

    public BeanUtils() {
    }

    /**
     * copyClass
     */
    public static <T, K> T copy(K source, Class<T> targetClass) {
        return copy(source, targetClass, (String[]) null);
    }

    /**
     * copyClass
     */
    public static <T, K> T copy(K source, Class<T> targetClass, String... ignoreProperties) {

        Assert.notNull(source, "source is null");

        T target = null;

        try {
            target = targetClass.newInstance();
            copyProperties(source, target, ignoreProperties);
        } catch (InstantiationException | IllegalAccessException e) {
            logger.error("convert obj error", e);
        }

        return target;
    }

    /**
     * copyList
     */
    public static <T, K> List<T> copyList(List<K> sourceList, Class<T> targetClass) {

        if (CollectionUtils.isEmpty(sourceList)) {
            return new ArrayList<>();
        }

        List<T> targetList = new ArrayList<>(sourceList.size());

        sourceList.forEach(var -> {

            T target = null;

            try {
                target = targetClass.newInstance();
                copyProperties(var, target);

            } catch (InstantiationException | IllegalAccessException e) {
                logger.error("convert obj error", e);
            }
            targetList.add(target);
        });

        return targetList;
    }
}