package com.digiwin.athena.eventcenter.core.util;

/**
 * String操作工具类
 *
 * @author zhangzhi@digiwin.com
 * @date 2020/7/17
 */
public final class StringUtil {
    private StringUtil() {
    }

    public static boolean isBlank(String string) {
        return nullToEmpty(string).trim().isEmpty();
    }

    public static boolean isNotBlank(String string) {
        return !isBlank(string);
    }

    public static String trimToEmpty(String string) {
        return string == null ? "" : string.trim();
    }

    public static String nullToEmpty(String string) {
        return string == null ? "" : string;
    }

    public static boolean isEmpty(String string) {
        return nullToEmpty(string).isEmpty();
    }

    public static String firstUpper(String string) {
        if (isBlank(string)) {
            return string;
        }
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

}
