package com.digiwin.athena.eventcenter.pojo.bo.km;


import com.alibaba.fastjson.JSONObject;
import lombok.*;

/**
 * @author zhangzhi@digiwin.com
 */
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Setter
@Getter
public class EventResponseBo {

    /**
     * 状态
     */
    private Integer status;

    /**
     * 描述
     */
    private String statusDescription;

    /**
     * 事件模板实体
     */
    private EventTemplateBo response;

    /**
     * 事件模板创建人信息
     * {
     *    "tenantName" : "AthenaQCTestW",
     *    "tenantSid" : 416778900513344,
     *    "tenantId" : "AthenaQCTestW",
     *    "userSid" : 1984610499,
     *    "userName" : "集成账号",
     *    "userId" : "integration"
     *  },
     */
    private JSONObject profile;

    /**
     * 【DAP生成】 必有字段
     */
    private String uuid;

}
