package com.digiwin.athena.eventcenter.pojo.dto.consumer;


import com.digiwin.athena.eventcenter.core.util.JsonUtil;
import lombok.Getter;
import lombok.Setter;

/**
 * @author zhangzhi@digiwin.com
 * @description: 订阅者执行完成Log
 * @date 2023/11/20 10:46
 */
@Getter
@Setter
public class CallbackEventDto {

    /** 事件实例id */
    private String eventLogId;

    /** 事件消费LogId */
    private String consumeLogId;

    /** 事件消费执行完成时间 */
    private String consumeCompleteTime;

    /** 事件消费执行结果 */
    private Boolean success;

    /** 事件消费执行信息 */
    private String message;

    @Override
    public String toString() {
        return JsonUtil.getJsonString(this);
    }

}
