package com.digiwin.athena.eventcenter.pojo.dto.trigger;


import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.eventcenter.core.util.JsonUtil;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author zhangzhi@digiwin.com
 * @description: 触发事件
 * @date 2023/11/20 10:46
 */
@Getter
@Setter
public class TriggerEventDto {

    /**
     * 事件id
     */
    @NotBlank(message = "事件id不能为空")
    private String eventId;

    /**
     * 事件头
     */
    @NotNull(message = "事件头不能为空")
    private TriggerEventHeaderDto eventHeader;

    /**
     * 事件体，遵循定义时设定的数据内容
     */
    private JSONObject eventBody;


    @Override
    public String toString() {
        return JsonUtil.getJsonString(this);
    }

}
