package com.digiwin.athena.eventcenter.pojo.dto.trigger;


import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.eventcenter.core.util.JsonUtil;
import lombok.Getter;
import lombok.Setter;

/**
 * @author zhangzhi@digiwin.com
 * @description: 触发事件请求头
 * @date 2023/11/20 10:46
 */
@Getter
@Setter
public class TriggerEventHeaderDto {

    /**
     * 链路追踪用，事件生产者发布事件时随机给出GUID
     */
    private String traceId;

    /**
     * 事件时间
     */
    private String eventSendTime;

    /**
     * 发起方
     */
    private String appId;

    /**
     * 发起方租户ID
     */
    private String tenantId;

    /**
     * 员工信息（可能无法拿到员工信息）
     * {
     * "eoc_company_id":"xx",
     * "eoc_site_id":""
     * }
     */
    private JSONObject eocMap;

    /**
     * 如果触发事件时没有带发起人信息，则往后走流程时，默认使用：athena
     * {
     * "initiatorId":"", //发起人，非必填
     * "initiatorNo":"", //发起人，非必填，
     * "initiatorName":"",//发起人，非必填，
     * }
     */
    private JSONObject initiator;

    /**
     * 来源id（透传给下游）
     */
    private String sourceIds;

    @Override
    public String toString() {
        return JsonUtil.getJsonString(this);
    }

}
