package com.digiwin.athena.eventcenter.provider.impl;

import com.digiwin.athena.eventcenter.pojo.dto.response.SimpleResp;
import com.digiwin.athena.eventcenter.pojo.dto.trigger.TriggerEventDto;
import com.digiwin.athena.eventcenter.provider.IEventApiProvider;
import com.digiwin.athena.eventcenter.service.facade.IEventTriggerFacadeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.validation.Valid;

/**
 * @author zhangzhi@digiwin.com
 */
@Service
public class EventApiProvider implements IEventApiProvider {

    @Autowired
    private IEventTriggerFacadeService eventTriggerFacadeService;

    @Override
    public SimpleResp triggerEvent(@Valid TriggerEventDto dto) {
        eventTriggerFacadeService.triggerEvent(dto);
        return new SimpleResp();
    }
}
