package com.digiwin.athena.eventcenter.repository.model.trigger;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.eventcenter.core.base.BaseModel;
import com.digiwin.athena.eventcenter.core.util.JsonUtil;
import com.digiwin.athena.eventcenter.pojo.dto.trigger.TriggerEventDto;
import com.digiwin.athena.eventcenter.pojo.dto.trigger.TriggerEventHeaderDto;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.springframework.data.mongodb.core.mapping.Document;

/**
 * @author zhangzhi@digiwin.com
 * @description: 事件触发记录
 * @date 2023/11/8 17:58
 */
@Document(collection = "event_log")
@Getter
@Setter
@NoArgsConstructor
public class EventTriggerLogModel extends BaseModel {

    /**
     * 事件id
     */
    private String eventId;

    /**
     * 追踪id
     */
    private String traceId;

    /**
     * 状态
     */
    private Integer status;

    /**
     * 投递次数
     */
    private Integer count;

    /**
     * 事件头
     */
    private JSONObject eventHeader;

    /**
     * 事件体
     */
    private JSONObject eventBody;

    /**
     * 租户id
     */
    private String tenantId;

    /**
     * 发送应用
     */
    private String sendAppid;

    public EventTriggerLogModel(TriggerEventDto dto) {
        this.eventId = dto.getEventId();
        TriggerEventHeaderDto eventHeader = dto.getEventHeader();
        this.traceId = eventHeader.getTraceId();
        this.status = 1;
        this.count = 0;
        this.eventHeader = JsonUtil.getJSONObject(eventHeader);
        this.eventBody = dto.getEventBody();
        this.tenantId = eventHeader.getTenantId();
        this.sendAppid = eventHeader.getAppId();
    }
}
