package com.digiwin.athena.eventcenter.core.base;

import com.digiwin.athena.eventcenter.core.util.BeanUtils;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.util.List;

/**
 * @author huwei
 */
@Getter
@Setter
@NoArgsConstructor
@Builder
public class Page<T> {
    private Integer pageNo;
    private Integer pageSize;
    private Long total;
    private List<T> data;

    public <E> Page(Integer pageNo, Integer pageSize, Long total, List<E> data, Class<T> tClass) {
        this.pageNo = pageNo;
        this.pageSize = pageSize;
        this.total = total;
        this.data = BeanUtils.copyList(data, tClass);
    }

    public Page(Integer pageNo, Integer pageSize, Long total, List<T> data) {
        this.pageNo = pageNo;
        this.pageSize = pageSize;
        this.total = total;
        this.data = data;
    }
}
