package com.digiwin.athena.eventcenter.core.config;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.config.AbstractMongoConfiguration;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.repository.config.EnableMongoRepositories;

/**
 * 后续使用springboot原生处理的话，此处的初始化操作可以都在AutoConfiguration中进行处理
 *
 * @author zhangzhi@digiwin.com
 * @date 2021/6/30
 */
@Configuration
@EnableMongoRepositories(mongoTemplateRef = "eventcenterMongoTemplate", basePackages = "com.digiwin.athena.eventcenter.repository.dao.*")
public class EventcenterMongoConfig extends AbstractMongoConfiguration {

    private static final Logger LOGGER = LoggerFactory.getLogger(EventcenterMongoConfig.class);

    @Value("${spring.data.mongodb.eventcenter.database:eventcenter}")
    private String database;

    @Value("${spring.data.mongodb.eventcenter.uri}")
    private String uri;

    @Override
    protected String getDatabaseName() {
            if(StringUtils.isBlank(database)){
                LOGGER.error("mongodb database 属性未配置！请查看");
                System.exit(0);
        }
        return database;
    }

    @Override
    @Bean("eventcenterMongoClient")
    public MongoClient mongoClient() {
        return new MongoClient(new MongoClientURI(uri));
    }

    @Bean(name = "eventcenterMongoTemplate")
    public MongoTemplate eventcenterMongoTemplate(@Qualifier("eventcenterMongoClient") MongoClient mongoClient) {
        return new MongoTemplate(mongoClient, database);
    }
}
