package com.digiwin.athena.eventcenter.pojo.bo.km;


import com.alibaba.fastjson.JSONObject;
import lombok.*;

import java.util.List;

/**
 * @author zhangzhi@digiwin.com
 */
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Setter
@Getter
public class EventTemplateBo {

    /**
     * 事件id
     */
    private String eventId;

    /**
     * 事件名称
     */
    private String eventName;

    /**
     * 事件等级
     */
    private String eventLevel;

    /**
     * 事件类型
     */
    private String eventType;

    /**
     * 事件应用
     */
    private String eventOwner;

    /**
     * 用于验证事件携带的数据格式
     * 扩展功能，待细化，后续实现
     */
    private JSONObject eventBodyExplain;

    /**
     * 事件可用状态
     */
    private String eventEnable;

    /**
     * 名称多语言
     */
    private JSONObject lang;

    /**
     * 订阅事件配置集合
     */
    private List<EventSubscribeBo> subscribes;

}
