package com.digiwin.athena.eventcenter.provider;

import com.digiwin.app.service.DWService;
import com.digiwin.app.service.restful.DWRequestMapping;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.app.service.restful.DWRestfulService;
import com.digiwin.athena.eventcenter.pojo.dto.consumer.CallbackEventDto;
import com.digiwin.athena.eventcenter.pojo.dto.response.SimpleResp;
import com.digiwin.athena.eventcenter.pojo.dto.trigger.TriggerEventDto;
import org.springframework.validation.annotation.Validated;

import javax.validation.Valid;

/**
 * @author zhangzhi@digiwin.com
 * @description: 触发事件
 * @date 2023/11/17 15:52
 */
@DWRestfulService
@Validated
public interface IEventApiProvider extends DWService {

    @DWRequestMapping(path = "/api/event/trigger", method = DWRequestMethod.POST)
    SimpleResp triggerEvent(@Valid TriggerEventDto dto);

    @DWRequestMapping(path = "/api/event/callback", method = DWRequestMethod.POST)
    default void callbackEvent(CallbackEventDto dto){

    };

}